/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

class RadiusHandle
extends AbstractHandle {
    private Point fRadius;
    private RoundRectangleFigure fOwner;
    private static final int OFFSET = 4;

    public RadiusHandle(RoundRectangleFigure roundRectangleFigure) {
        super(roundRectangleFigure);
        this.fOwner = roundRectangleFigure;
    }

    public void invokeStart(int n, int n2, DrawingView drawingView) {
        this.fRadius = this.fOwner.getArc();
        this.fRadius.x /= 2;
        this.fRadius.y /= 2;
    }

    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        int n5 = n - n3;
        int n6 = n2 - n4;
        Rectangle rectangle = this.fOwner.displayBox();
        int n7 = Geom.range(0, rectangle.width, 2 * (this.fRadius.x + n5));
        int n8 = Geom.range(0, rectangle.height, 2 * (this.fRadius.y + n6));
        this.fOwner.setArc(n7, n8);
    }

    public Point locate() {
        Point point = this.fOwner.getArc();
        Rectangle rectangle = this.fOwner.displayBox();
        return new Point(rectangle.x + point.x / 2 + 4, rectangle.y + point.y / 2 + 4);
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.yellow);
        graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

