#ifndef MENU_SINGLETON_H
#define MENU_SINGLETON_H

// agranig: we'll need this definitions for each
// new menu, so this will make life easier ;o)

#define MENU_SINGLETON(t) \
  public: \
    virtual ~t##Menu(); \
    static t##Menu* getInstance() { \
      if(sm_instance == NULL) \
        sm_instance = new t##Menu(); \
      return sm_instance; \
    } \
    static void destroy() { \
      ZAP_POINTER(sm_instance); \
    }\
  protected: \
    t##Menu(); \
    t##Menu(t##Menu &c); \
    static t##Menu *sm_instance

#define MENU_SINGLETON_INIT(t)             \
    t##Menu* t##Menu::sm_instance = NULL

#endif // MENU_SINGLETON_H
