      SUBROUTINE cleo_CHKLUN( CRNAME )
C.......................................................................
C.
C. CHKLUN - Check integrity of LUN allocation table
C.
C. Inputs    : CRNAME - Character name of calling routine
C. Outputs   : None
C.
C. COMMON    : LUNMCI LUNMCC
C. Calls     : ERRLUN
C. Called    : FRELUN GETLUN
C.
C.......................................................................
C
C------------------------- Argument declarations -----------------------
C
      CHARACTER*(*) CRNAME
C
C------------------------- EXTERNAL declarations -----------------------
C
* None
C
C------------------------- SEQUENCE declarations -----------------------
C
C
* LUNMIN - Smallest allowed LUN number
* LUNMAX - Largest  allowed LUN number
* MAXLUN - Length of the    LUN number allocation table
*
      INTEGER    LUNMIN,     LUNMAX
      PARAMETER( LUNMIN = 1, LUNMAX = 99 )
*
      INTEGER    MAXLUN
      PARAMETER( MAXLUN = LUNMAX - LUNMIN + 1 )
*
* LISUSE - Flag for LUN is in use
* LISFRE - Flag for LUN is free
* LISLOK - Flag for LUN is locked
*
      INTEGER    LISUSE,     LISFRE,     LISLOK
      PARAMETER( LISUSE = 1, LISFRE = 0, LISLOK = -1 )
*
* LUSEER - Error, LUN in use
* LRNGER - Error, LUN number out of range
* LTABER - Error, LUN allocation table corrupted
* LFULER - Error, LUN allocation table full
* LLOKER - Error, LUN is already locked
* LFLKER - Error, LUN is locked, cannot be freed
* LINIER - Error, in initialization
* LUALER - Error, found unalloacted unit connected to file
* LNONAM - Warning, Allocator name is blank
* LDIFER - Warning, Allocator and deallocator are different
*
      INTEGER    LUSEER,     LRNGER,     LTABER,     LFULER
      PARAMETER( LUSEER = 1, LRNGER = 2, LTABER = 3, LFULER = 4 )
      INTEGER    LLOKER,     LFLKER,     LINIER,     LUALER
      PARAMETER( LLOKER = 5, LFLKER = 6, LINIER = 7, LUALER = 8 )
      INTEGER    LNONAM,     LDIFER
      PARAMETER( LNONAM = 9, LDIFER =10                         )
*
* LUNTBL - The LUN allocation table
* LUNOWN - The LUN allocation owner table
*
      INTEGER         LUNTBL
      COMMON /LUNMCI/ LUNTBL(LUNMIN:LUNMAX)
      CHARACTER*8     LUNOWN
      COMMON /LUNMCC/ LUNOWN(LUNMIN:LUNMAX)
C
C------------------------- Local    declarations -----------------------
C
      INTEGER I
      LOGICAL LOPEN
C
C------------------------- SAVE     declarations -----------------------
C
* None
C
C------------------------- DATA  initializations -----------------------
C
* None
C
C---------------------- Executable code starts here --------------------
C
C
C== If a unit is OPEN but table indicates it is free then complain
C
      DO 10 I = LUNMIN, LUNMAX
         INQUIRE( UNIT=I, OPENED=LOPEN )
         IF( LOPEN .AND. LUNTBL(I).EQ.LISFRE ) THEN
            CALL CLEO_LOKLUN( I, 'LUNMGR' )
            CALL CLEO_ERRLUN( CRNAME, I, LUALER, ' ' )
         ENDIF
   10 CONTINUE
C
      RETURN
      END
