      SUBROUTINE M_APRS(TEXT,NNCHAR)
C
C-----------------------------------------------------------------------
C
C     Interprets the aliases and replaces them in the command line
C     Aliases are not case sensitive. Therefore the string must always
C     be converted to upper case before looking.
C
C     Called by TYQRED
C
C-----------------------------------------------------------------------
C
#include "mnpar.inc"
#include "mntyq.inc"
C
      CHARACTER*(*) TEXT
      INTEGER NNCHAR
C
      CHARACTER*255 TXT1,TXT2,TXTU
      INTEGER LEN1,LEN2,LENOCC,IND,N1,N2
C
      IF(.NOT.QALIAS .OR. NALIAS.LE.0) RETURN
C
      TXT1 = TEXT(1:NNCHAR)
      LENT = NNCHAR
      DO 2000 I=1,NALIAS
          N1 = 1
          LEN1 = LENOCC(TALIAS(I))
          LEN2 = LALCMD(I)
1100      CONTINUE
          CALL M_LUPC(TXT1,TXTU)
          IND = INDEX(TXTU(N1:),TALIAS(I)(1:LEN1))
          IF(IND.LE.0) GOTO 2000
          N2 = N1 + IND - 1
C
C         If alias is preceded by a @ then do not substitute it.
C
          IF(N2.GT.1) THEN
              IF(TEXT(N2-1:N2-1).EQ.'@') THEN
                  IF(N2.GT.2) THEN
                      TXT2 = TXT1(1:N2-2) // TXT1(N2:)
                  ELSE
                      TXT2 = TXT1(N2:)
                  ENDIF
                  TXT1 = TXT2
                  N1 = N2
                  LENT = LENT - 1
                  GOTO 1100
              ENDIF
          ENDIF
C
C         The alias must be followed by something other than a letter
C         or a number.
C
          IF(N2+LEN1.LE.LENT) THEN
              ICH = ICHAR(TXT1(N2+LEN1:N2+LEN1))
              IF((ICH.GE.ICHAR('A') .AND. ICH.LE.ICHAR('Z')) .OR.
     +           (ICH.GE.ICHAR('a') .AND. ICH.LE.ICHAR('z')) .OR.
     +           (ICH.GE.ICHAR('0') .AND. ICH.LE.ICHAR('9'))) THEN
                  N1 = N2 + 1
                  GOTO 1100
              ENDIF
          ENDIF
C
C         Look for a // and something following the alias
C
          NX = 0
          IF(N2+LEN1+2.LE.LENT) THEN
              IF(TXT1(N2+LEN1:N2+LEN1+1).EQ.'//') THEN
                  NX = 2
              ENDIF
          ENDIF
C
C         Do the alias substitution
C
          IF(N2.GT.1 .AND. LEN2.GT.0 .AND. N2+LEN1+NX.LE.LENT) THEN
              TXT2 = TXT1(1:N2-1) // TALCMD(I)(1:LEN2) //
     +               TXT1(N2+LEN1+NX:)
          ELSEIF(N2.GT.1 .AND. LEN2.GT.0) THEN
              TXT2 = TXT1(1:N2-1) // TALCMD(I)(1:LEN2)
          ELSEIF(N2.GT.1 .AND. N2+LEN1+NX.LE.LENT) THEN
              TXT2 = TXT1(1:N2-1) // TXT1(N2+LEN1+NX:)
          ELSEIF(N2.GT.1) THEN
              TXT2 = TXT1(1:N2-1)
          ELSEIF(LEN2.GT.0 .AND. N2+LEN1+NX.LE.LENT) THEN
              TXT2 = TALCMD(I)(1:LEN2) // TXT1(N2+LEN1+NX:)
          ELSEIF(LEN2.GT.0) THEN
              TXT2 = TALCMD(I)(1:LEN2)
          ELSEIF(N2+LEN1+NX.LE.LENT) THEN
              TXT2 = TXT1(N2+LEN1+NX:)
          ELSE
              TXT1 = ' '
              GOTO 2100
          ENDIF
          TXT1 = TXT2
          LENT = LENT + LEN2 - LEN1 - NX
          N1 = N2 + LEN2
          GOTO 1100
2000  CONTINUE
2100  CONTINUE
C
      TEXT = TXT1
      NNCHAR = MAX0(1,LENOCC(TXT1))
C
      END
