C
      SUBROUTINE MN_MNW(JDA,JDB,NNID,LUN)
C
C     Routine for writing MNBOOK histograms
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mntmp.inc"
#include "mnlun.inc"
C
      LOGICAL QERRL,QERRH
      LOGICAL QTMPRD
C
      NLOOP = 1
      IF(JDA.EQ.0) THEN
          NLOOP = NDHIS
      ENDIF
C
      DO 3000 NL=1,NLOOP
          IF(JDA.EQ.0) THEN
              IDA = IDIDA(NL)
              IDB = IDIDB(NL)
              IF(IDPTRH(NL).LE.0 .OR. IDPTRD(NL).LE.0) GOTO 3000
              IF(NNID.EQ.2 .AND. JDB.NE.IDB) GOTO 3000
          ELSE
              IDA = JDA
              IDB = JDB
          ENDIF
          CALL MN_HGT(IDA,IDB,NH)
          IF(NH.LE.0) THEN
              WRITE(TXTERR,'(''Plot'',I7,I4,'' does not exist'')')
     +          IDA,IDB
              CALL MN_ERR('MN_MNW',TXTERR)
              GOTO 3000
          ENDIF
C
          NWH   = NINT(RDAT(NPTRH+1))
          NWDAT = NINT(RDAT(NPTRH+2))
          NWTOT = NWH + NWDAT
C
          IF(NWDAT.LE.0) THEN
              IF(QMNOPN) THEN
                  REWIND LUNMNU
                  NRECU = 0
                  NRECG = 0
C
C                 FIND OUT HOW MANY RECORDS THERE ARE FOR THIS PLOT
C
                  DO 1300 NN=1,NUBIN
                      IF(IDTA(NN).EQ.IDA .AND. IDTB(NN).EQ.IDB) THEN
                          NTREC = IDWR(NN)
                          GOTO 1310
                      ENDIF
1300              CONTINUE
                  WRITE(LUNTTO,'('' *** MN_MNW: I expect the data''
     1             ,'' for plot'',I7,I4,'' to be stored in a''
     2             ,'' temporary file''
     3             ,/,13X,''but the file is not open'')') IDA,IDB
                  GOTO 3000
1310              CONTINUE
              ENDIF
C
C             MAKE SURE THE NUMBER OF POINTS IS FILLED PROPERLY
C
              EDLO = 0.0
              EDHI = 0.0
              IF(EDENT.GT.0.0) EDHI = 1.0
          ELSE
              CALL AMNOFF(NDIM,NWPPT,NOFF,NOFFL,NOFFH,QERRL,QERRH)
C
              CALL MN_UOF(RDAT(NPTRH),ACONT)
C
              EDLO = 1.0E+30
              EDHI = -1.0E+30
              DEEL = 0.0
              DEEH = 0.0
              NERR = 0
              DO 2100 II=1,NPNT
                  EE = AMNE(II,NH,NERR)
                  IF(QERRL) DEEL = AMNDEN(II,NH,NERR)
                  DEEH = DEEL
                  IF(QERRH) DEEH = AMNDEP(II,NH,NERR)
                  EDLO = AMIN1(EDLO,EE-DEEL)
                  EDHI = AMAX1(EDHI,EE+DEEH)
 2100         CONTINUE
          ENDIF
C
          CALL MN_HDU(RDAT(NPTRH),NWTOT,NWH,NWDAT,IDA,IDB
     +     ,NDIM,NWPPT,NPNT,NHDATE,NHTIME,NSDATE,NSTIME,NTMODE
     +     ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,NBPPT,ACONT)
          CALL MN_MSU(IDA,IDB,NDIM,NWH,NH)
C
          QTMPRD = NWDAT.EQ.0
          IF(NDIM.GT.0) THEN
              NWW = NWDAT
          ELSE
              NWW = NPNT * NWPPT
          ENDIF
          NH1 = NPTRH
          NH2 = NPTRH + NWH - 1
          IF(QTMPRD) THEN
              NNREC = NTREC
          ELSE
              NNREC = (NWW-1)/MNBLOK + 1
          ENDIF
          ANBLK = FLOAT(MNBLOK)
          ANREC = FLOAT(NNREC)
          NWT = NWH + 2
          WRITE(LUN,ERR=9100) NWT,(RDAT(II),II=NH1,NH2),ANBLK,ANREC
          LENTIT = LEN(TDTIT(NH))
          LENNAM = LEN(TDNAM(1,NH))
          NBT = LENTIT + IABS(NDIM)*LENNAM
          WRITE(LUN,ERR=9100) NBT,LENTIT,LENNAM,TDTIT(NH)
     1     ,(TDNAM(II,NH),II=1,IABS(NDIM))
          DO 2900 JJ=1,NNREC
              IF(NDIM.GT.0 .OR. .NOT.QTMPRD) THEN
                  NWD = MIN0(MNBLOK,NWW-(JJ-1)*MNBLOK)
                  ND1 = NPTRD + (JJ-1)*MNBLOK
                  ND2 = ND1 + NWD - 1
                  WRITE(LUN,ERR=9100) NWD,(RDAT(II),II=ND1,ND2)
              ELSE IF(QMNOPN .AND. QTMPRD) THEN
2800              CONTINUE
                  NRECU = NRECU + 1
                  READ(LUNMNU,ERR=9200) IDDA,IDDB,NNWD
     1             ,(RTMP(II,1),II=1,NNWD)
                  IF(IDDA.NE.IDA .OR. IDDB.NE.IDB) GOTO 2800
                  NRECG = NRECG + 1
C                 IF(NNWD.NE.NWD) THEN
C                     WRITE(LUNTTO,'('' MN_MNW: I expected to read''
C     1                ,'' in'',I6,'' words, but got'',I6
C     2                ,/,9X,'' trying to read record'',I6
C     3                ,'' from the temporary file''
C     4                ,'' for histogram'',I7,I4)') NWD,NNWD,NRECU
C     5                ,IDA,IDB
C                     GOTO 2800
C                 ENDIF
                  WRITE(LUN,ERR=9100) NNWD,(RTMP(II,1),II=1,NNWD)
              ELSE
                  GOTO 9300
              ENDIF
 2900     CONTINUE
 3000 CONTINUE
C
 9000 CONTINUE
      GOTO 9900
C
C     ERROR WRITING OUT THE HISTOGRAMS
C
9100  CONTINUE
      WRITE(LUNTTO,19100) IDA,IDB
19100 FORMAT(' *** MN_MNW: Error trying to store histogram',I7,I4
     1 ,/,13X,'Store will be aborted')
      GOTO 9900
C
C     ERROR READING TEMPORARY FILE
C
9200  CONTINUE
      WRITE(LUNTTO,19200) NRECU,IDA,IDB
19200 FORMAT(' *** MN_MNW: Error trying to read record',I6
     1 ,' from the temporary file'
     2 ,/,13X,'for histogram',I7,I4,'  Store will be aborted')
      GOTO 9900
C
C     TEMPORARY FILE IS NOT OPEN
C
9300  CONTINUE
      WRITE(LUNTTO,19300) IDA,IDB
19300 FORMAT(' *** MN_MNW: I expect the data for plot',I7,I4
     1 ,' to be stored in a temporary file'
     2 ,/,13X,'but the file is not open. Store will be aborted')
      GOTO 9900
C
9900  CONTINUE
      RETURN
      END
