#if ( defined(VMS) )
      SUBROUTINE M_RUN_
#endif
#if ( !defined(VMS) )
      SUBROUTINE M_RUN
#endif

C
C-----------------------------------------------------------------------
C
C     Main running loop of Mn_Fit
C
C     Called by Mn_Fit
C
C-----------------------------------------------------------------------
C
#include "mnpar.inc"
#include "mnfit.inc"
#include "mnfun.inc"
#include "mnflg.inc"
#include "mncmd.inc"
#include "mnhpj.inc"
#include "mntyq.inc"
#include "mnprj.inc"
#include "mngrn.inc"
cicb +CDE,MNCNDJ.
#include "mnlun.inc"
      CHARACTER*20 TCMD
C
      EXTERNAL FCN,FUTIL
C
C     Establish the break handler
C     Use IEXIT to decide if this is startup or a break
C
C     Get the command
C
2000  CONTINUE
      CALL MN_CMI(ICMD,IDELIM,IEXIT)
C
C     IF WE HAVE AN INTERRUPT THEN IEXIT = 0 on the Vax
C
      IF(IEXIT.NE.0) GOTO 9000
2100  CONTINUE
C
C     Close any open segments
C
      CALL M_CLSG(0)
C
C     Close all files and terminate DO loops
C
      CALL M_TIDY
C
C     Close all open histogram files
C     Note that this will affect Ntuples
C
      CALL M_HCLS
C
C     Clean up properly after fitting and reset the functions from multiple
C     histogram fitting
C
      IF(NHFIT.GT.0) THEN
          TCMD = 'CLEAR'
          CALL MNEXCM(FCN,TCMD,0.0D0,0,IERFLG,FUTIL)
C
          QMNCHGE = .TRUE.
          CALL MN_FUP(-1)
      ENDIF
      NHFIT = 0
C
C     Reset the window number
C
      IPWNDS(1) = 0
      IPWNDS(2) = 0
C
C     QPROJ indicates we are doing a projection and can use Ntuple variable
C     names when parsing expressions
      QPROJ = .FALSE.
C
C     Reset the word showing if it was an arithmetic error
C
      IF(IARITH.NE.0) THEN
          CALL MN_ERR('MN_FIT','Arithmetic error occured.' //
     +     ' You have been returned to MN_CMD> level')
      ENDIF
      IARITH = 0
C
      GOTO 2000
C
 9000 CONTINUE
C
      END
