# -------------------------------------------------------------------------
#     This file is part of mMass - the spectrum analysis tool for MS.
#     Copyright (C) 2005-07 Martin Strohalm <mmass@biographics.cz>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE in the
#     main directory of the program
# -------------------------------------------------------------------------

# Function: Save document to selected format.

# load libs
import wx
import os.path

# load modules
import document_mmass


class mDocumentExporter:
    """ Save spectrum document to selected format. """

    # ----
    def __init__(self, parent):
        self.parent = parent
    # ----


    # ----
    def exportData(self, document, lastDir=None, saveAs=False):
        """ Show dialog and save document data to file. """

        # get path from document
        path = document.getPath()
        docType = document.getDocType()

        # raise dialog to ask for file name and format
        if saveAs or not path or docType != 'mSD':

            # get file name
            if path:
                fileName = os.path.basename(path)
                fileName = os.path.splitext(fileName)
                fileName = fileName[0]
                if document.getScanID():
                    fileName += '_scan' + document.getScanID()
                fileName += '.msd'
            else:
                fileName = 'spectrum.msd'

            # get dir name
            if path:
                path = os.path.dirname(path)
            else:
                path = lastDir

            # raise export dialog
            dlg = wx.FileDialog(self.parent, "Save Spectrum", path, fileName, "mMass document (*.msd)|*.msd", wx.SAVE|wx.OVERWRITE_PROMPT)
            if dlg.ShowModal() == wx.ID_OK:
                path = dlg.GetPath()
                dlg.Destroy()
            else:
                dlg.Destroy()
                return False

        # format data
        formatMMass = document_mmass.formatMMass(document)
        data = formatMMass.formatData()

        # check data
        if not data:
            dlg = wx.MessageDialog(self.parent, "Current document has no data to save in the selected format!", "No Data!", wx.OK|wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        # save file
        try:
            saveFile = file(path, 'w')
            saveFile.write(data.encode("utf-8"))
            saveFile.close()
            return path

        except IOError:
            dlg = wx.MessageDialog(self.parent, "File cannot be saved! Check permissions please.", "Save Error!", wx.OK|wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False
    # ----
