; $Id: test.scm,v 1.5 2008/01/25 13:30:17 logik Exp $
; This file is intended as a general test.

; (load "~/minlog/init.scm")
(set! DOT-NOTATION #f)


; Contents
; 1. Preliminaries (list.scm and gen-app.scm)
; 2. Types (typ.scm)
; 3. Variables (var.scm)
; 4. Constants (pconst.scm)
; 5. Predicates (psym.scm)
; 6. Terms (term.scm and pp.scm)
; 7. Formulas and comprehension terms (formula.scm and boole.scm)
; 8. and 9. Assumption variables and axioms (axiom.scm)
; 10. Proofs (proof.scm)
; 11. Partial proofs (pproof.scm)
; 13. Automated propositional proofs (prop.scm)
; 16. Extracted terms (ets.scm and etsd.scm)
; 17. A-translation (atr.scm)


; 1. Preliminaries
; ================
; (list.scm and gen-app.scm)


; 2. Types
; ========
; (typ.scm)

; Tests of add-algs (introducing free algebras)

(add-alg "nat" '("Zero" "nat") '("Succ" "nat=>nat"))

(add-alg "ord" '("OrdZero" "ord") '("OrdSup" "(nat=>ord)=>ord"))

(add-param-alg "list" 'prefix-typeop
	       '("Nil" "list")
	       '("Cons" "alpha1=>list=>list"))

(add-param-alg "ytensor" 'tensor-typeop
	       '("TensorPair" "alpha1=>alpha2=>ytensor")) 

; (add-param-alg "ypair" 'prod-typeop
; 	       '("CartPair" "(unit=>alpha1)=>(unit=>alpha2)=>unit=>ypair"))

(add-param-alg "yplus" 'sum-typeop
	       '("Inleft" "alpha1=>yplus")
	       '("Inright" "alpha2=>yplus"))

(add-algs (list "tree" "tlist")
	  '("Leaf" "tree")
	  '("Branch" "tlist=>tree")
	  '("Empty" "tlist")
	  '("Tcons" "tree=>tlist=>tlist"))

(add-param-algs (list "labtree" "labtlist") 'alg-typeop 2
		'("LabLeaf" "alpha1=>labtree")
		'("LabBranch" "labtlist=>alpha2=>labtree")
		'("LabEmpty" "labtlist")
		'("LabTcons" "labtree=>labtlist=>labtlist"))

; An ordinal notation scheme by W. Buchholz:

(add-algs (list "hterm" "htermlist" "term")
	  '("One" "hterm")
	  '("Dn" "nat=>term=>hterm")
	  '("Hempty" "htermlist")
	  '("Hcons" "hterm=>htermlist=>htermlist")
	  '("Seq" "htermlist=>term"))

; An example for an infinitary algebra (s. ~benl/demo2.scm)

(add-algs (list "inftree" "inftlist")
	  '("Newleaf" "nat=>inftree")
          '("Infbranch" "nat=>inftlist=>inftree")
          '("Lim" "nat=>(nat=>inftree)=>inftree")
          '("Emptyinftlist" "inftlist")
          '("Inftcons" "inftree=>inftlist=>inftlist"))

(finalg? (py "nat")) ;#t
(finalg? (py "ord")) ;#f
(finalg? (py "list nat")) ;#t
(finalg? (py "list alpha")) ;#f
(finalg? (py "nat ytensor boole")) ;#t
(finalg? (py "nat ytensor alpha")) ;#f
(finalg? (py "nat yplus boole")) ;#t
(finalg? (py "nat yplus alpha")) ;#f
(finalg? (py "tree")) ;#t
(finalg? (py "tlist")) ;#t
(finalg? (py "labtree nat boole")) ;#t
(finalg? (py "labtlist nat boole")) ;#t
(finalg? (py "labtree nat alpha")) ;#f
(finalg? (py "labtlist nat alpha")) ;#f
(finalg? (py "hterm")) ;#t
(finalg? (py "inftlist")) ;#f

(sfinalg? (py "list alpha")) ;#t
(sfinalg? (py "ord")) ;#f
(sfinalg? (py "nat ytensor alpha")) ;#t
(sfinalg? (py "nat yplus alpha")) ;#t
(sfinalg? (py "labtree nat alpha")) ;#t
(sfinalg? (py "labtlist nat alpha")) ;#t
(sfinalg? (py "inftlist")) ;#f

(remove-alg-name "nat" "ord" "list" "ytensor" "yplus" "tree"
		 "labtree" "hterm"
		 "inftree")

; 3. Variables
; ============
; (var.scm)


; 4. Constants
; ============
; (pconst.scm)


; 5. Predicates
; =============
; (psym.scm)

; Tests of add-ids (introducing inductively defined predicates)

(set! COMMENT-FLAG #f)
(libload "nat.scm")
(set! COMMENT-FLAG #t)

(add-ids (list (list "Even" (make-arity (py "nat")) "algEven"))
	 '("Even 0" "InitEven")
	 '("allnc n(Even n -> Even(n+2))" "GenEven"))

; Todo: Use allnc n^(Even n^ -> Even(n^ +2)) instead.

(map car (alg-name-to-typed-constr-names "algEven"))
; ("InitEven" "GenEven")

(define idpc
  (idpredconst-name-and-types-and-cterms-to-idpredconst "Even" '() '()))

; There are no types, since the clauses do not contain type variables,
; and no cterms, since the clauses do not contain parameter predicate
; variables.

(define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpc))
(pp (aconst-to-formula aconst0))
; "Even 0"
(define aconst1 (number-and-idpredconst-to-intro-aconst 1 idpc))
(pp (aconst-to-formula aconst1))
; allnc n(Even n -> Even(n+2))

(define eterm1 (proof-to-extracted-term (make-proof-in-aconst-form aconst1)))
(pp (term-to-type eterm1)) 
; "algEven=>algEven"

(add-pvar-name "Q" (make-arity (py "nat")))

(define aconst (imp-formulas-to-elim-aconst (pf "Even m^ -> Q m^")))
(pp (aconst-to-formula aconst))
; allnc m^(Even m^ -> Q 0 -> allnc n(Even n -> Q n -> Q(n+2)) -> Q m^)

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst)))
(pp (term-to-type eterm))
; algEven=>alpha6=>(algEven=>alpha6=>alpha6)=>alpha6

(remove-pvar-name "Q")

(add-ids (list (list "Ev" (make-arity (py "nat")) "algEv")
	       (list "Od" (make-arity (py "nat")) "algOd"))
	 '("Ev 0" "InitEv")
	 '("allnc n(Od n -> Ev(n+1))" "GenEv")
	 '("Od 1" "InitOd")
	 '("allnc n(Ev n -> Od(n+1))" "GenOd"))

(map car (alg-name-to-typed-constr-names "algEv"))
; ("cInitEv" "cGenEv")
(map car (alg-name-to-typed-constr-names "algOd"))
; ("cInitOd" "cGenOd")

(define idpcev
  (idpredconst-name-and-types-and-cterms-to-idpredconst "Ev" '() '()))
(define idpcod
  (idpredconst-name-and-types-and-cterms-to-idpredconst "Od" '() '()))

(define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpcev))
(pp (aconst-to-formula aconst0))
; "Ev 0"
(define aconst1 (number-and-idpredconst-to-intro-aconst 1 idpcev))
(pp (aconst-to-formula aconst1))
; allnc n(Od n -> Ev(n+1))

(define aconst3 (number-and-idpredconst-to-intro-aconst 0 idpcod))
(pp (aconst-to-formula aconst3))
; Od 1

(define aconst4 (number-and-idpredconst-to-intro-aconst 1 idpcod))
(pp (aconst-to-formula aconst4))
; allnc n(Ev n -> Od(n+1))

(define eterm4 (proof-to-extracted-term (make-proof-in-aconst-form aconst4)))
(pp (term-to-type eterm4))
; algEv=>algOd

(add-pvar-name "Q" (make-arity (py "nat")))

(define aconst (imp-formulas-to-elim-aconst (pf "Ev m^ -> Q1 m^")
					    (pf "Od m^ -> Q2 m^")))
(pp (aconst-to-formula aconst))
; allnc m^(
;  Ev m^ -> 
;  Q1 0 -> 
;  allnc n(Od n -> Q2 n -> Q1(n+1)) -> 
;  Q2 1 -> allnc n(Ev n -> Q1 n -> Q2(n+1)) -> Q1 m^)

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst)))
(pp (term-to-type eterm))

; algEv=>
; alpha9=>(algOd=>alpha10=>alpha9)=>alpha10=>(algEv=>alpha9=>alpha10)=>alpha9

(remove-pvar-name "Q")

; - the transitive closure of a relation <.  Introduction axioms:

;   x<y -> TrCl(x,y)
;   TrCl(x,y) -> y<z -> TrCl(x,z)

; Postponed.

(add-var-name "x" (py "alpha"))
(add-pvar-name "R" (make-arity (py "alpha") (py "alpha")))
(add-pvar-name "Q" (make-arity (py "alpha")))

; Example Barral:

(add-ids (list (list "NotNull" (make-arity (py "alpha")) "algNotNull"))
	 '("all x^1,x^2((R x^1 x^2 -> F) -> NotNull x^1)" "NotNullConstr"))

(alg-name-to-tvars "algNotNull")
; ((tvar 1 "alpha"))

; We need two inductively defined existential quantifiers, one (ExID
; with D for double) for a kernel with computational content, and one
; (ExI) for a kernel without.  The reason is to avoid garbage in
; extracted programs.

(add-ids (list (list "ExID" (make-arity) "algExID"))
	 '("all x^(Q x^ -> ExID)" "GenExID"))
;new here: all x^, not allnc

(define idpc (predicate-form-to-predicate (pf "exid n n=m")))
(idpredconst-to-string idpc)
; "exid n n=m"

; Notice that formula-to-free needs to take free variables in idpcs
; into account.  presently we have

; (formula-to-free (pf "exid n n=m"))
; ()


(define aconst (imp-formulas-to-elim-aconst (pf "exid n n=m -> k=0")))
(pp (aconst-to-formula aconst))
; allnc m,k(exid n^602 n^602=m -> all n^603(n^603=m -> k=0) -> k=0)

(define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpc))
(pp (aconst-to-formula aconst0))
; allnc m all n^605(n^605=m -> exid n^606 n^606=m)

(define eterm0 (proof-to-extracted-term (make-proof-in-aconst-form aconst0)))
(pp (term-to-type eterm0))
; nat=>unit=>algExID nat unit

; This should be formulated with uniform implication Q x^ ->^U instead
; of Q^'x^ ->.

(add-ids (list (list "ExI" (make-arity) "algExI"))
	 '("all x^(Q^'x^ -> ExI)" "GenExI")) 

(define idpc (predicate-form-to-predicate (pf "exi n n=m")))
(idpredconst-to-string idpc)
; "exi n n=m"

(define aconst (imp-formulas-to-elim-aconst (pf "exi n n=m -> k=0")))
(pp (aconst-to-formula aconst))
; allnc m,k(exi n^612 n^612=m -> all n^613(n^613=m -> k=0) -> k=0)

(define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpc))
(pp (aconst-to-formula aconst0))
; allnc m all n^615(n^615=m -> exi n^616 n^616=m)

(define eterm0 (proof-to-extracted-term (make-proof-in-aconst-form aconst0)))
(pp (term-to-type eterm0))
; nat=>algExI nat


(add-var-name "y" (py "alpha"))

(add-ids (list (list "Acc" (make-arity (py "alpha")) "algAcc"))
	 '("allnc x(all y(R^'y x -> Acc y) -> Acc x)" "GenAccSup"))
(map car (alg-name-to-typed-constr-names "algAcc"))
; ("DummyalgAcc" "cGenAccSup")

; Here the clauses contain the type variable alpha and the parameter
; predicate variable R^', which can be substituted by themselves.

(define idpc
  (idpredconst-name-and-types-and-cterms-to-idpredconst
   "Acc"
   (list (py "alpha"))
   (list (make-cterm (pv "x1") (pv "x2") (pf "R^'x1 x2")))))

(define formula (make-predicate-formula idpc (pt "x3")))
(pp formula)
; (Acc (cterm (x1,x2) R^'x1 x2))x3

; ... or else can be substituted e.g. by nat and {n1,n2|n1<n2}

(define idpc-inst
  (idpredconst-name-and-types-and-cterms-to-idpredconst
   "Acc"
   (list (py "nat"))
   (list (make-cterm (pv "n1") (pv "n2") (pf "n1<n2")))))

(define formula (make-predicate-formula idpc-inst (pt "n3")))
(pp formula)
; (Acc (cterm (n1,n2) n1<n2))n3

(define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpc))
(pp (aconst-to-formula aconst0))
; allnc x(
;  all y(R^'y x -> (Acc (cterm (x^626,x^625) R^'x^626 x^625))y) -> 
;  (Acc (cterm (x^626,x^625) R^'x^626 x^625))x)

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst0)))
(pp (term-to-type eterm)) 
; (alpha=>algAcc alpha)=>algAcc alpha

(define aconst
  (imp-formulas-to-elim-aconst
   (pf "(Acc alpha (cterm (x70,x69) R^'x70 x69))x^ -> Q x^")))
(pp (aconst-to-formula aconst))
; allnc x^(
;  (Acc (cterm (x^629,x^628) R^'x^629 x^628))x^ -> 
;  allnc x(
;   all y(R^'y x -> (Acc (cterm (x^629,x^628) R^'x^629 x^628))y) -> 
;   all y(R^'y x -> Q y) -> Q x) -> 
;  Q x^)

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst)))
(pp (term-to-type eterm))
; algAcc alpha=>((alpha=>algAcc alpha)=>(alpha=>alpha11)=>alpha11)=>alpha11


(add-ids (list (list "FalsityID" (make-arity) "algFalsityID")))

(pp (pf "FalsityID"))
(add-pvar-name "P" (make-arity))

(define aconst
  (imp-formulas-to-elim-aconst
   (pf "FalsityID -> P")))
(pp (aconst-to-formula aconst))
; FalsityID -> P

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst)))
(pp (term-to-type eterm))
; algFalsityID=>alpha18

(pp eterm)
; (Rec algFalsityID=>alpha18)


(add-ids (list (list "EqID" (make-arity (py "alpha") (py "alpha")) "algEqID"))
	 '("allnc x^ EqID x^ x^" "GenEqID"))

(map car (alg-name-to-typed-constr-names "algEqID"))
; ("cGenEqID")

; Here the clauses contain the type variable alpha, which can be
; substituted by itself.

(define idpc
  (idpredconst-name-and-types-and-cterms-to-idpredconst
   "EqID" (list (py "alpha")) '()))

(define formula (make-predicate-formula idpc (pt "x^1")  (pt "x^2")))
(pp formula)
; "x^1 eqid x^2"

; ... or else can be substituted e.g. by nat

(define idpc-inst
  (idpredconst-name-and-types-and-cterms-to-idpredconst
   "EqID" (list (py "nat")) '()))

(define formula (make-predicate-formula idpc-inst (pt "n1") (pt "n2")))
(pp formula)
; "n1 eqid n2"

(define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpc))
(pp (aconst-to-formula aconst0))
; allnc x^ x^eqid x^

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst0)))
(pp (term-to-type eterm))
; "algEqID"

(define aconst
  (imp-formulas-to-elim-aconst
   (pf "x^1 eqid x^2 -> R x^1 x^2")))
(pp (aconst-to-formula aconst))
; allnc x^1,x^2(x^1 eqid x^2 -> allnc x^ R x^ x^ -> R x^1 x^2)

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst)))
(pp (term-to-type eterm))
; algEqID=>alpha20=>alpha20

(add-ids (list (list "OrID" (make-arity) "algOrID"))
	 '("P1 -> OrID" "InlOrID")
	 '("P2 -> OrID" "InrOrID"))

(map car (alg-name-to-typed-constr-names "algOrID"))
; ("DummyalgOrID" "cInlOrID" "cInrOrID")

; Here the clauses contain the parameter predicate variables P1 and
; P2, which can be substituted by themselves.

(define idpc
  (idpredconst-name-and-types-and-cterms-to-idpredconst
   "OrID" '()
   (list (make-cterm (pf "P1")) (make-cterm (pf "P2")))))

(define formula (make-predicate-formula idpc))
(pp formula)
; P1 or P2

; ... or else can be substituted e.g. {|T} and {|F}

(define idpc-inst
  (idpredconst-name-and-types-and-cterms-to-idpredconst
   "OrID" '() (list  (make-cterm (pf "T")) (make-cterm (pf "F")))))

(define formula (make-predicate-formula idpc-inst))
(pp formula)
; T or F

(define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpc))
(pp (aconst-to-formula aconst0))
; P1 -> P1 or P2

(define aconst1 (number-and-idpredconst-to-intro-aconst 1 idpc))
(pp (aconst-to-formula aconst1))
; P2 -> P1 or P2

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst0)))
(pp (term-to-type eterm))
; alpha24=>algOrID alpha24 alpha22

(define aconst
  (imp-formulas-to-elim-aconst
   (pf "P1 or P2 -> P")))
(pp (aconst-to-formula aconst))
; P1 or P2 -> (P1 -> P) -> (P2 -> P) -> P

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst)))
(pp (term-to-type eterm))
; algOrID alpha23 alpha21=>(alpha23=>alpha18)=>(alpha21=>alpha18)=>alpha18

(define idpc
  (idpredconst-name-and-types-and-cterms-to-idpredconst
   "OrID" '() (list (make-cterm (pf "P1")) (make-cterm (pf "P2")))))

; Test for additional type parameters.

(add-var-name "f" (py "alpha=>alpha"))
(add-ids (list (list "I" (make-arity (py "nat")) "algI"))
	 '("allnc x,f(Equal x(f x) -> I 0)" "InitI"))

(pp (pf "(I alpha)0"))
(pp (pf "(I nat)0"))

(define idpc-inst
  (idpredconst-name-and-types-and-cterms-to-idpredconst
   "I"
   (list (py "nat"))
   '()))

(define formula (make-predicate-formula idpc-inst (pt "n3")))
(pp formula)
; "(I nat)n3"

(define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpc-inst))
(pp (aconst-to-formula aconst0))
; allnc n689,(nat=>nat)_690(Equal n689((nat=>nat)_690 n689) -> (I nat)0)

(remove-var-name "x")
(remove-pvar-name "P" "R")
(remove-idpc-name "Even" "Ev" "NotNull" "ExID" "ExI" "Acc" "FalsityID" 
		  "EqID" "OrID" "I")


; 6. Terms
; ========
; (term.scm and pp.scm)


; 7. Formulas and comprehension terms
; ===================================
; (formula.scm and boole.scm)


(add-var-name "x" (py "alpha"))
(add-pvar-name "Q" (make-arity (py "alpha")))

(add-ids (list (list "ExID" (make-arity) "algExID"))
	 '("all x^(Q x^ -> ExID)" "GenExID"))

(define formula (pf "exid boole1(boole1=boole2 -> Q alpha)"))
(define formula (pf "exid x1(Equal x1 x2 -> Q x3)"))

(map var-to-string (formula-to-free formula))
(map tvar-to-string (formula-to-tvars formula))
(map pvar-to-string (formula-to-pvars formula))

(pp (formula-subst formula (py "alpha") (py "unit")))

(remove-var-name "x")
(remove-pvar-name "Q")
(remove-idpc-name "ExID")

(define testformula1
  (pf "all n allnc m(exca n1 n=n1 -> excl m1,m2(m1=m2 and F))"))

(formula-to-free testformula1)
(ex-free-formula? testformula1)
(pp (nbe-formula-to-type testformula1))
(length (formula-to-prime-subformulas testformula1))

(alpha-equal-formulas-to-renaming
 (pf "all boole allnc unit(exca boole1 boole=boole1 ->
                           excl unit1,unit2(unit1=unit2 and F))")
 (pf "all boole allnc unit(exca boole1 boole=boole1 ->
                           excl unit1,unit3(unit1=unit3 and F))"))


; 8. and 9. Assumption variables and axioms
; =========================================
; (axiom.scm)

(add-param-alg "list" 'prefix-typeop
	       '("Nil" "list")
	       '("Cons" "alpha1=>list=>list"))

(add-pvar-name "P" (make-arity (py "nat")))

(pp (caar (all-formulas-to-uninst-imp-formulas-and-tpinst
	   (pf "all n^(E n^ -> P n^)"))))
; all n^1284(
;  E n^1284 -> 
;  P298 0 -> all n1285(P298 n1285 -> P298(Succ n1285)) -> P298 n^1284)

(remove-pvar-name "P")

(add-pvar-name "P" (make-arity (py "list nat")))
(add-var-name "ns" (py "list nat"))

(pp (caar (all-formulas-to-uninst-imp-formulas-and-tpinst
	   (pf "all ns^(SE ns^ -> P ns^)"))))
; all (list alpha15)^1330(
;  (SE alpha15)(list alpha15)^1330 -> 
;  (Pvar list alpha15)_311(Nil alpha15) -> 
;  all alpha15^1332,(list alpha15)^1331(
;   (SE alpha15)(list alpha15)^1331 -> 
;   (Pvar list alpha15)_311(list alpha15)^1331 -> 
;   (Pvar list alpha15)_311((Cons alpha15)alpha15^1332(list alpha15)^1331)) -> 
;  (Pvar list alpha15)_311(list alpha15)^1330)

(display-substitutions
 (cadr (all-formulas-to-uninst-imp-formulas-and-tpinst
	(pf "all ns^(SE ns^ -> P ns^)"))))
; Type substitution:
; alpha13	->	nat
; Predicate substitution:
; (Pvar list alpha13)_309	->	(cterm (ns^) P ns^)

(remove-pvar-name "P")
(remove-var-name "ns")
(remove-alg-name "list")

(add-pvar-name "P" (make-arity (py "nat")))

(pp (aconst-to-formula
     (all-formulas-to-ind-aconst (pf "all n P n"))))

; all n1427(P 0 -> all n1428(P n1428 -> P(Succ n1428)) -> P n1427)

(remove-pvar-name "P")

; Simultaeously defined algebras require simultaneous induction:

(add-algs (list "tree" "tlist")
	  '("Leaf" "tree")
	  '("Branch" "tlist=>tree")
	  '("Empty" "tlist")
	  '("Tcons" "tree=>tlist=>tlist"))

(add-pvar-name "P" (make-arity (py "tree")))
(add-pvar-name "Q" (make-arity (py "tlist")))

(pp (aconst-to-formula
     (all-formulas-to-ind-aconst
      (pf "all tree P tree")
      (pf "all tlist Q tlist"))))

; all tree1450(
;  P Leaf -> 
;  all tlist1453(Q tlist1453 -> P(Branch tlist1453)) -> 
;  Q Empty -> 
;  all tree1452,tlist1451(
;   P tree1452 -> Q tlist1451 -> Q(Tcons tree1452 tlist1451)) -> 
;  P tree1450)

(remove-pvar-name "P" "Q")
(remove-alg-name "tree")

; Cases:

(add-pvar-name "P" (make-arity (py "nat")))

(pp (aconst-to-formula
     (all-formula-to-cases-aconst (pf "all n P n"))))

; all n1461(P 0 -> all n1462 P(Succ n1462) -> P n1461)

(remove-pvar-name "P")

; GInd: all h,x(all x(all y(hy<hx -> Ry) -> Rx) -> allnc p(p -> Rx))
; with h a measure function of type alpha1 => ... => alphan => nat.

(add-var-name "h" (py "alpha=>alpha=>nat"))
(add-var-name "x" (py "alpha"))
(add-pvar-name "R" (make-arity (py "alpha") (py "alpha")))

(pp (aconst-to-formula
     (all-formula-to-gind-aconst (pf "all x1,x2 R x1 x2") 2)))

; all h1436,x1437,x1438(
;  all x1437,x1438(
;   all x1439,x1440(h1436 x1439 x1440<h1436 x1437 x1438 -> R x1439 x1440) -> 
;   R x1437 x1438) -> 
;  allnc boole(boole -> R x1437 x1438))


; intro and elim

(add-ids (list (list "Even" (make-arity (py "nat")) "algEven"))
	 '("Even 0" "InitEven")
	 '("allnc n(Even n -> Even(n+2))" "GenEven"))

(define idpc
  (idpredconst-name-and-types-and-cterms-to-idpredconst "Even" '() '()))

; There are no types, since the clauses do not contain type variables,
; and no cterms, since the clauses do not contain parameter predicate
; variables.

(define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpc))
(pp (aconst-to-formula aconst0))

; "Even 0"

(define aconst1 (number-and-idpredconst-to-intro-aconst 1 idpc))
(pp (aconst-to-formula aconst1))

; allnc n(Even n -> Even(n+2))

(add-pvar-name "Q" (make-arity (py "nat")))

(define aconst (imp-formulas-to-elim-aconst (pf "Even m^ -> Q m^")))
(pp (aconst-to-formula aconst))

; allnc m^(Even m^ -> Q 0 -> allnc n^(Even n^ -> Q n^ -> Q(n^ +2)) -> Q m^)

(remove-pvar-name "Q")
(remove-idpc-name "Even")


; 10. Proofs
; ==========
; (proof.scm)


; 11. Partial proofs
; ==================
; (pproof.scm)

; Tests for use

(add-var-name "x" (py "alpha"))
(pp "Eq-Refl")
; allnc alpha^ Equal alpha^ alpha^

(set-goal (pf "all boole Equal boole boole"))
(assume "boole")
(use "Eq-Refl")

(add-pvar-name "P" (make-arity (py "alpha")))
(add-global-assumption "MPUnary" (pf "all x(P1 x -> (P1 x -> P2 x) -> P2 x)"))

(set-goal (pf "all x1 P3 x1"))
(assume "x1")
(use "MPUnary" (make-cterm (pv "x4") (pf "Total x4")) (pt "x5"))

(remove-pvar-name "P")

; The next example show that error messages in use-intern in case of
; missing terms refer to the original variable in the used formula
; even if such variables had to be renamed.

(pp "Eq-Trans")

; allnc alpha^1,alpha^2,alpha^3(
;  Equal alpha^1 alpha^2 -> Equal alpha^2 alpha^3 -> Equal alpha^1 alpha^3)

(set-goal (pf "all x Equal x x"))
(assume "x")
; (use "Eq-Trans")

; use
; more terms expected, to be substituted for
; alpha^2

(use "Eq-Trans" (pt "x1"))

(remove-var-name"x")


; Tests for ind

(add-pvar-name "P" (make-arity (py "nat")))

(set-goal (pf "all n P n"))
(ind)
; ok, ?_1 can be obtained from
; ?_3: all n1423(P n1423 -> P(Succ n1423)) from
;   n1421

; ?_2: P 0 from
;   n1421

(set-goal (pf "all n^(E n^ -> P n^)"))
(ind)
; ok, ?_1 can be obtained from
; ?_3: all n1298(P n1298 -> P(Succ n1298)) from
;   n^1296  1:E n^1296

; ?_2: P 0 from
;   n^1296  1:E n^1296

(set-goal (pf "all n^ P n^"))
(assume "n^")
(ind (pt "n^"))
; ok, ?_2 can be obtained from
; ?_5: all n1292(P n1292 -> P(Succ n1292)) from
;   n^

; ?_4: P 0 from
;   n^

; ?_3: E n^ from
;   n^

(remove-pvar-name "P")

(add-alg "ord" '("OrdZero" "ord") '("OrdSup" "(nat=>ord)=>ord"))
(add-pvar-name "P" (make-arity (py "ord")))

(set-goal (pf "all ord P ord"))
(ind)
; ok, ?_1 can be obtained from
; ?_3: all (nat=>ord)_1426(
;       all n1427 P((nat=>ord)_1426 n1427) -> P(OrdSup(nat=>ord)_1426)) from
;   ord1424

; ?_2: P OrdZero from
;   ord1424

; (set-goal (pf "all ord^(STotal ord^ -> P ord^)"))
; (ind)
; sfinalg-to-se-const
; structure finitary algebra expected
; ord

(remove-pvar-name "P")
(remove-alg-name "ord")

(add-param-alg "list" 'prefix-typeop
	       '("Nil" "list")
	       '("Cons" "alpha1=>list=>list"))
(add-pvar-name "P" (make-arity (py "list nat")))
(add-var-name "ns" (py "list nat"))

(set-goal (pf "all ns P ns"))
(ind)
; ok, ?_1 can be obtained from
; ?_3: all n1296,ns1297(P ns1297 -> P((Cons nat)n1296 ns1297)) from
;   ns1291

; ?_2: P(Nil nat) from
;   ns1291

; (set-goal (pf "all ns^(E ns^ -> P ns^)"))
; (ind)
; does not allow usage of (ind): the uninst-type of ns^ is list alpha
; and therefore the used indction axiom is formulated with SE.

(set-goal (pf "all ns^(SE ns^ -> P ns^)"))
(ind)
; ok, ?_1 can be obtained from
; ?_3: all n^1308,ns^1309(
;       SE ns^1309 -> P ns^1309 -> P((Cons nat)n^1308 ns^1309)) from
;   ns^1303  1:SE ns^1303

; ?_2: P(Nil nat) from
;   ns^1303  1:SE ns^1303

(set-goal (pf "all ns^(STotal ns^ -> P ns^)"))
(ind)

(set-goal (pf "all ns^ P ns^"))
(assume "ns^")
(ind (pt "ns^"))
; ok, ?_2 can be obtained from
; ?_5: all n^1354,ns^1355(
;        SE ns^1355 -> P ns^1355 -> P((Cons nat)n^1354 ns^1355)) from
;   ns^

; ?_4: P(Nil nat) from
;   ns^

; ?_3: SE ns^ from
;   ns^

(remove-pvar-name "P")
(remove-var-name "ns")


(add-pvar-name "P" (make-arity (py "list alpha")))
(add-var-name "x" (py "alpha"))
(add-var-name "xs" (py "list alpha"))

(set-goal (pf "all xs P xs"))
(ind)
; ok, ?_1 can be obtained from
; ?_3: all x1433,xs1434(P xs1434 -> P((Cons alpha)x1433 xs1434)) from
;   xs1428

; ?_2: P(Nil alpha) from
;   xs1428

(set-goal (pf "all xs^(SE xs^ -> P xs^)"))
(ind)
; ok, ?_1 can be obtained from
; ?_3: all x^1399,xs^1400(
;       SE xs^1400 -> P xs^1400 -> P((Cons alpha)x^1399 xs^1400)) from
;   xs^1394  1:SE xs^1394

; ?_2: P(Nil alpha) from
;   xs^1394  1:SE xs^1394

(set-goal (pf "all xs^(STotal xs^ -> P xs^)"))
(ind)
; ?_1: all xs^(STotal xs^ -> P xs^)
; ok, ?_1 can be obtained from
; ?_3: all x^1392,xs^1393(
;       SE xs^1393 -> P xs^1393 -> P((Cons alpha)x^1392 xs^1393)) from
;   xs^1387  1:SE xs^1387

; ?_2: P(Nil alpha) from
;   xs^1387  1:SE xs^1387

(remove-pvar-name "P")
(remove-var-name "x" "xs")
(remove-alg-name "list")


; Tests for simind

(add-algs (list "tree" "tlist")
	  '("Leaf" "tree")
	  '("Branch" "tlist=>tree")
	  '("Empty" "tlist")
	  '("Tcons" "tree=>tlist=>tlist"))

(add-pvar-name "P" (make-arity (py "tree")))
(add-pvar-name "Q" (make-arity (py "tlist")))

(set-goal (pf "all tree P tree"))
(simind (pf "all tlist Q tlist"))
; ok, ?_1 can be obtained from
; ?_5: all tree55,tlist54.P tree55 -> Q tlist54 -> Q(Tcons tree55 tlist54) from
;   tree51

; ?_4: Q Empty from
;   tree51

; ?_3: all tlist56.Q tlist56 -> P(Branch tlist56) from
;   tree51

; ?_2: P Leaf from
;   tree51

(set-goal (pf "all tree^(STotal tree^ -> P tree^)"))
(simind (pf "all tlist^(STotal tlist^ -> Q tlist^)"))

(remove-pvar-name "P")
(remove-pvar-name "Q")
(remove-alg-name "tree")

(add-algs (list "inftree" "inftlist")
	  '("Newleaf" "boole=>inftree")
          '("Infbranch" "boole=>inftlist=>inftree")
          '("Lim" "boole=>(boole=>inftree)=>inftree")
          '("Emptyinftlist" "inftlist")
          '("Inftcons" "inftree=>inftlist=>inftlist"))

(add-pvar-name "P" (make-arity (py "inftree")))
(add-pvar-name "Q" (make-arity (py "inftlist")))

(set-goal (pf "all inftree P inftree"))
(simind (pf "all inftlist Q inftlist"))

(set-goal (pf "all inftree^(STotal inftree^ -> P inftree^)"))
(simind (pf "all inftlist^(STotal inftlist^ -> Q inftlist^)"))
; ok, ?_1 can be obtained from
; ?_6: all inftree^91,inftlist^90(
;       STotal inftree^91 -> 
;       STotal inftlist^90 -> 
;       P inftree^91 -> Q inftlist^90 -> Q(Inftcons inftree^91 inftlist^90)) from
;   inftree^87  1:STotal inftree^87

; ?_5: Q Emptyinftlist from
;   inftree^87  1:STotal inftree^87

; ?_4: all boole^93,(boole=>inftree)^92(
;       SE boole^93 -> 
;       all boole94 STotal((boole=>inftree)^92 boole94) -> 
;       all boole95 P((boole=>inftree)^92 boole95) -> 
;       P(Lim boole^93(boole=>inftree)^92)) from
;   inftree^87  1:STotal inftree^87

; ?_3: all boole^97,inftlist^96(
;       SE boole^97 -> 
;       STotal inftlist^96 -> 
;       Q inftlist^96 -> P(Infbranch boole^97 inftlist^96)) from
;   inftree^87  1:STotal inftree^87

; ?_2: all boole^98(SE boole^98 -> P(Newleaf boole^98)) from
;   inftree^87  1:STotal inftree^87

(remove-pvar-name "P" "Q")
(remove-alg-name "inftree")


; Tests for cases

(add-pvar-name "P" (make-arity (py "nat")))

(set-goal (pf "all n P n"))
(cases)
; ok, ?_1 can be obtained from
; ?_3: all n1358 P(Succ n1358) from
;   n1356

; ?_2: P 0 from
;   n1356

(set-goal (pf "all n^(E n^ -> P n^)"))
(cases)
; ok, ?_1 can be obtained from
; ?_3: all n1370 P(Succ n1370) from
;   n^1368  1:E n^1368

; ?_2: P 0 from
;   n^1368  1:E n^1368

(set-goal (pf "all n^ P n^"))
(assume "n^")
(cases (pt "n^"))
; ok, ?_2 can be obtained from
; ?_5: all n1376(Equal n^(Succ n1376) -> P(Succ n1376)) from
;   n^

; ?_4: Equal n^ 0 -> P 0 from
;   n^

; ?_3: E n^ from
;   n^

(remove-pvar-name "P")

(add-alg "ord" '("OrdZero" "ord") '("OrdSup" "(nat=>ord)=>ord"))
(add-pvar-name "P" (make-arity (py "ord")))

(set-goal (pf "all ord P ord"))
(cases)
; ok, ?_1 can be obtained from
; ?_3: all (nat=>ord)_1379 P(OrdSup(nat=>ord)_1379) from
;   ord1377

; ?_2: P OrdZero from
;   ord1377

; (set-goal (pf "all ord^(STotal ord^ -> P ord^)"))
; (cases)
; sfinalg-to-se-const
; structure finitary algebra expected
; ord

(remove-pvar-name "P")
(remove-alg-name "ord")

(add-param-alg "list" 'prefix-typeop
	       '("Nil" "list")
	       '("Cons" "alpha1=>list=>list"))
(add-pvar-name "P" (make-arity (py "list nat")))
(add-var-name "ns" (py "list nat"))

(set-goal (pf "all ns P ns"))
(cases)
; ok, ?_1 can be obtained from
; ?_3: all n1386,ns1387 P((Cons nat)n1386 ns1387) from
;   ns1381

; ?_2: P(Nil nat) from
;   ns1381

; (set-goal (pf "all ns^(E ns^ -> P ns^)"))
; (cases)
; does not allow usage of (cases): the uninst-type of ns^ is list alpha
; and therefore the used cases axiom is formulated with SE.

(set-goal (pf "all ns^(SE ns^ -> P ns^)"))
(cases)

; ok, ?_1 can be obtained from
; ?_3: all n^1400,ns^1401(SE ns^1401 -> P((Cons nat)n^1400 ns^1401)) from
;   ns^1395  1:SE ns^1395

; ?_2: P(Nil nat) from
;   ns^1395  1:SE ns^1395

(set-goal (pf "all ns^(STotal ns^ -> P ns^)"))
(cases)

(set-goal (pf "all ns^ P ns^"))
(assume "ns^")
(cases (pt "ns^"))
; ok, ?_2 can be obtained from
; ?_5: all n^1417,ns^1418(
;       SE ns^1418 -> 
;       Equal ns^((Cons nat)n^1417 ns^1418) -> P((Cons nat)n^1417 ns^1418)) from
;   ns^

; ?_4: Equal ns^(Nil nat) -> P(Nil nat) from
;   ns^

; ?_3: SE ns^ from
;   ns^

(remove-pvar-name "P")
(remove-var-name "ns")

(add-pvar-name "P" (make-arity (py "list alpha")))
(add-var-name "x" (py "alpha"))
(add-var-name "xs" (py "list alpha"))

(set-goal (pf "all xs P xs"))
(cases)
; ok, ?_1 can be obtained from
; ?_3: all x1424,xs1425 P((Cons alpha)x1424 xs1425) from
;   xs1419

; ?_2: P(Nil alpha) from
;   xs1419

(set-goal (pf "all xs^(SE xs^ -> P xs^)"))
(cases)
; ok, ?_1 can be obtained from
; ?_3: all x^1431,xs^1432(SE xs^1432 -> P((Cons alpha)x^1431 xs^1432)) from
;   xs^1426  1:SE xs^1426

; ?_2: P(Nil alpha) from
;   xs^1426  1:SE xs^1426

(set-goal (pf "all xs^(STotal xs^ -> P xs^)"))
(cases)

(remove-pvar-name "P")
(remove-var-name "x" "xs")
(remove-alg-name "list")

(set-goal (pf "all boole^(STotal boole^ -> boole^ =boole^)"))
(cases)
; ok, ?_1 can be obtained from
; ?_3: False=False from
;   boole^1536  1:E boole^1536

; ?_2: True=True from
;   boole^1536  1:E boole^1536
(use "Truth-Axiom")
(use "Truth-Axiom")
; Proof finished.

(set-goal (pf "all boole^ boole^ =boole^"))
(assume "boole^")
(cases (pt "boole^"))
; ok, ?_2 can be obtained from
; ?_5: (boole^ -> F) -> False=False from
;   boole^

; ?_4: boole^ -> True=True from
;   boole^

; ?_3: E boole^ from
;   boole^


; Test for elim

(add-ids (list (list "Even" (make-arity (py "nat")) "algEven"))
	 '("Even 0" "InitEven")
	 '("allnc n(Even n -> Even(n+2))" "GenEven"))

(set-goal (pf "allnc n(Even n -> ex m n=m+m)"))
(assume "n")
(elim)
(ex-intro (pt "0"))
(use "Truth-Axiom")
(assume "n1" "Even n1" "IH")
(by-assume-with "IH" "m" "n1=m+m")
(ex-intro (pt "m+1"))
(ng)
(use "n1=m+m")
; Proof finished.

(remove-idpc-name "Even")


; 13. Automated propositional proofs
; ==================================
; (prop.scm)


; 16. Extracted terms
; ===================
; (ets.scm and etsd.scm)

(define (extraction-test proof)
  (let ((et (proof-to-extracted-term proof))
	(etd (proof-to-extracted-d-term proof)))
    (pp et)
    (pp (nt et))
    (pp etd)
    (pp (nt etd))))

; simple proof by cases
(set-goal "all nat1 ex nat2 . nat1 = nat2")
(cases)
(ex-intro (pt "0"))
(use "Truth-Axiom")
(assume "nat1")
(strip)
(ex-intro (pt "Succ nat1"))
(use "Truth-Axiom")
(extraction-test (current-proof))

; simple proof by induction
(set-goal "all nat1 ex nat2 . nat1 = nat2")
(ind)
(ex-intro (pt "0"))
(use "Truth-Axiom")
(assume "nat1")
(strip)
(ex-intro (pt "Succ nat1"))
(use "Truth-Axiom")
(extraction-test (current-proof))

; simple proof by general induction
(set-goal "all nat1 ex nat2 . nat1 = nat2")
(gind (pt "[nat]nat"))
(assume "nat1")
(strip)
(ex-intro (pt "nat1"))
(use "Truth-Axiom")
(extraction-test (current-proof))


; 17. A-translation
; =================
; (atr.scm)

