; $Id: higman01.scm,v 1.7 2008/01/25 13:30:20 logik Exp $
; An inductive proof Higman's Lemma for a 0/1 alphabet
; see Coquand/Fridlender 1994
; We prove that every infinite sequence in a  0/1 alphabet has a good
; initial segment

; 1. Definitions

(exload "bar/bar.scm")

(aga "only-two-letters" (pf "all a,b,c.(a=b -> F) -> (c=a -> F) -> c=b"))

(add-ids (list (list "R" (make-arity nat seq seq)))
	 '("R a (Lin (tsil nat)) (Lin (tsil nat))") 
	 '("allnc vs,ws,w,a. R a vs ws ->
                             R a (vs::w) (ws::(w::a))"))

(add-ids (list (list "TT" (make-arity nat seq seq)))
	 '("allnc ws,zs,w,a,b. (a=b -> F) -> R b ws zs ->
                               TT a (zs::w) (zs::(w::a))")
         '("allnc ws,zs,w,a. TT a ws zs -> 
                             TT a (ws::w) (zs::(w::a))")
         '("allnc ws,zs,w,a. (a=b -> F) -> TT a ws zs ->
                             TT a ws (zs::(w::b))"))

(aga "lemma1nc" (pf "allnc ws,w,a. L ws w -> L ws (w::a)"))  
(aga "lemma2nc" (pf "allnc ws,zs,a. R a ws zs -> Good ws -> Good zs"))
(aga "lemma3nc" (pf "allnc ws,zs,a. TT a ws zs -> Good ws -> Good zs"))
(aga "lemma4nc" (pf "allnc ws,zs,a.(ws=(Lin (tsil nat)) -> F) -> 
                       R a ws zs -> TT a ws zs "))

; 2. Interactive proofs

; Prop1 has been proven in bar.scm

; Prop2

(set-goal  (pf "allnc xs. Bar xs ->
                allnc ys. Bar ys -> 
                all zs,a,b. (a=b -> F) -> TT a xs zs  -> TT b ys zs -> 
                Bar zs"))
(assume "xs1")
(elim)

; 1. Good xs 
(assume "xs" "Good xs" "ys" "Bar ys" "zs" "a" "b" "a=b -> F" 
        "TT a xs zs" "TT b ys zs")
(intro 0)
(use-with "lemma3nc" (pt "xs") (pt "zs") (pt "a") "TT a xs zs" "Good xs")

; 2. all w Bar(xs::w)
(assume "xs" "all w Bar(xs::w)" "ih1" "ys1")
(elim)

; 2.1
(assume "ys" "Good ys"  "zs" "a" "b" "a=b -> F" "TT a xs zs" "TT b ws zs")
(intro 0)
(use-with "lemma3nc" (pt "ys") (pt "zs") (pt "b") "TT b ws zs" "Good ys")

; 2.2
(assume "ys" "all w Bar(ys::w)" "ih2" "zs" "a" "b"
	"a=b -> F" "TT a xs zs" "TT b ws zs")
(intro 1)

; structural induction on w 
(ind) 

; 2.2.1
(use "Prop1")

; 2.2.2
(assume "z" "c" "Bar(zs::z)")

(cases (pt "c=a"))

(assume "c=a")
(simp "c=a")

(use "ih1" (pt "z") (pt "ys") (pt "a") (pt"b"))
; Bar ys
(intro 1)
(use "all w Bar(ys::w)")
; a=b -> F
(use "a=b -> F")

; TT a(xs::z) (zs::z::a) from
(intro 1)
(use "TT a xs zs")

(intro 2)
(assume "b=a")
(use "a=b -> F")
(simp "b=a")
(prop)
(use "TT b ws zs")

; false
(assume "c=a -> F")
(cut (pf "c=b"))
(assume "c=b")

(use-with "ih2" (pt "z") (pt "zs::z::c") (pt "a") (pt "c") "?" "?" "?")
(assume "a=c")
(use "c=a -> F")
(simp "a=c")
(ng)
(use "Truth-Axiom")

(simp "c=b")
(intro 2)
(use "a=b -> F")
(use "TT a xs zs")

(simp "c=b")
(intro 1)
(use "TT b ws zs")
(use "only-two-letters" (pt "a"))
(use "a=b -> F")
(use "c=a -> F")
(save  "Prop2")

; The extracted program from Prop2

(av "gc" (py "tsil nat=>tsil(tsil nat)=>tree"))
(av "gd" (py "tsil nat=>tree=>tsil(tsil nat)=>nat=>nat=>tree"))
(av "ge" (py "tsil nat=>tsil(tsil nat)=>nat=>nat=>tree"))

(term-to-expr (nt (proof-to-extracted-term (current-proof))))

; ((|(Rec tree=>tree=>tsil(tsil nat)=>nat=>nat=>tree)|
;    (lambda (tree5)
;      (lambda (ws6) (lambda (a7) (lambda (a8) |Leaf|)))))
;  (lambda (ga5)
;    (lambda (gd6)
;      ((|(Rec tree=>tsil(tsil nat)=>nat=>nat=>tree)|
;         (lambda (ws11) (lambda (a12) (lambda (a13) |Leaf|))))
;       (lambda (ga11)
;         (lambda (ge12)
;           (lambda (ws13)
;             (lambda (a14)
;               (lambda (a15)
;                 (|Branch|
;                   ((|(Rec tsil nat=>tree)| |cPropOne|)
;                    (lambda (w17)
;                      (lambda (a18)
;                        (lambda (tree19)
;                          ("if" (a18 "=" a14)
;                                (((((gd6 w17) (|Branch| ga11))
;                                   (ws13 "::" (w17 "::" a14)))
;                                  a14)
;                                 a15)
;                                ((((ge12 w17) (ws13 "::" (w17 "::" a18)))
;                                  a14)
;                                 a18))))))))))))))))

; Prop3

(set-goal  (pf "all a. allnc xs. Bar xs -> (xs = (Lin (tsil nat)) -> F) ->
                           all zs. R a xs zs -> Bar zs"))
(assume "a" "xs1")

(elim)

; all ws.good ws -> formula[a,ws]

(assume "xs" "Good xs" "xs ne Lin" "zs" "R a xs zs")
(intro 0)
(use-with "lemma2nc" (pt "xs") (pt "zs") (pt "a") "R a xs zs" "Good xs")

; step

(assume "xs"  "all w Bar xs::w" "ih"  "xs ne Lin" "zs" "R a xs zs")

(intro 1)

(ind)

(use "Prop1")

(assume "z" "c" "Bar zs::z")

(cases (pt "c=a"))

(assume "c=a")

(use-with "ih" (pt "z") "?" (pt "zs::z::c") "?")
(ng)
(prop)

; R a(xs::z)(zs::z::c) from
(simp "c=a")
(intro 1)
(use "R a xs zs")


; (c=a -> F) -> Bar(zs::z::c) from
(assume "c=a -> F")
(cut (pf "a=c -> F"))
(assume "a=c -> F")
(use-with "Prop2"  (pt "xs") "?" 
                   (pt "zs::z") "Bar zs::z" 
                   (pt "zs::z::c")(pt "a") (pt "c") "?" "?" "?")




; Bar xs
(intro 1)
(use "all w Bar xs::w")

; a=c -> F 
(use "a=c -> F")

; TT a xs(zs::z::c)
(intro 2)
(use "a=c -> F")

; TT a xs zs from
(use "lemma4nc" )
(use "xs ne Lin")
(use "R a xs zs")


; TT c(zs::z)(zs::z::c) from
(intro 0 (pt "xs")(pt "a"))
(use "c=a -> F")
(use "R a xs zs")

; a=c -> F from
(assume "a=c")
(use "c=a -> F")
(simp "a=c")
(ng)
(use "Truth-Axiom")

(save "Prop3")

; The extracted program from Prop3

(term-to-expr (nt (proof-to-extracted-term (current-proof))))

; (lambda (a0)
;   ((|(Rec tree=>tsil(tsil nat)=>tree)| (lambda (ws3) |Leaf|))
;    (lambda (ga3)
;      (lambda (gc4)
;        (lambda (ws5)
;          (|Branch|
;            ((|(Rec tsil nat=>tree)| |cPropOne|)
;             (lambda (w7)
;               (lambda (a8)
;                 (lambda (tree9)
;                   ("if" (a8 "=" a0)
;                         ((gc4 w7) (ws5 "::" (w7 "::" a8)))
;                         (((((|cPropTwo| (|Branch| ga3)) tree9)
;                            (ws5 "::" (w7 "::" a8)))
;                           a0)
;                          a8))))))))))))

; The proof of the Theorem

(set-goal (pf "Bar (Lin (tsil nat))"))
(intro 1)

(ind)
;1.
(use "Prop1")
;2.
(assume "w"  "a" 1)
(use-with "Prop3" (pt "a") (pt ":w") 1 "?" (pt ":(w::a)") "?")
(ng)
(prop)

; R a(:w)(:(w::a))
(intro 1)
(intro 0)
(save "Thm")

(term-to-expr (nt (proof-to-extracted-term (current-proof))))

; (|Branch|
;   ((|(Rec tsil nat=>tree)| |cPropOne|)
;    (lambda (w1)
;      (lambda (a2)
;        (lambda (tree3)
;          (((|cPropThree| a2) tree3) (":" (w1 "::" a2))))))))


(set-goal (pf " all f  ex m. Good (Init f m)"))
(assume "f")
(use-with "Bar-thm" (pt "(Lin (tsil nat))") "Thm" (pt "f")(pt "0") "?")
; Init f 0=(Lin tsil nat)
(ng)
(use "Truth-Axiom")

(define program (proof-to-extracted-term (current-proof)))


(animate "Bar-thm")
(animate "Thm")
(animate "Prop1")
(animate "Prop2")
(animate "Prop3")

(term-to-expr program)

; ==> (lambda (f) (((|cBarXxthm| |cThm|) f) "0"))

(define nprogram (nt program))
(term-to-string nprogram)

; 3. Test of the extracted program

(define (run-higman infinite-sequence)
  (dt (nt (mk-term-in-app-form nprogram infinite-sequence))))

; a. [0 0], [1 1 0], [0 1 0 1], [0], ...
(apc "Seq" (mk-arrow (py "nat")(py "(tsil nat)")) 1)
(add-rewrite-rule (pt "Seq 0")(pt ":0::0"))
(add-rewrite-rule (pt "Seq 1")(pt "(:1::1)::0"))
(add-rewrite-rule (pt "Seq 2")(pt "((:0::1)::0)::1"))
(add-rewrite-rule (pt "Seq (++(++(++ n)))")(pt ":0"))
(run-higman (pt "Seq"))
; ==> 3  
; i.e., the subsequence of consisting of the first three word is good

; b. [0 0], [1], [1 0], [], [], ...

(apc "Interesting" (mk-arrow (py "nat")(py "(tsil nat)")) 1)
(add-rewrite-rule (pt "Interesting 0")(pt ":0::0"))
(add-rewrite-rule (pt "Interesting 1")(pt ":1"))
(add-rewrite-rule (pt "Interesting 2")(pt ":1::0"))
(add-rewrite-rule (pt "Interesting (++(++(++ n)))")(pt "(Lin nat)"))
(run-higman (pt "Interesting"))

; ==> 5  
; This is an example in which not the shortest good initial segment is found.
