/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
/*
 * $Id: configfile.h,v 1.5 1999/12/20 19:51:33 kos Exp $
 *
 */

#ifndef _LOCAL_CONFIG_H
#define _LOCAL_CONFIG_H

#include "array.h"

#define DEFAULT_CLASS "default"
#define CONFIG_LINELEN 1024
#define CONFIG_SEPARATORS " \t"

#define CONFIG_VAR_ELEMLEN 1

typedef struct config_elem_t {
  char lhs[CONFIG_LINELEN];
  char rhs[CONFIG_LINELEN];
} config_elem_t;

typedef struct config_class_t {
  char name[CONFIG_LINELEN];
  array *elements;
} config_class_t;

typedef struct {
  array *classes;  
  char errstring[CONFIG_LINELEN];
  char configclass[CONFIG_LINELEN];
  char separators[CONFIG_LINELEN];
} config_t;

config_t * config_init(char *class);
int config_destroy(config_t *c);
int config_seterror(config_t *c, char *, ...);
char *config_perror(config_t *);
int config_get(config_t *c, char *what, char *res, int len);
int config_set(config_t *c, char *what, char *towhat);
int config_int_get(config_t *c, char *what);
char *config_char_get(config_t *c, char *what);
int config_load(config_t *, char *);
int config_save(config_t *, char *);
int config_nelems(config_t *);
int config_getbynam(config_t *c, int what, config_elem_t *elem);
config_elem_t *config_getbynum(config_t *c, int which);
int config_nclasses(config_t *c);
char *config_class_name(config_t *c, int which);
char *config_class_char_get(config_t *c, char *class, char *lhs);
int config_class_nelems(config_t *c, char *class);
char *config_class_elem_name(config_t *c, char *class, int which);
void config_dump(config_t *c);
int config_class_unset(config_t *c, char *class, char *which);
int config_unset(config_t *c, char *which);

#endif /* _LOCAL_CONFIG_H */

