<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 * @ingroup SMWLanguage
 */

$aliases = array();

/** English */
$aliases['en'] = array(
	'Ask' => array( 'Ask' ),
	'Browse' => array( 'Browse' ),
	'ExportRDF' => array( 'ExportRDF' ),
	'PageProperty' => array( 'PageProperty' ),
	'Properties' => array( 'Properties' ),
	'SMWAdmin' => array( 'SMWAdmin' ),
	'SearchByProperty' => array( 'SearchByProperty' ),
	'SemanticStatistics' => array( 'SemanticStatistics' ),
	'Types' => array( 'Types' ),
	'URIResolver' => array( 'URIResolver' ),
	'UnusedProperties' => array( 'UnusedProperties' ),
	'WantedProperties' => array( 'WantedProperties' ),
);

/** Arabic (العربية)
 * @author Meno25
 */
$aliases['ar'] = array(
	'Ask' => array( 'سؤال' ),
	'Browse' => array( 'تصفح' ),
	'ExportRDF' => array( 'تصدير_آر_دي_إف' ),
	'PageProperty' => array( 'خاصية_الصفحة' ),
	'Properties' => array( 'خصائص' ),
	'SMWAdmin' => array( 'إداري_سمو' ),
	'SearchByProperty' => array( 'بحث_بواسطة_الخاصية' ),
	'SemanticStatistics' => array( 'إحصاءات_سيمانتيك' ),
	'Types' => array( 'أنواع' ),
	'URIResolver' => array( 'محلل_يو_آر_آي' ),
	'UnusedProperties' => array( 'خصائص_غير_مستخدمة' ),
	'WantedProperties' => array( 'خصائص_مطلوبة' ),
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Meno25
 */
$aliases['arz'] = array(
	'Ask' => array( 'سؤال' ),
	'Browse' => array( 'تصفح' ),
	'ExportRDF' => array( 'تصدير_آر_دى_إف' ),
	'PageProperty' => array( 'خاصية_الصفحة' ),
	'Properties' => array( 'خصائص' ),
	'SMWAdmin' => array( 'إدارى_سمو' ),
	'SearchByProperty' => array( 'بحث_بواسطة_الخاصية' ),
	'SemanticStatistics' => array( 'إحصاءات_سيمانتيك' ),
	'Types' => array( 'أنواع' ),
	'URIResolver' => array( 'محلل_يو_آر_آى' ),
	'UnusedProperties' => array( 'خصائص_غير_مستخدمة' ),
	'WantedProperties' => array( 'خصائص_مطلوبة' ),
);

/** Breton (Brezhoneg) */
$aliases['br'] = array(
	'Ask' => array( 'Goulenn' ),
	'Browse' => array( 'Furchal' ),
	'Properties' => array( 'Perzhioù' ),
	'Types' => array( 'Seurtoù' ),
);

/** German (Deutsch) */
$aliases['de'] = array(
	'Ask' => array( 'Semantische Suche' ),
	'Browse' => array( 'Browse' ),
	'ExportRDF' => array( 'Exportiere RDF' ),
	'PageProperty' => array( 'Seitenattribut' ),
	'Properties' => array( 'Attribute' ),
	'SMWAdmin' => array( 'SMW-Einrichtung' ),
	'SearchByProperty' => array( 'Suche mittels Attribut' ),
	'SemanticStatistics' => array( 'Semantische Statistik' ),
	'Types' => array( 'Datentypen' ),
	'UnusedProperties' => array( 'Verwaiste Attribute' ),
	'WantedProperties' => array( 'Gewünschte Attribute' ),
);

/** Finnish (Suomi) */
$aliases['fi'] = array(
	'Ask' => array( 'Kysy' ),
	'Browse' => array( 'Selaa' ),
);

/** Galician (Galego) */
$aliases['gl'] = array(
	'Types' => array( 'Tipos' ),
);

/** Upper Sorbian (Hornjoserbsce) */
$aliases['hsb'] = array(
	'Ask' => array( 'Semantiske pytanje' ),
	'Browse' => array( 'Přepytać' ),
	'ExportRDF' => array( 'RDF eksportować' ),
	'PageProperty' => array( 'Kajkosć strony' ),
	'Properties' => array( 'Kajkosće' ),
	'SearchByProperty' => array( 'Pytanje po kajkosći' ),
	'SemanticStatistics' => array( 'Semantiska statistika' ),
	'Types' => array( 'Typy' ),
	'UnusedProperties' => array( 'Njewužiwane kajkosće' ),
	'WantedProperties' => array( 'Falowace kajkosće' ),
);

/** Khmer (ភាសាខ្មែរ) */
$aliases['km'] = array(
	'Browse' => array( 'រាវរក' ),
	'Properties' => array( 'លក្ខណៈ' ),
	'Types' => array( 'ប្រភេទ' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$aliases['lb'] = array(
	'Ask' => array( 'Froen' ),
	'ExportRDF' => array( 'RDF exportéieren' ),
	'PageProperty' => array( 'Säiten-Eegeschaften' ),
	'Properties' => array( 'Eegeschaften' ),
	'SemanticStatistics' => array( 'Semantesch Statistiken' ),
	'Types' => array( 'Datentypen' ),
	'UnusedProperties' => array( 'Netbenotzen Eegeschaften' ),
	'WantedProperties' => array( 'Gewënschten Eegeschaften' ),
);

/** Nedersaksisch (Nedersaksisch) */
$aliases['nds-nl'] = array(
	'Browse' => array( 'Bekieken' ),
	'ExportRDF' => array( 'RDF_uutvoeren' ),
	'PageProperty' => array( 'Pagina-eigenschap' ),
	'SMWAdmin' => array( 'SMW-beheer' ),
	'SearchByProperty' => array( 'Op_eigenschap_zeuken' ),
	'SemanticStatistics' => array( 'Semantische_staotestieken' ),
	'UnusedProperties' => array( 'Ongebruken_eigenschappen' ),
	'WantedProperties' => array( 'Gewunste_eigenschappen' ),
);

/** Dutch (Nederlands) */
$aliases['nl'] = array(
	'Ask' => array( 'Vragen' ),
	'Browse' => array( 'Bekijken' ),
	'ExportRDF' => array( 'RDFExporteren' ),
	'PageProperty' => array( 'Paginaeigenschap' ),
	'Properties' => array( 'Eigenschappen' ),
	'SMWAdmin' => array( 'SMWBeheer' ),
	'SearchByProperty' => array( 'OpEigenschapZoeken' ),
	'SemanticStatistics' => array( 'SemantischeStatistieken' ),
	'Types' => array( 'Typen' ),
	'UnusedProperties' => array( 'OngebruikteEigenschappen' ),
	'WantedProperties' => array( 'GewensteEigenschappen' ),
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬) */
$aliases['no'] = array(
	'Ask' => array( 'Spør' ),
	'ExportRDF' => array( 'Eksporter RDF' ),
	'PageProperty' => array( 'Sideegenskaper' ),
	'Properties' => array( 'Egenskaper' ),
	'SearchByProperty' => array( 'Søk etter egenskap' ),
	'SemanticStatistics' => array( 'Semantisk statistikk' ),
	'Types' => array( 'Typer' ),
	'UnusedProperties' => array( 'Ubrukte egenskaper' ),
	'WantedProperties' => array( 'Ønskede egenskaper' ),
);

/** Occitan (Occitan) */
$aliases['oc'] = array(
	'Browse' => array( 'Percórrer' ),
	'Properties' => array( 'Proprietats' ),
	'Types' => array( 'Tipes' ),
	'UnusedProperties' => array( 'Proprietats inutilizadas', 'ProprietatsInutilizadas' ),
	'WantedProperties' => array( 'Proprietats demandadas', 'ProprietatsDemandadas' ),
);

/** Romanian (Română) */
$aliases['ro'] = array(
	'Browse' => array( 'Răsfoieşte' ),
);

