<?php
/**
 * Internationalisation file for the CreateBox extension.
 *
 * @ingroup Extensions
 * @author Ross McClure
 */

$messages = array();

/** English
 * @author Ross McClure
 */
$messages['en'] = array(
	'createbox-desc'   => 'Specialised inputbox for page creation',
	'createbox-create' => 'Create',
	'createbox-exists' => "Sorry, \"'''{{FULLPAGENAME}}'''\" already " .
			"exists.\n\nYou cannot create this page, but you can " .
			"[{{fullurl:{{FULLPAGENAME}}|action=edit}} edit it], " .
			"[{{fullurl:{{FULLPAGENAME}}}} read it], or choose to " .
			"create a different page using the box below.\n\n" .
			"<createbox>break=no</createbox>",
);

/** Message documentation (Message documentation)
 * @author Jon Harald Søby
 * @author Purodha
 */
$messages['qqq'] = array(
	'createbox-desc' => 'Extension description displayed on [[Special:Version]].',
	'createbox-create' => '{{Identical|Create}}',
);

/** Afrikaans (Afrikaans)
 * @author Naudefj
 */
$messages['af'] = array(
	'createbox-desc' => 'Gespesialiseerde invoerveld vir die skep van nuwe bladsye',
	'createbox-create' => 'Skep',
);

/** Arabic (العربية)
 * @author Meno25
 */
$messages['ar'] = array(
	'createbox-desc' => 'صندوق إدخال متخصص لإنشاء الصفحات',
	'createbox-create' => 'إنشاء',
	'createbox-exists' => "عذرا، \"'''{{FULLPAGENAME}}'''\" موجودة بالفعل.

أنت لا يمكنك إنشاء هذه الصفحة، لكن يمكنك [{{fullurl:{{FULLPAGENAME}}|action=edit}} تعديلها], [{{fullurl:{{FULLPAGENAME}}}} قراءتها]، أو اختيار إنشاء صفحة أخرى باستخدام الصندوق بالأسفل.

<createbox>break=no</createbox>",
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Meno25
 */
$messages['arz'] = array(
	'createbox-desc' => 'صندوق إدخال متخصص لإنشاء الصفحات',
	'createbox-create' => 'إنشاء',
	'createbox-exists' => "عذرا، \"'''{{FULLPAGENAME}}'''\" موجودة بالفعل.

أنت لا يمكنك إنشاء هذه الصفحة، لكن يمكنك [{{fullurl:{{FULLPAGENAME}}|action=edit}} تعديلها], [{{fullurl:{{FULLPAGENAME}}}} قراءتها]، أو اختيار إنشاء صفحة أخرى باستخدام الصندوق بالأسفل.

<createbox>break=no</createbox>",
);

/** Belarusian (Taraškievica orthography) (Беларуская (тарашкевіца))
 * @author EugeneZelenko
 */
$messages['be-tarask'] = array(
	'createbox-create' => 'Стварыць',
);

/** Bulgarian (Български)
 * @author DCLXVI
 */
$messages['bg'] = array(
	'createbox-create' => 'Създаване',
);

/** Bosnian (Bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'createbox-desc' => 'Specijalizirana kutija unosa za pravljenje stranice',
	'createbox-create' => 'Napravi',
	'createbox-exists' => "Žao nam je, \"'''{{FULLPAGENAME}}'''\" već postoji.

Ne možete napraviti ovu stranicu, ali je možete [{{fullurl:{{FULLPAGENAME}}|action=edit}} urediti], [{{fullurl:{{FULLPAGENAME}}}} pročitati] ili odabrati pravljenje druge stranice koristeći kutiju ispod.

<createbox>break=no</createbox>",
);

/** Catalan (Català)
 * @author Loupeter
 */
$messages['ca'] = array(
	'createbox-create' => 'Crear',
);

/** Corsican (Corsu) */
$messages['co'] = array(
	'createbox-create' => 'Creà',
);

/** German (Deutsch)
 * @author ChrisiPK
 * @author Revolus
 */
$messages['de'] = array(
	'createbox-desc' => 'Spezielles Eingabefeld zur Seitenerstellung',
	'createbox-create' => 'Erstellen',
	'createbox-exists' => "„'''{{FULLPAGENAME}}'''“ existiert bereits.

Du kannst diese Seite nicht anlegen, aber du kannst sie [{{fullurl:{{FULLPAGENAME}}|action=edit}} bearbeiten], [{{fullurl:{{FULLPAGENAME}}}} lesen] oder eine andere Seite mithilfe des untenstehenden Eingabefeldes anlegen.

<createbox>break=no</createbox>",
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'createbox-desc' => 'Specielne zapódawańske pólo za napóranje bokow',
	'createbox-create' => 'Napóraś',
	'createbox-exists' => "\"'''{{FULLPAGENAME}}'''\" južo eksistěrujo.

Njamóžoš tós ten bok napóraś, ale móžoš jen [{{fullurl:{{FULLPAGENAME}}|action=edit}} wobźěłaś],
[{{fullurl:{{FULLPAGENAME}}}} cytaś] abo wubraś, aby drugi bok z pomocu slědujucego kašćika napórał.

<createbox>break=no</createbox>",
);

/** Greek (Ελληνικά)
 * @author Konsnos
 */
$messages['el'] = array(
	'createbox-create' => 'Δημιουργία',
);

/** Esperanto (Esperanto)
 * @author Yekrats
 */
$messages['eo'] = array(
	'createbox-create' => 'Krei',
);

/** Spanish (Español)
 * @author Crazymadlover
 * @author Imre
 */
$messages['es'] = array(
	'createbox-create' => 'Crear',
	'createbox-exists' => "Disculpe, \"'''{{FULLPAGENAME}}'''\" ya existe.

No puedes crear esta página, pero puedes [{{fullurl:{{FULLPAGENAME}}|action=edit}} editarla], [{{fullurl:{{FULLPAGENAME}}}} leerla], o escoger crear una página diferente usando la tabla de debajo.

<createbox>break=no</createbox>",
);

/** Basque (Euskara)
 * @author An13sa
 */
$messages['eu'] = array(
	'createbox-create' => 'Sortu',
);

/** Finnish (Suomi)
 * @author Jack Phoenix
 * @author Mobe
 * @author Nike
 */
$messages['fi'] = array(
	'createbox-desc' => 'Erityinen syöttölomake sivun luontiin.',
	'createbox-create' => 'Luo',
	'createbox-exists' => "Pahoittelut, \"'''{{FULLPAGENAME}}'''\" on jo olemassa.

Et voi luoda tätä sivua, mutta voit [{{fullurl:{{FULLPAGENAME}}|action=edit}} muokata sitä], [{{fullurl:{{FULLPAGENAME}}}} lukea sitä], tai luoda erilaisen sivun allaolevaa laatikkoa käyttäen.

<createbox>break=no</createbox>",
);

/** French (Français)
 * @author Crochet.david
 * @author Verdy p
 */
$messages['fr'] = array(
	'createbox-desc' => 'Boîte de saisie spécialisée pour la création de page',
	'createbox-create' => 'Créer',
	'createbox-exists' => "Désolé, « '''{{FULLPAGENAME}}''' » existe déjà.

Vous ne pouvez pas créer cette page, mais vous pouvez [{{fullurl:{{FULLPAGENAME}}|action=edit}} la modifier], [{{fullurl:{{FULLPAGENAME}}}} la lire] ou choisir de créer une page différente à l’aide de la boîte ci-dessous.

<createbox>break=no</createbox>",
);

/** Galician (Galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'createbox-desc' => 'Caixa de entrada especializada para a creación de páxinas',
	'createbox-create' => 'Crear',
	'createbox-exists' => "Sentímolo, \"'''{{FULLPAGENAME}}'''\" xa existe.

Non pode crear esta páxina, pero pode [{{fullurl:{{FULLPAGENAME}}|action=edit}} editala], [{{fullurl:{{FULLPAGENAME}}}} lela], ou elixir crear unha páxina diferente usando a caixa de embaixo.

<createbox>break=no</createbox>",
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'createbox-create' => 'Ποεῖν',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'createbox-desc' => 'Speziäll Yygabfäld zum Aalege vu Syte',
	'createbox-create' => 'Aalege',
	'createbox-exists' => "Excusez, „'''{{FULLPAGENAME}}'''“ git s scho.

Du chasch die Syte nit aalege, aber Du chasch si [{{fullurl:{{FULLPAGENAME}}|action=edit}} bearbeite], [{{fullurl:{{FULLPAGENAME}}}} läse] oder e anderi Syte aalege mit em Yygabfäld, wu do unte stoht.

<createbox>break=no</createbox>",
);

/** Hakka (Hak-kâ-fa)
 * @author Hakka
 */
$messages['hak'] = array(
	'createbox-create' => 'Tshóng-kien',
);

/** Hebrew (עברית)
 * @author Rotemliss
 */
$messages['he'] = array(
	'createbox-desc' => 'תיבת קלט מיוחדת ליצירת דפים',
	'createbox-create' => 'יצירה',
	'createbox-exists' => "מצטערים, \"'''{{FULLPAGENAME}}'''\" כבר קיים.

אינכם יכולים ליצור את הדף, אך באפשרותכם [{{fullurl:{{FULLPAGENAME}}|action=edit}} לערוך אותו], [{{fullurl:{{FULLPAGENAME}}}} לקרוא אותו] או ליצור דף אחר באמצעות התיבה למטה.

<createbox>break=no</createbox>",
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'createbox-desc' => 'Specielne zapodatny kašćik za wutworjenje stronow',
	'createbox-create' => 'Wutworić',
	'createbox-exists' => "Wodaj, \"'''{{FULLPAGENAME}}'''\" hižo eksistuje.

Njemóžeš tutu stronu wutworić, ale móžeš [{{fullurl:{{FULLPAGENAME}}|action=edit}} ju wobdźěłać], [{{fullurl:{{FULLPAGENAME}}}} čitać] abo z pomocu slědowaceho kašćik druhu stronu wutworić.

<createbox>break=no</createbox>",
);

/** Hungarian (Magyar)
 * @author Dani
 */
$messages['hu'] = array(
	'createbox-desc' => 'Speciális inputbox lapkészítéshez',
	'createbox-create' => 'Készítés',
	'createbox-exists' => "Sajnáljuk, de „'''{{FULLPAGENAME}}'''” című lap már létezik.

Nem készítheted el a lapot, de [{{fullurl:{{FULLPAGENAME}}|action=edit}} szerkesztheted], [{{fullurl:{{FULLPAGENAME}}}} elolvashatod], vagy választhatsz egy másik lapnevet a lenti dobozban.

<createbox>break=no</createbox>",
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'createbox-desc' => 'Quadro de entrata specialisate pro le creation de paginas',
	'createbox-create' => 'Crear',
	'createbox-exists' => "Pardono, \"'''{{FULLPAGENAME}}'''\" existe ja.

Tu non pote crear iste pagina, sed tu pote [{{fullurl:{{FULLPAGENAME}}|action=edit}} modificar lo], [{{fullurl:{{FULLPAGENAME}}}} leger lo], o optar pro crear un altere pagina con le quadro infra.

<createbox>break=no</createbox>",
);

/** Italian (Italiano)
 * @author Pietrodn
 */
$messages['it'] = array(
	'createbox-desc' => 'Inputbox specializzato per la creazione di pagine',
	'createbox-create' => 'Crea',
	'createbox-exists' => "Scusa, \"'''{{FULLPAGENAME}}'''\" esiste già.

Non puoi creare questa pagina, ma puoi [{{fullurl:{{FULLPAGENAME}}|action=edit}} modificarla], [{{fullurl:{{FULLPAGENAME}}}} leggerla] o scegliere di creare una pagina diversa usando il box sottostante.

<createbox>break=no</createbox>",
);

/** Japanese (日本語)
 * @author Aotake
 * @author Fievarsty
 */
$messages['ja'] = array(
	'createbox-desc' => 'ページ作成専用のInputbox',
	'createbox-create' => '作成',
	'createbox-exists' => "残念ながら\"'''{{FULLPAGENAME}}'''\" はすでに作成されています。

このページを作成することはできませんが、[{{fullurl:{{FULLPAGENAME}}|action=edit}} 同名のページを編集]、[{{fullurl:{{FULLPAGENAME}}}} 閲覧]、または以下のBoxを使用して他の名前のページを作成することができます。

<createbox>break=no</createbox>",
);

/** Khmer (ភាសាខ្មែរ)
 * @author Lovekhmer
 * @author Thearith
 * @author គីមស៊្រុន
 */
$messages['km'] = array(
	'createbox-create' => 'បង្កើត',
	'createbox-exists' => "សូមអភ័យទោស! \"'''{{FULLPAGENAME}}'''\" មានរួចហើយ។

អ្នកមិនអាចបង្កើតទំព័រនេះទេ ប៉ុន្តែអ្នកអាច[{{fullurl:{{FULLPAGENAME}}|action=edit}} កែសម្រួល] [{{fullurl:{{FULLPAGENAME}}}} អាន] ឬ បង្កើតទំព័រផ្សេងមួយទៀតដោយប្រើប្រអប់ខាងក្រោម។

<createbox>break=no</createbox>",
);

/** Krio (Krio)
 * @author Jose77
 */
$messages['kri'] = array(
	'createbox-create' => 'Mek sohmtin',
);

/** Ripoarisch (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'createbox-desc' => 'En spezjell Feld för der Tittel enzejävve för neu Sigge aanzelääje.',
	'createbox-create' => 'Aanläje!',
	'createbox-exists' => "De Sigg „'''{{FULLPAGENAME}}'''“ es ald doh.

Do kanns se nit aanläje, ävver Do kanns di Sigg
[{{fullurl:{{FULLPAGENAME}}|action=edit}} ändere], [{{fullurl:{{FULLPAGENAME}}}} lesse],
udder en ander Sigg neu aanläje:
<br />
<createbox>break=no</createbox>",
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'createbox-desc' => 'Spezialiséiert Këscht fir Säiten unzeleeën',
	'createbox-create' => 'Maachen',
	'createbox-exists' => "Pardon, \"'''{{FULLPAGENAME}}'''\" gëtt et schonn.

Dir kënnt dës Sàit net uleeën, awer Dir kënnt [{{fullurl:{{FULLPAGENAME}}|action=edit}} s'änneren], [{{fullurl:{{FULLPAGENAME}}}} liest] oder wielt fir eng aner Säit unzeleeë mat Hellëf vun der Kescht ënnendrënner.",
);

/** Marathi (मराठी)
 * @author Mahitgar
 */
$messages['mr'] = array(
	'createbox-create' => 'तयार करा',
);

/** Maltese (Malti)
 * @author Chrisportelli
 */
$messages['mt'] = array(
	'createbox-desc' => "''Inputbox'' speċjalizzata għall-ħolqien ta' paġni",
	'createbox-create' => 'Oħloq',
	'createbox-exists' => "Skużana, \"'''{{FULLPAGENAME}}'''\" teżisti diġà.

Ma tistax toħloq din il-paġna, imma tista' [{{fullurl:{{FULLPAGENAME}}|action=edit}} timmodifikaha], [{{fullurl:{{FULLPAGENAME}}}} taqraha] jew tagħżel li tikkrea paġna differenti bl-użu tal-kaxxa t'hawn taħt.

<createbox>break=no</createbox>",
);

/** Nahuatl (Nāhuatl)
 * @author Fluence
 */
$messages['nah'] = array(
	'createbox-create' => 'Ticchīhuāz',
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'createbox-desc' => "Aangepast invoerveld voor het aanmaken van nieuwe pagina's",
	'createbox-create' => 'Aanmaken',
	'createbox-exists' => "\"'''{{FULLPAGENAME}}'''\" bestaat al.

U kunt deze pagina niet aanmaken, maar u kunt deze [{{fullurl:{{FULLPAGENAME}}|action=edit}} bewerken], [{{fullurl:{{FULLPAGENAME}}}} bekijken], of een andere pagina aanmaken via het onderstaande formulier.

<createbox>break=no</createbox>",
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬)
 * @author Harald Khan
 */
$messages['nn'] = array(
	'createbox-desc' => 'Spesialisert tekstboks for oppretting av sider',
	'createbox-create' => 'Opprett',
	'createbox-exists' => "Orsak, «'''{{FULLPAGENAME}}'''» finst frå før.

Du kan ikkje oppretta denne sida, men du kan [{{fullurl:{{FULLPAGENAME}}|action=edit}} endra ho], [{{fullurl:{{FULLPAGENAME}}}} lesa ho] eller oppretta ei anna sida ved hjelp av boksen nedanfor.

<createbox>break=no</createbox>",
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Jon Harald Søby
 */
$messages['no'] = array(
	'createbox-desc' => 'Spesialisert tekstboks for sideoppretting',
	'createbox-create' => 'Opprett',
	'createbox-exists' => "Beklager, «'''{{FULLPAGENAME}}'''» finnes fra før.

Du kan ikke opprette denne siden, men du kan [{{fullurl:{{FULLPAGENAME}}|action=edit}} redigere den], [{{fullurl:{{FULLPAGENAME}}}} lese den] eller opprette en annen siden med hjelp av boksen nedenfor.

<createbox>break=no</createbox>",
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'createbox-desc' => 'Bóstia de picada especializada per la creacion de pagina',
	'createbox-create' => 'Crear',
	'createbox-exists' => "O planhèm, \"'''{{FULLPAGENAME}}'''\" existís ja.

Podètz pas crear aquesta pagina, mas la podètz [{{fullurl:{{FULLPAGENAME}}|action=edit}} modificar], [{{fullurl:{{FULLPAGENAME}}}} legir] o causir de crear una pagina diferenta amb l’ajuda de la bóstia çaijós.

<createbox>break=no</createbox>",
);

/** Polish (Polski)
 * @author Sp5uhe
 * @author Wpedzich
 */
$messages['pl'] = array(
	'createbox-desc' => 'Specjalizowane pole tekstowe do tworzenia nowych stron',
	'createbox-create' => 'Utwórz',
	'createbox-exists' => "Strona „'''{{FULLPAGENAME}}'''” już istnieje.

Nie możesz utworzyć tej strony, lecz możesz ją [{{fullurl:{{FULLPAGENAME}}|action=edit}} edytować], [{{fullurl:{{FULLPAGENAME}}}} przeczytać], lub stworzyć inną stronę za pomocą poniższego pola wyboru.

<createbox>break=no</createbox>",
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'createbox-create' => 'جوړول',
);

/** Portuguese (Português)
 * @author Malafaya
 * @author Waldir
 */
$messages['pt'] = array(
	'createbox-desc' => 'Inputbox especializado para a criação de páginas',
	'createbox-create' => 'Criar',
	'createbox-exists' => "Desculpe, \"'''{{FULLPAGENAME}}'''\" já existe.

Você não pode criar esta página, mas pode [{{fullurl:{{FULLPAGENAME}}|action=edit}} editá-la], 
[{{fullurl:{{FULLPAGENAME}}}} lê-la], ou optar por criar uma página diferente usando a caixa abaixo.

<createbox>break=no</createbox>",
);

/** Brazilian Portuguese (Português do Brasil)
 * @author Eduardo.mps
 */
$messages['pt-br'] = array(
	'createbox-desc' => 'Inputbox especializado para a criação de páginas',
	'createbox-create' => 'Criar',
	'createbox-exists' => "Desculpe, \"'''{{FULLPAGENAME}}'''\" já existe.

Você não pode criar esta página, mas pode [{{fullurl:{{FULLPAGENAME}}|action=edit}} editá-la],  
[{{fullurl:{{FULLPAGENAME}}}} lê-la], ou optar por criar uma página diferente usando a caixa abaixo.

<createbox>break=no</createbox>",
);

/** Romanian (Română)
 * @author KlaudiuMihaila
 */
$messages['ro'] = array(
	'createbox-create' => 'Creează',
);

/** Tarandíne (Tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'createbox-create' => 'Ccreje',
);

/** Russian (Русский)
 * @author Ferrer
 * @author Innv
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'createbox-desc' => 'Специализированные формы для создания страниц',
	'createbox-create' => 'Создать',
	'createbox-exists' => "Извините, \"'''{{FULLPAGENAME}}'''\" уже существует.

Вы не можете создать эту страницу, но вы можете [{{fullurl:{{FULLPAGENAME}}|action=edit}} отредактировать], [{{fullurl:{{FULLPAGENAME}}}} просмотреть] её, или выбрать для создания другую страницу в форме.

<createbox>break=no</createbox>",
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'createbox-desc' => 'Špecializované vstupné pole na vytváranie stránok',
	'createbox-create' => 'Vytvoriť',
	'createbox-exists' => "Prepáčte, „'''{{FULLPAGENAME}}'''” už existuje.

Túto stránku nemôžete vytvoriť, ale môžete ju [{{fullurl:{{FULLPAGENAME}}|action=edit}} upravovať], [{{fullurl:{{FULLPAGENAME}}}} čítať] alebo vytvoriť inú stránku pomocou tohto vstupného poľa.

<createbox>break=no</createbox>",
);

/** Sundanese (Basa Sunda)
 * @author Irwangatot
 */
$messages['su'] = array(
	'createbox-create' => 'Jieun',
);

/** Swedish (Svenska)
 * @author M.M.S.
 */
$messages['sv'] = array(
	'createbox-desc' => 'Specialiserad formulärbox för sidskapning',
	'createbox-create' => 'Skapa',
	'createbox-exists' => "Beklagar, \"'''{{FULLPAGENAME}}'''\" existerar redan.

Du kan inte skapa den här sidan, men du kan [{{fullurl:{{FULLPAGENAME}}|action=edit}} redigera den], [{{fullurl:{{FULLPAGENAME}}}} läsa den], eller välja att skapa en annan sida genom att använda boxen nedan.

<createbox>break=no</createbox>",
);

/** Swahili (Kiswahili)
 * @author Lloffiwr
 */
$messages['sw'] = array(
	'createbox-create' => 'Anzisha kurasa',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'createbox-create' => 'సృష్టించు',
	'createbox-exists' => "క్షమించండి, \"'''{{FULLPAGENAME}}'''\" ఇప్పటికే ఉంది.

ఈ పేజీని మీరు సృష్టించలేరు, కానీ మీరు [{{fullurl:{{FULLPAGENAME}}|action=edit}} దీన్ని మార్చవచ్చు], [{{fullurl:{{FULLPAGENAME}}}} చదువవచ్చు], లేదా క్రింది పెట్టెని ఉపయోగించి మరో పేజీని సృష్టించవచ్చు.

<createbox>break=no</createbox>",
);

/** Tajik (Cyrillic) (Тоҷикӣ (Cyrillic))
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'createbox-create' => 'Эҷод',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'createbox-desc' => 'Natatanging lalagyang-kahon para sa paglikha ng pahina',
	'createbox-create' => 'Likhain',
	'createbox-exists' => "Paumanhin, umiiral na ang \"'''{{FULLPAGENAME}}'''\".

Hindi mo malilikha ang pahinang ito, subalit maaari mong [{{fullurl:{{FULLPAGENAME}}|action=edit}} baguhin ito], [{{fullurl:{{FULLPAGENAME}}}} basahin ito], o piliing lumikha ng isang naiibang pahina na ginagamit ang kahong nasa ibaba.
 
<createbox>break=no</createbox>",
);

/** Turkish (Türkçe)
 * @author Joseph
 * @author Karduelis
 */
$messages['tr'] = array(
	'createbox-desc' => 'Sayfası oluşturmak için özelleştirilmiş girdikutusu',
	'createbox-create' => 'Oluştur',
	'createbox-exists' => "Üzgünüz, \"'''{{FULLPAGENAME}}'''\" zaten mevcut.

Bu sayfayı oluşturamazsınız, ancak [{{fullurl:{{FULLPAGENAME}}|action=edit}} değiştirebilir], [{{fullurl:{{FULLPAGENAME}}}} okuyabilir], ya da aşağıdaki kutuyu kullanarak farklı bir sayfa oluşturmayı seçebilirsiniz.

<createbox>break=no</createbox>",
);

/** Ukrainian (Українська)
 * @author AS
 */
$messages['uk'] = array(
	'createbox-desc' => 'Спеціалізоване поле вводу для створення сторінок',
	'createbox-create' => 'Створити',
	'createbox-exists' => "Даруйте, \"'''{{FULLPAGENAME}}'''\" вже існує.

Ви не можете створити цю сторінку, але ви можете [{{fullurl:{{FULLPAGENAME}}|action=edit}} редагувати її], [{{fullurl:{{FULLPAGENAME}}}} переглянути її], або створити іншу сторінку, використовуючи поле нижче.

<createbox>break=no</createbox>",
);

/** Vèneto (Vèneto)
 * @author Candalua
 */
$messages['vec'] = array(
	'createbox-desc' => 'Inputbox specialixà par la creassion de pàxene',
	'createbox-create' => 'Crèa',
	'createbox-exists' => "Scusa, \"'''{{FULLPAGENAME}}'''\" la esiste de xà.

No ti pol crear sta pàxena, ma ti pol [{{fullurl:{{FULLPAGENAME}}|action=edit}} modificarla], [{{fullurl:{{FULLPAGENAME}}}} lèxerla] o sièliere de crear na pàxena difarente doparando la casèla qua soto.

<createbox>break=no</createbox>",
);

/** Vietnamese (Tiếng Việt)
 * @author Vinhtantran
 */
$messages['vi'] = array(
	'createbox-desc' => 'Hộp nhập liệu đặc biệt dùng để tạo trang',
	'createbox-create' => 'Tạo',
	'createbox-exists' => "Xin lỗi, \"'''{{FULLPAGENAME}}'''\" đã tồn tại.

Bạn không thể tạo trang này, nhưng bạn có thể [{{fullurl:{{FULLPAGENAME}}|action=edit}} sửa đổi nó], [{{fullurl:{{FULLPAGENAME}}}} đọc nó], hoặc chọn tạo một trang khác sử dụng hộp phía dưới.

<createbox>break=no</createbox>",
);

/** Volapük (Volapük)
 * @author Smeira
 */
$messages['vo'] = array(
	'createbox-create' => 'Jafön',
);

/** Yiddish (ייִדיש)
 * @author פוילישער
 */
$messages['yi'] = array(
	'createbox-create' => 'שאַפֿן',
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author Gzdavidwong
 */
$messages['zh-hans'] = array(
	'createbox-create' => '建立',
);

/** Traditional Chinese (‪中文(繁體)‬)
 * @author Wrightbus
 */
$messages['zh-hant'] = array(
	'createbox-create' => '建立',
);

