/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.io.starter;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.Konstanten;
import mediathek.TModel;
import mediathek.daten.Daten;

public class ListeStarts extends LinkedList<Starts> {

    Daten daten;

    public ListeStarts(Daten d) {
        super();
        daten = d;
    }

    public synchronized Iterator<Starts> getIt() {
        return super.iterator();
    }

    public boolean contain(Starts starts) {
        boolean ret = false;
        ListIterator<Starts> it = this.listIterator(0);
        while (it.hasNext()) {
            Starts s = it.next();
            if (s.film.arr[Konstanten.FILM_URL_NR].equals(starts.film.arr[Konstanten.FILM_URL_NR])) {
                ret = true;
                break;
            }
        }

        return ret;
    }

    public void delStart(String url) {
        ListIterator<Starts> it = this.listIterator(0);
        while (it.hasNext()) {
            Starts s = it.next();
            if (s.film.arr[Konstanten.FILM_URL_NR].equals(url)) {
                s.stoppen = true;
                it.remove();
                break;
            }
        }
    }

    public int getDown() {
        int ret = 0;
        ListIterator<Starts> it = this.listIterator(0);
        while (it.hasNext()) {
            Starts s = it.next();
            if (s.status == Starts.STATUS_RUN) {
                ++ret;
            }
        }
        return ret;
    }

    public synchronized void aufraeumen(int quelle) {
        Iterator<Starts> it = this.iterator();
        while (it.hasNext()) {
            Starts start = it.next();
            if (start.status >= Starts.STATUS_FERTIG) {
                if (start.quelle == quelle || quelle == Starts.QUELLE_ALLE) {
                    it.remove();
                }
            }
        }
    }

    public int delRest() {
        //löscht alle Starts die noch nicht laufen
        int ret = 0;
        ListIterator<Starts> it = this.listIterator(0);
        while (it.hasNext()) {
            if (it.next().status < Starts.STATUS_RUN) {
                it.remove();
            }
        }
        return ret;
    }

    public void delAlle() {
        //löscht alle Starts, "alle Abbrechen"
        this.clear();
    }

    public int getmax() {
        int ret = 0;
        ListIterator<Starts> it = this.listIterator(0);
        while (it.hasNext()) {
            Starts s = it.next();
            if (s.status >= Starts.STATUS_FERTIG) {
                ++ret;
            }
        }
        if (ret != this.size()) {
            ret = this.size();
        } else {
            ret = 0;
        }
        return ret;
    }

    @Override
    public boolean add(Starts arg0) {
        return super.add(arg0);
    }

    @Override
    public Starts get(int arg0) {
        return super.get(arg0);
    }

    TModel getModel() {
        TModel model = null;
        if (this.size() == 0) {
            return null;
        } else {
            int max = Konstanten.FILME_MAX_ELEM + 1;
            String[] titel = new String[max];
            for (int i = 0; i < max; ++i) {
                if (i < Konstanten.FILME_MAX_ELEM) {
                    titel[i] = Konstanten.FILME_COLUMN_NAMES[i];
                } else {
                    titel[i] = "Art";
                }
            }
            model = new TModel(this.getObjectData(), titel);
            return model;
        }
    }

    //===================================
    // private
    //===================================
    private Object[][] getObjectData() {
        Object[][] object = null;
        Starts start;
        int i = 0;
        if (this.size() > 0) {
            Iterator<Starts> iterator = this.getIt();
            int objLen = Konstanten.FILME_MAX_ELEM + 1;
            object = new Object[this.size()][objLen];
            while (iterator.hasNext()) {
                start = iterator.next();
                for (int k = 0; k < objLen; ++k) {
                    if (k < Konstanten.FILME_MAX_ELEM) {
                        object[i][k] = start.film.arr[k];
                    } else {
                        if (start.quelle == Starts.QUELLE_PODCAST) {
                            object[i][k] = Konstanten.SENDER_PODCAST;
                        } else if (start.quelle == Starts.QUELLE_ABO) {
                            object[i][k] = "Filmabo";
                        } else {
                            object[i][k] = "Direkter Start";
                        }
                    }
                }
                ++i;
            }
        }
        return object;
    }
}
