/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

med_err MEDchampCr( med_idt fid,  char *  champ,  med_type_champ type,  char *  comp,
		    char *  unit, med_int ncomp)
{
  med_err ret=-1;
  med_idt root=0,gid=0;
  char chemin[MED_TAILLE_CHA+1];
  med_size dimd[1];
  med_int _type = (med_int) type;
  med_mode_acces MED_MODE_ACCES;

  /*
   * On inhibe le gestionnaire d'erreur HDF 5
   */
  _MEDmodeErreurVerrouiller();

  if ( (MED_MODE_ACCES = _MEDmodeAcces(fid) ) == MED_UNDEF_MODE_ACCES ) {
    MESSAGE("Impossible de dterminer le mode d'acces au fichier.");
    goto ERROR;
  }

  if ( MED_MODE_ACCES == MED_LECTURE ) {
    MESSAGE("Impossible de crer un champ en mode MED_LECTURE.");
    goto ERROR;
  };
  
  /* 
   * Si le Data Group "/CHA/" n'existe pas, on le cree
   */
  strncpy(chemin,MED_CHA,MED_TAILLE_CHA-1);
  chemin[MED_TAILLE_CHA-1] = '\0';
  if ((root = _MEDdatagroupOuvrir(fid,chemin)) < 0)
    if ((root = _MEDdatagroupCreer(fid,chemin)) < 0) {
      MESSAGE("Erreur  la cration du datagroup : ");
      SSCRUTE(chemin);
      goto ERROR;
    }

  /* 
   * Si le Data Group cha n'existe pas, on le cree
   * Sinon => erreur
   */

  NOFINALBLANK(champ,ERROR);

  if ((gid = _MEDdatagroupCreer(root,champ)) < 0) {
    MESSAGE("Erreur  la cration du champ : ");
    SSCRUTE(champ);
    goto ERROR;
  }

  /*
   * Les infos sur les composants du champ
   */
  if ( _MEDattrEntierEcrire(gid,MED_NOM_NCO,&ncomp) < 0 ) {
    MESSAGE("Erreur  l'criture du nombre de composantes : ");
    ISCRUTE(ncomp);
    goto ERROR;
  }
  if ( _MEDattrEntierEcrire(gid,MED_NOM_TYP,&_type) < 0) {
    MESSAGE("Erreur  l'criture du type du champ : ");
    ISCRUTE(_type);
    goto ERROR;
  }
  if ( _MEDattrStringEcrire(gid,MED_NOM_NOM,MED_TAILLE_PNOM*ncomp,comp) < 0) {
    MESSAGE("Erreur  l'criture des noms des composantes : ");
    SSCRUTE(comp);
    goto ERROR;
  }
  if ( _MEDattrStringEcrire(gid,MED_NOM_UNI,MED_TAILLE_PNOM*ncomp,unit) < 0) {
    MESSAGE("Erreur  l'criture des units : ");
    SSCRUTE(unit);
    goto ERROR;
  }
  /*
   * On ferme tout
   */
  
  ret=0;
 ERROR:
  if (gid>0)     if (_MEDdatagroupFermer(gid) < 0) {
    MESSAGE("Impossible de fermer le datagroup : ");
    ISCRUTE_id(gid);ret = -1; 
  }
  
  if (root>0)     if (_MEDdatagroupFermer(root) < 0) {
    MESSAGE("Impossible de fermer le datagroup : ");
    ISCRUTE_id(root); ret = -1; 
  }

  return ret;
}
