/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#include "preferences_dialog.hh"
#include "application.hh"
#include "xine_engine.hh"
#include "channel_manager.hh"

void PreferencesDialog::show()
{
	int response = 0;
	Application& application = Application::get_current();
	MainWindow& main_window = application.get_main_window();
	Glade& glade = application.get_glade();
	Configuration& configuration = application.get_configuration();
		
	String			recording_directory				= configuration.get_string_value("recording_directory");
	gint			record_extra_before				= configuration.get_int_value("record_extra_before");
	gint			record_extra_after				= configuration.get_int_value("record_extra_after");
	gint			epg_span_hours					= configuration.get_int_value("epg_span_hours");
	String			broadcast_address				= configuration.get_string_value("broadcast_address");
	gint			broadcast_port					= configuration.get_int_value("broadcast_port");
	String			epg_encoding					= configuration.get_string_value("epg_encoding");
	String			video_driver					= configuration.get_string_value("xine.video_driver");
	String			deinterlace_type				= configuration.get_string_value("xine.deinterlace_type");
	gboolean		start_minimised_in_tray			= configuration.get_boolean_value("start_minimised_in_tray");
	gboolean		always_on_top					= configuration.get_boolean_value("always_on_top");
	gboolean		fullscreen_workaround			= configuration.get_boolean_value("fullscreen_workaround");
	gint			channel_sort					= configuration.get_int_value("channel_sort");
	
	GtkWidget* dialog_preferences							= glade.get_widget("dialog_preferences");
	GtkWidget* filechooserbutton_recording_directory		= glade.get_widget("filechooserbutton_recording_directory");
	GtkWidget* spin_button_record_extra_before				= glade.get_widget("spin_button_record_extra_before");
	GtkWidget* spin_button_record_extra_after				= glade.get_widget("spin_button_record_extra_after");
	GtkWidget* spin_button_epg_span_hours					= glade.get_widget("spin_button_epg_span_hours");
	GtkWidget* entry_broadcast_address						= glade.get_widget("entry_broadcast_address");
	GtkWidget* spin_button_broadcast_port					= glade.get_widget("spin_button_broadcast_port");
	GtkWidget* combo_box_epg_encoding						= glade.get_widget("combo_box_epg_encoding");
	GtkWidget* combo_box_video_driver						= glade.get_widget("combo_box_video_driver");
	GtkWidget* combo_box_deinterlace_type					= glade.get_widget("combo_box_deinterlace_type");
	GtkWidget* check_button_start_minimised_in_tray			= glade.get_widget("check_button_start_minimised_in_tray");
	GtkWidget* check_button_always_on_top					= glade.get_widget("check_button_always_on_top");
	GtkWidget* check_button_fullscreen_workaround			= glade.get_widget("check_button_fullscreen_workaround");
	GtkWidget* combo_box_channel_sort						= glade.get_widget("combo_box_channel_sort");
	
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(filechooserbutton_recording_directory), recording_directory.c_str());
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin_button_record_extra_before), record_extra_before);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin_button_record_extra_after), record_extra_after);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin_button_epg_span_hours), epg_span_hours);
	gtk_entry_set_text(GTK_ENTRY(entry_broadcast_address), broadcast_address.c_str());
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin_button_broadcast_port), broadcast_port);
	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_box_epg_encoding), (epg_encoding == "auto") ? 0 : 1);
	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_box_video_driver), (video_driver == "auto") ? 0 : 1);
	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_box_deinterlace_type),
		(deinterlace_type == "default") ? 0 : ((deinterlace_type == "tvtime") ? 1 : 2));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_button_start_minimised_in_tray), start_minimised_in_tray);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_button_always_on_top), always_on_top);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_button_fullscreen_workaround), fullscreen_workaround);
	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_box_channel_sort), channel_sort);

	gboolean was_fullscreen = main_window.get_is_fullscreen();

	if (fullscreen_workaround && was_fullscreen)
	{
		main_window.maximise();
		main_window.show_fullscreen(false);
	}
	
	response = gtk_dialog_run(GTK_DIALOG(dialog_preferences));
	gtk_widget_hide(GTK_WIDGET(dialog_preferences));
	
	if (fullscreen_workaround && was_fullscreen)
	{
		main_window.show_fullscreen(true);
	}
	
	if (response == 1)
	{
		recording_directory				= gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER(filechooserbutton_recording_directory));
		record_extra_before				= (gint)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin_button_record_extra_before));
		record_extra_after				= (gint)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin_button_record_extra_after));
		epg_span_hours					= (gint)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin_button_epg_span_hours));
		broadcast_address				= gtk_entry_get_text(GTK_ENTRY(entry_broadcast_address));
		broadcast_port					= (gint)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin_button_broadcast_port));
		gint epg_encoding_index			= gtk_combo_box_get_active(GTK_COMBO_BOX(combo_box_epg_encoding));
		gint video_driver_index			= gtk_combo_box_get_active(GTK_COMBO_BOX(combo_box_video_driver));
		gint deinterlace_type_index		= gtk_combo_box_get_active(GTK_COMBO_BOX(combo_box_deinterlace_type));
		start_minimised_in_tray			= gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button_start_minimised_in_tray));
		always_on_top					= gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button_always_on_top));
		fullscreen_workaround			= gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button_fullscreen_workaround));
		channel_sort					= gtk_combo_box_get_active(GTK_COMBO_BOX(combo_box_channel_sort));

		configuration.set_string_value("recording_directory", recording_directory);
		configuration.set_int_value("record_extra_before", record_extra_before);
		configuration.set_int_value("record_extra_after", record_extra_after);
		configuration.set_int_value("epg_span_hours", epg_span_hours);
		configuration.set_string_value("broadcast_address", broadcast_address);
		configuration.set_int_value("broadcast_port", broadcast_port);
		configuration.set_string_value("epg_encoding", epg_encoding_index == 0 ? "auto" : "iso6937");
		configuration.set_string_value("xine.video_driver", video_driver_index == 0 ? "auto" : "xshm");
		configuration.set_string_value("xine.deinterlace_type",
			deinterlace_type_index == 0 ? "default" : (deinterlace_type_index == 1 ? "tvtime" : "none"));
		configuration.set_boolean_value("start_minimised_in_tray", start_minimised_in_tray);
		configuration.set_boolean_value("always_on_top", always_on_top);
		configuration.set_boolean_value("fullscreen_workaround", fullscreen_workaround);
		configuration.set_int_value("channel_sort", channel_sort);
	}
}
