#include <time.h>
#include <string.h>
#include "allegro.h"
#include "graphics.h"

#define INFOWIDTH 64
#define SMPICSZ 16
#define LGPICSZ 32
#define BINOC   0
#define BINOCX2 1
#define SATEL   2
#define SATELX2 3
#define GRAPH   4

RLE_SPRITE *crpic[N_OF_SPECIES][N_OF_CRPIC];
RLE_SPRITE *itempic[N_OF_ITEMS];
BITMAP *used_screen;
RGB my_palette[256];
int focusx, focusy, focmodx, focmody, focmodxres, focmodyres,nofpicx, nofpicy,
    timer,fixed_speed_speed,turns_per_sec,turns_per_sec_display,turn_then,
    viewmode;
time_t t_then;
int on_screen[MAPWIDTH][MAPHEIGHT];
int pop_num_display[N_OF_SPECIES],focposx,focposy,picsz;
bool draw_again,smooth,always_draw,left_side,fixed_speed,super_speed,possession,
     mpause,a_pressed,e_pressed,t_pressed,n_pressed;
creature *followcr;
BITMAP *one_pic, *cr_info,*crpic0[N_OF_SPECIES],*itempic0[N_OF_ITEMS],*logo;
char str[50];

void followchoosejob()
{
 if (possession) {
  if (!followcr->usekey()) {
   if (key[KEY_LEFT])
    followcr->dir=WEST;
   if (key[KEY_RIGHT])
    followcr->dir=EAST;
   if (key[KEY_UP])
    followcr->dir=NORTH;
   if (key[KEY_DOWN])
    followcr->dir=SOUTH;
   if (key[KEY_A]||a_pressed) {
    followcr->job=ATTACK;
    a_pressed=false;
   }
   else if (e_pressed) {
    followcr->job=EAT;
    e_pressed=false;
   }
   else if (t_pressed) {
    followcr->job=TAKE;
    t_pressed=false;
   }
   else if (n_pressed) {
    followcr->job=MULTIPLY;
    n_pressed=false;
   }
   else if (key[KEY_LEFT]||key[KEY_RIGHT]||key[KEY_UP]||key[KEY_DOWN])
    followcr->job=RUN;
   else
    followcr->job=SLEEP;
  }
 }
 else
  followcr->choosejob();
}

int matrem()
{
 strcpy(str,"Version  ");
 strcat(str,VERSION);
 DIALOG d[] =
  {
  // (dialog proc)     (x)              (y)          (w)  (h)   (fg)  (bg)  (key) (flags) (d1)  (d2)  (dp)  (dp2) (dp3)
   { d_box_proc,      SCREEN_W/2-150, SCREEN_H/2-100,300, 200,   20,    1,    0,    0,      0,    0, NULL,  NULL, NULL  },
   { d_bitmap_proc,   SCREEN_W/2-80,  SCREEN_H/2-80, 160,  30,    9,    1,    0,    0,      0,    0, logo,  NULL, NULL  },
   { d_ctext_proc,    SCREEN_W/2,     SCREEN_H/2-20, 100,  16,    9,    1,    0,    0,      0,    0,  str,  NULL, NULL  },
   { d_ctext_proc,    SCREEN_W/2,     SCREEN_H/2,    100,  16,    9,    1,    0,    0,      0,    0,(char*) "By Mathijs Romans",  NULL, NULL  },
   { d_ctext_proc,    SCREEN_W/2,     SCREEN_H/2+20, 100,  16,    9,    1,    0,    0,      0,    0,(char*) "www.phys.uu.nl/~romans",  NULL, NULL  },
   { d_ctext_proc,    SCREEN_W/2,     SCREEN_H/2+40, 100,  16,    9,    1,    0,    0,      0,    0,(char*) "see readme.txt for details",  NULL, NULL  },
   { d_button_proc,   SCREEN_W/2-40,  SCREEN_H/2+60,  80,  16,   20,    1,  'o',D_EXIT,     0,    0,(char*) "&Okay!", NULL, NULL },
   { NULL,              0,                        0,   0,   0,    0,    0,    0,    0,      0,    0,            NULL, NULL, NULL  }
  };
 popup_dialog(d,-1);
 return D_O_K;
}


int show_randseed()
{
 char s[12];
 itostr(seedrand,s);
 alert("RandSeed is:", s, NULL, "Okay!", NULL, 'o',0);
 return D_CLOSE;
}

int resume()
{
 return D_CLOSE;
}

int quit()
{
 if (alert("You", "want", "out?", "Yes", "No", 'y', 'n')==1) {
  allegro_exit();
  exit(0);
 }
 return 0;
}

int set_fixed_speed()
{
 DIALOG d[] =
  {
  // (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)     (d1)  (d2)                      (dp)    (dp2) (dp3)
   { d_box_proc,      200,  100,  200,   40,   20,    1,    0,    0,          0,    0,                             NULL,  NULL, NULL  },
   { d_slider_proc,   220,  102,  160,   16,   24,    1,    0,    0,         100, 100-sqrt(100*fixed_speed_speed), NULL,  NULL, NULL  },
   { d_button_proc,   260,  122,   80,   16,   20,    1,  'o', D_EXIT,        0,    0,                     (char*) "&Ok", NULL, NULL  },
   { NULL,              0,    0,    0,    0,    0,    0,    0,    0,          0,    0,                             NULL,  NULL, NULL  }
  };
 popup_dialog(d,-1);
 fixed_speed_speed=((100-d[1].d2)*(100-d[1].d2))/100;
 return D_CLOSE;
}

void follow(int s)
{
 if (number_of[s]!=0) {
  if (!followcr)
   followcr=firstcreature[s];
  else
   if (s!=followcr->species)
    followcr=firstcreature[s];
  do
   if (followcr->next()) followcr=followcr->next();
   else followcr=firstcreature[s]->next();
  while (followcr->status==DEAD);
  smooth=false;
  clear(cr_info);
  followcr->drawinfo(cr_info,true);
 }
}

int find()
{
 int s;
 DIALOG d[N_OF_SPECIES+4];
 for (s=0;s<N_OF_SPECIES+4;s++) {
  d[s].proc=NULL;
  d[s].x=205;d[s].y=15;
  d[s].w=16;d[s].h=16;
  d[s].fg=20;d[s].bg=1;
  d[s].key=0;d[0].flags=0;
  d[s].d1=0, d[s].d2=0;
  d[s].dp=NULL;d[s].dp2=NULL;d[s].dp3=NULL;
 }
 d[0].proc=d_box_proc;
 d[0].w=16*(1+N_OF_SPECIES/4)+49;d[0].h=16*MIN(4,N_OF_SPECIES)+9;
 d[N_OF_SPECIES+1].proc=d_button_proc;
 d[N_OF_SPECIES+1].x=210;d[N_OF_SPECIES+1].y=20;
 d[N_OF_SPECIES+1].h=16*MIN(4,N_OF_SPECIES);d[N_OF_SPECIES+1].w=15;
 d[N_OF_SPECIES+1].key=' ';
 d[N_OF_SPECIES+1].flags=D_EXIT;
 d[N_OF_SPECIES+1].dp=(char*) "X";
 d[N_OF_SPECIES+2].proc=d_button_proc;
 d[N_OF_SPECIES+2].x=230;d[N_OF_SPECIES+2].y=20;
 d[N_OF_SPECIES+2].h=16*MIN(4,N_OF_SPECIES);d[N_OF_SPECIES+2].w=15;
 d[N_OF_SPECIES+2].key='p';
 d[N_OF_SPECIES+2].flags=D_EXIT+(followcr ? 0:D_DISABLED)+(possession ? D_SELECTED:0);
 d[N_OF_SPECIES+2].dp=(char*) "P";
 for (s=0;s<N_OF_SPECIES;s++) {
  d[s+1].proc=d_icon_proc;
  d[s+1].x=250+16*(s/4);d[s+1].y=20+16*(s%4);
  d[s+1].key=firstcreature[s]->shortkey();
  d[s+1].flags=D_EXIT;
  d[s+1].dp=crpic0[s];
 }
 s=popup_dialog(d,-1);
 if (s>0&&s<=N_OF_SPECIES)
  follow(s-1);
 else
  if (s==N_OF_SPECIES+1) followcr=NULL;
 else
  if (s==N_OF_SPECIES+2) possession=!possession;
 return(D_CLOSE);
}

int god()
{
 int s,x,y,xres,yres,modx,mody;
 creature *cr;
 BITMAP *res=create_bitmap(picsz,picsz);
 BITMAP *uno_pic=create_bitmap(picsz,picsz);
 DIALOG d[N_OF_SPECIES+N_OF_ITEMS+3];
 for (s=0;s<N_OF_SPECIES+N_OF_ITEMS+3;s++) {
  d[s].proc=NULL;
  d[s].x=125;d[s].y=15;
  d[s].w=16;d[s].h=16;
  d[s].fg=20;d[s].bg=255;
  d[s].key=0;d[0].flags=0;
  d[s].d1=0, d[s].d2=0;
  d[s].dp=NULL;d[s].dp2=NULL;d[s].dp3=NULL;
 }
 d[0].proc=d_box_proc;
 d[0].w=16*MAX(N_OF_SPECIES/4,N_OF_ITEMS/2)+45;d[0].h=105;
 d[N_OF_SPECIES+1].proc=d_button_proc;
 d[N_OF_SPECIES+1].x=130;d[N_OF_SPECIES+1].y=20;
 d[N_OF_SPECIES+1].h=96;d[N_OF_SPECIES+1].w=15;
 d[N_OF_SPECIES+1].bg=1;
 d[N_OF_SPECIES+1].key=' ';
 d[N_OF_SPECIES+1].flags=D_EXIT;
 d[N_OF_SPECIES+1].dp=(char*) "X";
 for (s=0;s<N_OF_SPECIES;s++) {
  d[s+1].proc=d_icon_proc;
  d[s+1].x=150+16*(s/4);d[s+1].y=20+16*(s%4);
  d[s+1].key=firstcreature[s]->shortkey();
  d[s+1].flags=D_EXIT;
  d[s+1].dp=crpic0[s];
 }
 for (s=0;s<N_OF_ITEMS;s++) {
  d[s+N_OF_SPECIES+2].proc=d_icon_proc;
  d[s+N_OF_SPECIES+2].x=150+16*(s/2);d[s+N_OF_SPECIES+2].y=84+16*(s%2);
  d[s+N_OF_SPECIES+2].key=0;
  d[s+N_OF_SPECIES+2].flags=D_EXIT;
  d[s+N_OF_SPECIES+2].dp=itempic0[s];
 }
 s=popup_dialog(d,-1);
 if (s>=1&&s<N_OF_SPECIES+1)
  stretch_blit(crpic0[s-1], uno_pic, 0, 0, SMPICSZ,SMPICSZ,0, 0, picsz, picsz);
 else if (s>=N_OF_SPECIES+2&&s<N_OF_SPECIES+N_OF_ITEMS+2)
  stretch_blit(itempic0[s-N_OF_SPECIES-2], uno_pic, 0, 0, SMPICSZ,SMPICSZ, 0, 0, picsz, picsz);
 else
  return(D_CLOSE);
 modx=focposx%picsz;
 mody=focposy%picsz;
 x=mouse_x-mouse_x%picsz+modx;y=mouse_y-mouse_y%picsz+mody;
 if (left_side) {
  x-=INFOWIDTH;y-=INFOWIDTH;
 }
 xres=x;yres=y;show_mouse(NULL);
 blit(used_screen,res,x,y,0,0,picsz,picsz);
 blit(uno_pic,used_screen,0,0,x,y,picsz,picsz);
 do {
  x=mouse_x-mouse_x%picsz+modx;y=mouse_y-mouse_y%picsz+mody;
  if (x!=xres||y!=yres) {
   blit(res,used_screen,0,0,xres,yres,picsz,picsz);
   blit(used_screen,res,x,y,0,0,picsz,picsz);
   blit(uno_pic,used_screen,0,0,x,y,picsz,picsz);
   xres=x;yres=y;
  }
  if (!(mouse_b&1)) continue;
  x=(x-focposx)/picsz+focusx;y=(y-focposy)/picsz+focusy;
  if (!(x>0&&x<MAPWIDTH-1&&y>0&&y<MAPHEIGHT-1)) continue;
  if (r[x][y]) continue;
  if (s>=N_OF_SPECIES+2&&s<N_OF_SPECIES+N_OF_ITEMS+2) {
   p[x][y]=s-N_OF_SPECIES-2;
   break;
  }
  else {
   if (!(atterrain[p[x][y]]&firstcreature[s-1]->terrain))
    continue;
   cr=firstcreature[s-1]->newcreature();
   cr->xcoor=x;
   cr->ycoor=y;
   r[x][y]=cr;
   number_of[s-1]++;
   followcr=cr;
   break;
  }
 }
 while (!(key[KEY_ESC]));
 show_mouse(screen);
 destroy_bitmap(res);
 destroy_bitmap(uno_pic);
 return(D_CLOSE);
}

char *creature_list(int index, int *list_size)
{
 char s1[50];
 int i, totpop;
 for (i=0;i<strlen(str);i++)
  str[i]=0;
 if (index<0)
  *list_size=N_OF_SPECIES;
 else if (index<N_OF_SPECIES) {
  totpop=0;
  for (i=0;i<MIN(turn/32,POPMEM);i++)
   totpop+=pop[i][index];
  strcat(str,firstcreature[index]->name());
  for (i=strlen(str);i<15;i++)
   strcat(str," ");
  itostr(firstcreature[index]->weight,s1);
  strcat(str,s1);
  for (i=strlen(str);i<25;i++)
   strcat(str," ");
  itostr(totpop/MIN(turn/32,POPMEM),s1);
  strcat(str,s1);
  for (i=strlen(str);i<38;i++)
   strcat(str," ");
  itostr(firstcreature[index]->weight*totpop/MIN(turn/32,POPMEM),s1);
  strcat(str,s1);
  return str;
 }
 return "&%@#!";
}


int show_results()
{
 DIALOG d[] =
  {
  // (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)     (d1)  (d2)           (dp)   (dp2) (dp3)
   { d_box_proc,      100,   50,  500,  350,   20,    1,    0,    0,          0,    0,            NULL,  NULL, NULL  },
   { d_text_proc,     120,   60,  480,   16,    9,    1,    0,    0,          0,    0,(char*) "Species              Weight   Population  Biomass",  NULL, NULL  },
   { d_list_proc,     110,   80,  480,  270,    3,    1,    0,    0,          0,    0,   creature_list,  NULL, NULL  },
   { d_button_proc,   310,  375,   80,   16,   20,    1,  'o', D_EXIT,        0,    0,(char*) "&Okay!",  NULL, NULL  },
   { NULL,              0,    0,    0,    0,    0,    0,    0,    0,          0,    0,            NULL,  NULL, NULL  }
  };
 popup_dialog(d,-1);
 return D_CLOSE;
}

int toggle_fixed_speed();
int toggle_super_speed();
int toggle_pause();
int toggle_smooth();
int toggle_draw_turns();
int toggle_left_side();
int set_viewmode(int mode);
int set_viewmode0() {return set_viewmode(0);}
int set_viewmode1() {return set_viewmode(1);}
int set_viewmode2() {return set_viewmode(2);}
int set_viewmode3() {return set_viewmode(3);}
int set_viewmode4() {return set_viewmode(4);}
int set_res(int w, int h);
int set_res640() {return set_res(640,480);}
int set_res800() {return set_res(800,600);}
int set_res1024() {return set_res(1024,768);}


MENU speed[]=
  {
    { "&Fixed speed",             toggle_fixed_speed,NULL, 0, NULL },
    { "&Smooth scroll",           toggle_smooth,     NULL, 0, NULL },
    { "&Always draw screen",      toggle_draw_turns, NULL, 0, NULL },
    { "",                         NULL,              NULL, 0, NULL },
    { "S&et fixed speed",         set_fixed_speed,   NULL, 0, NULL },
    { "S&uper speed",             toggle_super_speed,NULL, 0, NULL },
    { "&Pause",                   toggle_pause,      NULL, 0, NULL },
    { NULL,                       NULL,              NULL, 0, NULL }
  };
MENU windows[]=
  {
    { "&Populations",             toggle_left_side, NULL, 0, NULL },
    { "",                         NULL,             NULL, 0, NULL },
    { "&Binoculars",              set_viewmode0,    NULL, 0, NULL },
    { "Binoculars &x2",           set_viewmode1,    NULL, 0, NULL },
    { "&Satellite",          set_viewmode2,    NULL, 0, NULL },
    { "S&atellite x2",       set_viewmode3,    NULL, 0, NULL },
    { "&Graph",                   set_viewmode4,    NULL, 0, NULL },
    { NULL,                       NULL,             NULL, 0, NULL }
  };
MENU info[]=
  {
    { "&RandSeed",                show_randseed,    NULL, 0, NULL },
    { "&Results",                 show_results,    NULL, 0, NULL },
    { NULL,                       NULL,             NULL, 0, NULL }
  };
MENU resolution[]=
  {
    { "&640x480",                 set_res640,       NULL, 0, NULL },
    { "&800x600",                 set_res800,       NULL, 0, NULL },
    { "&1024x768",                set_res1024,      NULL, 0, NULL },
    { NULL,                       NULL,             NULL, 0, NULL }
  };

MENU menu[] =
  {
    { "&Matrem",                matrem,            NULL,           0, NULL },
    { "&Speed",                   NULL,            speed,           0, NULL },
    { "&Windows",                 NULL,          windows,           0, NULL },
    { "&Find",                    find,             NULL,           0, NULL },
    { "&God",                     god,              NULL,           0, NULL },
    { "&Info",                    NULL,             info,           0, NULL },
    { "Reso&lution",              NULL,       resolution,           0, NULL },
    { "&Resume",                  resume,           NULL,           0, NULL },
    { "&Quit",                    quit,             NULL,           0, NULL },
    { NULL,                       NULL,             NULL,           0, NULL }
  };
DIALOG main_menu[] =
  {
  // (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)     (d1)  (d2)  (dp)    (dp2) (dp3)
   { d_menu_proc,       0,    0,    0,    0,    0,    0,    0,    0,          0,    0,    menu,  NULL, NULL  },
   { NULL,              0,    0,    0,    0,    0,    0,    0,    0,          0,    0,    NULL,  NULL, NULL  }
  };

void update_left_side()

{
 int s,sumalive=0,sumdead=0;
 text_mode(0);
 for (s=0;s<MIN(N_OF_SPECIES,20);s++)
  if (pop_num_display[s]!=number_of[s]) {
   rectfill(screen,20,s*16+16,INFOWIDTH-2,s*16+31,0);
   textprintf(screen, font, 24, s*16+20, 5, "%i",number_of[s]);
   pop_num_display[s]=number_of[s];
  }
 for (s=0;s<N_OF_SPECIES;s++) {
  sumalive+=number_of[s];
  sumdead+=number_of_dead[s];
 }
 if (followcr)
  followcr->drawinfo(cr_info,draw_again);
 else {
  rectfill(screen,4,338,INFOWIDTH-2,346,0);
  textprintf(screen,font,4,338,5,"%i",turn);
  rectfill(screen,4,358,INFOWIDTH-2,366,0);
  textprintf(screen,font,4,358,5,"%i",sumalive);
  rectfill(screen,4,378,INFOWIDTH-2,386,0);
  textprintf(screen,font,4,378,5,"%i",sumdead);
 }
 if (turns_per_sec_display!=turns_per_sec) {
  rectfill(screen,4,471,INFOWIDTH-25,478,0);
  textprintf(screen,font,4,471,5,"%i",turns_per_sec);
  turns_per_sec_display=turns_per_sec;
 }
}

void draw_left_side()

{
 int s;
 text_mode(0);
 rectfill(screen,0,0,INFOWIDTH-1,SCREEN_H-1,0);
 rect(screen,0,14,INFOWIDTH-1,325,30);
 rect(screen,0,325,INFOWIDTH-1,470,30);
 rect(screen,0,470,INFOWIDTH-1,479,30);
 for (s=0;s<MIN(N_OF_SPECIES,20);s++) {
  draw_rle_sprite(screen,crpic[s][0],4,s*16+16);
  if (viewmode==SATEL||viewmode==SATELX2||viewmode==GRAPH)
   rect(screen,4,s*16+16,4+15,s*16+16+16,firstcreature[s]->color());
  pop_num_display[s]=-1;
 }
 turns_per_sec_display=-1;
 if (!followcr) {
  textout(screen,font,"T:",20,330,5);
  textout(screen,font,"Alive:",10,350,5);
  textout(screen,font,"Dead:",10,370,5);
 }
 textout(screen,font,"t/s",INFOWIDTH-25,471,5);
 update_left_side();
}

void draw_graph()
{
 int x,y,p0,p1,p2;
 if (draw_again)
  clear(used_screen);
 for (x=MAX(MAX(0,used_screen->w-POPMEM),used_screen->w-(int) (turn/32));x<used_screen->w;x++)
  for (y=0;y<N_OF_SPECIES;y++) {
   p0=pop[(turn/32-(used_screen->w-x))%POPMEM][y];
   p1=pop[(turn/32-1-(used_screen->w-x))%POPMEM][y];
   p2=pop[(turn/32-2-(used_screen->w-x))%POPMEM][y];
   if (!draw_again)
    if (p1||p2)
     vline(used_screen,x,SCREEN_H-p1,SCREEN_H-p2,0);
   if (p0||p1)
    vline(used_screen,x,SCREEN_H-p0,SCREEN_H-p1,firstcreature[y]->color());
  }
}

void draw_sattelite()
{
 int x,y,pix;
 if (draw_again)
  clear(used_screen);
 for (x=0;x<MAPWIDTH;x++)
  for (y=0;y<MAPHEIGHT;y++) {
   if (r[x][y]) pix=firstcreature[r[x][y]->species]->color();
   else pix=p[x][y];
   if (draw_again||pix!=on_screen[x][y]) {
    if (viewmode==SATEL)
     putpixel(used_screen,10+x,y,pix);
    else
     rectfill(used_screen,10+x*2,y*2,11+x*2,1+y*2,pix);
    on_screen[x][y]=pix;
   }
  }
}

int toggle_fixed_speed()
{
 fixed_speed=!fixed_speed;
 speed[0].flags=fixed_speed ? D_SELECTED:0;
 return D_CLOSE;
}

int toggle_super_speed()
{
 super_speed=!super_speed;
 return D_CLOSE;
}

int toggle_pause()
{
 mpause=!mpause;
 return D_CLOSE;
}


int toggle_smooth()
{
 if (!followcr) smooth=!smooth;
 return D_CLOSE;
}

int toggle_draw_turns()
{
 always_draw=!always_draw;
 return D_CLOSE;
}

int toggle_left_side()
{
 destroy_bitmap(used_screen);
 left_side=!left_side;
 if (left_side)
  used_screen=create_sub_bitmap(screen,INFOWIDTH,0,SCREEN_W-INFOWIDTH,SCREEN_H);
 else
  used_screen=create_sub_bitmap(screen,0,0,SCREEN_W,SCREEN_H);
 nofpicx=((used_screen->w+picsz-1)/picsz+1)/2;
 nofpicy=((used_screen->h+picsz-1)/picsz+1)/2;
 return D_CLOSE;
}

int set_viewmode(int mode)
{
 if (viewmode==mode) return D_O_K;
 viewmode=mode;
 if (viewmode==BINOC)
  picsz=SMPICSZ;
 if (viewmode==BINOCX2)
  picsz=LGPICSZ;
 focusx+=focmodx/picsz;
 focusy+=focmody/picsz;
 focmodx=focmodx%picsz;
 focmody=focmody%picsz;
 nofpicx=((used_screen->w+picsz-1)/picsz+1)/2;
 nofpicy=((used_screen->h+picsz-1)/picsz+1)/2;
 return D_CLOSE;
}

int set_res(int w,int h)
{
 if (w==SCREEN_W) return D_O_K;
 destroy_bitmap(cr_info);
 destroy_bitmap(used_screen);
 if (set_gfx_mode(GFX_AUTODETECT,w,h,0,0)) {
  set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
  set_palette(my_palette);
  alert("I tried, and tried", "but your computer is too stupid",
  "to get this kind of civilized resolution", "How embarassing!", NULL, 'h',0);
 }
 else set_palette(my_palette);
 cr_info=create_sub_bitmap(screen,1,326,INFOWIDTH-2,144);
 if (left_side)
  used_screen=create_sub_bitmap(screen,INFOWIDTH,0,SCREEN_W-INFOWIDTH,SCREEN_H);
 else
  used_screen=create_sub_bitmap(screen,0,0,SCREEN_W,SCREEN_H);
 nofpicx=((used_screen->w+picsz-1)/picsz+1)/2;
 nofpicy=((used_screen->h+picsz-1)/picsz+1)/2;
 return D_CLOSE;
}

void init_graphics()
{
 BITMAP *bmp;
 int x,y;
 one_pic=create_bitmap(SMPICSZ,SMPICSZ);
 if (!(logo=load_bmp("logo.bmp", my_palette)))
  error ("couldn't find the file 'logo.bmp'");
 if (!(bmp=load_bmp("map.bmp", my_palette)))
  error ("couldn't find the file 'map.bmp'");
 for (y=0;y<bmp->h;y++)
  for (x=0;x<bmp->w;x++)
   p[x][y]=bmp->line[y][x];
 destroy_bitmap(bmp);

 if (!(bmp=load_bmp("crpic.bmp", my_palette)))
  error ("couldn't find the file 'crpic.bmp'");
 for (x=0;x<N_OF_SPECIES;x++)
 {
  crpic0[x]=create_bitmap(SMPICSZ,SMPICSZ);
  blit(bmp, crpic0[x], x*SMPICSZ, 0, 0, 0, SMPICSZ, SMPICSZ);
  for (y=0;y<N_OF_CRPIC;y++) {
   blit(bmp, one_pic, x*SMPICSZ, y*SMPICSZ, 0, 0, SMPICSZ, SMPICSZ);
   crpic[x][y]=get_rle_sprite(one_pic);
  }
 }
 destroy_bitmap(bmp);

 if (!(bmp=load_bmp("itempic.bmp", my_palette)))
  error ("couldn't find the file 'itempic.bmp'");
 for (x=0;x<N_OF_ITEMS;x++) {
  itempic0[x]=create_bitmap(SMPICSZ,SMPICSZ);
  blit(bmp, itempic0[x], x*SMPICSZ, 0, 0, 0, SMPICSZ, SMPICSZ);
  itempic[x]=get_rle_sprite(itempic0[x]);
  }
 destroy_bitmap(bmp);
 if (set_gfx_mode(GFX_AUTODETECT,640,480,0,0))
  error ("couldn't get graphics mode with resolution:",640,480);
 set_palette(my_palette);
 cr_info=create_sub_bitmap(screen,1,326,INFOWIDTH-2,144);
 used_screen=create_sub_bitmap(screen,INFOWIDTH,0,SCREEN_W-INFOWIDTH,SCREEN_H);
 focusx=0;focusy=0;
 focmodx=0;focmody=0;
 draw_again=true;
 smooth=false;
 always_draw=true;
 fixed_speed=false;
 fixed_speed_speed=10;
 left_side=true;
 viewmode=BINOC;
 picsz=SMPICSZ;
 nofpicx=((used_screen->w+picsz-1)/picsz+1)/2;
 nofpicy=((used_screen->h+picsz-1)/picsz+1)/2;
 super_speed=false;
 mpause=false;
 turns_per_sec=0;
 turns_per_sec_display=-1;
 t_then=time(0);
 turn_then=0;
 followcr=NULL;
 possession=false;
 a_pressed=false;
 e_pressed=false;
 t_pressed=false;
 n_pressed=false;
 get_mouse_mickeys(&x,&y);
 set_mouse_speed(0,0);
 gui_fg_color=20;
 gui_bg_color=1;
 clear_keybuf();
 timer=retrace_count;
}

void draw_one_pic(int x, int y)

{
 if (x>=0&&x<MAPWIDTH&&y>=0&&y<MAPHEIGHT) {
  if (viewmode==BINOC) {
   if (!r[x][y]) {
    if (p[x][y]==FIRE||draw_again||on_screen[128+x-focusx][128+y-focusy]!=p[x][y]) {
     if (p[x][y]!=FIRE)
      draw_rle_sprite(used_screen,itempic[p[x][y]],focposx+(x-focusx)*picsz,focposy+(y-focusy)*picsz);
     else
      draw_rle_sprite(used_screen,itempic[16+(x+y+turn/5)%3],focposx+(x-focusx)*picsz,focposy+(y-focusy)*picsz);
     on_screen[128+x-focusx][128+y-focusy]=p[x][y];
    }
   }
   else {
    if (p[x][y]!=FIRE)
     draw_rle_sprite(one_pic,itempic[p[x][y]],0,0);
    else
     draw_rle_sprite(one_pic,itempic[16+(x+y+turn/5)%3],0,0);
    draw_rle_sprite(one_pic,crpic[r[x][y]->species][r[x][y]->lookslike()],0,0);
    blit(one_pic,used_screen,0,0,focposx+(x-focusx)*picsz,focposy+(y-focusy)*picsz,picsz,picsz);
    on_screen[128+x-focusx][128+y-focusy]=-1;
   }
  }
  else if (viewmode==BINOCX2) {
   if (p[x][y]==FIRE||draw_again||r[x][y]||on_screen[128+x-focusx][128+y-focusy]!=p[x][y]) {
    if (p[x][y]!=FIRE)
     draw_rle_sprite(one_pic,itempic[p[x][y]],0,0);
    else
     draw_rle_sprite(one_pic,itempic[16+(x+y+turn/5)%3],0,0);
    if (r[x][y]) {
     draw_rle_sprite(one_pic,crpic[r[x][y]->species][r[x][y]->lookslike()],0,0);
     on_screen[128+x-focusx][128+y-focusy]=-1;
    }
    else
     on_screen[128+x-focusx][128+y-focusy]=p[x][y];
    stretch_blit(one_pic,used_screen,0,0,SMPICSZ,SMPICSZ,focposx+(x-focusx)*picsz,focposy+(y-focusy)*picsz,LGPICSZ,LGPICSZ);
   }
  }
 }
 else
  on_screen[128+x-focusx][128+y-focusy]=-1;
}

void draw_screen()
{
 int dx,dy,mx,my,x,y;
 char c;
 do
 {
  if (!super_speed&&(always_draw||!(turn%32))) {
   if (difftime(time(0),t_then)) {
    turns_per_sec=turn-turn_then;
    turn_then=turn;
    t_then=time(0);
   }
   get_mouse_mickeys(&dx,&dy);
   if (followcr) {
    focusx=followcr->xcoor;
    focusy=followcr->ycoor;
   }
   if (left_side)
    if (draw_again) draw_left_side();
     else update_left_side();
   if (viewmode==GRAPH) {
    if (draw_again||!(turn%32))
    draw_graph();
   }
   if (viewmode==SATEL||viewmode==SATELX2)
    draw_sattelite();
   else if (viewmode==BINOC||viewmode==BINOCX2) {
    if (draw_again) {
     if (smooth) {
      focposx=used_screen->w/2-focmodx;
      focposy=used_screen->h/2-focmody;
     }
     else {
      focposx=used_screen->w/2;
      focposy=used_screen->h/2;
     }
    }
    if (!followcr&&(dx||dy)) {
     mx=picsz*focusx+focmodx+dx;my=picsz*focusy+focmody+dy;
     focusx=mx/picsz;focusy=my/picsz;
     focmodx=mx%picsz; focmody=my%picsz;
     if (focusx<=0) {focusx=0;focmodx=0;}
     if (focusy<=0) {focusy=0;focmody=0;}
     if (focusx>=MAPWIDTH) {focusx=MAPWIDTH-1;focmodx=picsz-1;}
     if (focusy>=MAPHEIGHT) {focusy=MAPHEIGHT-1;focmody=picsz-1;}
     if (smooth) {
      draw_again=true;
      focposx=used_screen->w/2-focmodx;
      focposy=used_screen->h/2-focmody;
     }
    }
    if (followcr||dx||dy||draw_again) {
     if (focusx-nofpicx<0)
      rectfill(used_screen,0,0,focposx-picsz*focusx-1,used_screen->h-1,0);
     if (focusy-nofpicy<0)
      rectfill(used_screen,0,0,used_screen->w-1,focposy-picsz*focusy-1,0);
     if (focusx+nofpicx>MAPWIDTH)
      rectfill(used_screen,focposx+picsz*(MAPWIDTH-focusx),0,used_screen->w-1,used_screen->h-1,0);
     if (focusy+nofpicy>MAPHEIGHT)
      rectfill(used_screen,0,focposy+picsz*(MAPHEIGHT-focusy),used_screen->w-1,used_screen->h-1,0);
    }
    for (x=focusx-nofpicx;x<focusx+nofpicx+(smooth?1:0);x++)
     for (y=focusy-nofpicy;y<focusy+nofpicy+(smooth?1:0);y++)
       draw_one_pic(x,y);
   }
   draw_again=false;
  }
  c=0;
  if (mouse_b & 2) c='m';
  if (keypressed())
   c=readkey()&0xff;
  if (c) {
   draw_again=true;
   if (c=='m') {
    menu[4].flags=(viewmode==BINOC||viewmode==BINOCX2)? 0:D_DISABLED;
    speed[0].flags=fixed_speed ? D_SELECTED:0;
    speed[1].flags=(smooth ? D_SELECTED:0)|(followcr ? D_DISABLED:0);
    speed[2].flags=always_draw ? D_SELECTED:0;
    speed[5].flags=super_speed ? D_SELECTED:0;
    speed[6].flags=mpause ? D_SELECTED:0;
    windows[0].flags=left_side ? D_SELECTED:0;
    windows[2].flags=viewmode==0 ? D_SELECTED:0;
    windows[3].flags=viewmode==1 ? D_SELECTED:0;
    windows[4].flags=viewmode==2 ? D_SELECTED:0;
    windows[5].flags=viewmode==3 ? D_SELECTED:0;
    windows[6].flags=viewmode==4 ? D_SELECTED:0;
    resolution[0].flags=SCREEN_W==640 ? D_SELECTED:0;
    resolution[1].flags=SCREEN_W==800 ? D_SELECTED:0;
    resolution[2].flags=SCREEN_W==1024 ? D_SELECTED:0;
    do_dialog(main_menu,0);
   }
   else if (c=='q') quit();
   else if (c==' ') followcr=NULL;
   else if (c=='p') possession=!possession;
   else if (possession&&followcr) {
    if (c=='a') a_pressed=true;
    else if (c=='e') e_pressed=true;
    else if (c=='t') t_pressed=true;
    else if (c=='n') n_pressed=true;
   }
   else {
    for (x=0;x<N_OF_SPECIES;x++)
     if (c==firstcreature[x]->shortkey())
      break;
    if (x<N_OF_SPECIES)
     follow(x);
   }
   get_mouse_mickeys(&x,&y);
   if (super_speed) {
    clear(screen);
    text_mode(0);
    textout(screen,font,"Super Speed!",SCREEN_W/2-50,SCREEN_H/2,5);
   }
  }
 }
 while (retrace_count-timer<fixed_speed_speed&&fixed_speed||mpause);
 timer=retrace_count;
}

