(* Copyright (C) 2006, HELM Team.
 * 
 * This file is part of HELM, an Hypertextual, Electronic
 * Library of Mathematics, developed at the Computer Science
 * Department, University of Bologna, Italy.
 * 
 * HELM is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * HELM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HELM; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA  02111-1307, USA.
 * 
 * For details, see the HELM World-Wide-Web page,
 * http://helm.cs.unibo.it/
 *)

type type_of_rc = 
  | Success of Cic.term * Cic.term * Cic.metasenv * CicUniv.universe_graph
  | Exception of string Lazy.t

  (* these are the same functions of cic_unification/ (eventually wrapped) *)
type kit = {
  type_of_aux':
    ?localization_tbl:Stdpp.location Cic.CicHash.t ->
    Cic.metasenv -> Cic.context -> Cic.term -> CicUniv.universe_graph ->
      type_of_rc;
  pack_coercion_obj: Cic.obj -> Cic.obj;
  apply_subst: Cic.substitution -> Cic.term -> Cic.term ;
  ppsubst: metasenv:Cic.metasenv -> Cic.substitution -> string;
  ppmetasenv: Cic.substitution -> Cic.metasenv -> string;
} 

