/* massXpert - the true massist's program.
   --------------------------------------
   Copyright(C) 2006,2007 Filippo Rusconi

   http://www.massxpert.org/massXpert

   This file is part of the massXpert project.

   The massxpert project is the successor to the "GNU polyxmass"
   project that is an official GNU project package(see
   www.gnu.org). The massXpert project is not endorsed by the GNU
   project, although it is released ---in its entirety--- under the
   GNU General Public License. A huge part of the code in massXpert
   is actually a C++ rewrite of code in GNU polyxmass. As such
   massXpert was started at the Centre National de la Recherche
   Scientifique(FRANCE), that granted me the formal authorization to
   publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License version 3, as published by the Free Software Foundation.
   

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software; if not, write to the

   Free Software Foundation, Inc.,

   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef MZ_LAB_OUTPUT_OLIGOMER_TREEVIEW_DLG_HPP
#define MZ_LAB_OUTPUT_OLIGOMER_TREEVIEW_DLG_HPP


/////////////////////// Qt includes
#include <QMainWindow>
#include <QSortFilterProxyModel>


/////////////////////// Local includes
#include "ui_mzLabOutputOligomerTreeViewDlg.h"
#include "mzLabOutputOligomerTreeViewModel.hpp"
#include "mzLabOutputOligomerTreeViewSortProxyModel.hpp"
#include "mzLabInputOligomerTreeViewModel.hpp"


namespace massXpert
{

  class MzLabOutputOligomerTreeViewModel;
  class MzLabOutputOligomerTreeViewSortProxyModel;

  class MzLabOutputOligomerTreeViewDlg : public QDialog
  {
    Q_OBJECT
  
    private:
    QList <OligomerPair *> *mpa_oligomerPairList;
    MassType m_massType;
    Ui::MzLabOutputOligomerTreeViewDlg m_ui;

    // The dialog windows that hold the data that were used to perform
    // the matches that we are reporting in *this dialog window.
    MzLabInputOligomerTreeViewDlg *mp_inputOligomerTreeViewDlg1;
    MzLabInputOligomerTreeViewDlg *mp_inputOligomerTreeViewDlg2;
    
    QString m_name;
    
    MzLabOutputOligomerTreeViewModel *mpa_oligomerTreeViewModel;

    void closeEvent(QCloseEvent *event);
  
  public:
    MzLabOutputOligomerTreeViewDlg(QWidget *, 
				    QList<OligomerPair *> *,
				    MassType,
				    MzLabInputOligomerTreeViewDlg *,
				    MzLabInputOligomerTreeViewDlg *,
				    const QString & = QString());
  
    ~MzLabOutputOligomerTreeViewDlg();

    void setName(const QString &);
    QString name();

  public slots:
  };
  
} // namespace massXpert


#endif // MZ_LAB_OUTPUT_OLIGOMER_TREEVIEW_DLG_HPP
