/* massXpert - the true massist's program.
   --------------------------------------
   Copyright(C) 2006,2007 Filippo Rusconi

   http://www.massxpert.org/massXpert

   This file is part of the massXpert project.

   The massxpert project is the successor to the "GNU polyxmass"
   project that is an official GNU project package(see
   www.gnu.org). The massXpert project is not endorsed by the GNU
   project, although it is released ---in its entirety--- under the
   GNU General Public License. A huge part of the code in massXpert
   is actually a C++ rewrite of code in GNU polyxmass. As such
   massXpert was started at the Centre National de la Recherche
   Scientifique(FRANCE), that granted me the formal authorization to
   publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License version 3, as published by the Free Software Foundation.
   

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software; if not, write to the

   Free Software Foundation, Inc.,

   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
*/


/////////////////////// Local includes
#include "fragmentOligomerTreeViewModel.hpp"
#include "application.hpp"


namespace massXpert
{

  FragmentOligomerTreeViewModel::FragmentOligomerTreeViewModel 
 (QList<OligomerList *> *dataList, QObject *parent) 
    : QAbstractItemModel(parent)
  {
    QList<QVariant> rootData;

    Q_ASSERT(dataList);
    Q_ASSERT(parent);
  
    mp_parentDlg = static_cast<FragmentationDlg *>(parent);
  
    rootData << tr("Pattern") << tr("Name") << tr("Coordinates")
	     << tr("Mono") << tr("Avg") 
	     << tr("Charge") << tr("Modif");
  
    mpa_rootItem = new FragmentOligomerTreeViewItem(rootData);
  
    mp_list = dataList;
    setupModelData(mpa_rootItem);
  }


  FragmentOligomerTreeViewModel::~FragmentOligomerTreeViewModel()
  {
    delete mpa_rootItem;
  }


  FragmentationDlg *
  FragmentOligomerTreeViewModel::getParentDlg()
  {
    return mp_parentDlg;
  }


  void 
  FragmentOligomerTreeViewModel::setTreeView(QTreeView *treeView)
  {
    Q_ASSERT(treeView);
  
    mp_treeView = treeView;
  }


  QTreeView *
  FragmentOligomerTreeViewModel::treeView()
  {
    return mp_treeView;
  }


  QVariant 
  FragmentOligomerTreeViewModel::data(const QModelIndex &index, 
				       int role) const
  {
    if (!index.isValid())
      return QVariant();
  
    if (role != Qt::DisplayRole)
      return QVariant();
  
    FragmentOligomerTreeViewItem *item = 
      static_cast<FragmentOligomerTreeViewItem *>(index.internalPointer());
  
    return item->data(index.column());
  }


  // bool
  // FragmentOligomerTreeViewModel::setData(const QModelIndex & index, 
  // 					  const QVariant & value, 
  // 					  int role)
  // {
 
  //   return true;
  // }


  QVariant 
  FragmentOligomerTreeViewModel::headerData(int section, 
					     Qt::Orientation orientation,
					     int role) const
  {
    if (orientation == Qt::Horizontal && role == Qt::DisplayRole)
      return mpa_rootItem->data(section);
  
    return QVariant();
  }


  // Qt::ItemFlags 
  // FragmentOligomerTreeViewModel::flags(const QModelIndex &index) const
  // {
  //   if (!index.isValid())
  //     return;
  
  //   return Qt::ItemIsEnabled | Qt::ItemIsSelectable;
  // }


  QModelIndex 
  FragmentOligomerTreeViewModel::index(int row, int column,
					const QModelIndex &parent) const
  {
    FragmentOligomerTreeViewItem *parentItem = 0;
  
    if (!parent.isValid())
      parentItem = mpa_rootItem;
    else
      parentItem = 
	static_cast<FragmentOligomerTreeViewItem *> 
	(parent.internalPointer());
  
    FragmentOligomerTreeViewItem *childItem = parentItem->child(row);
    if (childItem != 0)
      return createIndex(row, column, childItem);
    else
      return QModelIndex();
  }


  QModelIndex 
  FragmentOligomerTreeViewModel::parent(const QModelIndex &index) const
  {
    if (!index.isValid())
      return QModelIndex();

    FragmentOligomerTreeViewItem *childItem = 
      static_cast<FragmentOligomerTreeViewItem *>(index.internalPointer());
  
    FragmentOligomerTreeViewItem *parentItem = childItem->parent();

    if (parentItem == mpa_rootItem)
      return QModelIndex();
  
    return createIndex(parentItem->row(), 0, parentItem);
  }


  int 
  FragmentOligomerTreeViewModel::rowCount(const QModelIndex &parent) const
  {
    FragmentOligomerTreeViewItem *parentItem;
  
    if (!parent.isValid())
      parentItem = mpa_rootItem;
    else
      parentItem = 
	static_cast<FragmentOligomerTreeViewItem *> 
	(parent.internalPointer());
  
    return parentItem->childCount();
  }


  int
  FragmentOligomerTreeViewModel::columnCount(const QModelIndex &parent) const
  {
    if (parent.isValid())
      return static_cast<FragmentOligomerTreeViewItem *> 
	(parent.internalPointer())->columnCount();
    else
      return mpa_rootItem->columnCount();
  }



  bool 
  FragmentOligomerTreeViewModel::setupModelData 
 (FragmentOligomerTreeViewItem *parent)
  {
    Application *application = static_cast<Application *>(qApp);
    QLocale locale = application->locale();
    
    QList<FragmentOligomerTreeViewItem *> parents;
    FragmentOligomerTreeViewItem *currentItem = 0;
  
    FragmentOligomer *oligomer = 0;
  
    Q_ASSERT(parent);
  
    // Start with populating the very first item of the treeviewmodel.
    parents << parent;
  
    // We have the mp_list pointer that points to a QList of
    // OligomerList * pointers. For each list, we have to create one
    // "parent" item. The first list item is by definition partial
    // cleavage 0. All the subsequent ones are 1, 2, 3, n+1...
  
    for (int iter = 0; iter < mp_list->size(); ++iter)
      {
	QList<QVariant> columnData;
      
	// Get the name of the currently iterated OligomerList. We'll
	// use it for the "Partial" column of the treeview, as this is
	// what this name contains(as set during the filling of the
	// list of lists of oligomers in the Cleaver instance).

	QString listName = mp_list->at(iter)->name();

	OligomerList *oligomerList = mp_list->at(iter);
      
	for(int jter = 0; jter < oligomerList->size(); ++jter)
	  {
	    oligomer = 
	      static_cast<FragmentOligomer *>(oligomerList->at(jter));
	  
	    QList<QVariant> columnData;
	  
	    QString coordinates(QString("[%1-%2]")
				 .arg(oligomer->startIndex() + 1)
				 .arg(oligomer->endIndex() + 1));

	    // And now convert the masses from double to string, so
	    // that we can use our conversion system.

	    QString mono = oligomer->mono(locale, MXP_OLIGOMER_DEC_PLACES);
	      // locale.toString(oligomer->mono(), 'f', 5);

	    QString avg = oligomer->avg(locale, MXP_OLIGOMER_DEC_PLACES);
	      // locale.toString(oligomer->avg(), 'f', 5);

	    columnData  
	      << oligomer->fragmentationPattern() << oligomer->name() 
	      << coordinates
	      << mono << avg
	      << oligomer->charge() << oligomer->isModified();
	  	  
	    currentItem = new FragmentOligomerTreeViewItem(columnData,
							    parents [0]);

	    currentItem->setOligomer(oligomer);
	  
	    // Append the currently created item to the last partial.
	  
	    parents [0]->appendChild(currentItem);
	  }
      
	// At this point we have finished setting up the Model data.
      }

    return true;
  }

} // namespace massXpert
