/* This file is part of the KDE project

   Copyright (C) 2006 KovoKs <info@kovoks.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef ADDRESSLINEEDIT_H
#define ADDRESSLINEEDIT_H

#include <kcompletion.h>
#include <kcompletionbox.h>

namespace Mailody {

/**
 * @class Completion
 * This class provides the completion for the Composers AddressLineEdit
 * Its reimplemented to show a box to choose the address from.
 * @author Tom Albers <tomalbers@kde.nl>
 */
class Completion : public KCompletion
{
    public:
        /**
         * Constructor
         */
        explicit Completion(KLineEdit*);

        /**
         * reimplemented to show the completion box
         */
        virtual QString makeCompletion(const QString&);

        /**
         * returns a pointer to the completion box
         */
        KCompletionBox* box() const { return m_box; };

        /**
         * returns true if the box id currently shown
         */
        bool boxVisible()     const { return !m_box->isHidden();};

    private:
        KCompletionBox* m_box;
};

/**
 * @class AddressLineEdit
 * This class provides Composers KLineEdit with auto completion
  * @author Tom Albers <tomalbers@kde.nl>
 */
class AddressLineEdit : public KLineEdit
{
    Q_OBJECT

    public:
        /**
         * Constructor
         */
        explicit AddressLineEdit(QWidget*);

        /**
         * makes us aware that the text currently shown is a help text
         */
        void setHelp(bool i) { m_helpText = i; };

        /**
         * returns if the current text is a help text
         */
        bool help() const {return m_helpText; };

        /**
         * returns a pointer to the completion object
         */
        Completion* completion() const { return m_completion; };

    protected:
        /**
         * reimplemented to be able to remove the help text
         */
        void keyPressEvent ( QKeyEvent *e );
        /**
         * reimplemented to be able to remove the help text
         */
        void mousePressEvent ( QMouseEvent * e );

    private:
        bool        m_helpText;
        Completion* m_completion;
        QColor      m_origColor;

    private slots:
        void slotSetAddress(const QString& text);

    signals:
        /**
         * Will be emitted when the address needs to shift from to->cc, cc->bcc
         */
        void shiftAddress();

        /**
         * Will be emitted when the @p address needs to be added to the
         * addressees.
         */
        void addAddress(const QString& address);
};

}

#endif // COMPOSER
