/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file IsoShadingAttributes.h
    \brief Definition of IsoShading Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:37 2011
*/
   

#ifndef IsoShadingAttributes_H
#define IsoShadingAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "ShadingTechnique.h"
#include "ColourTechnique.h"

namespace magics {

class XmlNode;


template <class P>
class IsoShadingAttributes 
{
public:
//  --  constructor
    IsoShadingAttributes();
    
//  --  destructor
    virtual ~IsoShadingAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const IsoShadingAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Technique used for shading (POLYGON_SHADING/ CELL_SHADING/ MARKER) 
    \param technique Setting contour_shade_technique - default=polygon_shading
*/
	void setTechnique(ShadingTechnique<P> * technique) 
		{ auto_ptr<ShadingTechnique<P> > tmp(technique); technique_ = tmp; } 
	const ShadingTechnique<P> &  getTechnique() const 
		{ return *technique_; }
/*!
    Magics Information:
    \brief  Maximum level for which shading is required 
    \param max Setting contour_shade_max_level - default=1.0e+21
*/
	void setMax(double max) 
		{ max_ =  max; } 
	double getMax() const 
		{ return max_; } 
        
/*!
    Magics Information:
    \brief  Minimum level for which shading is required 
    \param min Setting contour_shade_min_level - default=-1.0e+21
*/
	void setMin(double min) 
		{ min_ =  min; } 
	double getMin() const 
		{ return min_; } 
        
/*!
    Magics Information:
    \brief  Method of generating the colours of the bands in contour shading (LIST/CALCULATE) 
    \param colourmethod Setting contour_shade_colour_method - default=calculate
*/
	void setColourMethod(ColourTechnique* colourmethod) 
		{ auto_ptr<ColourTechnique> tmp(colourmethod); colourMethod_ = tmp; } 
	const ColourTechnique&  getColourMethod() const 
		{ return *colourMethod_; }
/*!
    Magics Information:
    \brief  Blank around labels, highs and lows (ON/OFF) 
    \param labelblanking Setting contour_shade_label_blanking - default=on
*/
	void setLabelBlanking(bool labelblanking) 
		{ labelBlanking_ =  labelblanking; } 
	bool getLabelBlanking() const 
		{ return labelBlanking_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	auto_ptr<ShadingTechnique<P> > technique_;
	double max_;
	double min_;
	auto_ptr<ColourTechnique> colourMethod_;
	bool labelBlanking_;

private:
  
	friend ostream& operator<<(ostream& s,const IsoShadingAttributes<P>& p)
	{ p.print(s); return s; }
};

} // namespace magics
#include "IsoShadingAttributes.cc" 

#endif
