/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file ImportPlotAttributes.h
    \brief Definition of ImportPlot Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:39 2011
*/
   

#ifndef ImportPlotAttributes_H
#define ImportPlotAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class ImportPlotAttributes 
{
public:
//  --  constructor
    ImportPlotAttributes();
    
//  --  destructor
    virtual ~ImportPlotAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const ImportPlotAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief Specify the format of the imported file 
    \param format Setting import_format - default=PNG
*/
	void setFormat(const string& format) 
		{ format_ =  format; } 
	const string& getFormat() const 
		{ return format_; } 
        
/*!
    Magics Information:
    \brief Specify the format of the imported file 
    \param system Setting import_system_coordinates - default=user
*/
	void setSystem(const string& system) 
		{ system_ =  system; } 
	const string& getSystem() const 
		{ return system_; } 
        
/*!
    Magics Information:
    \brief X position of the imported image 
    \param x Setting import_x_position - default=0
*/
	void setX(double x) 
		{ x_ =  x; } 
	double getX() const 
		{ return x_; } 
        
/*!
    Magics Information:
    \brief Y position of the imported image 
    \param y Setting import_y_position - default=0
*/
	void setY(double y) 
		{ y_ =  y; } 
	double getY() const 
		{ return y_; } 
        
/*!
    Magics Information:
    \brief Width of the imported image (-1 means use the dimension of the image)
    \param width Setting import_width - default=-1
*/
	void setWidth(double width) 
		{ width_ =  width; } 
	double getWidth() const 
		{ return width_; } 
        
/*!
    Magics Information:
    \brief Metview info :Crs used for the import
    \param crs Setting crs - default=
*/
	void setCrs(const string& crs) 
		{ crs_ =  crs; } 
	const string& getCrs() const 
		{ return crs_; } 
        
/*!
    Magics Information:
    \brief Metview info :Crs used for the import
    \param crs_minx Setting crs_minx - default=-180.
*/
	void setCrs_minx(double crs_minx) 
		{ crs_minx_ =  crs_minx; } 
	double getCrs_minx() const 
		{ return crs_minx_; } 
        
/*!
    Magics Information:
    \brief Metview info :Crs used for the import
    \param crs_maxx Setting crs_maxx - default=180.
*/
	void setCrs_maxx(double crs_maxx) 
		{ crs_maxx_ =  crs_maxx; } 
	double getCrs_maxx() const 
		{ return crs_maxx_; } 
        
/*!
    Magics Information:
    \brief Metview info :Crs used for the import
    \param crs_miny Setting crs_miny - default=-90.
*/
	void setCrs_miny(double crs_miny) 
		{ crs_miny_ =  crs_miny; } 
	double getCrs_miny() const 
		{ return crs_miny_; } 
        
/*!
    Magics Information:
    \brief Metview info :Crs used for the import
    \param crs_maxy Setting crs_maxy - default=-90.
*/
	void setCrs_maxy(double crs_maxy) 
		{ crs_maxy_ =  crs_maxy; } 
	double getCrs_maxy() const 
		{ return crs_maxy_; } 
        
/*!
    Magics Information:
    \brief Height of the imported image (-1 means use the dimension of the image)
    \param height Setting import_height - default=-1
*/
	void setHeight(double height) 
		{ height_ =  height; } 
	double getHeight() const 
		{ return height_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string format_;
	string system_;
	double x_;
	double y_;
	double width_;
	string crs_;
	double crs_minx_;
	double crs_maxx_;
	double crs_miny_;
	double crs_maxy_;
	double height_;

private:
  
	friend ostream& operator<<(ostream& s,const ImportPlotAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
