/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file HistogramLegendMethodAttributes.h
    \brief Definition of HistogramLegendMethod Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:40 2011
*/
   

#ifndef HistogramLegendMethodAttributes_H
#define HistogramLegendMethodAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class HistogramLegendMethodAttributes 
{
public:
//  --  constructor
    HistogramLegendMethodAttributes();
    
//  --  destructor
    virtual ~HistogramLegendMethodAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const HistogramLegendMethodAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Frequency of the labels. 
    \param label_frequency Setting legend_label_frequency - default=1
*/
	void setLabel_frequency(int label_frequency) 
		{ label_frequency_ =  label_frequency; } 
	int getLabel_frequency() const 
		{ return label_frequency_; } 
        
/*!
    Magics Information:
    \brief  add a border to the the bars 
    \param histo_border Setting legend_histogram_border - default=on
*/
	void setHisto_border(bool histo_border) 
		{ histo_border_ =  histo_border; } 
	bool getHisto_border() const 
		{ return histo_border_; } 
        
/*!
    Magics Information:
    \brief  border colour of the bars
    \param histo_border_colour Setting legend_histogram_border_colour - default=black
*/
	void setHisto_border_colour(Colour* histo_border_colour) 
		{ auto_ptr<Colour> tmp(histo_border_colour); histo_border_colour_ = tmp; } 
	const Colour&  getHisto_border_colour() const 
		{ return *histo_border_colour_; }
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	int label_frequency_;
	bool histo_border_;
	auto_ptr<Colour> histo_border_colour_;

private:
  
	friend ostream& operator<<(ostream& s,const HistogramLegendMethodAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
