/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file DateAxisMethodAttributes.cc
    \brief Implemtation of DateAxisMethod Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Tue Nov 22 10:53:40 2011
*/    

#include "DateAxisMethodAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


DateAxisMethodAttributes::DateAxisMethodAttributes():
	interval_(ParameterManager::getDouble("axis_tick_interval"))
{
} 



DateAxisMethodAttributes::~DateAxisMethodAttributes()
{
}

    
void DateAxisMethodAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "axis";

	setAttribute(prefix, "axis_tick_interval", interval_, params);
}

void DateAxisMethodAttributes::copy(const DateAxisMethodAttributes& other)
{
	interval_ = other.interval_;
} 


bool DateAxisMethodAttributes::accept(const string& node)
{	
	if ( magCompare(node, "date")  )
		return true;
	return false;
}

void DateAxisMethodAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "date") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void DateAxisMethodAttributes::print(ostream& out)  const
{
	out << "DateAxisMethodAttributes[";
	out << "interval = " << interval_;
	out << "]" << "\n";
}


void DateAxisMethodAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
     out <<  "\"date\"";
	 out << ", \"axis_tick_interval\":";
	 niceprint(out,interval_);
}
static MagicsParameter<double> axis_tick_interval("axis_tick_interval", INT_MAX, "Default changed from '1/7 of axis length' to'INT_MAX' ");
