/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file CountSelectionTypeAttributes.h
    \brief Definition of CountSelectionType Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:38 2011
*/
   

#ifndef CountSelectionTypeAttributes_H
#define CountSelectionTypeAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class CountSelectionTypeAttributes 
{
public:
//  --  constructor
    CountSelectionTypeAttributes();
    
//  --  destructor
    virtual ~CountSelectionTypeAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const CountSelectionTypeAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Count or number of levels to be plotted. Magics will try to find "nice levels", 
         this means that the number of levels could be slightly different from the asked number of levels
    \param levelcount Setting contour_level_count - default=10
*/
	void setLevelCount(int levelcount) 
		{ levelCount_ =  levelcount; } 
	int getLevelCount() const 
		{ return levelCount_; } 
        
/*!
    Magics Information:
    \brief  Tolerance: Do not use nice levels if the number of levels is really to different [count +/- tolerance] 
    \param tolerance Setting contour_level_tolerance - default=2
*/
	void setTolerance(int tolerance) 
		{ tolerance_ =  tolerance; } 
	int getTolerance() const 
		{ return tolerance_; } 
        
/*!
    Magics Information:
    \brief  Contour level from which contour interval is calculated 
    \param reference Setting contour_reference_level - default=0.0
*/
	void setReference(double reference) 
		{ reference_ =  reference; } 
	double getReference() const 
		{ return reference_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	int levelCount_;
	int tolerance_;
	double reference_;

private:
  
	friend ostream& operator<<(ostream& s,const CountSelectionTypeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
