/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file WrepRootNodeAttributes.h
    \brief Definition of WrepRootNode Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:40 2011
*/
   

#ifndef WrepRootNodeAttributes_H
#define WrepRootNodeAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class WrepRootNodeAttributes 
{
public:
//  --  constructor
    WrepRootNodeAttributes();
    
//  --  destructor
    virtual ~WrepRootNodeAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const WrepRootNodeAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  dimension in pixel of the output width 
    \param pixel_width Setting wrep_node_width - default=800
*/
	void setPixel_width(double pixel_width) 
		{ pixel_width_ =  pixel_width; } 
	double getPixel_width() const 
		{ return pixel_width_; } 
        
/*!
    Magics Information:
    \brief  dimension in pixel of the output height
    \param pixel_height Setting wrep_node_height - default=400
*/
	void setPixel_height(double pixel_height) 
		{ pixel_height_ =  pixel_height; } 
	double getPixel_height() const 
		{ return pixel_height_; } 
        
/*!
    Magics Information:
    \brief  method name used for the extension 
    \param anchor Setting wrep_node_mapping_anchor - default=centre
*/
	void setAnchor(const string& anchor) 
		{ anchor_ =  anchor; } 
	const string& getAnchor() const 
		{ return anchor_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	double pixel_width_;
	double pixel_height_;
	string anchor_;

private:
  
	friend ostream& operator<<(ostream& s,const WrepRootNodeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
