/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file HourDateAxisAttributes.cc
    \brief Implemtation of HourDateAxis Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Thu Jun 16 12:02:58 2011
*/    

#include "HourDateAxisAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


HourDateAxisAttributes::HourDateAxisAttributes():
	colour_(Translator<string, Colour>().magics("axis_hours_label_colour")),
	quality_(ParameterManager::getString("axis_hours_label_quality")),
	height_(ParameterManager::getDouble("axis_hours_label_height"))
{
} 



HourDateAxisAttributes::~HourDateAxisAttributes()
{
}

    
void HourDateAxisAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "axis_hours";
	prefix[1] = "axis";

	setAttribute(prefix, "axis_hours_label_colour", colour_, params);
	setAttribute(prefix, "axis_hours_label_quality", quality_, params);
	setAttribute(prefix, "axis_hours_label_height", height_, params);
}

void HourDateAxisAttributes::copy(const HourDateAxisAttributes& other)
{
	setColour(other.colour_->clone());
	quality_ = other.quality_;
	height_ = other.height_;
} 


bool HourDateAxisAttributes::accept(const string& node)
{	
	if ( magCompare(node, "hours")  )
		return true;
	return false;
}

void HourDateAxisAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "hours") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void HourDateAxisAttributes::print(ostream& out)  const
{
	out << "HourDateAxisAttributes[";
	out << "colour = " << *colour_;
	out << ", quality = " << quality_;
	out << ", height = " << height_;
	out << "]" << "\n";
}


void HourDateAxisAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\taxis_hours_label_colour = \'" << *colour_ << "\'\n";
	out << tab << "\taxis_hours_label_quality = \'" << quality_ << "\'\n";
	out << tab << "\taxis_hours_label_height = \'" << height_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> axis_hours_label_colour("axis_hours_label_colour", "automatic", " New Magics: Parameter axis_hours_label_ colour sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_hours_label_quality("axis_hours_label_quality", "low", " New Magics: Parameter axis_hours_label_quality  sent to new Magics[XYSystem].  ");
static MagicsParameter<double> axis_hours_label_height("axis_hours_label_height", 0.2, " New Magics: Parameter axis_hours_label_ height sent to new Magics[XYSystem].  ");
