/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file DateAxisMethod.h
    \brief Definition of the Template class DateAxisMethod.
    
    Magics Team - ECMWF 2005
    
    Started: Mon 10-Oct-2005
    
    Changes:
    
*/

#ifndef DateAxisMethod_H
#define DateAxisMethod_H

#include "magics.h"
#include "Translator.h"
#include "Factory.h"
#include "AxisItem.h"
#include "DateTime.h"
#include "DateAxisMethodAttributes.h"


namespace magics {

class Box;
class DateAxis;

class DateAxisMethod : public DateAxisMethodAttributes{

public:
	DateAxisMethod();
	virtual ~DateAxisMethod();
    
    virtual void set(const XmlNode& node) {
    	DateAxisMethodAttributes::set(node);
    }
    virtual void set(const map<string, string>& map) {
      	DateAxisMethodAttributes::set(map);
    }
    virtual DateAxisMethod* clone() const {
        Log::dev() << "(const map<string, string&)---> to be checked!...\n";
        return new DateAxisMethod();
    }
     virtual void toxml(ostream&, int)  const {}
    
  virtual void prepare(DateAxis&, const DateTime&, const DateTime&, const DateTime&, AxisItems&) {}
    

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 

private:
    //! Copy constructor - No copy allowed
	DateAxisMethod(const DateAxisMethod&);
    //! Overloaded << operator to copy - No copy allowed
	DateAxisMethod& operator=(const DateAxisMethod&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const DateAxisMethod& p)
		{ p.print(s); return s; }

};




class DateHourAxisMethod : public DateAxisMethod
{
public:
	 virtual DateAxisMethod* clone() const {
        return new DateHourAxisMethod();
    }
    
    virtual void prepare(DateAxis&, const DateTime& ref, const DateTime& min, const DateTime& max, AxisItems&);
	
};

class DateDayAxisMethod : public DateAxisMethod
{
public:
	 virtual DateAxisMethod* clone() const {
        return new DateDayAxisMethod();
    }
    
    virtual void prepare(DateAxis&, const DateTime& ref, const DateTime& min, const DateTime& max, AxisItems&);
	
};

class DateMonthAxisMethod : public DateAxisMethod
{
public:
	 virtual DateAxisMethod* clone() const {
        return new DateMonthAxisMethod();
    }
    
    virtual void prepare(DateAxis&, const DateTime& ref, const DateTime& min, const DateTime& max, AxisItems&);
	
};

class DateYearAxisMethod : public DateAxisMethod
{
public:
	 virtual DateAxisMethod* clone() const {
        return new DateYearAxisMethod();
    }
    
    virtual void prepare(DateAxis&, const DateTime& ref, const DateTime& min, const DateTime& max, AxisItems&);
	
};

template <>
class Translator<string, DateAxisMethod> { 
public:
	DateAxisMethod* operator()(const string& val )
	{
		return SimpleObjectMaker<DateAxisMethod>::create(val);
	}     

	DateAxisMethod* magics(const string& param)
	{
		DateAxisMethod* object;
		ParameterManager::update(param, object);
		return object;
	}
};

} // namespace magics
#endif
