/*! \file ContourLibrary.cc
    \brief Implementation of the Template class ContourLibrary.
    
    Magics Team - ECMWF 2010
    
    Started: Fri 16-Jul-2010
    
    Changes:
    
*/



#include "ContourLibrary.h"
#include "Layer.h"
#include "VisDefInfo.h"

using namespace magics;

VisDefInfoBase* ContourLibrary::info_=0;

ContourLibrary::ContourLibrary() 
{	
}


ContourLibrary::~ContourLibrary() 
{	
}

/*!
 Class information are given to the output-stream.
*/		
void ContourLibrary::print(ostream& out)  const
{
	out << "ContourLibrary[";
	out << "]";
}

// sete meta["shortName"] =the meta dat to be collected 
void ContourLibrary::askId(MetaDataCollector& meta)
{
	meta["observationDiagnostic"]="";

	/*if(!obstat_)
		obstat_ = new ObstatVisdefManager;

	for(int i=0; i < obstat_->keys().size(); i++)
	{
		meta[obstat_->keys().at(i)]="";
	}*/

	//meta["shortName"] = "";
	//meta["lev"] = "";
}


bool ContourLibrary::checkId(MetaDataCollector& metaId,MetaDataCollector& metaKey)
{
	//Obstat
	if(metaId["observationDiagnostic"] !="")
	{		
		if(!setInfoObject("ObstatGrib"))
		{
			return false;
		}
	}
	else
	{
		return false;
	}

	for(unsigned int i=0; i < info_->keys().size(); i++)
	{
		metaKey[info_->keys().at(i)]="";
		if(metaId["observationDiagnostic"] !="")
		{
			metaKey.setIntegerItem(info_->keys().at(i));
		}
	}

	return true;

	//meta["shortName"] = "";
	//meta["lev"] = "";
}


	
// se the map to set the contour!
void ContourLibrary::getAttributes(MetaDataCollector& meta, map<string, string>& attributes)
{
	Log::dev() << "ContourLibrary::set-->" << endl;

	//Obstat
	if(info_)
	{
		for(map<string,string>::iterator it=meta.begin(); it != meta.end(); it++)
		{
			Log::dev() << it->first << "--> " << it->second << endl; 
		}

		info_->getAttributes(meta,attributes);
	}

	/*if(!obstat_)
		obstat_ = new ObstatVisdefManager;

	Log::dev() << "ContourLibrary::set-->" << endl;

	for(map<string,string>::iterator it=meta.begin(); it != meta.end(); it++)
	{
		Log::dev() << it.first << "--> " << it.second << endl; 
	}
	//Log::dev() << "shortName-->" << meta["shortName"] << endl;
	//Log::dev() << "level-->" << meta["lev"] << endl;
	
	//attributes["contour_line_colour"] = "red";

	obstat_->setVisDefAttributes(meta,attributes);*/
	
}	

bool ContourLibrary::setInfoObject(string type)
{
	if(info_ && info_->type() != type)
	{
		delete info_;
		info_=0;
	}
	if(!info_)
	{
		info_=VisDefInfoFactory::makeItem(type);
	}

	if(!info_)
		return false;
	else if(info_->isLoaded())
		return true;
	else 
		return false;
}
