/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file Contour.cc
    \brief Implementation of the Template class Contour.
    
    Magics Team - ECMWF 2004
    
    Started: Wed 3-Mar-2004
    
    Changes:
    
*/

#include "Contour.h"
#include "Layout.h"
#include "Layer.h"
#include "Text.h"
#include "ContourLibrary.h"

using namespace magics;

template <class P>
Contour<P>::Contour() 
{

}

template <class P>
Contour<P>::~Contour() 
{
}

/*!
 Class information are given to the output-stream.
*/	
template <class P>	
void Contour<P>::print(ostream& out)  const
{
	out << "Contour<P>[";
	ContourAttributes<P>::print(out);
	out << "]";
}

template <class P> 
class MatrixTreshold : public MatrixHandler<P>
{
public :
	MatrixTreshold(const AbstractMatrix& matrix, double min, double max) : 
		MatrixHandler<P>(matrix), min_(min), max_(max)
	{
	}
	double operator()(int row, int column) const { 
		double val = this->matrix_(row, column); 
		if ( same(val, this->matrix_.missing()) ) 
				return val;
		if ( val  < min_ ) return min_;
		if ( val  > max_ ) return max_;
		return val; 
	}
	
	double min_;
	double max_;


};

template <class P>	
void Contour<P>::operator()(Data<P>& data, BasicGraphicsObjectContainer& parent)
{
    try {
    	if (this->setting_ )
	{
    		// Here we try call the Contour libry to set up visual properties...
    		MetaDataCollector needId,needAttributes;
    		map<string, string> attributes;
    		
    		ContourLibrary library;
		library.askId(needId);
		data.visit(needId);
		if(library.checkId(needId,needAttributes))
		{			
    			data.visit(needAttributes);
    			library.getAttributes(needAttributes,attributes);
    			this->set(attributes);
    		}	    		
    	}
    	{
    	
    	MatrixHandler<P> m = data.matrix();
    	
		BoxMatrixHandler<P> box(m, parent.transformation());
		if ( !box.rows() || ! box.columns() ) 
			return;
		MatrixHandler<P>* handler((*this->method_).handler(box, parent));     
    	
    	
		
		MatrixTreshold<P> threshold(*handler, this->floor_, this->ceiling_);
    	
		MatrixHandler<P>* matrix = 0;
		if (this->floor_ != int_MAX || this->ceiling_ != -int_MAX) 
			matrix = &threshold ;
		else 
			matrix =  handler;
		
		
		
		(*this->contour_).adjust(matrix->min(), matrix->max());
		(*this->contour_)(*matrix, parent);
		
		(*this->contour_)(data, parent);
		if ( magCompare( this->grid_->getType(), "akima" ) ) 
			(*this->grid_)(*matrix, parent);
		else 
			(*this->grid_)(box, parent);
		(*this->hilo_)(*matrix, parent);
    	}
    }
    catch (MagicsException& e) 
    {
    	// Do nothing! 
    }
}

template <class P>	
void Contour<P>::visit(LegendVisitor& legend)
{

	if ( !this->legend_ ) return;
	this->contour_->visit(legend);
	//this->grid_->visit(legend);
	//this->hilo_->visit(legend);

}

