#include "MagPlus.h"
#include <iostream>

#include <MvRootSceneNodeWrapper.h>
#include <FortranSceneNodeWrapper.h>
#include <FortranViewNodeWrapper.h>
#include <CoastlinesWrapper.h>
#include <AxisWrapper.h>
#include <VisualAction.h>

#include <GribDecoderWrapper.h>
#include <GribLoopWrapper.h>
#include <GeoPointsDecoderWrapper.h>
#include <NetcdfDecoderWrapper.h>

#if MAGICS_ODB	
#include <OdaGeoDecoderWrapper.h>
#include <OdaXYDecoderWrapper.h>
#endif

#if MAGICS_BUFR	
#include <ObsDecoderWrapper.h>
#include <ObsPlottingWrapper.h>
#endif

#include <ImportPlotWrapper.h>
#include <ImportActionWrapper.h>

#include <ContourWrapper.h>

#include <TextVisitor.h>
#include <TextVisitorWrapper.h>
#include <LegendVisitorWrapper.h>


#include <SymbolPlottingWrapper.h>
#include <WindWrapper.h>

#include <GeoPoint.h>
#include "MagicsEvent.h"


#include <PostScriptDriverWrapper.h>

#ifdef MAGICS_CAIRO
#include <CairoDriverWrapper.h>
#endif

#include <SVGDriverWrapper.h>
#include <KMLDriverWrapper.h>

#if MAGICS_QT
#include <QtDriver.h>
#endif


template <class T>
void replace(magics::MagRequest& request, const string& name, T from, T to)
{
	if (request.countValues(name.c_str()) == 0 ) {
		request(name) = to;
		return;
	}
	T val = request(name);
	if (val == from) 
		request(name) = to;
	
}

void replace_string(magics::MagRequest& request, const string& name, const string& from, const string& to)
{
	if (request.countValues(name) == 0 ) {
		request(name) = to;
		return;
	}
	string val =  request(name);
	if (val == from) 
		request(name) = to;
	
}

template <class T>
void replace(magics::MagRequest& request, const string& name, T from, const string& newname, T to)
{
	if (request.countValues(name) == 0 ) {
		request(newname.c_str()) = to;
		return;
	}
	T val = request(name);
	if (val == from) 
		request(newname) = to;
	else 
		request(newname) = val;
}

string get(magics::MagRequest& request, const string& param, const string& val)
{
	
	string v = request(param);
	
	return ( !v.empty() ) ? v : val; 
} 

using namespace std;
using namespace magics;




map<string,  MagPlus::ObjectCreator > MagPlus::sceneCreators_;
map<string,  MagPlus::ObjectCreator > MagPlus::driverCreators_;





MagPlus::MagPlus() : root_(0), superpage_(-1), geographical_(true), mode_(interactif)
{
#if MAGICS_QT
	qtDriver_ = 0;
#endif
 	if ( sceneCreators_.empty()) { 		
 		sceneCreators_["PAGE"] = &MagPlus::page;
 		sceneCreators_["PCOAST"] = &MagPlus::coastlines;
 		sceneCreators_["MCOAST"] = &MagPlus::coastlines;
 		sceneCreators_["PAXIS"] = &MagPlus::axis;
 		sceneCreators_["CARTESIANVIEW"] = &MagPlus::cartesian;
 		sceneCreators_["PGRIB"] = &MagPlus::gribloop;
        sceneCreators_["GRIBLOOP"] = &MagPlus::gribloop;
        sceneCreators_["GEOPOINTS"] = &MagPlus::geopoints;
 		sceneCreators_["NETCDF_GEOPOINTS"] = &MagPlus::geonetcdf;
        sceneCreators_["NETCDF_GEOVECTORS"] = &MagPlus::geonetcdf;
        sceneCreators_["NETCDF_GEOMATRIX"] = &MagPlus::geonetcdf;
        sceneCreators_["NETCDF_POINTS"] = &MagPlus::xynetcdf;
        sceneCreators_["NETCDF_VECTORS"] = &MagPlus::xynetcdf;
        sceneCreators_["NETCDF_MATRIX"] = &MagPlus::xynetcdf;
        sceneCreators_["BUFR"] = &MagPlus::bufr;
#if MAGICS_ODB	
	sceneCreators_["ODB_GEOPOINTS"] = &MagPlus::geoodb;
	sceneCreators_["ODB_GEOVECTORS"] = &MagPlus::geoodb;
	sceneCreators_["ODB_XY_POINTS"] = &MagPlus::xyodb;
	sceneCreators_["ODB_XY_VECTORS"] = &MagPlus::xyodb;
	sceneCreators_["ODB_XY_MATRIX"] = &MagPlus::xyodb;
#endif
	    sceneCreators_["VISDEFS"] = &MagPlus::visdef;
 		sceneCreators_["PCONT"] = &MagPlus::contour;
 		sceneCreators_["MCONT"] = &MagPlus::contour;
 		sceneCreators_["POBS"] = &MagPlus::obs;
 		sceneCreators_["PSYMB"] = &MagPlus::symbol;
 		sceneCreators_["MSYMB"] = &MagPlus::symbol;
        sceneCreators_["PSYMBPLUS"] = &MagPlus::symbol;
        sceneCreators_["PWIND"] = &MagPlus::wind;
        sceneCreators_["MWIND"] = &MagPlus::wind;
 		sceneCreators_["SUPERPAGE"] = &MagPlus::superpage;
        sceneCreators_["PTEXT"] = &MagPlus::ptext;
        sceneCreators_["MTEXT"] = &MagPlus::text;
        sceneCreators_["MLEGEND"] = &MagPlus::legend;
        sceneCreators_["DEVICE"] = &MagPlus::device;
        sceneCreators_["PIMPORT"] = &MagPlus::import; 
        sceneCreators_["PRASTER"] = &MagPlus::raster;
        sceneCreators_["PRASTERLOOP"] = &MagPlus::rasterloop;
 	}
    
    if ( driverCreators_.empty())
    {
#if MAGICS_QT
	driverCreators_["QTOUTPUT"] = &MagPlus::qtdriver;
#endif
 	driverCreators_["PSOUTPUT"] = &MagPlus::psdriver;
        driverCreators_["PNGOUTPUT"] = &MagPlus::pngdriver;
        driverCreators_["KMLOUTPUT"] = &MagPlus::kmldriver;
        driverCreators_["PDFOUTPUT"] = &MagPlus::pdfdriver;
        driverCreators_["SVGOUTPUT"] = &MagPlus::svgdriver;
        driverCreators_["EPSOUTPUT"] = &MagPlus::epsdriver;
    }
}

bool MagPlus::superpage(magics::MagRequest& in)
{
	Log::dev()<< "superpage--->" << endl;

	int superpage = in("SUPERPAGE_INDEX");

	if ( superpage == superpage_) return false;
	superpage_ = superpage;
	in("LAYOUT") = "positional";
    
    replace_string(in, "SUPER_PAGE_FRAME_COLOUR", "BLUE", "grey");
  
    in.print();
    MvRootSceneNodeWrapper helper;
	helper.set(in);
		
	root_ = helper.object();
    
	Log::dev()<< "<----superpage" << endl;
	return false;
}



bool MagPlus::psdriver(magics::MagRequest& in)
{
	PostScriptDriverWrapper helper;
	helper.set(in); 
	  
	drivers_.push_back(helper.object());  
	mode_ = paper;
	return false;
}

bool MagPlus::epsdriver(magics::MagRequest& in)
{
	PostScriptDriverWrapper helper;
	helper.set(in); 
	helper.me()->setEPS(true);
	drivers_.push_back(helper.object());  
	mode_ = paper;
	return false;
}

bool MagPlus::pngdriver(magics::MagRequest&  in)
{
#ifdef MAGICS_CAIRO
	CairoDriverWrapper helper;
	helper.set(in); 
	helper.me()->setPNG();
	drivers_.push_back(helper.object());   
	mode_ = paper;
#endif
	return false;
}

bool MagPlus::pdfdriver(magics::MagRequest& in)
{
#ifdef MAGICS_CAIRO
	   CairoDriverWrapper helper;
	   helper.set(in); 
	   helper.me()->setPDF();
       drivers_.push_back(helper.object());  
       mode_ = paper;
       
#endif
       return false;
}

#if MAGICS_QT
void MagPlus::setQtScene(QGraphicsScene *scene)
{
	ParameterManager::set("output_qt_scene", scene);;
}

bool MagPlus::qtdriver(magics::MagRequest& /*in*/)
{
	if ( !qtDriver_)
	{
		//ParameterManager::set("ouptup_qt_scene", widget);
		qtDriver_ = new magics::QtDriver();
	}
	drivers_.push_back(qtDriver_);   
	if (root_)
	{
		delete root_;
		root_ = 0;
		superpage_ = -1;
	}
	return false;
}
#endif

bool MagPlus::svgdriver(magics::MagRequest& in)
{
	SVGDriverWrapper helper;
	helper.set(in); 

	drivers_.push_back(helper.object());   
	mode_ = paper;
	return false;
}

bool MagPlus::kmldriver(magics::MagRequest& in)
{
	KMLDriverWrapper helper;
	helper.set(in); 
	mode_ = paper;
	drivers_.push_back(helper.object());   

	return false;
}


bool MagPlus::page(magics::MagRequest& in)
{
	Log::dev()<< "page and subpage--->" << endl;
	sceneCreators_["MLEGEND"] = &MagPlus::legend;
	//in("LAYOUT") = "positional";

	while ( !empty() ) pop();

	replace_string(in, "PAGE_FRAME_COLOUR", "BLUE", "grey");
	
	in.print();
	FortranSceneNodeWrapper scenehelper;
	scenehelper.set(in);

	root_->insert(scenehelper.object());
	push(scenehelper.object());
	replace(in, "SUBPAGE_Y_LENGTH", 17.85, -1.); // reset to the default!
	in("SUBPAGE_MAP_PREVIEW") = "on";
	
	if ( (string) in("SUBPAGE_MAP_PROJECTION") != "NEXT" ) {
		FortranViewNodeWrapper viewhelper;
		viewhelper.set(in);
		FortranViewNode* view = viewhelper.object();
		string id =  in("METVIEW_ID");
		if ( !id.empty() )
		{
			view->setInteractiveInfo(id.c_str(), 
			in("ZOOM_NUMBER_OF_LEVELS"), in("ZOOM_CURRENT_LEVEL"));
		}
		top()->insert(view);
		push(view);
	}
	
	Log::dev()<< "<----page and subpage" << endl;
	return false; // do not exit
}

bool MagPlus::cartesian(magics::MagRequest& in) {
	in("SUBPAGE_MAP_PROJECTION") = "cartesian";
	FortranViewNodeWrapper viewhelper;
			viewhelper.set(in);
			FortranViewNode* view = viewhelper.object();
			string id =  in("METVIEW_ID");
			if (  !id.empty()  )
			{
				string id =  in("METVIEW_ID");
				view->setInteractiveInfo(id.c_str(), 
				in("ZOOM_NUMBER_OF_LEVELS"), in("ZOOM_CURRENT_LEVEL"));
			}
			top()->insert(view);
			push(view);	
			cout << "cartesian! " << endl;
			in.print();
			magics::MagRequest& raxis = in.getSubRequest("BACKGROUND_HORIZONTAL_AXIS");
			if ( raxis ) {
				// use the user defined one
				    HorizontalAxis*	 axis = new HorizontalAxis();
				    raxis.print();
				    replace_string(raxis, "_NAME", "", "Horizontal Axis");
					replace_string(raxis, "_CLASS", "", "PAXIS");
					setIconInfo(raxis, *axis); 
					AxisWrapper helper(axis);				
					helper.set(raxis);
					top()->push_back(axis);
			}
			else {
				HorizontalAxis* haxis = new HorizontalAxis();
				haxis->icon("Horizontal Axis", "PAXIS");
				top()->push_back(haxis);
				cout << "no HorizontalAxis! " << endl;
			}
			raxis = in.getSubRequest("BACKGROUND_VERTICAL_AXIS");
			if (  raxis ) {
				// use the user defined one
				raxis.print();
				VerticalAxis*	 axis = new VerticalAxis();
				replace_string(raxis, "_NAME", "", "Vertical Axis");
				replace_string(raxis, "_CLASS", "", "PAXIS");
				setIconInfo(raxis, *axis); 
				AxisWrapper helper(axis);				
				helper.set(raxis);
				top()->push_back(axis);
			}
			else {
				VerticalAxis* vaxis = new VerticalAxis();
				vaxis->icon("Vertical Axis", "PAXIS");
				top()->push_back(vaxis);
				cout << "no VerticalAxis! " << endl;
			}
			raxis = in.getSubRequest("FOREGROUND_HORIZONTAL_AXIS");
			if ( raxis )
			{
				// use the user defined one 
				HorizontalAxis*	 axis = new HorizontalAxis();
				setIconInfo(raxis, *axis); 
				AxisWrapper helper(axis);				
				helper.set(raxis);
				foreground_.push_back(axis);
			}
			raxis = in.getSubRequest("FOREGROUND_VERTICAL_AXIS");
			if ( raxis ) {
				// use the user defined one 
				
				VerticalAxis*	 axis = new VerticalAxis();
				setIconInfo(raxis, *axis); 
				AxisWrapper helper(axis);				
				helper.set(raxis);
				foreground_.push_back(axis);
			}
            geographical_ = false;
			return false; // do not exit
}

bool MagPlus::coastlines(magics::MagRequest& in)
{
	Log::dev()<< "add coastlines" << endl;
	
	replace_string(in, "MAP_COASTLINE_RESOLUTION", "MEDIUM", "automatic");
	replace_string(in, "_NAME", "", "Coastlines");
	replace_string(in, "_CLASS", "", "PCOAST");
	CoastlinesWrapper helper;
	
	helper.set(in);
	
	top()->push_back(helper.object());
	setIconInfo(in,*helper.object());
	Log::dev()<< top() << endl;
	Log::dev()<< *helper.object() << endl;
	
	return false; // do not exit
}

bool MagPlus::axis(magics::MagRequest& in)
{
	return false; // do not exit
	Log::dev()<< "add axis" << endl;
	 string orientation =  in("AXIS_ORIENTATION");
	 Axis* axis = 0;
	 if ( magCompare(orientation, "vertical") ) 
		 axis = new VerticalAxis();
	 else 
		 axis = new HorizontalAxis();
	 
	AxisWrapper helper(axis);				
	helper.set(in);
	
	top()->push_back(axis);
	Log::dev() << *axis << "\n";

	return false; // do not exit
}

bool MagPlus::import(magics::MagRequest& /*in*/)
{
	Log::dev()<< "ignore for now!!!" << endl;
	return false; // do not exit
}

bool MagPlus::raster(magics::MagRequest& in)
{
	Log::dev()<< "import a raster object" << endl;
	
	in.print();

	in("IMPORT_FILE_NAME") =  in("IMPORT_FILE_PATH");
	in("IMPORT_FORMAT") =  in("IMPORT_FILE_TYPE");
	
	ImportActionWrapper<GeoPoint> object;
	ImportPlotWrapper<GeoPoint> visdef;
	
	object.set(in);
	visdef.set(in);
	setIconInfo(in, *object.object());
	setIconInfo(in, *visdef.object());
	
	
		VisualAction<GeoPoint>* action = new VisualAction<GeoPoint>();
		top()->push_back(action);
		push(action);		
		top()->data(object.object());
		top()->visdef(visdef.object());
		pop();

	return false; // do not exit
}

bool MagPlus::grib(magics::MagRequest& in)
{
	Log::dev()<< "add grib" << endl;
	in.print();
	
	VisualAction<GeoPoint>* action = new VisualAction<GeoPoint>();
	top()->push_back(action);
	push(action);	
  
	GribDecoderWrapper grib;
	grib.set(in);
	setIconInfo(in, *grib.object());
	top()->data(grib.object());

	return false; // do not exit
}

void MagPlus::setIconInfo(magics::MagRequest& mv, MetviewIcon& object) 
{
	string iconname =  get(mv, "_NAME", "");
	string iconclass =  get(mv, "_CLASS", "");
	object.icon(iconname, iconclass);
}

bool MagPlus::gribloop(magics::MagRequest& in)
{
	Log::dev()<< "add gribloop" << endl;
	in.print();
	string loop("loop");
	string mode =  get(in, "GRIB_VISIT_MODE", loop);
	
	if ( !magCompare(mode, loop) ) 
		// we assume it is not an animation...
		return grib(in);
	
	string file =  get(in, "GRIB_INPUT_FILE_NAME", "");
	

	in("GRIB_LOOP_PATH") = file.c_str();
	VisualAnimation<GeoPoint>* action = new VisualAnimation<GeoPoint>();
	top()->push_back(action);
	push(action);	
  
	GribLoopWrapper grib;
	grib.set(in);
	setIconInfo(in, *grib.object());
	
	action->loop(grib.object());
	
	return false; // do not exit
}

bool MagPlus::rasterloop(magics::MagRequest& in)
{
	Log::dev()<< "add rasterloop" << endl;
	in.print();
	
	VisualAnimation<GeoPoint>* geoloop = new VisualAnimation<GeoPoint>();
	top()->push_back(geoloop);
	push(geoloop);
	
		ImportPlotWrapper<GeoPoint> visdef;

		visdef.set(in);
		
		setIconInfo(in, *visdef.object());

	ImportLoop<GeoPoint>* loop = new ImportLoop<GeoPoint>();
	setIconInfo(in, *loop);
	geoloop->loop(loop);
	geoloop->visdef(visdef.object());
	
	in.countValues("RASTERS");
	
	magics::MagRequest& rasters = in.getSubRequest("RASTERS");
	rasters.print();

	//At this point we do not know the exact type, 
	//later we refine it
	loop->setInfo("_datatype","RASTERLOOP");

	bool first =true;

	while ( rasters ) {
		string name =  rasters("LAYERS");
		string format  =   rasters("IMPORT_FILE_TYPE");
		string path = rasters("IMPORT_FILE_PATH");
		string type =  rasters("IMPORT_FILE_TYPE");
		string time =  rasters("TIME"); //Should not work for WMS

		rasters("IMPORT_FILE_NAME") = path;
		rasters("IMPORT_FORMAT") =  rasters("IMPORT_FILE_TYPE");
		rasters("IMPORT_VALID_TIME") =  rasters("TIME");
		
		ImportActionWrapper<GeoPoint> object;
		object.set(rasters);

		visdef.set(rasters);
		object.object()->icon(name, format);

		//WMS related part

		string service_name =  rasters("SERVICE");
	
		if(service_name == "WMS")
		{
			string service_title =  rasters("SERVICE_TITLE");
			string url =  rasters("URL");
			string title =  rasters("TITLE");
			string description =  rasters("DESCRIPTION");
			string legend =  rasters("LEGEND");
			string logo =  rasters("LOGO");
			string dimName = rasters("DIM_NAME");		
			string dimValue = rasters("DIM_VALUE");
			
			if(first)
			{
				loop->setInfo("_datatype","RASTERLOOP_WMS");
				loop->setInfo("service_name",service_name);
				loop->setInfo("service_title",service_title);
				loop->setInfo("url",url);
				loop->setInfo("name",name);
				loop->setInfo("title",title);
				loop->setInfo("description",description);
				loop->setInfo("legend",legend);
				loop->setInfo("logo",logo);
				loop->setInfo("dimName",dimName);
				loop->setInfo("dimValue",dimValue);
			}

			object.object()->setInfo("_datatype","RASTERLOOP_WMS");
			object.object()->setInfo("service_name",service_name);
			object.object()->setInfo("service_title",service_title);
			object.object()->setInfo("url",url);
			object.object()->setInfo("name",name);
			object.object()->setInfo("title",title);
			object.object()->setInfo("description",description);
			object.object()->setInfo("legend",legend);
			object.object()->setInfo("logo",logo);
			object.object()->setInfo("dimName",dimName);
			object.object()->setInfo("dimValue",dimValue);

			//Temporal dimensions
			vector<string> dimNameLst,dimValueLst;
		
    			std::stringstream ssN(dimName);
   			std::string item;

    			while(std::getline(ssN, item,'/'))
			{
        			dimNameLst.push_back(item);
   			}
    		
			std::stringstream ssV(dimValue);
    			while(std::getline(ssV, item,'/'))
			{
        			dimValueLst.push_back(item);
   			}

			if(dimNameLst.size() == dimValueLst.size())
			{
				for(int i=0; i < dimNameLst.size(); i++)
				{
					object.object()->setInfo(dimNameLst[i],dimValueLst[i]);

					if(dimNameLst[i] == "TIME" && dimValueLst[i].size() >=9)
					{
						string dataDate=dimValueLst[i].substr(0,8);
						string dataTime=dimValueLst[i].substr(8);

						object.object()->setInfo("date",dataDate);
						object.object()->setInfo("dataDate",dataDate);
						object.object()->setInfo("time.dataDate",dataDate);
						object.object()->setInfo("validityDate",dataDate);
						object.object()->setInfo("time.validityDate",dataDate);

						object.object()->setInfo("time",dataTime);
						object.object()->setInfo("dataTime",dataTime);
						object.object()->setInfo("time.dataTime",dataTime);
						object.object()->setInfo("validityTime",dataTime);
						object.object()->setInfo("time.validityTime",dataTime);

					}
					else if(dimNameLst[i] == "DIM_RUN" && dimValueLst[i].size() >=9)
					{
						string dataDate=dimValueLst[i].substr(0,8);
						string dataTime=dimValueLst[i].substr(8);

						object.object()->setInfo("date",dataDate);
						object.object()->setInfo("dataDate",dataDate);
						object.object()->setInfo("time.dataDate",dataDate);

						object.object()->setInfo("time",dataTime);
						object.object()->setInfo("dataTime",dataTime);
						object.object()->setInfo("time.dataTime",dataTime);
												
					}
					else if(dimNameLst[i] == "DIM_FORECAST")
					{
						object.object()->setInfo("step",dimValueLst[i]);
						object.object()->setInfo("stepRange",dimValueLst[i]);
						object.object()->setInfo("time.stepRange",dimValueLst[i]);
					}
					else if(dimNameLst[i] == "ELEVATION")
					{
						object.object()->setInfo("level",dimValueLst[i]);
						object.object()->setInfo("vertical.level",dimValueLst[i]);
					}
		
				}

			}

		}

		/*ImportActionWrapper<GeoPoint> object;
		object.set(rasters);

		visdef.set(rasters);
		object.object()->icon(name, format);*/
		
			//object.object()->setInfo("date",title);

		loop->add(object.object());
		
		rasters.advance();

		first=false;
	}
	pop();
	return false; // do not exit
}

#if MAGICS_ODB	
bool MagPlus::geoodb(magics::MagRequest& in)
{
	Log::dev()<< "add geo odb" << endl;
	in.print();
	string path(in("ODB_FILENAME"));
	if (path == "OFF") {
		magics::MagRequest& odb = in.getSubRequest("ODB_DATA");
		path = string(odb("PATH"));
	}
	in("ODB_FILENAME") = path.c_str();
    static map<string, string> types;
    if ( types.empty() ) {
        types["ODB_GEOPOINTS"] = "geopoint";
        types["ODB_GEOVECTORS"] = "geovector";
    }
        
	in("ODB_TYPE") = types[in.getVerb()].c_str();
	VisualAction<GeoPoint>* action = new VisualAction<GeoPoint>();
	top()->push_back(action);
	push(action);	
  
	OdaGeoDecoderWrapper geoodb;
	geoodb.set(in);
	setIconInfo(in, *geoodb.object());
	top()->data(geoodb.object());

	//Meta data
	geoodb.object()->setInfo("_datatype","ODB");
	geoodb.object()->setInfo("path",geoodb.object()->getPath());
	geoodb.object()->setInfo("lat",geoodb.object()->getLatitude());
	geoodb.object()->setInfo("lon",geoodb.object()->getLongitude());
	geoodb.object()->setInfo("value",geoodb.object()->getValue());
	geoodb.object()->setInfo("x",geoodb.object()->getX());
	geoodb.object()->setInfo("y",geoodb.object()->getY());		

	return false; // do not exit
}

bool MagPlus::xyodb(magics::MagRequest& in)
{
	Log::dev()<< "add xy odb" << endl;
	in.print();
	string path(in("ODB_FILENAME"));
	if (path == "OFF") {
		magics::MagRequest& odb = in.getSubRequest("ODB_DATA");
		path = string(odb("PATH"));
	}
	in("ODB_FILENAME") = path.c_str();
    static map<string, string> types;
    if ( types.empty() ) {
        types["ODB_GEOPOINTS"] = "geopoint";
        types["ODB_GEOVECTORS"] = "geovector";
    }
        
	in("ODB_TYPE") = types[in.getVerb()].c_str();
	VisualAction<UserPoint>* action = new VisualAction<UserPoint>();
	top()->push_back(action);
	push(action);	
  
	OdaXYDecoderWrapper xyodb;
	xyodb.set(in);
	setIconInfo(in, *xyodb.object());
	top()->data(xyodb.object());
	geographical_ = false;
	return false; // do not exit
}
#endif

bool MagPlus::geonetcdf(magics::MagRequest& in)
{
	Log::dev()<< "add geo netcdf" << endl;
	in.print();
	string path = get(in, "NETCDF_FILENAME", "OFF");
	if (path == "OFF") {
		magics::MagRequest& netcdf = in.getSubRequest("NETCDF_DATA");
		path = string(netcdf("PATH"));
	}
	in("NETCDF_FILENAME") = path.c_str();
    static map<string, string> types;
    if ( types.empty() ) {
        types["NETCDF_GEOPOINTS"] = "geopoint";
        types["NETCDF_GEOVECTORS"] = "geovector";
        types["NETCDF_GEOMATRIX"] = "geomatrix";
    }
        
	in("NETCDF_TYPE") = types[in.getVerb()].c_str();
	VisualAnimation<GeoPoint>* action = new VisualAnimation<GeoPoint>();
	top()->push_back(action);
	push(action);	
  
	NetcdfDecoderWrapper<GeoPoint> geonet;
	geonet.set(in);
	
	NetcdfLoop<GeoPoint>* loop = new NetcdfLoop<GeoPoint>(geonet.object());
	setIconInfo(in, *geonet.object());
	setIconInfo(in, *loop);
	action->loop(loop);
	
	return false; // do not exit
}


bool MagPlus::xynetcdf(magics::MagRequest& in)
{
	Log::dev()<< "add xy netcdf" << endl;
	in.print();
	string path = get(in, "NETCDF_FILENAME", "OFF");
	if (path == "OFF") {
		magics::MagRequest& netcdf = in.getSubRequest("NETCDF_DATA");
		path = string(netcdf("PATH"));
	}
	in("NETCDF_FILENAME") = path.c_str();
    static map<string, string> types;
    if ( types.empty() ) {
        types["NETCDF_POINTS"] = "xypoint";
        types["NETCDF_VECTORS"] = "vector";
        types["NETCDF_MATRIX"] = "matrix";
    }
        
	in("NETCDF_TYPE") = types[in.getVerb()].c_str();
	VisualAnimation<UserPoint>* action = new VisualAnimation<UserPoint>();
	top()->push_back(action);
	push(action);	
  
	NetcdfDecoderWrapper<UserPoint> xynet;
	xynet.set(in);
	
	NetcdfLoop<UserPoint>* loop = new NetcdfLoop<UserPoint>(xynet.object());
	setIconInfo(in, *xynet.object());
	geographical_ = false;
	setIconInfo(in, *loop);
	action->loop(loop);
	
	return false; // do not exit
}


bool MagPlus::geopoints(magics::MagRequest& in)
{
	// Extract the path ..
	magics::MagRequest& record = in.getSubRequest("RECORD");
	
	string path =  record("PATH");
	in("GEO_INPUT_FILE_NAME") = path;
	in.print();
	VisualAction<GeoPoint>* action = new VisualAction<GeoPoint>();
	top()->push_back(action);
	push(action);	
  
	GeoPointsDecoderWrapper geopoints;
	geopoints.set(in);
	setIconInfo(in, *geopoints.object());
	top()->data(geopoints.object());

	return false; // do not exit
}
bool MagPlus::bufr(magics::MagRequest& in)
{
#ifdef MAGICS_BUFR
	/*
	// Extract the path ..
	magics::MagRequest record = in("RECORD");
	
	in("GEO_INPUT_FILE_NAME") = record("PATH");
	*/
	in.print();
	VisualAction<GeoPoint>* action = new VisualAction<GeoPoint>();
	top()->push_back(action);
	push(action);	
  
	ObsDecoderWrapper obs;
	obs.set(in);
	top()->data(obs.object());
	setIconInfo(in, *obs.object());
#endif
	return false; // do not exit
}
bool MagPlus::symbol(magics::MagRequest& in)
{
	if ( in.countValues("SYMBOL_INPUT_MARKER_LIST") ) {
		in("SYMBOL_MARKER") = in("SYMBOL_INPUT_MARKER_LIST");
	}
    string verb = in.getVerb();
    if ( verb == "PSYMBPLUS" ) {
        in("SYMBOL_TABLE_MODE") = "advanced"; 
        in("SYMBOL_TYPE") = "marker"; 
    } 
    
    FortranAutomaticLegendVisitor* node = new FortranAutomaticLegendVisitor();	
    		LegendMethod* method = new ContinuousLegendMethod();
    		node->setMethod(method);
    		node->getReady();
    		//top()->legend(node);
	if ( geographical_ ) {		
		SymbolPlottingWrapper<GeoPoint> symbol;
		symbol.set(in);
		Log::dev()<< "add symbol" << *symbol.object() << endl;
		top()->visdef(symbol.object());
		pop();
	}
	else {
		   SymbolPlottingWrapper<UserPoint> symbol;
		           symbol.set(in);
				           Log::dev()<< "add symbol" << *symbol.object() << endl;
						           top()->visdef(symbol.object());
								           pop();

	}

	return false; // do not exit
}
bool MagPlus::obs(magics::MagRequest& in)
{
#ifdef MAGICS_BUFR
	ObsPlottingWrapper visdef;
	// here we have to set up manullay the parameters because the obs object is more complex!
	// This is not the right solution just a workaround before we find a clean solution...
	
	for (int i = 0; i <    in.countParameters(); i++) {
		string param = in.getParameter(i);
	    string val =  in(param.c_str());
	
	   ParameterManager::set(param, val);
}


	visdef.set(in);
	Log::dev()<< "add obs" << *visdef.object() << endl;
	top()->visdef(visdef.object());
	pop();	
	
	
#endif
	return false; // do not exit
}

bool MagPlus::wind(magics::MagRequest& in)
{
	
	WindWrapper<GeoPoint> wind;
	wind.set(in);
	Log::dev()<< "add wind" << *wind.object() << endl;
	top()->visdef(wind.object());
	pop();

	return false; // do not exit
}

bool MagPlus::visdef(magics::MagRequest& in)
{
	Log::dev()<< "found visdef" << endl;
	
	MagRequest& visdefs = in.getSubRequest("ACTIONS");
	
	visdefs.print();
	bool dopop = false;
	while (visdefs) {
		
		string verb = visdefs.getVerb();
		{
	   	    map<string,  ObjectCreator >::iterator creator = sceneCreators_.find(verb);
	   	    if ( creator != sceneCreators_.end() ) {
	   	    	  magics::MagRequest& visdef = visdefs.justOneRequest();
	   	    	 // we keep the action
	   	    	  BasicSceneObject* action = top();
	   	    	  (this->*creator->second)(visdef);
	   	    	  // we pout it back!
	   	    	  push(action);
	   	    	  dopop = true;
	   	    }
		}
		visdefs.advance();
	}
	if ( dopop ) pop();
	Log::dev()<< "<---end visdef" << endl;
	return false;
}

bool MagPlus::contour(magics::MagRequest& in)
{
	Log::dev()<< "add contour" << endl;
	
	replace(in, "CONTOUR_LABEL_HEIGHT", 0.3, 0.2);
	string legend  = get(in, "CONTOUR_LEGEND", "ON");
	
	if ( geographical_) {
		ContourWrapper<GeoPoint> contour;
		contour.set(in);
		setIconInfo(in, *contour.object());
		top()->visdef(contour.object());
		
		pop();
	}
	else {
		ContourWrapper<UserPoint> contour;
		contour.set(in);
		setIconInfo(in, *contour.object());
		top()->visdef(contour.object());
		pop();
	}

	return false; // do not exit
}

bool MagPlus::ptext(magics::MagRequest& in)   
{
	Log::dev()<< "add Text" << endl;
	in.print();
	sceneCreators_["MLEGEND"] = &MagPlus::ignore;

	replace(in, "TEXT_REFERENCE_CHARACTER_HEIGHT", 2.0 , "TEXT_FONT_SIZE", 0.3);
	replace_string(in, "TEXT_COLOUR", "BLUE", "navy"); 
	in("TEXT_HTML") = "on";
	text(in);
	legend(in);

	return false; // do not exit
}

bool MagPlus::text(magics::MagRequest& in)   
{
	
	Log::dev()<< "add Text-->" << endl;
	in.print();
	Log::dev()<< "<--add Text" << endl;
	string mode = get(in, "TEXT_MODE", "automatic");
	
	
	in("TEXT_HTML") = "on";

	TextVisitor* node;
	if (magCompare(mode, "positional") )
		node = new FortranPositionalTextVisitor();
	else 
		node = new FortranAutomaticTextVisitor();	
	
	TextVisitorWrapper helper(node);
	helper.set(in);	
	top()->text(node);


	return false; // do not exit
}


bool MagPlus::legend(magics::MagRequest& in)
{
	
	Log::dev()<< "add legend-->" << endl;
	in.print();
	Log::dev()<< "<--add legend" << endl;
	string mode = get(in, "LEGEND_BOX_MODE", "automatic");

	LegendVisitor* legend;
	if ( magCompare(mode, "positional") ) {
		legend = new FortranPositionalLegendVisitor();
	
	}
	else 
		legend = new FortranAutomaticLegendVisitor();
	LegendVisitorWrapper helper(legend);
	helper.set(in);	
	top()->legend(legend);
	return false; // do not exit
}

bool MagPlus::ignore(magics::MagRequest&)
{
	return false; // do not exit
}

bool MagPlus::device(magics::MagRequest& in)
{
	Log::dev()<< "add device" << endl;
	in.print();
	XmlNode* driver = 0;
	if ( !in.countValues("FORMAT") ) return false;
    string fmt =  in("FORMAT");
    
   
    string format(fmt);
    
    if ( format == "POSTSCRIPT") {
    	
    	map<string, string> attributes;
    	attributes["output_fullname"] =  string(in("FILE"));
    
    	driver = new XmlNode("ps", attributes);
    }
	
	output_.set(*driver, drivers_);
    if ( driver) delete(driver);
	return false; // do not exit
}

/*
 
void MagPlus::serve( magics::MagRequest& in, magics::MagRequest& out)
{
   magin = magics::MagRequest(in);
   magout = magics::MagRequest(in);
   //execute(in, out);
}

*/
void MagPlus::execute( magics::MagRequest& in)
{
	cout << "MagPlus::execute-->" << endl;
	in.print();
	cout << "<---MagPlus::execute" << endl;
	try {
	// Start from a fersh tree! 
	if (root_)
		{
			delete root_;
			root_ = 0;
			superpage_ = -1;
			drivers_.clear();
			mode_ = interactif;
		}
   while ( in ) {
   		string verb = in.getVerb();
   	    Log::dev()<< "create-->" << verb <<endl;
        {
   	    map<string,  ObjectCreator >::iterator creator = sceneCreators_.find(verb);
   	    if ( creator != sceneCreators_.end() ) {
   	    	  magics::MagRequest& request = in.justOneRequest();
   	    	  if ( (this->*creator->second)(request) ) return;
   	    }
        }
        { 
        map<string,  ObjectCreator >::iterator creator = driverCreators_.find(verb);
   	    if ( creator != driverCreators_.end() ) {
   	    	  magics::MagRequest& request = in.justOneRequest();
   	    	  if ( (this->*creator->second)(request) ) return;
   	    }
   	    }
   		in.advance();
   }
        if ( !root_ ) {
        	Log::warning() << "Sorry, nothing to to display!" << endl;
        	return;
        }
		assert(root_);
	  
		root_->getReady();
		drivers_.setDriversWidth(root_->absoluteWidth());
		drivers_.setDriversHeight(root_->absoluteHeight());
		root_->mode(mode_);
		root_->execute();
		
		drivers_.openDrivers();
		drivers_.dispatch(root_->root());
		drivers_.closeDrivers();
   }
   catch (MagicsException& e) 
   {
   	/*! \todo Why is this exception empty???  */
	   Log::error() << "Something went really wrong!" << e << endl;
	   Log::error() << "Sorry!" << endl;
   } 
}



void MagPlus::notify(MagicsEvent& event)
{
	Log::dev()<< "NOTIFY---" << event << endl;
	 for (vector<MagicsObserver*>::iterator observer = observers_.begin(); observer != observers_.end(); ++observer) 
			event.notify(**observer);
}

void MagPlus::unregisterObserver(MagicsObserver* observer)
{

    observers_.erase(std::remove_if(observers_.begin(), observers_.end(), 
    	bind2nd(equal_to<MagicsObserver*>(), observer)), observers_.end());
    	  
}


//_____________________________________________________________________

#ifdef STANDALONE
int main( int argc, char** argv )
{
    MvApplication theApp( argc, argv );
    MagPlusService magplus;
    theApp.run();
}
#endif
