/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file MgQPlotScene.h
    \brief Definition of MgQPlotScene.
    \author Graphics Section, ECMWF

    Started: March 2010
*/

#ifndef MgPlotScene_H
#define MgQPlotScene_H

#include <QGraphicsScene>
#include <QMap>
#include "Layer.h"
#include "QtDriver.h"
#include "MgQScene.h"

// for AIX compiler which fails when we have two definition of a macro
// (gcc also complains, but does not fail)
// in any case, we do not use the macro, so removing it should be safe
#undef ABS

class QProgressDialog;

class MgQDriverObject;
class MgQBaseNode;
class MgQLayerNode;
class MgQLayerState;
class MgQLayoutNode;
class MgQPreviewLayoutNode;
class MgQSceneLayerNode;

using magics::Layer;
using magics::SceneLayer;

class Layer;
class SceneLayer;

class MgQStepMetaData
{
public:
	MgQStepMetaData(QStringList);

	void clear();
	QStringList keys() {return keys_;}
	int stepNum();
	QStringList stepData(int);
	void addStep(QString);
	void appendToStepData(QString,int,QString);

protected:
	QStringList keys_;
	QMap<int,QStringList> stepData_;
};


class MgQPlotScene : public MgQScene
{

public:
	MgQPlotScene(QObject *parent=0);
	~MgQPlotScene();

	void clearBeforeNewRequest();
	void saveStateBeforeNewRequest();
	void restoreLayerState();

	MgQLayoutNode* projectorNode(QPointF);
	MgQLayoutNode* projectorNode();
	MgQLayoutNode* findPreviewLayout();
	MgQLayoutNode* findMagnifierLayout();

	//MgQAnimation* animation();
	//void addAnimation(MgQLayoutNode*,MgQAnimation*);
	void selectCurrentStepForAnimation();
	
	void setStepNum(int n) {stepNum_=n;} 
	int stepNum();
	int currentStep();
	bool stepCached(int);
	void setCurrentStep(int);
	void setStepVisible(int,bool);
	QStringList stepLabel(int i) {return QStringList();}
	void stepMetaData(MgQStepMetaData*);

	MgQMagnifierLayoutNode* updateMagnifier(float);
	void clearMagnifier();

	void addSceneLayerNode(MgQSceneLayerNode *node) {sceneLayerNode_=node;}
	MgQSceneLayerNode* sceneLayerNode() {return sceneLayerNode_;}
	const QList<MgQLayerNode*>& layerNodes() {return layerNodes_;}
	void addLayerNode(MgQLayerNode*);
	MgQLayerNode* layerNode(const Layer&);

	void collectLayerData(QList<QPointF> &,QMap<int,QList<QStringList> > &,bool addLayerName=true);
	void collectLayerDataForCurrentStep(QList<QPointF> &,QList<QStringList> &,bool addLayerName=true);
	void collectLayerData(QList<QPointF> &,QList<QStringList> &,int,bool addLayerName=true);
	const map<string,string>& getLayerInfoForCurrentStep(MgQLayerNode *);
	const map<string,string>& getLayerInfo(MgQLayerNode *,int);
	QPixmap getLayerInfoImageForCurrentStep(MgQLayerNode *);
	QPixmap getLayerInfoImage(MgQLayerNode *,int);
	void  renderLayerPreview();
   
	void addPreviewLayoutNode(MgQPreviewLayoutNode* node) {previewLayoutNode_=node;}
	MgQPreviewLayoutNode* previewLayoutNode() {return previewLayoutNode_;}

	//QList<MgQLayerState*> previousLayerState() {return previousLayerState_;}

	void setDriverObject(MgQDriverObject* drv) {driverObject_=drv;}

	void renderForMagnifier(QPainter *, const QRectF &, const QRectF &);
	void renderForPrinter(QPainter *);
	void renderForVideo(QPainter *,QProgressDialog *,QString,QStringList &);

	void updateAnimation();
	void updateLayers();
	void setEnableAntialias(bool);

protected:
	void scanLayers();
	void updateCache();
	void drawBackground ( QPainter * painter, const QRectF & rect ); 

	int prevCurrentStep_;
	int currentStep_;
	int stepNum_;

	QRectF magnifierSceneRect_;
	float  magnifierFactor_;

	MgQPreviewLayoutNode* previewLayoutNode_;

	MgQSceneLayerNode *sceneLayerNode_;
	QList<MgQLayerNode*> layerNodes_;
	QList<MgQLayerState*> previousLayerState_;

	MgQDriverObject *driverObject_;

	QPixmap *cacheDevice_;
	QPainter* cachePainter_;

	bool antialias_;

};


#endif
