/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax2;

import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax2.OutputContentHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class TextOutputHandler
implements OutputContentHandler {
    private Writer writer;
    private boolean keepOpen;

    public TextOutputHandler() {
    }

    public TextOutputHandler(Writer writer) {
        this.writer = writer;
    }

    public ContentHandler init(Destination dest, Properties props) throws IOException {
        String mediaType = props.getProperty("media-type");
        if (mediaType == null) {
            mediaType = "text/plain";
        }
        this.writer = dest.getWriter(mediaType, props.getProperty("encoding"));
        this.keepOpen = dest.keepOpen();
        return this;
    }

    public void startDocument() {
    }

    public void endDocument() throws SAXException {
        try {
            if (this.writer != null) {
                if (this.keepOpen) {
                    this.writer.flush();
                } else {
                    this.writer.close();
                }
                this.writer = null;
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void characters(char[] cbuf, int off, int len) throws SAXException {
        try {
            this.writer.write(cbuf, off, len);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String namespace, String localName, String qname, Attributes atts) {
    }

    public void endElement(String namespace, String localName, String qname) {
    }

    public void setDocumentLocator(Locator loc) {
    }

    public void skippedEntity(String name) {
    }

    public void startPrefixMapping(String prefix, String namespace) {
    }

    public void endPrefixMapping(String prefix) {
    }

    public void processingInstruction(String target, String value) {
    }

    public void ignorableWhitespace(char[] buf, int start, int len) {
    }
}

