/* libwpd
 * Copyright (C) 2008 Miklos Vajna (vmiklos@frugalware.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

using org.libwpd;
using System;
using System.Linq;
using System.Collections.Generic;
using System.Collections.ObjectModel;

class RawListenerImpl : WPXDocumentCSharpInterface
{
	private String getPropString(Dictionary<String,String> propList)
	{
		String propString = "";
		var items = from k in propList.Keys
			orderby k ascending
			select k;
        foreach (String k in items)
        {
			if (propString.Length > 0)
				propString += ", ";
			propString += k + ": " + propList[k];
		}
		return propString;
	}

	private String getPropString(List<Dictionary<String,String>> itemList)
	{
		String propString = "";
		foreach (Dictionary<String,String> dict in itemList)
		{
			if (propString.Length > 0)
				propString += ", ";
			else
				propString += "(";
			propString += "(" + getPropString(dict) + ")";
		}
		if (propString.Length == 0)
			propString += "(";
		propString += ")";
		return propString;
	}

	public void setDocumentMetaData(Dictionary<String,String> propList)
	{
		Console.WriteLine("setDocumentMetaData(" + getPropString(propList) + ")");
	}

	public void startDocument()
	{
		Console.WriteLine("startDocument()");
	}

	public void endDocument()
	{
		Console.WriteLine("endDocument()");
	}

	public void openPageSpan(Dictionary<String,String> propList)
	{
		Console.WriteLine("openPageSpan(" + getPropString(propList) + ")");
	}

	public void closePageSpan()
	{
		Console.WriteLine("closePageSpan()");
	}

	public void openHeader(Dictionary<String,String> propList)
	{
		Console.WriteLine("openHeader(" + getPropString(propList) + ")");
	}

	public void closeHeader()
	{
		Console.WriteLine("closeHeader()");
	}

	public void openFooter(Dictionary<String,String> propList)
	{
		Console.WriteLine("openFooter(" + getPropString(propList) + ")");
	}

	public void closeFooter()
	{
		Console.WriteLine("closeFooter()");
	}

	public void openParagraph(Dictionary<String,String> propList, List<Dictionary<String,String>> tabStops)
	{
		Console.WriteLine("openParagraph(" + getPropString(propList)+", tab-stops: " +
				getPropString(tabStops)+")");
	}

	public void closeParagraph()
	{
		Console.WriteLine("closeParagraph()");
	}

	public void openSpan(Dictionary<String,String> propList)
	{
		Console.WriteLine("openSpan("+getPropString(propList)+")");
	}

	public void closeSpan()
	{
		Console.WriteLine("closeSpan()");
	}

	public void openSection(Dictionary<String,String> propList, List<Dictionary<String,String>> columns)
	{
		Console.WriteLine("openSection("+getPropString(propList)+", columns: "+getPropString(columns)+")");
	}

	public void closeSection()
	{
		Console.WriteLine("closeSection()");
	}


	public void insertTab()
	{
		Console.WriteLine("insertTab()");
	}

	public void insertText(String text)
	{
		Console.WriteLine("insertText(text: "+text+")");
	}

	public void insertLineBreak()
	{
		Console.WriteLine("insertLineBreak()");
	}


	public void defineOrderedListLevel(Dictionary<String,String> propList)
	{
		Console.WriteLine("defineOrderedListLevel("+getPropString(propList)+")");
	}

	public void defineUnorderedListLevel(Dictionary<String,String> propList)
	{
		Console.WriteLine("defineUnorderedListLevel("+getPropString(propList)+")");
	}

	public void openOrderedListLevel(Dictionary<String,String> propList)
	{
		Console.WriteLine("openOrderedListLevel("+getPropString(propList)+")");
	}

	public void openUnorderedListLevel(Dictionary<String,String> propList)
	{
		Console.WriteLine("openUnorderedListLevel("+getPropString(propList)+")");
	}

	public void closeOrderedListLevel()
	{
		Console.WriteLine("closeOrderedListLevel()");
	}

	public void closeUnorderedListLevel()
	{
		Console.WriteLine("closeUnorderedListLevel()");
	}

	public void openListElement(Dictionary<String,String> propList, List<Dictionary<String,String>> tabStops)
	{
		Console.WriteLine("openListElement("+getPropString(propList)+", tab-stops: "+getPropString(tabStops)+")");
	}

	public void closeListElement()
	{
		Console.WriteLine("closeListElement()");
	}


	public void openFootnote(Dictionary<String,String> propList)
	{
		Console.WriteLine("openFootnote("+getPropString(propList)+")");
	}

	public void closeFootnote()
	{
		Console.WriteLine("closeFootnote()");
	}

	public void openEndnote(Dictionary<String,String> propList)
	{
		Console.WriteLine("openEndnote("+getPropString(propList)+")");
	}

	public void closeEndnote()
	{
		Console.WriteLine("closeEndnote()");
	}


	public void openComment(Dictionary<String,String> propList)
	{
		Console.WriteLine("openComment("+getPropString(propList)+")");
	}

	public void closeComment()
	{
		Console.WriteLine("closeComment()");
	}


	public void openTextBox(Dictionary<String,String> propList)
	{
		Console.WriteLine("openTextBox("+getPropString(propList)+")");
	}

	public void closeTextBox()
	{
		Console.WriteLine("closeTextBox()");
	}


	public void openTable(Dictionary<String,String> propList, List<Dictionary<String,String>> columns)
	{
		Console.WriteLine("openTable("+getPropString(propList)+", columns: "+getPropString(columns)+")");
	}

	public void openTableRow(Dictionary<String,String> propList)
	{
		Console.WriteLine("openTableRow("+getPropString(propList)+")");
	}

	public void closeTableRow()
	{
		Console.WriteLine("closeTableRow()");
	}

	public void openTableCell(Dictionary<String,String> propList)
	{
		Console.WriteLine("openTableCell("+getPropString(propList)+")");
	}

	public void closeTableCell()
	{
		Console.WriteLine("closeTableCell()");
	}

	public void insertCoveredTableCell(Dictionary<String,String> propList)
	{
		Console.WriteLine("insertCoveredTableCell("+getPropString(propList)+")");
	}

	public void closeTable()
	{
		Console.WriteLine("closeTable()");
	}

	public void openFrame(Dictionary<String,String> propList)
	{
		Console.WriteLine("openFrame("+getPropString(propList)+")");
	}

	public void closeFrame()
	{
		Console.WriteLine("closeFrame()");
	}

	public void insertBinaryObject(Dictionary<String,String> propList, byte[] data)
	{
		Console.WriteLine("insertBinaryObject("+getPropString(propList)+")");
	}
}
