#define TEAGN_ENABLE_STDOUT_LOG

#include <TePDIExamplesBase.hpp>

#include <TePDIFusion.hpp>

#include <TePDIParameters.hpp>
#include <TeAgnostic.h>
#include <TePDIUtils.hpp>
#include <TePDIPrincipalComponentsFusion.hpp>

#include <TeInitRasterDecoders.h>
#include <TeProgress.h>
#include <TeStdIOProgress.h>
#include <TeRasterParams.h> 

#include <vector>

void GarguetFusion_test()
{
  TePDIParameters params1;

  /* Building rasters */

  TePDITypes::TePDIRasterPtrType reference_raster( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( reference_raster->init(), 
    "Unable to init input_raster1" );
    
  TePDITypes::TePDIRasterPtrType lowres_raster( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop_contraste_halfsampled.tif" ), 
    'r' ) );
  TEAGN_TRUE_OR_THROW( lowres_raster->init(), 
    "Unable to init input_raster2" );    
    
  TePDITypes::TePDIRasterPtrType output_raster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( output_raster,
    1, 1, 1, false, TeDOUBLE, 0 ), "output_raster Alloc error" );
    
  params1.SetParameter( "fusion_type" , std::string( "garguet" ) );
  params1.SetParameter( "reference_raster" , reference_raster );
  params1.SetParameter( "lowres_raster" , lowres_raster );
  params1.SetParameter( "output_raster" , output_raster );
  params1.SetParameter( "reference_raster_band" , 0 );
  params1.SetParameter( "lowres_raster_band" , 0 );
  
  TePDIFusion fusion;
  
  TEAGN_TRUE_OR_THROW( fusion.Reset(params1), "Reset failed" );
  
  TEAGN_TRUE_OR_THROW( fusion.Apply(), "Apply error" );
  
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( output_raster,
    TEPDIEXAMPLESBINPATH "Fusion_Garguet_test.tif" ), "GeoTIF generation error" );
}


void VenturaFusion_test()
{
  TePDIParameters params1;

  /* Building rasters */

  TePDITypes::TePDIRasterPtrType reference_raster( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( reference_raster->init(), 
    "Unable to init input_raster1" );
    
  TePDITypes::TePDIRasterPtrType lowres_raster( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop_contraste_halfsampled.tif" ), 
    'r' ) );
  TEAGN_TRUE_OR_THROW( lowres_raster->init(), 
    "Unable to init input_raster2" );    
    
  TePDITypes::TePDIRasterPtrType output_raster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( output_raster,
    1, 1, 1, false, TeDOUBLE, 0 ), "output_raster Alloc error" );
    
  params1.SetParameter( "fusion_type" , std::string( "ventura" ) );
  params1.SetParameter( "reference_raster" , reference_raster );
  params1.SetParameter( "lowres_raster" , lowres_raster );
  params1.SetParameter( "output_raster" , output_raster );
  params1.SetParameter( "reference_raster_band" , 0 );
  params1.SetParameter( "lowres_raster_band" , 0 );
  
  TePDIFusion fusion;
  
  TEAGN_TRUE_OR_THROW( fusion.Reset(params1), "Reset failed" );
  
  TEAGN_TRUE_OR_THROW( fusion.Apply(), "Apply error" );
  
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( output_raster,
    TEPDIEXAMPLESBINPATH "Fusion_Ventura_test.tif" ), "GeoTIF generation error" );
}


void IHSFusion_test()
{
  /* Initializing the reference raster */

  TePDITypes::TePDIRasterPtrType reference_raster( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers2b_hrc_crop.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( reference_raster->init(), 
    "Unable to init input_raster1" );
    
  /* Initializing the rgb raster */
  
  TePDITypes::TePDIRasterPtrType rgb_raster( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers2b_rgb342_crop.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( rgb_raster->init(), 
    "Unable to init input_raster1" );
  
  /* Building output raster */
    
  TePDITypes::TePDIRasterPtrType output_raster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( output_raster,
    1, 1, 1, false, rgb_raster->params().dataType_[ 0 ], 0 ), "output_raster Alloc error" );
    
  /* Building algorithm parameters */
    
  TePDIParameters params1;
    
  params1.SetParameter( "fusion_type" , std::string( "ihs" ) );
  params1.SetParameter( "reference_raster" , reference_raster );
  params1.SetParameter( "lowres_raster" , rgb_raster );
  params1.SetParameter( "output_raster" , output_raster );
  params1.SetParameter( "reference_raster_band" , 0 );
  
  TePDIFusion fusion;
  
  TEAGN_TRUE_OR_THROW( fusion.Reset(params1), "Reset failed" );
  
  TEAGN_TRUE_OR_THROW( fusion.Apply(), "Apply error" );
  
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( output_raster,
    TEPDIEXAMPLESBINPATH "Fusion_IHS_test.tif" ), "GeoTIF generation error" );
}


void TePDIPrincipalComponentsFusion_test()
{
	TePDIParameters params;

	TePDITypes::TePDIRasterVectorType input_rasters;
	TePDITypes::TePDIRasterVectorType output_rasters;
	std::vector<int> bands_direct;

	for (unsigned int b = 0; b < 3; b++)
	{
		TePDITypes::TePDIRasterPtrType inRaster(new TeRaster(
		  TEPDIEXAMPLESRESPATH "cbers_b2_crop_contraste_halfsampled.tif", 'r'));
		TEAGN_TRUE_OR_THROW(inRaster->init(), "Unable to init inRaster " + 
		  Te2String(b));
		input_rasters.push_back(inRaster);

		TePDITypes::TePDIRasterPtrType outRaster;
		TEAGN_TRUE_OR_THROW(TePDIUtils::TeAllocRAMRaster(outRaster, 1, 1, 1, false, TeDOUBLE, 0), "RAM Raster " + Te2String(b+1) + " Alloc error");
		output_rasters.push_back(outRaster);
		
		bands_direct.push_back(0);
	}

	TePDITypes::TePDIRasterPtrType reference_raster(new TeRaster(
	  std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop.tif" ), 'r'));
	TEAGN_TRUE_OR_THROW(reference_raster->init(), "Unable to init reference_raster");

	params.SetParameter("input_rasters", input_rasters);
	params.SetParameter("bands", bands_direct);
	params.SetParameter("output_rasters", output_rasters);
	params.SetParameter("reference_raster", reference_raster);
	params.SetParameter("reference_raster_band", 0);
	params.SetParameter("resampling_type", 
	  TePDIPrincipalComponentsFusion::NNMethod);
	params.SetParameter("fit_histogram", false);
	
	TePDIPrincipalComponentsFusion pcf;
	TEAGN_TRUE_OR_THROW(pcf.Reset(params), "Invalid Parameters");
	TEAGN_TRUE_OR_THROW(pcf.Apply(), "Apply error");
	
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( output_rasters[ 0 ],
    TEPDIEXAMPLESBINPATH "Fusion_PC_test_output_b0.tif" ), 
    "GeoTIF generation error" );
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( output_rasters[ 1 ],
    TEPDIEXAMPLESBINPATH "Fusion_PC_test_output_b1.tif" ), 
    "GeoTIF generation error" );
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( output_rasters[ 2 ],
    TEPDIEXAMPLESBINPATH "Fusion_PC_test_output_b2.tif" ), 
    "GeoTIF generation error" );        
}


int main()
{
  TEAGN_LOGMSG( "Test started." );

  try{
    TeInitRasterDecoders();
    
    TeStdIOProgress pi;
    TeProgress::setProgressInterf( dynamic_cast< TeProgressBase* >( &pi ) );     

    IHSFusion_test();
    VenturaFusion_test();
    GarguetFusion_test();
    TePDIPrincipalComponentsFusion_test();
  }
  catch( const TeException& excpt ){
    TEAGN_LOGERR( excpt.message() )
    return EXIT_FAILURE;
  }

  TEAGN_LOGMSG( "Test OK." );
  return EXIT_SUCCESS;
}

