#define TEAGN_ENABLE_STDOUT_LOG

#include <TePDIExamplesBase.hpp>

#include <TePDIArithmetic.hpp>
#include <TePDIParameters.hpp>
#include <TePDIUtils.hpp>

#include <TeRaster.h>
#include <TeInitRasterDecoders.h>
#include <TeProgress.h>
#include <TeStdIOProgress.h>

#include <TeAgnostic.h>

#include <string>

void TePDIAType1_test()
{
  TePDIParameters params;

  params.SetParameter( "arithmetic_type", TePDIArithmetic::TePDIAType1 );

  TePDITypes::TePDIRasterPtrType inRaster1( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( inRaster1->init(), "Unable to init inRaster1" );
  params.SetParameter( "input_image1", inRaster1 );

  TePDITypes::TePDIRasterPtrType outRaster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( outRaster,
    1, 1, 1, false, TeUNSIGNEDCHAR, 0 ), "RAM Raster Alloc error" );
  params.SetParameter( "output_image", outRaster );

  params.SetParameter( "img1_chan", (int)0 );
  params.SetParameter( "gain", 2. );
  params.SetParameter( "offset", 0. );

  TePDIArithmetic arith;
    
  TEAGN_TRUE_OR_THROW( arith.Reset( params ),
    "Invalid Parameters" );

  TEAGN_TRUE_OR_THROW( arith.Apply(),
    "Apply error" );

  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    TEPDIEXAMPLESBINPATH "TePDIArithTePDIAType1_test.tif" ), "GeoTIF generation error" );
}


void TePDIAType1_norm_test()
{
  TePDIParameters params;

  params.SetParameter( "arithmetic_type", TePDIArithmetic::TePDIAType1 );

  TePDITypes::TePDIRasterPtrType inRaster1( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( inRaster1->init(), "Unable to init inRaster1" );
  params.SetParameter( "input_image1", inRaster1 );

  TePDITypes::TePDIRasterPtrType outRaster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( outRaster,
    1, 1, 1, false, TeUNSIGNEDCHAR, 0 ), "RAM Raster Alloc error" );
  params.SetParameter( "output_image", outRaster );

  params.SetParameter( "img1_chan", (int)0 );
  params.SetParameter( "gain", 2. );
  params.SetParameter( "offset", 0. );
  params.SetParameter( "normalize_output", (int)1 );

  TePDIArithmetic arith;
    
  TEAGN_TRUE_OR_THROW( arith.Reset( params ),
    "Invalid Parameters" );

  TEAGN_TRUE_OR_THROW( arith.Apply(),
    "Apply error" );

  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    TEPDIEXAMPLESBINPATH "TePDIArithTePDIAType1_norm_test.tif" ), "GeoTIF generation error" );
}


void TePDIAType2_test()
{
  TePDIParameters params;

  params.SetParameter( "arithmetic_type", TePDIArithmetic::TePDIAType2 );

  TePDITypes::TePDIRasterPtrType inRaster1( new TeRaster(
    std::string( TEPDIEXAMPLESBINPATH "TePDIArithTePDIAType1_test.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( inRaster1->init(), "Unable to init inRaster1" );
  params.SetParameter( "input_image1", inRaster1 );

  TePDITypes::TePDIRasterPtrType inRaster2( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( inRaster2->init(), "Unable to init inRaster2" );
  params.SetParameter( "input_image2", inRaster2 );

  TePDITypes::TePDIRasterPtrType outRaster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( outRaster,
    1, 1, 1, false, TeUNSIGNEDCHAR, 0 ), "RAM Raster Alloc error" );
  params.SetParameter( "output_image", outRaster );

  params.SetParameter( "img1_chan", (int)0 );
  params.SetParameter( "img2_chan", (int)0 );
  params.SetParameter( "gain", 1. );
  params.SetParameter( "offset", 0. );

  TePDIArithmetic arith;
    
  TEAGN_TRUE_OR_THROW( arith.Reset( params ),
    "Invalid Parameters" );

  TEAGN_TRUE_OR_THROW( arith.Apply(),
    "Apply error" );

  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    TEPDIEXAMPLESBINPATH "TePDIArithTePDIAType2_test.tif" ), "GeoTIF generation error" );
}


void TePDIAType2_norm_test()
{
  TePDIParameters params;

  params.SetParameter( "arithmetic_type", TePDIArithmetic::TePDIAType2 );

  TePDITypes::TePDIRasterPtrType inRaster1( new TeRaster(
    std::string( TEPDIEXAMPLESBINPATH "TePDIArithTePDIAType1_test.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( inRaster1->init(), "Unable to init inRaster1" );
  params.SetParameter( "input_image1", inRaster1 );

  TePDITypes::TePDIRasterPtrType inRaster2( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( inRaster2->init(), "Unable to init inRaster2" );
  params.SetParameter( "input_image2", inRaster2 );

  TePDITypes::TePDIRasterPtrType outRaster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( outRaster,
    1, 1, 1, false, TeUNSIGNEDCHAR, 0 ), "RAM Raster Alloc error" );
  params.SetParameter( "output_image", outRaster );

  params.SetParameter( "img1_chan", (int)0 );
  params.SetParameter( "img2_chan", (int)0 );
  params.SetParameter( "gain", 1. );
  params.SetParameter( "offset", 0. );
  params.SetParameter( "normalize_output", (int)1 );

  TePDIArithmetic arith;
    
  TEAGN_TRUE_OR_THROW( arith.Reset( params ),
    "Invalid Parameters" );

  TEAGN_TRUE_OR_THROW( arith.Apply(),
    "Apply error" );

  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    TEPDIEXAMPLESBINPATH "TePDIArithTePDIAType2_norm_test.tif" ), "GeoTIF generation error" );
}

void TePDIAType1_numeric_test()
{
  /* Creating images */
  
  TePDITypes::TePDIRasterPtrType input_image1;
  TePDITypes::TePDIRasterPtrType input_image2;
  TePDITypes::TePDIRasterPtrType output_image;
  
  TeRasterParams params;
  params.nBands( 1 );
  params.nlines_ = 1;
  params.ncols_ = 1;
  params.setDataType( TeDOUBLE, -1 );
    
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( 
    input_image1, params, false ), "Allocation error" );
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( 
    input_image2, params, false ), "Allocation error" );
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( 
    output_image, params, false ), "Allocation error" );
        
  TEAGN_TRUE_OR_THROW( input_image1->setElement( 0, 0, 2.0, 0 ), 
    "error defining raster element");
  TEAGN_TRUE_OR_THROW( input_image2->setElement( 0, 0, 3.0, 0 ), 
    "error defining raster element");
    
  /* Calling algorithm */
  
  TePDIParameters algo_params;
  algo_params.SetParameter( "arithmetic_type", 
    TePDIArithmetic::TePDIAType1 );
  algo_params.SetParameter( "input_image1", input_image1 );
  algo_params.SetParameter( "input_image2", input_image2 );
  algo_params.SetParameter( "img1_chan", (int)0 );
  algo_params.SetParameter( "img2_chan", (int)0 );
  algo_params.SetParameter( "gain", (double)2 );
  algo_params.SetParameter( "offset", (double)1 );
  algo_params.SetParameter( "output_image", output_image );

  TePDIArithmetic arith_instance;
    
  TEAGN_TRUE_OR_THROW( arith_instance.Reset( algo_params ),
    "Invalid Parameters" );

  TEAGN_TRUE_OR_THROW( arith_instance.Apply(),
    "Apply error" ); 
    
  /* Checking values */
  
  TEAGN_TRUE_OR_THROW( 
    ( output_image->params().nlines_ == 
    input_image1->params().nlines_ ) &&
    ( output_image->params().ncols_ == 
    input_image1->params().ncols_ ) &&
    ( output_image->params().nBands() == 1 ),
    "Invalid output raster size" )
  
  double value = 0; 
  
  TEAGN_TRUE_OR_THROW( output_image->getElement( 0, 0, value, 0 ), 
    "error getting raster element");  
  TEAGN_CHECK_EPS( value, 5, 0, "Invalid value" );
}

void TePDIAType2_numeric_test()
{
  /* Creating images */
  
  TePDITypes::TePDIRasterPtrType input_image1;
  TePDITypes::TePDIRasterPtrType input_image2;
  TePDITypes::TePDIRasterPtrType output_image;
  
  TeRasterParams params;
  params.nBands( 1 );
  params.nlines_ = 1;
  params.ncols_ = 1;
  params.setDataType( TeDOUBLE, -1 );
    
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( 
    input_image1, params, false ), "Allocation error" );
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( 
    input_image2, params, false ), "Allocation error" );
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( 
    output_image, params, false ), "Allocation error" );
        
  TEAGN_TRUE_OR_THROW( input_image1->setElement( 0, 0, 2.0, 0 ), 
    "error defining raster element");
  TEAGN_TRUE_OR_THROW( input_image2->setElement( 0, 0, 3.0, 0 ), 
    "error defining raster element");
    
  /* Calling algorithm */
  
  TePDIParameters algo_params;
  algo_params.SetParameter( "arithmetic_type", 
    TePDIArithmetic::TePDIAType2 );
  algo_params.SetParameter( "input_image1", input_image1 );
  algo_params.SetParameter( "input_image2", input_image2 );
  algo_params.SetParameter( "img1_chan", (int)0 );
  algo_params.SetParameter( "img2_chan", (int)0 );
  algo_params.SetParameter( "gain", (double)2 );
  algo_params.SetParameter( "offset", (double)1 );
  algo_params.SetParameter( "output_image", output_image );

  TePDIArithmetic arith_instance;
    
  TEAGN_TRUE_OR_THROW( arith_instance.Reset( algo_params ),
    "Invalid Parameters" );

  TEAGN_TRUE_OR_THROW( arith_instance.Apply(),
    "Apply error" ); 
    
  /* Checking values */
  
  TEAGN_TRUE_OR_THROW( 
    ( output_image->params().nlines_ == 
    input_image1->params().nlines_ ) &&
    ( output_image->params().ncols_ == 
    input_image1->params().ncols_ ) &&
    ( output_image->params().nBands() == 1 ),
    "Invalid output raster size" )  
  
  double value = 0; 
  
  TEAGN_TRUE_OR_THROW( output_image->getElement( 0, 0, value, 0 ), 
    "error getting raster element");  
  TEAGN_CHECK_EPS( value, -1, 0, "Invalid value" );
}

void TePDIAType3_numeric_test()
{
  /* Creating images */
  
  TePDITypes::TePDIRasterPtrType input_image1;
  TePDITypes::TePDIRasterPtrType input_image2;
  TePDITypes::TePDIRasterPtrType output_image;
  
  TeRasterParams params;
  params.nBands( 1 );
  params.nlines_ = 1;
  params.ncols_ = 1;
  params.setDataType( TeDOUBLE, -1 );
    
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( 
    input_image1, params, false ), "Allocation error" );
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( 
    input_image2, params, false ), "Allocation error" );
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( 
    output_image, params, false ), "Allocation error" );
        
  TEAGN_TRUE_OR_THROW( input_image1->setElement( 0, 0, 2.0, 0 ), 
    "error defining raster element");
  TEAGN_TRUE_OR_THROW( input_image2->setElement( 0, 0, 3.0, 0 ), 
    "error defining raster element");
    
  /* Calling algorithm */
  
  TePDIParameters algo_params;
  algo_params.SetParameter( "arithmetic_type", 
    TePDIArithmetic::TePDIAType3 );
  algo_params.SetParameter( "input_image1", input_image1 );
  algo_params.SetParameter( "input_image2", input_image2 );
  algo_params.SetParameter( "img1_chan", (int)0 );
  algo_params.SetParameter( "img2_chan", (int)0 );
  algo_params.SetParameter( "gain", (double)2 );
  algo_params.SetParameter( "offset", (double)1 );
  algo_params.SetParameter( "output_image", output_image );

  TePDIArithmetic arith_instance;
    
  TEAGN_TRUE_OR_THROW( arith_instance.Reset( algo_params ),
    "Invalid Parameters" );

  TEAGN_TRUE_OR_THROW( arith_instance.Apply(),
    "Apply error" ); 
    
  /* Checking values */
  
  TEAGN_TRUE_OR_THROW( 
    ( output_image->params().nlines_ == 
    input_image1->params().nlines_ ) &&
    ( output_image->params().ncols_ == 
    input_image1->params().ncols_ ) &&
    ( output_image->params().nBands() == 1 ),
    "Invalid output raster size" )  
  
  double value = 0; 
  
  TEAGN_TRUE_OR_THROW( output_image->getElement( 0, 0, value, 0 ), 
    "error getting raster element");  
  TEAGN_CHECK_EPS( value, 11, 0, "Invalid value" );
}

void TePDIAType4_numeric_test()
{
  /* Creating images */
  
  TePDITypes::TePDIRasterPtrType input_image1;
  TePDITypes::TePDIRasterPtrType input_image2;
  TePDITypes::TePDIRasterPtrType output_image;
  
  TeRasterParams params;
  params.nBands( 1 );
  params.nlines_ = 1;
  params.ncols_ = 1;
  params.setDataType( TeDOUBLE, -1 );
    
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( 
    input_image1, params, false ), "Allocation error" );
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( 
    input_image2, params, false ), "Allocation error" );
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( 
    output_image, params, false ), "Allocation error" );
        
  TEAGN_TRUE_OR_THROW( input_image1->setElement( 0, 0, 2.0, 0 ), 
    "error defining raster element");
  TEAGN_TRUE_OR_THROW( input_image2->setElement( 0, 0, 3.0, 0 ), 
    "error defining raster element");
    
  /* Calling algorithm */
  
  TePDIParameters algo_params;
  algo_params.SetParameter( "arithmetic_type", 
    TePDIArithmetic::TePDIAType4 );
  algo_params.SetParameter( "input_image1", input_image1 );
  algo_params.SetParameter( "input_image2", input_image2 );
  algo_params.SetParameter( "img1_chan", (int)0 );
  algo_params.SetParameter( "img2_chan", (int)0 );
  algo_params.SetParameter( "gain", (double)2 );
  algo_params.SetParameter( "offset", (double)1 );
  algo_params.SetParameter( "output_image", output_image );

  TePDIArithmetic arith_instance;
    
  TEAGN_TRUE_OR_THROW( arith_instance.Reset( algo_params ),
    "Invalid Parameters" );

  TEAGN_TRUE_OR_THROW( arith_instance.Apply(),
    "Apply error" ); 
    
  /* Checking values */
  
  TEAGN_TRUE_OR_THROW( 
    ( output_image->params().nlines_ == 
    input_image1->params().nlines_ ) &&
    ( output_image->params().ncols_ == 
    input_image1->params().ncols_ ) &&
    ( output_image->params().nBands() == 1 ),
    "Invalid output raster size" )  
  
  double value = 0; 
  
  TEAGN_TRUE_OR_THROW( output_image->getElement( 0, 0, value, 0 ), 
    "error getting raster element");  
  TEAGN_CHECK_EPS( value, 2.3333333, 0.00001, "Invalid value" );
}

void TePDIAType5_numeric_test()
{
  /* Creating images */
  
  TePDITypes::TePDIRasterPtrType input_image1;
  TePDITypes::TePDIRasterPtrType input_image2;
  TePDITypes::TePDIRasterPtrType output_image;
  
  TeRasterParams params;
  params.nBands( 1 );
  params.nlines_ = 1;
  params.ncols_ = 1;
  params.setDataType( TeDOUBLE, -1 );
    
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( 
    input_image1, params, false ), "Allocation error" );
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( 
    input_image2, params, false ), "Allocation error" );
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( 
    output_image, params, false ), "Allocation error" );
        
  TEAGN_TRUE_OR_THROW( input_image1->setElement( 0, 0, 2.0, 0 ), 
    "error defining raster element");
  TEAGN_TRUE_OR_THROW( input_image2->setElement( 0, 0, 3.0, 0 ), 
    "error defining raster element");
    
  /* Calling algorithm */
  
  TePDIParameters algo_params;
  algo_params.SetParameter( "arithmetic_type", 
    TePDIArithmetic::TePDIAType5 );
  algo_params.SetParameter( "input_image1", input_image1 );
  algo_params.SetParameter( "input_image2", input_image2 );
  algo_params.SetParameter( "img1_chan", (int)0 );
  algo_params.SetParameter( "img2_chan", (int)0 );
  algo_params.SetParameter( "gain", (double)2 );
  algo_params.SetParameter( "offset", (double)1 );
  algo_params.SetParameter( "output_image", output_image );

  TePDIArithmetic arith_instance;
    
  TEAGN_TRUE_OR_THROW( arith_instance.Reset( algo_params ),
    "Invalid Parameters" );

  TEAGN_TRUE_OR_THROW( arith_instance.Apply(),
    "Apply error" ); 
    
  /* Checking values */
  
  double value = 0; 
  
  TEAGN_TRUE_OR_THROW( 
    ( output_image->params().nlines_ == 
    input_image1->params().nlines_ ) &&
    ( output_image->params().ncols_ == 
    input_image1->params().ncols_ ) &&
    ( output_image->params().nBands() == 1 ),
    "Invalid output raster size" )  
  
  TEAGN_TRUE_OR_THROW( output_image->getElement( 0, 0, value, 0 ), 
    "error getting raster element");  
  TEAGN_CHECK_EPS( value, 0.6, 0, "Invalid value" );
}

int main()
{
  TEAGN_LOGMSG( "Test started." );

  try{
    TeStdIOProgress pi;
    TeProgress::setProgressInterf( dynamic_cast< TeProgressBase* >( &pi ) );
      
    TeInitRasterDecoders();
    
    TePDIAType1_numeric_test();
    TePDIAType2_numeric_test();
    TePDIAType3_numeric_test();
    TePDIAType4_numeric_test();
    TePDIAType5_numeric_test();

    TePDIAType1_test();
    TePDIAType1_norm_test();
    TePDIAType2_test();
    TePDIAType2_norm_test();

  }
  catch( const TeException& excpt ){
    TEAGN_LOGERR( excpt.message() )
    return EXIT_FAILURE;
  }

  TEAGN_LOGMSG( "Test OK." );
  return EXIT_SUCCESS;
}
