/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2008  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_TRANSPORT_H_
#define _SML_TRANSPORT_H_

typedef enum SmlTransportEventType {
	SML_TRANSPORT_EVENT_CONNECT_DONE,
	SML_TRANSPORT_EVENT_DISCONNECT_DONE,
	SML_TRANSPORT_EVENT_ERROR,
	SML_TRANSPORT_EVENT_DATA
} SmlTransportEventType;

typedef enum {
	SML_TRANSPORT_CONNECTION_TYPE_UNKNOWN = 0,
	SML_TRANSPORT_CONNECTION_TYPE_SERIAL = 1,
	SML_TRANSPORT_CONNECTION_TYPE_BLUETOOTH = 2,
	SML_TRANSPORT_CONNECTION_TYPE_IRDA = 3,
	SML_TRANSPORT_CONNECTION_TYPE_NET = 4,
	SML_TRANSPORT_CONNECTION_TYPE_USB = 5
} SmlTransportConnectionType;

typedef SmlBool (* SmlTransportEventCb) (SmlTransport *tsp, SmlLink *link, SmlTransportEventType type, SmlTransportData *data, SmlError *error, void *userdata);

SmlTransport *smlTransportNew(SmlTransportType type, SmlError **error);
void smlTransportFree(SmlTransport *tsp);

SmlBool smlTransportSetConfigOption(SmlTransport *tsp, const char *name, const char *value, SmlError **error);
SmlBool smlTransportSetConnectionType(SmlTransport *tsp, SmlTransportConnectionType type, SmlError **error);
SmlBool smlTransportInitialize(SmlTransport *tsp, SmlError **error);

void smlTransportSetEventCallback(SmlTransport *tsp, SmlTransportEventCb callback, void *userdata);
SmlBool smlTransportFinalize(SmlTransport *tsp, SmlError **error);
SmlBool smlTransportConnect(SmlTransport *tsp, SmlError **error);
SmlBool smlTransportDisconnect(SmlTransport *tsp, SmlLink *link, SmlError **error);
SmlBool smlTransportSend(SmlTransport *tsp, SmlLink *link, SmlTransportData *data, SmlError **error);
SmlTransportData *smlTransportDataNew(char *data, unsigned long size, SmlMimeType mimetype, SmlBool ownsData, SmlError **error);
SmlTransportData *smlTransportDataRef(SmlTransportData *data);
void smlTransportDataDeref(SmlTransportData *data);
SmlLink *smlLinkNew(SmlTransport *tsp, void *link_data, SmlError **error);
SmlLink *smlLinkRef(SmlLink *link);
void smlLinkDeref(SmlLink *link);
void smlTransportSetError(SmlTransport *tsp, SmlLink *link, SmlError **error);
SmlTransportType smlTransportGetType(SmlTransport *tsp);
SmlTransport *smlManagerGetTransport(SmlManager *manager);

/* This function will only be removed from the header. */
SmlBool smlTransportRunAsync(SmlTransport *tsp, SmlError **error) LIBSYNCML_DEPRECATED; /* expire date: 20090728 */
void smlTransportStop(SmlTransport *tsp) LIBSYNCML_DEPRECATED; /* expire date: 20090815 */
/* The function always returns NULL.
 * The function is not removed to protect the intergrity of the library.
 * Actually no user of this function is known.
 */
SmlLink *smlLinkFind(SmlTransport *tsp, void *link_data) LIBSYNCML_DEPRECATED; /* expire data: 20091223 */

#endif //_SML_TRANSPORT_H_
