/* tool.c generated by valac 0.14.0, the Vala compiler
 * generated from tool.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Daiki Ueno <ueno@unixuser.org>
 * Copyright (C) 2011-2012 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <stdio.h>
#include <libskk/libskk.h>
#include <gee.h>


#define SKK_TYPE_TOOL (skk_tool_get_type ())
#define SKK_TOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_TOOL, SkkTool))
#define SKK_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_TOOL, SkkToolClass))
#define SKK_IS_TOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_TOOL))
#define SKK_IS_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_TOOL))
#define SKK_TOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_TOOL, SkkToolClass))

typedef struct _SkkTool SkkTool;
typedef struct _SkkToolClass SkkToolClass;
typedef struct _SkkToolPrivate SkkToolPrivate;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _SkkTool {
	GObject parent_instance;
	SkkToolPrivate * priv;
};

struct _SkkToolClass {
	GObjectClass parent_class;
};


static gpointer skk_tool_parent_class = NULL;
static gchar* skk_tool_file_dict;
static gchar* skk_tool_file_dict = NULL;
static gchar* skk_tool_user_dict;
static gchar* skk_tool_user_dict = NULL;
static gchar* skk_tool_skkserv;
static gchar* skk_tool_skkserv = NULL;
static gchar* skk_tool_typing_rule;
static gchar* skk_tool_typing_rule = NULL;
static gboolean skk_tool_list_typing_rules;
static gboolean skk_tool_list_typing_rules = FALSE;

GType skk_tool_get_type (void) G_GNUC_CONST;
enum  {
	SKK_TOOL_DUMMY_PROPERTY
};
gint skk_tool_main (gchar** args, int args_length1);
static void _vala_SkkRuleMetadata_array_free (SkkRuleMetadata* array, gint array_length);
SkkTool* skk_tool_new (void);
SkkTool* skk_tool_construct (GType object_type);
static void skk_tool_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry SKK_TOOL_options[6] = {{"file-dict", 'f', 0, G_OPTION_ARG_STRING, &skk_tool_file_dict, "Path to a file dictionary", NULL}, {"user-dict", 'u', 0, G_OPTION_ARG_STRING, &skk_tool_user_dict, "Path to a user dictionary", NULL}, {"skkserv", 's', 0, G_OPTION_ARG_STRING, &skk_tool_skkserv, "Host and port running skkserv (HOST:PORT)", NULL}, {"rule", 'r', 0, G_OPTION_ARG_STRING, &skk_tool_typing_rule, "Typing rule (default: \"default\")", NULL}, {"list-rules", 'l', 0, G_OPTION_ARG_NONE, &skk_tool_list_typing_rules, "List typing rules", NULL}, {NULL}};

static void _vala_SkkRuleMetadata_array_free (SkkRuleMetadata* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			skk_rule_metadata_destroy (&array[i]);
		}
	}
	g_free (array);
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gchar* g_file_stream_read_line (FILE* self) {
	gchar* result = NULL;
	gint c = 0;
	GString* ret;
	GString* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		gint _tmp0_ = 0;
		gint _tmp1_;
		GString* _tmp2_;
		gint _tmp4_;
		GString* _tmp5_;
		gint _tmp6_;
		_tmp0_ = fgetc (self);
		c = _tmp0_;
		_tmp1_ = c;
		if (!(_tmp1_ != EOF)) {
			break;
		}
		_tmp2_ = ret;
		if (_tmp2_ == NULL) {
			GString* _tmp3_;
			_tmp3_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp3_;
		}
		_tmp4_ = c;
		if (_tmp4_ == ((gint) '\n')) {
			break;
		}
		_tmp5_ = ret;
		_tmp6_ = c;
		g_string_append_c (_tmp5_, (gchar) _tmp6_);
	}
	_tmp7_ = ret;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = ret;
		_tmp9_ = _tmp8_->str;
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		_g_string_free0 (ret);
		return result;
	}
	_g_string_free0 (ret);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gint skk_tool_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_;
	GOptionContext* option_context;
	GOptionContext* _tmp2_;
	gboolean _tmp7_;
	GeeArrayList* _tmp19_;
	GeeArrayList* dictionaries;
	const gchar* _tmp20_;
	const gchar* _tmp30_;
	const gchar* _tmp58_;
	GeeArrayList* _tmp86_;
	gint _tmp87_ = 0;
	gpointer* _tmp88_ = NULL;
	SkkDict** _tmp89_;
	gint _tmp89__length1;
	SkkContext* _tmp90_;
	SkkContext* _tmp91_;
	SkkContext* context;
	const gchar* _tmp92_;
	gchar* line = NULL;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = _ ("- emulate SKK input method on the command line");
	_tmp1_ = g_option_context_new (_tmp0_);
	option_context = _tmp1_;
	_tmp2_ = option_context;
	g_option_context_add_main_entries (_tmp2_, SKK_TOOL_options, "libskk");
	{
		GOptionContext* _tmp3_;
		_tmp3_ = option_context;
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (option_context);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (option_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	skk_init ();
	_tmp7_ = skk_tool_list_typing_rules;
	if (_tmp7_) {
		gint _tmp8_ = 0;
		SkkRuleMetadata* _tmp9_ = NULL;
		SkkRuleMetadata* rules;
		gint rules_length1;
		gint _rules_size_;
		SkkRuleMetadata* _tmp10_;
		gint _tmp10__length1;
		_tmp9_ = skk_rule_list (&_tmp8_);
		rules = _tmp9_;
		rules_length1 = _tmp8_;
		_rules_size_ = rules_length1;
		_tmp10_ = rules;
		_tmp10__length1 = rules_length1;
		{
			SkkRuleMetadata* rule_collection = NULL;
			gint rule_collection_length1 = 0;
			gint _rule_collection_size_ = 0;
			gint rule_it = 0;
			rule_collection = _tmp10_;
			rule_collection_length1 = _tmp10__length1;
			for (rule_it = 0; rule_it < _tmp10__length1; rule_it = rule_it + 1) {
				SkkRuleMetadata _tmp11_ = {0};
				SkkRuleMetadata rule = {0};
				skk_rule_metadata_copy (&rule_collection[rule_it], &_tmp11_);
				rule = _tmp11_;
				{
					FILE* _tmp12_;
					SkkRuleMetadata _tmp13_;
					const gchar* _tmp14_;
					SkkRuleMetadata _tmp15_;
					const gchar* _tmp16_;
					SkkRuleMetadata _tmp17_;
					const gchar* _tmp18_;
					_tmp12_ = stdout;
					_tmp13_ = rule;
					_tmp14_ = _tmp13_.name;
					_tmp15_ = rule;
					_tmp16_ = _tmp15_.label;
					_tmp17_ = rule;
					_tmp18_ = _tmp17_.description;
					fprintf (_tmp12_, "%s - %s: %s\n", _tmp14_, _tmp16_, _tmp18_);
					skk_rule_metadata_destroy (&rule);
				}
			}
		}
		result = 0;
		rules = (_vala_SkkRuleMetadata_array_free (rules, rules_length1), NULL);
		_g_option_context_free0 (option_context);
		return result;
	}
	_tmp19_ = gee_array_list_new (SKK_TYPE_DICT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	dictionaries = _tmp19_;
	_tmp20_ = skk_tool_user_dict;
	if (_tmp20_ != NULL) {
		{
			const gchar* _tmp21_;
			SkkUserDict* _tmp22_;
			SkkUserDict* _tmp23_;
			GeeArrayList* _tmp24_;
			SkkUserDict* _tmp25_;
			_tmp21_ = skk_tool_user_dict;
			_tmp22_ = skk_user_dict_new (_tmp21_, "UTF-8", &_inner_error_);
			_tmp23_ = _tmp22_;
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
			_tmp24_ = dictionaries;
			_tmp25_ = _tmp23_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, (SkkDict*) _tmp25_);
			_g_object_unref0 (_tmp25_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			FILE* _tmp26_;
			const gchar* _tmp27_;
			GError* _tmp28_;
			const gchar* _tmp29_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp26_ = stderr;
			_tmp27_ = skk_tool_user_dict;
			_tmp28_ = e;
			_tmp29_ = _tmp28_->message;
			fprintf (_tmp26_, "can't open user dict %s: %s", _tmp27_, _tmp29_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp30_ = skk_tool_file_dict;
	if (_tmp30_ != NULL) {
		const gchar* _tmp31_;
		gboolean _tmp32_ = FALSE;
		_tmp31_ = skk_tool_file_dict;
		_tmp32_ = g_str_has_suffix (_tmp31_, ".cdb");
		if (_tmp32_) {
			{
				const gchar* _tmp33_;
				SkkCdbDict* _tmp34_;
				SkkCdbDict* _tmp35_;
				GeeArrayList* _tmp36_;
				SkkCdbDict* _tmp37_;
				_tmp33_ = skk_tool_file_dict;
				_tmp34_ = skk_cdb_dict_new (_tmp33_, "EUC-JP", &_inner_error_);
				_tmp35_ = _tmp34_;
				if (_inner_error_ != NULL) {
					goto __catch2_g_error;
				}
				_tmp36_ = dictionaries;
				_tmp37_ = _tmp35_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, (SkkDict*) _tmp37_);
				_g_object_unref0 (_tmp37_);
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* e = NULL;
				FILE* _tmp38_;
				const gchar* _tmp39_;
				GError* _tmp40_;
				const gchar* _tmp41_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp38_ = stderr;
				_tmp39_ = skk_tool_file_dict;
				_tmp40_ = e;
				_tmp41_ = _tmp40_->message;
				fprintf (_tmp38_, "can't open CDB dict %s: %s", _tmp39_, _tmp41_);
				result = 1;
				_g_error_free0 (e);
				_g_object_unref0 (dictionaries);
				_g_option_context_free0 (option_context);
				return result;
			}
			__finally2:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (dictionaries);
				_g_option_context_free0 (option_context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		} else {
			{
				const gchar* _tmp42_;
				SkkFileDict* _tmp43_;
				SkkFileDict* _tmp44_;
				GeeArrayList* _tmp45_;
				SkkFileDict* _tmp46_;
				_tmp42_ = skk_tool_file_dict;
				_tmp43_ = skk_file_dict_new (_tmp42_, "EUC-JP", &_inner_error_);
				_tmp44_ = _tmp43_;
				if (_inner_error_ != NULL) {
					goto __catch3_g_error;
				}
				_tmp45_ = dictionaries;
				_tmp46_ = _tmp44_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, (SkkDict*) _tmp46_);
				_g_object_unref0 (_tmp46_);
			}
			goto __finally3;
			__catch3_g_error:
			{
				GError* e = NULL;
				FILE* _tmp47_;
				const gchar* _tmp48_;
				GError* _tmp49_;
				const gchar* _tmp50_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp47_ = stderr;
				_tmp48_ = skk_tool_file_dict;
				_tmp49_ = e;
				_tmp50_ = _tmp49_->message;
				fprintf (_tmp47_, "can't open file dict %s: %s", _tmp48_, _tmp50_);
				result = 1;
				_g_error_free0 (e);
				_g_object_unref0 (dictionaries);
				_g_option_context_free0 (option_context);
				return result;
			}
			__finally3:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (dictionaries);
				_g_option_context_free0 (option_context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	} else {
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_;
		SkkFileDict* _tmp53_;
		SkkFileDict* _tmp54_;
		SkkFileDict* _tmp55_;
		GeeArrayList* _tmp56_;
		SkkFileDict* _tmp57_;
		_tmp51_ = g_build_filename (DATADIR, "skk", "SKK-JISYO.L", NULL);
		_tmp52_ = _tmp51_;
		_tmp53_ = skk_file_dict_new (_tmp52_, "EUC-JP", &_inner_error_);
		_tmp54_ = _tmp53_;
		_g_free0 (_tmp52_);
		_tmp55_ = _tmp54_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp56_ = dictionaries;
		_tmp57_ = _tmp55_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, (SkkDict*) _tmp57_);
		_g_object_unref0 (_tmp57_);
	}
	_tmp58_ = skk_tool_skkserv;
	if (_tmp58_ != NULL) {
		const gchar* _tmp59_;
		gint _tmp60_ = 0;
		gint index;
		gchar* host = NULL;
		guint16 port = 0U;
		gint _tmp61_;
		_tmp59_ = skk_tool_skkserv;
		_tmp60_ = string_last_index_of (_tmp59_, ":", 0);
		index = _tmp60_;
		_tmp61_ = index;
		if (_tmp61_ < 0) {
			const gchar* _tmp62_;
			gchar* _tmp63_;
			_tmp62_ = skk_tool_skkserv;
			_tmp63_ = g_strdup (_tmp62_);
			_g_free0 (host);
			host = _tmp63_;
			port = (guint16) 1178;
		} else {
			const gchar* _tmp64_;
			gint _tmp65_;
			gchar* _tmp66_ = NULL;
			const gchar* _tmp67_;
			gint _tmp68_;
			const gchar* _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			gchar* _tmp72_ = NULL;
			gchar* _tmp73_;
			gint _tmp74_ = 0;
			_tmp64_ = skk_tool_skkserv;
			_tmp65_ = index;
			_tmp66_ = string_slice (_tmp64_, (glong) 0, (glong) _tmp65_);
			_g_free0 (host);
			host = _tmp66_;
			_tmp67_ = skk_tool_skkserv;
			_tmp68_ = index;
			_tmp69_ = skk_tool_skkserv;
			_tmp70_ = strlen (_tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = string_slice (_tmp67_, (glong) (_tmp68_ + 1), (glong) _tmp71_);
			_tmp73_ = _tmp72_;
			_tmp74_ = atoi (_tmp73_);
			port = (guint16) _tmp74_;
			_g_free0 (_tmp73_);
		}
		{
			const gchar* _tmp75_;
			guint16 _tmp76_;
			SkkSkkServ* _tmp77_;
			SkkSkkServ* _tmp78_;
			GeeArrayList* _tmp79_;
			SkkSkkServ* _tmp80_;
			_tmp75_ = host;
			_tmp76_ = port;
			_tmp77_ = skk_skk_serv_new (_tmp75_, _tmp76_, "EUC-JP", &_inner_error_);
			_tmp78_ = _tmp77_;
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
			_tmp79_ = dictionaries;
			_tmp80_ = _tmp78_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp79_, (SkkDict*) _tmp80_);
			_g_object_unref0 (_tmp80_);
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			FILE* _tmp81_;
			const gchar* _tmp82_;
			guint16 _tmp83_;
			GError* _tmp84_;
			const gchar* _tmp85_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp81_ = stderr;
			_tmp82_ = host;
			_tmp83_ = port;
			_tmp84_ = e;
			_tmp85_ = _tmp84_->message;
			fprintf (_tmp81_, "can't connect to skkserv at %s:%d: %s", _tmp82_, (gint) _tmp83_, _tmp85_);
			result = 1;
			_g_error_free0 (e);
			_g_free0 (host);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally4:
		if (_inner_error_ != NULL) {
			_g_free0 (host);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_free0 (host);
	}
	_tmp86_ = dictionaries;
	_tmp88_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp86_, &_tmp87_);
	_tmp89_ = _tmp88_;
	_tmp89__length1 = _tmp87_;
	_tmp90_ = skk_context_new (_tmp89_, _tmp87_);
	_tmp91_ = _tmp90_;
	_tmp89_ = (_vala_array_free (_tmp89_, _tmp89__length1, (GDestroyNotify) g_object_unref), NULL);
	context = _tmp91_;
	_tmp92_ = skk_tool_typing_rule;
	if (_tmp92_ != NULL) {
		{
			const gchar* _tmp93_;
			SkkRule* _tmp94_;
			SkkRule* _tmp95_;
			SkkContext* _tmp96_;
			SkkRule* _tmp97_;
			_tmp93_ = skk_tool_typing_rule;
			_tmp94_ = skk_rule_new (_tmp93_, &_inner_error_);
			_tmp95_ = _tmp94_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
					goto __catch5_skk_rule_parse_error;
				}
				_g_object_unref0 (context);
				_g_object_unref0 (dictionaries);
				_g_option_context_free0 (option_context);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_tmp96_ = context;
			_tmp97_ = _tmp95_;
			skk_context_set_typing_rule (_tmp96_, _tmp97_);
			_g_object_unref0 (_tmp97_);
		}
		goto __finally5;
		__catch5_skk_rule_parse_error:
		{
			GError* e = NULL;
			FILE* _tmp98_;
			const gchar* _tmp99_;
			GError* _tmp100_;
			const gchar* _tmp101_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp98_ = stderr;
			_tmp99_ = skk_tool_typing_rule;
			_tmp100_ = e;
			_tmp101_ = _tmp100_->message;
			fprintf (_tmp98_, "can't load rule \"%s\": %s\n", _tmp99_, _tmp101_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally5:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		FILE* _tmp102_;
		gchar* _tmp103_ = NULL;
		const gchar* _tmp104_;
		SkkContext* _tmp105_;
		const gchar* _tmp106_;
		SkkContext* _tmp107_;
		gchar* _tmp108_ = NULL;
		gchar* output;
		SkkContext* _tmp109_;
		const gchar* _tmp110_;
		const gchar* _tmp111_;
		gchar* _tmp112_;
		gchar* preedit;
		FILE* _tmp113_;
		const gchar* _tmp114_;
		gchar* _tmp115_ = NULL;
		gchar* _tmp116_;
		const gchar* _tmp117_;
		gchar* _tmp118_ = NULL;
		gchar* _tmp119_;
		const gchar* _tmp120_;
		gchar* _tmp121_ = NULL;
		gchar* _tmp122_;
		SkkContext* _tmp123_;
		SkkContext* _tmp124_;
		_tmp102_ = stdin;
		_tmp103_ = g_file_stream_read_line (_tmp102_);
		_g_free0 (line);
		line = _tmp103_;
		_tmp104_ = line;
		if (!(_tmp104_ != NULL)) {
			break;
		}
		_tmp105_ = context;
		_tmp106_ = line;
		skk_context_process_key_events (_tmp105_, _tmp106_);
		_tmp107_ = context;
		_tmp108_ = skk_context_poll_output (_tmp107_);
		output = _tmp108_;
		_tmp109_ = context;
		_tmp110_ = skk_context_get_preedit (_tmp109_);
		_tmp111_ = _tmp110_;
		_tmp112_ = g_strdup (_tmp111_);
		preedit = _tmp112_;
		_tmp113_ = stdout;
		_tmp114_ = line;
		_tmp115_ = string_replace (_tmp114_, "\"", "\\\"");
		_tmp116_ = _tmp115_;
		_tmp117_ = output;
		_tmp118_ = string_replace (_tmp117_, "\"", "\\\"");
		_tmp119_ = _tmp118_;
		_tmp120_ = preedit;
		_tmp121_ = string_replace (_tmp120_, "\"", "\\\"");
		_tmp122_ = _tmp121_;
		fprintf (_tmp113_, "{ \"input\": \"%s\", " "\"output\": \"%s\", " "\"preedit\": \"%s\" }\n", _tmp116_, _tmp119_, _tmp122_);
		_g_free0 (_tmp122_);
		_g_free0 (_tmp119_);
		_g_free0 (_tmp116_);
		_tmp123_ = context;
		skk_context_reset (_tmp123_);
		_tmp124_ = context;
		skk_context_clear_output (_tmp124_);
		_g_free0 (preedit);
		_g_free0 (output);
	}
	result = 0;
	_g_free0 (line);
	_g_object_unref0 (context);
	_g_object_unref0 (dictionaries);
	_g_option_context_free0 (option_context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return skk_tool_main (argv, argc);
}


SkkTool* skk_tool_construct (GType object_type) {
	SkkTool * self = NULL;
	self = (SkkTool*) g_object_new (object_type, NULL);
	return self;
}


SkkTool* skk_tool_new (void) {
	return skk_tool_construct (SKK_TYPE_TOOL);
}


static void skk_tool_class_init (SkkToolClass * klass) {
	skk_tool_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = skk_tool_finalize;
}


static void skk_tool_instance_init (SkkTool * self) {
}


static void skk_tool_finalize (GObject* obj) {
	SkkTool * self;
	self = SKK_TOOL (obj);
	G_OBJECT_CLASS (skk_tool_parent_class)->finalize (obj);
}


GType skk_tool_get_type (void) {
	static volatile gsize skk_tool_type_id__volatile = 0;
	if (g_once_init_enter (&skk_tool_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkTool), 0, (GInstanceInitFunc) skk_tool_instance_init, NULL };
		GType skk_tool_type_id;
		skk_tool_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkTool", &g_define_type_info, 0);
		g_once_init_leave (&skk_tool_type_id__volatile, skk_tool_type_id);
	}
	return skk_tool_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



