/* util.c generated by valac 0.14.0, the Vala compiler
 * generated from util.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Daiki Ueno <ueno@unixuser.org>
 * Copyright (C) 2011-2012 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <gio/gio.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>


#define SKK_TYPE_ENTRY (skk_entry_get_type ())
typedef struct _SkkEntry SkkEntry;

#define SKK_TYPE_NUMERIC_CONVERSION_TYPE (skk_numeric_conversion_type_get_type ())

#define SKK_TYPE_UTIL (skk_util_get_type ())
#define SKK_UTIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_UTIL, SkkUtil))
#define SKK_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_UTIL, SkkUtilClass))
#define SKK_IS_UTIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_UTIL))
#define SKK_IS_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_UTIL))
#define SKK_UTIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_UTIL, SkkUtilClass))

typedef struct _SkkUtil SkkUtil;
typedef struct _SkkUtilClass SkkUtilClass;
typedef struct _SkkUtilPrivate SkkUtilPrivate;

#define SKK_UTIL_TYPE_KANA_TABLE_ENTRY (skk_util_kana_table_entry_get_type ())
typedef struct _SkkUtilKanaTableEntry SkkUtilKanaTableEntry;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block3Data Block3Data;

#define SKK_TYPE_KANA_MODE (skk_kana_mode_get_type ())

#define SKK_TYPE_INPUT_MODE (skk_input_mode_get_type ())

#define SKK_TYPE_UNICODE_STRING (skk_unicode_string_get_type ())
#define SKK_UNICODE_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_UNICODE_STRING, SkkUnicodeString))
#define SKK_UNICODE_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_UNICODE_STRING, SkkUnicodeStringClass))
#define SKK_IS_UNICODE_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_UNICODE_STRING))
#define SKK_IS_UNICODE_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_UNICODE_STRING))
#define SKK_UNICODE_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_UNICODE_STRING, SkkUnicodeStringClass))

typedef struct _SkkUnicodeString SkkUnicodeString;
typedef struct _SkkUnicodeStringClass SkkUnicodeStringClass;
typedef struct _SkkUnicodeStringPrivate SkkUnicodeStringPrivate;

#define SKK_TYPE_MEMORY_MAPPED_FILE (skk_memory_mapped_file_get_type ())
#define SKK_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFile))
#define SKK_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))
#define SKK_IS_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_IS_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_MEMORY_MAPPED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))

typedef struct _SkkMemoryMappedFile SkkMemoryMappedFile;
typedef struct _SkkMemoryMappedFileClass SkkMemoryMappedFileClass;
typedef struct _SkkMemoryMappedFilePrivate SkkMemoryMappedFilePrivate;

struct _SkkEntry {
	gpointer key;
	gpointer value;
};

typedef enum  {
	SKK_NUMERIC_CONVERSION_TYPE_LATIN,
	SKK_NUMERIC_CONVERSION_TYPE_WIDE_LATIN,
	SKK_NUMERIC_CONVERSION_TYPE_KANJI_NUMERAL,
	SKK_NUMERIC_CONVERSION_TYPE_KANJI,
	SKK_NUMERIC_CONVERSION_TYPE_RECONVERT,
	SKK_NUMERIC_CONVERSION_TYPE_DAIJI,
	SKK_NUMERIC_CONVERSION_TYPE_SHOGI
} SkkNumericConversionType;

struct _SkkUtil {
	GObject parent_instance;
	SkkUtilPrivate * priv;
};

struct _SkkUtilClass {
	GObjectClass parent_class;
};

struct _SkkUtilKanaTableEntry {
	gunichar katakana;
	gchar* hiragana;
	gchar* hankaku_katakana;
};

struct _Block1Data {
	int _ref_count_;
	GString* builder;
};

struct _Block2Data {
	int _ref_count_;
	GString* builder;
};

struct _Block3Data {
	int _ref_count_;
	GString* builder;
};

typedef enum  {
	SKK_KANA_MODE_HIRAGANA,
	SKK_KANA_MODE_KATAKANA,
	SKK_KANA_MODE_HANKAKU_KATAKANA
} SkkKanaMode;

typedef enum  {
	SKK_INPUT_MODE_HIRAGANA = SKK_KANA_MODE_HIRAGANA,
	SKK_INPUT_MODE_KATAKANA = SKK_KANA_MODE_KATAKANA,
	SKK_INPUT_MODE_HANKAKU_KATAKANA = SKK_KANA_MODE_HANKAKU_KATAKANA,
	SKK_INPUT_MODE_LATIN,
	SKK_INPUT_MODE_WIDE_LATIN,
	SKK_INPUT_MODE_LAST,
	SKK_INPUT_MODE_DEFAULT = SKK_INPUT_MODE_HIRAGANA
} SkkInputMode;

struct _SkkUnicodeString {
	GObject parent_instance;
	SkkUnicodeStringPrivate * priv;
	gint length;
};

struct _SkkUnicodeStringClass {
	GObjectClass parent_class;
};

struct _SkkUnicodeStringPrivate {
	gchar* str;
};

struct _SkkMemoryMappedFile {
	GObject parent_instance;
	SkkMemoryMappedFilePrivate * priv;
};

struct _SkkMemoryMappedFileClass {
	GObjectClass parent_class;
};

struct _SkkMemoryMappedFilePrivate {
	void* _memory;
	gsize _length;
	GFile* file;
};

typedef enum  {
	SKK_SKK_DICT_ERROR_NOT_READABLE,
	SKK_SKK_DICT_ERROR_MALFORMED_INPUT
} SkkSkkDictError;
#define SKK_SKK_DICT_ERROR skk_skk_dict_error_quark ()

static gpointer skk_util_parent_class = NULL;
static GeeMap* skk_util__HiraganaTable;
static GeeMap* skk_util__HiraganaTable = NULL;
static GeeMap* skk_util__KatakanaTable;
static GeeMap* skk_util__KatakanaTable = NULL;
static GeeMap* skk_util__HankakuKatakanaTable;
static GeeMap* skk_util__HankakuKatakanaTable = NULL;
static GeeMap* skk_util__CompositionTable;
static GeeMap* skk_util__CompositionTable = NULL;
static GeeMap* skk_util__WideLatinToLatinTable;
static GeeMap* skk_util__WideLatinToLatinTable = NULL;
static gpointer skk_unicode_string_parent_class = NULL;
static gpointer skk_memory_mapped_file_parent_class = NULL;

GType skk_entry_get_type (void) G_GNUC_CONST;
SkkEntry* skk_entry_dup (const SkkEntry* self);
void skk_entry_free (SkkEntry* self);
void skk_entry_copy (const SkkEntry* self, SkkEntry* dest);
void skk_entry_destroy (SkkEntry* self);
GType skk_numeric_conversion_type_get_type (void) G_GNUC_CONST;
GType skk_util_get_type (void) G_GNUC_CONST;
enum  {
	SKK_UTIL_DUMMY_PROPERTY
};
static GType skk_util_kana_table_entry_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SkkUtilKanaTableEntry* skk_util_kana_table_entry_dup (const SkkUtilKanaTableEntry* self);
static void skk_util_kana_table_entry_free (SkkUtilKanaTableEntry* self);
static void skk_util_kana_table_entry_copy (const SkkUtilKanaTableEntry* self, SkkUtilKanaTableEntry* dest);
static void skk_util_kana_table_entry_destroy (SkkUtilKanaTableEntry* self);
static gchar* skk_util_get_okurigana_prefix_for_char (gunichar uc);
gchar* skk_util_get_okurigana_prefix (const gchar* okurigana);
gunichar skk_util_get_wide_latin_char (gchar c);
gchar* skk_util_get_wide_latin (const gchar* latin);
static gunichar skk_util_get_katakana_char (gunichar uc);
static void skk_util_foreach_katakana (const gchar* kana, GFunc func, void* func_target);
gchar* skk_util_get_katakana (const gchar* kana);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void __lambda0_ (Block1Data* _data1_, gunichar uc);
static void ___lambda0__gfunc (gconstpointer data, gpointer self);
gchar* skk_util_get_hiragana (const gchar* kana);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void __lambda1_ (Block2Data* _data2_, gunichar uc);
static void ___lambda1__gfunc (gconstpointer data, gpointer self);
gchar* skk_util_get_hankaku_katakana (const gchar* kana);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void __lambda2_ (Block3Data* _data3_, gunichar uc);
static void ___lambda2__gfunc (gconstpointer data, gpointer self);
GType skk_kana_mode_get_type (void) G_GNUC_CONST;
GType skk_input_mode_get_type (void) G_GNUC_CONST;
gchar* skk_util_convert_by_input_mode (const gchar* str, SkkInputMode input_mode);
static gchar* skk_util_get_kanji_numeric (gint numeric, gchar** num_table, int num_table_length1, gchar** num_pos_table, int num_pos_table_length1);
gchar* skk_util_get_numeric (gint numeric, SkkNumericConversionType type);
gchar** skk_util_build_data_path (const gchar* subdir, int* result_length1);
SkkUtil* skk_util_new (void);
SkkUtil* skk_util_construct (GType object_type);
static void skk_util_finalize (GObject* obj);
GType skk_unicode_string_get_type (void) G_GNUC_CONST;
#define SKK_UNICODE_STRING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_UNICODE_STRING, SkkUnicodeStringPrivate))
enum  {
	SKK_UNICODE_STRING_DUMMY_PROPERTY
};
SkkUnicodeString* skk_unicode_string_new (const gchar* str);
SkkUnicodeString* skk_unicode_string_construct (GType object_type, const gchar* str);
gchar* skk_unicode_string_substring (SkkUnicodeString* self, glong offset, glong len);
static void skk_unicode_string_finalize (GObject* obj);
GType skk_memory_mapped_file_get_type (void) G_GNUC_CONST;
#define SKK_MEMORY_MAPPED_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFilePrivate))
enum  {
	SKK_MEMORY_MAPPED_FILE_DUMMY_PROPERTY,
	SKK_MEMORY_MAPPED_FILE_MEMORY,
	SKK_MEMORY_MAPPED_FILE_LENGTH
};
SkkMemoryMappedFile* skk_memory_mapped_file_new (GFile* file);
SkkMemoryMappedFile* skk_memory_mapped_file_construct (GType object_type, GFile* file);
GQuark skk_skk_dict_error_quark (void);
void skk_memory_mapped_file_remap (SkkMemoryMappedFile* self, GError** error);
static void skk_memory_mapped_file_map (SkkMemoryMappedFile* self, GError** error);
void* skk_memory_mapped_file_get_memory (SkkMemoryMappedFile* self);
gsize skk_memory_mapped_file_get_length (SkkMemoryMappedFile* self);
static void skk_memory_mapped_file_finalize (GObject* obj);
static void _vala_skk_memory_mapped_file_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const SkkUtilKanaTableEntry SKK_UTIL_KanaTable[86] = {{12450U, "あ", "ｱ"}, {12452U, "い", "ｲ"}, {12454U, "う", "ｳ"}, {12456U, "え", "ｴ"}, {12458U, "お", "ｵ"}, {12459U, "か", "ｶ"}, {12461U, "き", "ｷ"}, {12463U, "く", "ｸ"}, {12465U, "け", "ｹ"}, {12467U, "こ", "ｺ"}, {12469U, "さ", "ｻ"}, {12471U, "し", "ｼ"}, {12473U, "す", "ｽ"}, {12475U, "せ", "ｾ"}, {12477U, "そ", "ｿ"}, {12479U, "た", "ﾀ"}, {12481U, "ち", "ﾁ"}, {12484U, "つ", "ﾂ"}, {12486U, "て", "ﾃ"}, {12488U, "と", "ﾄ"}, {12490U, "な", "ﾅ"}, {12491U, "に", "ﾆ"}, {12492U, "ぬ", "ﾇ"}, {12493U, "ね", "ﾈ"}, {12494U, "の", "ﾉ"}, {12495U, "は", "ﾊ"}, {12498U, "ひ", "ﾋ"}, {12501U, "ふ", "ﾌ"}, {12504U, "へ", "ﾍ"}, {12507U, "ほ", "ﾎ"}, {12510U, "ま", "ﾏ"}, {12511U, "み", "ﾐ"}, {12512U, "む", "ﾑ"}, {12513U, "め", "ﾒ"}, {12514U, "も", "ﾓ"}, {12516U, "や", "ﾔ"}, {12518U, "ゆ", "ﾕ"}, {12520U, "よ", "ﾖ"}, {12521U, "ら", "ﾗ"}, {12522U, "り", "ﾘ"}, {12523U, "る", "ﾙ"}, {12524U, "れ", "ﾚ"}, {12525U, "ろ", "ﾛ"}, {12527U, "わ", "ﾜ"}, {12528U, "ゐ", "ｲ"}, {12529U, "ゑ", "ｴ"}, {12530U, "を", "ｦ"}, {12531U, "ん", "ﾝ"}, {12460U, "が", "ｶﾞ"}, {12462U, "ぎ", "ｷﾞ"}, {12464U, "ぐ", "ｸﾞ"}, {12466U, "げ", "ｹﾞ"}, {12468U, "ご", "ｺﾞ"}, {12470U, "ざ", "ｻﾞ"}, {12472U, "じ", "ｼﾞ"}, {12474U, "ず", "ｽﾞ"}, {12476U, "ぜ", "ｾﾞ"}, {12478U, "ぞ", "ｿﾞ"}, {12480U, "だ", "ﾀﾞ"}, {12482U, "ぢ", "ﾁﾞ"}, {12485U, "づ", "ﾂﾞ"}, {12487U, "で", "ﾃﾞ"}, {12489U, "ど", "ﾄﾞ"}, {12496U, "ば", "ﾊﾞ"}, {12499U, "び", "ﾋﾞ"}, {12502U, "ぶ", "ﾌﾞ"}, {12505U, "べ", "ﾍﾞ"}, {12508U, "ぼ", "ﾎﾞ"}, {12497U, "ぱ", "ﾊﾟ"}, {12500U, "ぴ", "ﾋﾟ"}, {12503U, "ぷ", "ﾌﾟ"}, {12506U, "ぺ", "ﾍﾟ"}, {12509U, "ぽ", "ﾎﾟ"}, {12449U, "ぁ", "ｧ"}, {12451U, "ぃ", "ｨ"}, {12453U, "ぅ", "ｩ"}, {12455U, "ぇ", "ｪ"}, {12457U, "ぉ", "ｫ"}, {12483U, "っ", "ｯ"}, {12515U, "ゃ", "ｬ"}, {12517U, "ゅ", "ｭ"}, {12519U, "ょ", "ｮ"}, {12526U, "ゎ", NULL}, {12532U, "う゛", "ｳﾞ"}, {12533U, NULL, NULL}, {12534U, NULL, NULL}};
static const SkkEntry SKK_UTIL_HankakuKatakanaSubstitute[3] = {{12526U, "ﾜ"}, {12533U, "ｶ"}, {12534U, "ｹ"}};
static const gchar* SKK_UTIL_WideLatinTable[95] = {"　", "！", "”", "＃", "＄", "％", "＆", "’", "（", "）", "＊", "＋", "，", "−", "．", "／", "０", "１", "２", "３", "４", "５", "６", "７", "８", "９", "：", "；", "＜", "＝", "＞", "？", "＠", "Ａ", "Ｂ", "Ｃ", "Ｄ", "Ｅ", "Ｆ", "Ｇ", "Ｈ", "Ｉ", "Ｊ", "Ｋ", "Ｌ", "Ｍ", "Ｎ", "Ｏ", "Ｐ", "Ｑ", "Ｒ", "Ｓ", "Ｔ", "Ｕ", "Ｖ", "Ｗ", "Ｘ", "Ｙ", "Ｚ", "［", "＼", "］", "＾", "＿", "‘", "ａ", "ｂ", "ｃ", "ｄ", "ｅ", "ｆ", "ｇ", "ｈ", "ｉ", "ｊ", "ｋ", "ｌ", "ｍ", "ｎ", "ｏ", "ｐ", "ｑ", "ｒ", "ｓ", "ｔ", "ｕ", "ｖ", "ｗ", "ｘ", "ｙ", "ｚ", "｛", "｜", "｝", "〜"};
static const gchar* SKK_UTIL_KanaRomTable[83] = {"x", "a", "x", "i", "x", "u", "x", "e", "x", "o", "k", "g", "k", "g", "k", "g", "k", "g", "k", "g", "s", "z", "s", "z", "s", "z", "s", "z", "s", "z", "t", "d", "t", "d", "t", "t", "d", "t", "d", "t", "d", "n", "n", "n", "n", "n", "h", "b", "p", "h", "b", "p", "h", "b", "p", "h", "b", "p", "h", "b", "p", "m", "m", "m", "m", "m", "x", "y", "x", "y", "x", "y", "r", "r", "r", "r", "r", "x", "w", "x", "x", "w", "n"};
static const gchar* SKK_UTIL_KanjiNumericTable[10] = {"〇", "一", "二", "三", "四", "五", "六", "七", "八", "九"};
static const gchar* SKK_UTIL_DaijiNumericTable[10] = {"零", "壱", "弐", "参", "四", "伍", "六", "七", "八", "九"};
static const gchar* SKK_UTIL_KanjiNumericalPositionTable[18] = {NULL, "十", "百", "千", "万", NULL, NULL, NULL, "億", NULL, NULL, NULL, "兆", NULL, NULL, NULL, NULL, "京"};
static const gchar* SKK_UTIL_DaijiNumericalPositionTable[18] = {NULL, "拾", "百", "阡", "萬", NULL, NULL, NULL, "億", NULL, NULL, NULL, "兆", NULL, NULL, NULL, NULL, "京"};

void skk_entry_copy (const SkkEntry* self, SkkEntry* dest) {
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	_tmp0_ = (*self).key;
	(*dest).key = _tmp0_;
	_tmp1_ = (*self).value;
	(*dest).value = _tmp1_;
}


void skk_entry_destroy (SkkEntry* self) {
}


SkkEntry* skk_entry_dup (const SkkEntry* self) {
	SkkEntry* dup;
	dup = g_new0 (SkkEntry, 1);
	skk_entry_copy (self, dup);
	return dup;
}


void skk_entry_free (SkkEntry* self) {
	skk_entry_destroy (self);
	g_free (self);
}


GType skk_entry_get_type (void) {
	static volatile gsize skk_entry_type_id__volatile = 0;
	if (g_once_init_enter (&skk_entry_type_id__volatile)) {
		GType skk_entry_type_id;
		skk_entry_type_id = g_boxed_type_register_static ("SkkEntry", (GBoxedCopyFunc) skk_entry_dup, (GBoxedFreeFunc) skk_entry_free);
		g_once_init_leave (&skk_entry_type_id__volatile, skk_entry_type_id);
	}
	return skk_entry_type_id__volatile;
}


GType skk_numeric_conversion_type_get_type (void) {
	static volatile gsize skk_numeric_conversion_type_type_id__volatile = 0;
	if (g_once_init_enter (&skk_numeric_conversion_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SKK_NUMERIC_CONVERSION_TYPE_LATIN, "SKK_NUMERIC_CONVERSION_TYPE_LATIN", "latin"}, {SKK_NUMERIC_CONVERSION_TYPE_WIDE_LATIN, "SKK_NUMERIC_CONVERSION_TYPE_WIDE_LATIN", "wide-latin"}, {SKK_NUMERIC_CONVERSION_TYPE_KANJI_NUMERAL, "SKK_NUMERIC_CONVERSION_TYPE_KANJI_NUMERAL", "kanji-numeral"}, {SKK_NUMERIC_CONVERSION_TYPE_KANJI, "SKK_NUMERIC_CONVERSION_TYPE_KANJI", "kanji"}, {SKK_NUMERIC_CONVERSION_TYPE_RECONVERT, "SKK_NUMERIC_CONVERSION_TYPE_RECONVERT", "reconvert"}, {SKK_NUMERIC_CONVERSION_TYPE_DAIJI, "SKK_NUMERIC_CONVERSION_TYPE_DAIJI", "daiji"}, {SKK_NUMERIC_CONVERSION_TYPE_SHOGI, "SKK_NUMERIC_CONVERSION_TYPE_SHOGI", "shogi"}, {0, NULL, NULL}};
		GType skk_numeric_conversion_type_type_id;
		skk_numeric_conversion_type_type_id = g_enum_register_static ("SkkNumericConversionType", values);
		g_once_init_leave (&skk_numeric_conversion_type_type_id__volatile, skk_numeric_conversion_type_type_id);
	}
	return skk_numeric_conversion_type_type_id__volatile;
}


static gchar* skk_util_get_okurigana_prefix_for_char (gunichar uc) {
	gchar* result = NULL;
	gunichar _tmp0_;
	_tmp0_ = uc;
	if (_tmp0_ == 12435U) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("n");
		result = _tmp1_;
		return result;
	} else {
		gboolean _tmp2_ = FALSE;
		gunichar _tmp3_;
		gboolean _tmp5_;
		_tmp3_ = uc;
		if (_tmp3_ < 12353U) {
			_tmp2_ = TRUE;
		} else {
			gunichar _tmp4_;
			_tmp4_ = uc;
			_tmp2_ = _tmp4_ > 12435U;
		}
		_tmp5_ = _tmp2_;
		if (_tmp5_) {
			result = NULL;
			return result;
		} else {
			gunichar _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp6_ = uc;
			_tmp7_ = SKK_UTIL_KanaRomTable[_tmp6_ - 12353U];
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		}
	}
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


gchar* skk_util_get_okurigana_prefix (const gchar* okurigana) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gunichar _tmp1_ = 0U;
	gunichar head;
	gboolean _tmp2_ = FALSE;
	gunichar _tmp3_;
	gboolean _tmp5_;
	gunichar _tmp11_;
	gchar* _tmp12_ = NULL;
	g_return_val_if_fail (okurigana != NULL, NULL);
	_tmp0_ = okurigana;
	_tmp1_ = string_get_char (_tmp0_, (glong) 0);
	head = _tmp1_;
	_tmp3_ = head;
	if (_tmp3_ == 12387U) {
		const gchar* _tmp4_;
		_tmp4_ = okurigana;
		_tmp2_ = g_strcmp0 (_tmp4_, "っ") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		const gchar* _tmp6_;
		gint _tmp7_ = 0;
		gint index;
		const gchar* _tmp8_;
		gint _tmp9_;
		gunichar _tmp10_ = 0U;
		_tmp6_ = okurigana;
		_tmp7_ = string_index_of_nth_char (_tmp6_, (glong) 1);
		index = _tmp7_;
		_tmp8_ = okurigana;
		_tmp9_ = index;
		_tmp10_ = string_get_char (_tmp8_, (glong) _tmp9_);
		head = _tmp10_;
	}
	_tmp11_ = head;
	_tmp12_ = skk_util_get_okurigana_prefix_for_char (_tmp11_);
	result = _tmp12_;
	return result;
}


gunichar skk_util_get_wide_latin_char (gchar c) {
	gunichar result = 0U;
	gchar _tmp0_;
	const gchar* _tmp1_;
	gunichar _tmp2_ = 0U;
	_tmp0_ = c;
	_tmp1_ = SKK_UTIL_WideLatinTable[_tmp0_ - 32];
	_tmp2_ = string_get_char (_tmp1_, (glong) 0);
	result = _tmp2_;
	return result;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


gchar* skk_util_get_wide_latin (const gchar* latin) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* builder;
	gint index;
	gunichar uc = 0U;
	GString* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	g_return_val_if_fail (latin != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	index = 0;
	while (TRUE) {
		const gchar* _tmp1_;
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gunichar _tmp5_;
		gboolean _tmp7_;
		_tmp1_ = latin;
		_tmp3_ = string_get_next_char (_tmp1_, &index, &_tmp2_);
		uc = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp5_ = uc;
		if (((gunichar) 0x20) <= _tmp5_) {
			gunichar _tmp6_;
			_tmp6_ = uc;
			_tmp4_ = _tmp6_ <= ((gunichar) 0x7E);
		} else {
			_tmp4_ = FALSE;
		}
		_tmp7_ = _tmp4_;
		if (_tmp7_) {
			GString* _tmp8_;
			gunichar _tmp9_;
			gunichar _tmp10_ = 0U;
			_tmp8_ = builder;
			_tmp9_ = uc;
			_tmp10_ = skk_util_get_wide_latin_char ((gchar) _tmp9_);
			g_string_append_unichar (_tmp8_, _tmp10_);
		} else {
			GString* _tmp11_;
			gunichar _tmp12_;
			_tmp11_ = builder;
			_tmp12_ = uc;
			g_string_append_unichar (_tmp11_, _tmp12_);
		}
	}
	_tmp13_ = builder;
	_tmp14_ = _tmp13_->str;
	_tmp15_ = g_strdup (_tmp14_);
	result = _tmp15_;
	_g_string_free0 (builder);
	return result;
}


static gunichar skk_util_get_katakana_char (gunichar uc) {
	gunichar result = 0U;
	GeeMap* _tmp0_;
	gunichar _tmp1_;
	gboolean _tmp2_ = FALSE;
	gunichar _tmp6_;
	_tmp0_ = skk_util__KatakanaTable;
	_tmp1_ = uc;
	_tmp2_ = gee_map_has_key (_tmp0_, GINT_TO_POINTER (_tmp1_));
	if (_tmp2_) {
		GeeMap* _tmp3_;
		gunichar _tmp4_;
		gpointer _tmp5_ = NULL;
		_tmp3_ = skk_util__KatakanaTable;
		_tmp4_ = uc;
		_tmp5_ = gee_map_get (_tmp3_, GINT_TO_POINTER (_tmp4_));
		result = GPOINTER_TO_INT (_tmp5_);
		return result;
	}
	_tmp6_ = uc;
	result = _tmp6_;
	return result;
}


static void skk_util_foreach_katakana (const gchar* kana, GFunc func, void* func_target) {
	gint index;
	gunichar uc0 = 0U;
	g_return_if_fail (kana != NULL);
	index = 0;
	while (TRUE) {
		const gchar* _tmp0_;
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_ = FALSE;
		GeeMap* _tmp3_;
		gunichar _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp0_ = kana;
		_tmp2_ = string_get_next_char (_tmp0_, &index, &_tmp1_);
		uc0 = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		_tmp3_ = skk_util__CompositionTable;
		_tmp4_ = uc0;
		_tmp5_ = gee_map_has_key (_tmp3_, GINT_TO_POINTER (_tmp4_));
		if (_tmp5_) {
			GeeMap* _tmp6_;
			gunichar _tmp7_;
			gpointer _tmp8_ = NULL;
			GeeMap* composition;
			gunichar uc1 = 0U;
			const gchar* _tmp9_;
			gunichar _tmp10_ = 0U;
			gboolean _tmp11_ = FALSE;
			_tmp6_ = skk_util__CompositionTable;
			_tmp7_ = uc0;
			_tmp8_ = gee_map_get (_tmp6_, GINT_TO_POINTER (_tmp7_));
			composition = (GeeMap*) _tmp8_;
			_tmp9_ = kana;
			_tmp11_ = string_get_next_char (_tmp9_, &index, &_tmp10_);
			uc1 = _tmp10_;
			if (_tmp11_) {
				GeeMap* _tmp12_;
				gunichar _tmp13_;
				gboolean _tmp14_ = FALSE;
				_tmp12_ = composition;
				_tmp13_ = uc1;
				_tmp14_ = gee_map_has_key (_tmp12_, GINT_TO_POINTER (_tmp13_));
				if (_tmp14_) {
					GFunc _tmp15_;
					void* _tmp15__target;
					GeeMap* _tmp16_;
					gunichar _tmp17_;
					gpointer _tmp18_ = NULL;
					_tmp15_ = func;
					_tmp15__target = func_target;
					_tmp16_ = composition;
					_tmp17_ = uc1;
					_tmp18_ = gee_map_get (_tmp16_, GINT_TO_POINTER (_tmp17_));
					_tmp15_ (GINT_TO_POINTER (GPOINTER_TO_INT (_tmp18_)), _tmp15__target);
				} else {
					GFunc _tmp19_;
					void* _tmp19__target;
					gunichar _tmp20_;
					gunichar _tmp21_ = 0U;
					GFunc _tmp22_;
					void* _tmp22__target;
					gunichar _tmp23_;
					gunichar _tmp24_ = 0U;
					_tmp19_ = func;
					_tmp19__target = func_target;
					_tmp20_ = uc0;
					_tmp21_ = skk_util_get_katakana_char (_tmp20_);
					_tmp19_ (GINT_TO_POINTER (_tmp21_), _tmp19__target);
					_tmp22_ = func;
					_tmp22__target = func_target;
					_tmp23_ = uc1;
					_tmp24_ = skk_util_get_katakana_char (_tmp23_);
					_tmp22_ (GINT_TO_POINTER (_tmp24_), _tmp22__target);
				}
			} else {
				GFunc _tmp25_;
				void* _tmp25__target;
				gunichar _tmp26_;
				gunichar _tmp27_ = 0U;
				_tmp25_ = func;
				_tmp25__target = func_target;
				_tmp26_ = uc0;
				_tmp27_ = skk_util_get_katakana_char (_tmp26_);
				_tmp25_ (GINT_TO_POINTER (_tmp27_), _tmp25__target);
				_g_object_unref0 (composition);
				break;
			}
			_g_object_unref0 (composition);
		} else {
			GFunc _tmp28_;
			void* _tmp28__target;
			gunichar _tmp29_;
			gunichar _tmp30_ = 0U;
			_tmp28_ = func;
			_tmp28__target = func_target;
			_tmp29_ = uc0;
			_tmp30_ = skk_util_get_katakana_char (_tmp29_);
			_tmp28_ (GINT_TO_POINTER (_tmp30_), _tmp28__target);
		}
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_string_free0 (_data1_->builder);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda0_ (Block1Data* _data1_, gunichar uc) {
	gunichar _tmp0_;
	_tmp0_ = uc;
	g_string_append_unichar (_data1_->builder, _tmp0_);
}


static void ___lambda0__gfunc (gconstpointer data, gpointer self) {
	__lambda0_ (self, data);
}


gchar* skk_util_get_katakana (const gchar* kana) {
	gchar* result = NULL;
	Block1Data* _data1_;
	GString* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (kana != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = g_string_new ("");
	_data1_->builder = _tmp0_;
	_tmp1_ = kana;
	skk_util_foreach_katakana (_tmp1_, ___lambda0__gfunc, _data1_);
	_tmp2_ = _data1_->builder->str;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_string_free0 (_data2_->builder);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda1_ (Block2Data* _data2_, gunichar uc) {
	GeeMap* _tmp0_;
	gunichar _tmp1_;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = skk_util__HiraganaTable;
	_tmp1_ = uc;
	_tmp2_ = gee_map_has_key (_tmp0_, GINT_TO_POINTER (_tmp1_));
	if (_tmp2_) {
		GeeMap* _tmp3_;
		gunichar _tmp4_;
		gpointer _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp3_ = skk_util__HiraganaTable;
		_tmp4_ = uc;
		_tmp5_ = gee_map_get (_tmp3_, GINT_TO_POINTER (_tmp4_));
		_tmp6_ = (gchar*) _tmp5_;
		g_string_append (_data2_->builder, _tmp6_);
		_g_free0 (_tmp6_);
	} else {
		gunichar _tmp7_;
		_tmp7_ = uc;
		g_string_append_unichar (_data2_->builder, _tmp7_);
	}
}


static void ___lambda1__gfunc (gconstpointer data, gpointer self) {
	__lambda1_ (self, data);
}


gchar* skk_util_get_hiragana (const gchar* kana) {
	gchar* result = NULL;
	Block2Data* _data2_;
	GString* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (kana != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = g_string_new ("");
	_data2_->builder = _tmp0_;
	_tmp1_ = kana;
	skk_util_foreach_katakana (_tmp1_, ___lambda1__gfunc, _data2_);
	_tmp2_ = _data2_->builder->str;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_string_free0 (_data3_->builder);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda2_ (Block3Data* _data3_, gunichar uc) {
	GeeMap* _tmp0_;
	gunichar _tmp1_;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = skk_util__HankakuKatakanaTable;
	_tmp1_ = uc;
	_tmp2_ = gee_map_has_key (_tmp0_, GINT_TO_POINTER (_tmp1_));
	if (_tmp2_) {
		GeeMap* _tmp3_;
		gunichar _tmp4_;
		gpointer _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp3_ = skk_util__HankakuKatakanaTable;
		_tmp4_ = uc;
		_tmp5_ = gee_map_get (_tmp3_, GINT_TO_POINTER (_tmp4_));
		_tmp6_ = (gchar*) _tmp5_;
		g_string_append (_data3_->builder, _tmp6_);
		_g_free0 (_tmp6_);
	} else {
		gunichar _tmp7_;
		_tmp7_ = uc;
		g_string_append_unichar (_data3_->builder, _tmp7_);
	}
}


static void ___lambda2__gfunc (gconstpointer data, gpointer self) {
	__lambda2_ (self, data);
}


gchar* skk_util_get_hankaku_katakana (const gchar* kana) {
	gchar* result = NULL;
	Block3Data* _data3_;
	GString* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (kana != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = g_string_new ("");
	_data3_->builder = _tmp0_;
	_tmp1_ = kana;
	skk_util_foreach_katakana (_tmp1_, ___lambda2__gfunc, _data3_);
	_tmp2_ = _data3_->builder->str;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}


gchar* skk_util_convert_by_input_mode (const gchar* str, SkkInputMode input_mode) {
	gchar* result = NULL;
	SkkInputMode _tmp0_;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = input_mode;
	switch (_tmp0_) {
		case SKK_INPUT_MODE_HIRAGANA:
		{
			const gchar* _tmp1_;
			gchar* _tmp2_ = NULL;
			_tmp1_ = str;
			_tmp2_ = skk_util_get_hiragana (_tmp1_);
			result = _tmp2_;
			return result;
		}
		case SKK_INPUT_MODE_KATAKANA:
		{
			const gchar* _tmp3_;
			gchar* _tmp4_ = NULL;
			_tmp3_ = str;
			_tmp4_ = skk_util_get_katakana (_tmp3_);
			result = _tmp4_;
			return result;
		}
		case SKK_INPUT_MODE_HANKAKU_KATAKANA:
		{
			const gchar* _tmp5_;
			gchar* _tmp6_ = NULL;
			_tmp5_ = str;
			_tmp6_ = skk_util_get_hankaku_katakana (_tmp5_);
			result = _tmp6_;
			return result;
		}
		case SKK_INPUT_MODE_WIDE_LATIN:
		{
			const gchar* _tmp7_;
			gchar* _tmp8_ = NULL;
			_tmp7_ = str;
			_tmp8_ = skk_util_get_wide_latin (_tmp7_);
			result = _tmp8_;
			return result;
		}
		default:
		{
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = str;
			_tmp10_ = g_strdup (_tmp9_);
			result = _tmp10_;
			return result;
		}
	}
}


static gchar* skk_util_get_kanji_numeric (gint numeric, gchar** num_table, int num_table_length1, gchar** num_pos_table, int num_pos_table_length1) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* builder;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* str;
	gunichar uc = 0U;
	gchar** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = numeric;
	_tmp2_ = g_strdup_printf ("%i", _tmp1_);
	str = _tmp2_;
	_tmp3_ = num_pos_table;
	_tmp3__length1 = num_pos_table_length1;
	if (_tmp3_ == NULL) {
		GString* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		{
			gint index;
			index = 0;
			{
				gboolean _tmp4_;
				_tmp4_ = TRUE;
				while (TRUE) {
					gboolean _tmp5_;
					const gchar* _tmp6_;
					gunichar _tmp7_ = 0U;
					gboolean _tmp8_ = FALSE;
					GString* _tmp9_;
					gchar** _tmp10_;
					gint _tmp10__length1;
					gunichar _tmp11_;
					const gchar* _tmp12_;
					_tmp5_ = _tmp4_;
					if (!_tmp5_) {
					}
					_tmp4_ = FALSE;
					_tmp6_ = str;
					_tmp8_ = string_get_next_char (_tmp6_, &index, &_tmp7_);
					uc = _tmp7_;
					if (!_tmp8_) {
						break;
					}
					_tmp9_ = builder;
					_tmp10_ = num_table;
					_tmp10__length1 = num_table_length1;
					_tmp11_ = uc;
					_tmp12_ = _tmp10_[_tmp11_ - '0'];
					g_string_append (_tmp9_, _tmp12_);
				}
			}
		}
		_tmp13_ = builder;
		_tmp14_ = _tmp13_->str;
		_tmp15_ = g_strdup (_tmp14_);
		result = _tmp15_;
		_g_free0 (str);
		_g_string_free0 (builder);
		return result;
	} else {
		GString* _tmp48_;
		const gchar* _tmp49_;
		gchar* _tmp50_;
		{
			gint index;
			index = 0;
			{
				gboolean _tmp16_;
				_tmp16_ = TRUE;
				while (TRUE) {
					gboolean _tmp17_;
					const gchar* _tmp18_;
					gunichar _tmp19_ = 0U;
					gboolean _tmp20_ = FALSE;
					gunichar _tmp21_;
					_tmp17_ = _tmp16_;
					if (!_tmp17_) {
					}
					_tmp16_ = FALSE;
					_tmp18_ = str;
					_tmp20_ = string_get_next_char (_tmp18_, &index, &_tmp19_);
					uc = _tmp19_;
					if (!_tmp20_) {
						break;
					}
					_tmp21_ = uc;
					if (_tmp21_ > ((gunichar) '0')) {
						const gchar* _tmp22_;
						gint _tmp23_;
						gint _tmp24_;
						gint _tmp25_;
						gint pos_index;
						gboolean _tmp26_ = FALSE;
						gunichar _tmp27_;
						gboolean _tmp29_;
						gchar** _tmp33_;
						gint _tmp33__length1;
						gint _tmp34_;
						const gchar* _tmp35_;
						gchar* _tmp36_;
						gchar* pos;
						gboolean _tmp37_ = FALSE;
						const gchar* _tmp38_;
						gboolean _tmp40_;
						const gchar* _tmp45_;
						_tmp22_ = str;
						_tmp23_ = strlen (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = index;
						pos_index = _tmp24_ - _tmp25_;
						_tmp27_ = uc;
						if (_tmp27_ != ((gunichar) '1')) {
							_tmp26_ = TRUE;
						} else {
							gint _tmp28_;
							_tmp28_ = pos_index;
							_tmp26_ = (_tmp28_ % 4) == 0;
						}
						_tmp29_ = _tmp26_;
						if (_tmp29_) {
							GString* _tmp30_;
							gunichar _tmp31_;
							const gchar* _tmp32_;
							_tmp30_ = builder;
							_tmp31_ = uc;
							_tmp32_ = SKK_UTIL_KanjiNumericTable[_tmp31_ - '0'];
							g_string_append (_tmp30_, _tmp32_);
						}
						_tmp33_ = num_pos_table;
						_tmp33__length1 = num_pos_table_length1;
						_tmp34_ = pos_index;
						_tmp35_ = _tmp33_[_tmp34_];
						_tmp36_ = g_strdup (_tmp35_);
						pos = _tmp36_;
						_tmp38_ = pos;
						if (_tmp38_ == NULL) {
							gint _tmp39_;
							_tmp39_ = pos_index;
							_tmp37_ = (_tmp39_ % 4) > 0;
						} else {
							_tmp37_ = FALSE;
						}
						_tmp40_ = _tmp37_;
						if (_tmp40_) {
							gchar** _tmp41_;
							gint _tmp41__length1;
							gint _tmp42_;
							const gchar* _tmp43_;
							gchar* _tmp44_;
							_tmp41_ = num_pos_table;
							_tmp41__length1 = num_pos_table_length1;
							_tmp42_ = pos_index;
							_tmp43_ = _tmp41_[_tmp42_ % 4];
							_tmp44_ = g_strdup (_tmp43_);
							_g_free0 (pos);
							pos = _tmp44_;
						}
						_tmp45_ = pos;
						if (_tmp45_ != NULL) {
							GString* _tmp46_;
							const gchar* _tmp47_;
							_tmp46_ = builder;
							_tmp47_ = pos;
							g_string_append (_tmp46_, _tmp47_);
						}
						_g_free0 (pos);
					}
				}
			}
		}
		_tmp48_ = builder;
		_tmp49_ = _tmp48_->str;
		_tmp50_ = g_strdup (_tmp49_);
		result = _tmp50_;
		_g_free0 (str);
		_g_string_free0 (builder);
		return result;
	}
	_g_free0 (str);
	_g_string_free0 (builder);
}


gchar* skk_util_get_numeric (gint numeric, SkkNumericConversionType type) {
	gchar* result = NULL;
	SkkNumericConversionType _tmp0_;
	gchar* _tmp14_;
	_tmp0_ = type;
	switch (_tmp0_) {
		case SKK_NUMERIC_CONVERSION_TYPE_LATIN:
		{
			gint _tmp1_;
			gchar* _tmp2_ = NULL;
			_tmp1_ = numeric;
			_tmp2_ = g_strdup_printf ("%i", _tmp1_);
			result = _tmp2_;
			return result;
		}
		case SKK_NUMERIC_CONVERSION_TYPE_WIDE_LATIN:
		{
			gint _tmp3_;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			_tmp3_ = numeric;
			_tmp4_ = g_strdup_printf ("%i", _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = skk_util_get_wide_latin (_tmp5_);
			_tmp7_ = _tmp6_;
			_g_free0 (_tmp5_);
			result = _tmp7_;
			return result;
		}
		case SKK_NUMERIC_CONVERSION_TYPE_KANJI_NUMERAL:
		{
			gint _tmp8_;
			gchar* _tmp9_ = NULL;
			_tmp8_ = numeric;
			_tmp9_ = skk_util_get_kanji_numeric (_tmp8_, SKK_UTIL_KanjiNumericTable, G_N_ELEMENTS (SKK_UTIL_KanjiNumericTable), NULL, 0);
			result = _tmp9_;
			return result;
		}
		case SKK_NUMERIC_CONVERSION_TYPE_KANJI:
		{
			gint _tmp10_;
			gchar* _tmp11_ = NULL;
			_tmp10_ = numeric;
			_tmp11_ = skk_util_get_kanji_numeric (_tmp10_, SKK_UTIL_KanjiNumericTable, G_N_ELEMENTS (SKK_UTIL_KanjiNumericTable), SKK_UTIL_KanjiNumericalPositionTable, G_N_ELEMENTS (SKK_UTIL_KanjiNumericalPositionTable));
			result = _tmp11_;
			return result;
		}
		case SKK_NUMERIC_CONVERSION_TYPE_DAIJI:
		{
			gint _tmp12_;
			gchar* _tmp13_ = NULL;
			_tmp12_ = numeric;
			_tmp13_ = skk_util_get_kanji_numeric (_tmp12_, SKK_UTIL_DaijiNumericTable, G_N_ELEMENTS (SKK_UTIL_DaijiNumericTable), SKK_UTIL_DaijiNumericalPositionTable, G_N_ELEMENTS (SKK_UTIL_DaijiNumericalPositionTable));
			result = _tmp13_;
			return result;
		}
		default:
		{
			break;
		}
	}
	_tmp14_ = g_strdup ("");
	result = _tmp14_;
	return result;
}


gchar** skk_util_build_data_path (const gchar* subdir, int* result_length1) {
	gchar** result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* dirs;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* path;
	const gchar* _tmp3_;
	GeeArrayList* _tmp23_;
	gint _tmp24_ = 0;
	gpointer* _tmp25_ = NULL;
	gchar** _tmp26_;
	gint _tmp26__length1;
	g_return_val_if_fail (subdir != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	dirs = _tmp0_;
	_tmp1_ = g_getenv ("LIBSKK_DATA_PATH");
	_tmp2_ = g_strdup (_tmp1_);
	path = _tmp2_;
	_tmp3_ = path;
	if (_tmp3_ == NULL) {
		GeeArrayList* _tmp4_;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		GeeArrayList* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_tmp4_ = dirs;
		_tmp5_ = g_get_user_config_dir ();
		_tmp6_ = subdir;
		_tmp7_ = g_build_filename (_tmp5_, PACKAGE_NAME, _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = dirs;
		_tmp10_ = subdir;
		_tmp11_ = g_build_filename (PKGDATADIR, _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp12_);
		_g_free0 (_tmp12_);
	} else {
		const gchar* _tmp13_;
		gchar** _tmp14_;
		gchar** _tmp15_ = NULL;
		gchar** elements;
		gint elements_length1;
		gint _elements_size_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		_tmp13_ = path;
		_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, ":", 0);
		elements = _tmp15_;
		elements_length1 = _vala_array_length (_tmp14_);
		_elements_size_ = elements_length1;
		_tmp16_ = elements;
		_tmp16__length1 = elements_length1;
		{
			gchar** element_collection = NULL;
			gint element_collection_length1 = 0;
			gint _element_collection_size_ = 0;
			gint element_it = 0;
			element_collection = _tmp16_;
			element_collection_length1 = _tmp16__length1;
			for (element_it = 0; element_it < _tmp16__length1; element_it = element_it + 1) {
				gchar* _tmp17_;
				gchar* element = NULL;
				_tmp17_ = g_strdup (element_collection[element_it]);
				element = _tmp17_;
				{
					GeeArrayList* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_ = NULL;
					gchar* _tmp22_;
					_tmp18_ = dirs;
					_tmp19_ = element;
					_tmp20_ = subdir;
					_tmp21_ = g_build_filename (_tmp19_, _tmp20_, NULL);
					_tmp22_ = _tmp21_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp22_);
					_g_free0 (_tmp22_);
					_g_free0 (element);
				}
			}
		}
		elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp23_ = dirs;
	_tmp25_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp23_, &_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp26__length1 = _tmp24_;
	if (result_length1) {
		*result_length1 = _tmp26__length1;
	}
	result = _tmp26_;
	_g_free0 (path);
	_g_object_unref0 (dirs);
	return result;
}


SkkUtil* skk_util_construct (GType object_type) {
	SkkUtil * self = NULL;
	self = (SkkUtil*) g_object_new (object_type, NULL);
	return self;
}


SkkUtil* skk_util_new (void) {
	return skk_util_construct (SKK_TYPE_UTIL);
}


static void skk_util_kana_table_entry_copy (const SkkUtilKanaTableEntry* self, SkkUtilKanaTableEntry* dest) {
	gunichar _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	_tmp0_ = (*self).katakana;
	(*dest).katakana = _tmp0_;
	_tmp1_ = (*self).hiragana;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).hiragana);
	(*dest).hiragana = _tmp2_;
	_tmp3_ = (*self).hankaku_katakana;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).hankaku_katakana);
	(*dest).hankaku_katakana = _tmp4_;
}


static void skk_util_kana_table_entry_destroy (SkkUtilKanaTableEntry* self) {
	_g_free0 ((*self).hiragana);
	_g_free0 ((*self).hankaku_katakana);
}


static SkkUtilKanaTableEntry* skk_util_kana_table_entry_dup (const SkkUtilKanaTableEntry* self) {
	SkkUtilKanaTableEntry* dup;
	dup = g_new0 (SkkUtilKanaTableEntry, 1);
	skk_util_kana_table_entry_copy (self, dup);
	return dup;
}


static void skk_util_kana_table_entry_free (SkkUtilKanaTableEntry* self) {
	skk_util_kana_table_entry_destroy (self);
	g_free (self);
}


static GType skk_util_kana_table_entry_get_type (void) {
	static volatile gsize skk_util_kana_table_entry_type_id__volatile = 0;
	if (g_once_init_enter (&skk_util_kana_table_entry_type_id__volatile)) {
		GType skk_util_kana_table_entry_type_id;
		skk_util_kana_table_entry_type_id = g_boxed_type_register_static ("SkkUtilKanaTableEntry", (GBoxedCopyFunc) skk_util_kana_table_entry_dup, (GBoxedFreeFunc) skk_util_kana_table_entry_free);
		g_once_init_leave (&skk_util_kana_table_entry_type_id__volatile, skk_util_kana_table_entry_type_id);
	}
	return skk_util_kana_table_entry_type_id__volatile;
}


static void skk_util_class_init (SkkUtilClass * klass) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	skk_util_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = skk_util_finalize;
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	skk_util__HiraganaTable = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	skk_util__KatakanaTable = (GeeMap*) _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	skk_util__HankakuKatakanaTable = (GeeMap*) _tmp2_;
	_tmp3_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	skk_util__CompositionTable = (GeeMap*) _tmp3_;
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_CHAR, NULL, NULL, NULL, NULL, NULL);
	skk_util__WideLatinToLatinTable = (GeeMap*) _tmp4_;
	{
		SkkUtilKanaTableEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = SKK_UTIL_KanaTable;
		entry_collection_length1 = G_N_ELEMENTS (SKK_UTIL_KanaTable);
		for (entry_it = 0; entry_it < G_N_ELEMENTS (SKK_UTIL_KanaTable); entry_it = entry_it + 1) {
			SkkUtilKanaTableEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				GeeMap* _tmp5_;
				SkkUtilKanaTableEntry _tmp6_;
				gunichar _tmp7_;
				SkkUtilKanaTableEntry _tmp8_;
				const gchar* _tmp9_;
				GeeMap* _tmp10_;
				SkkUtilKanaTableEntry _tmp11_;
				gunichar _tmp12_;
				SkkUtilKanaTableEntry _tmp13_;
				const gchar* _tmp14_;
				SkkUtilKanaTableEntry _tmp20_;
				const gchar* _tmp21_;
				SkkUtilKanaTableEntry _tmp51_;
				const gchar* _tmp52_;
				_tmp5_ = skk_util__HiraganaTable;
				_tmp6_ = entry;
				_tmp7_ = _tmp6_.katakana;
				_tmp8_ = entry;
				_tmp9_ = _tmp8_.hiragana;
				gee_map_set (_tmp5_, GINT_TO_POINTER (_tmp7_), _tmp9_);
				_tmp10_ = skk_util__HankakuKatakanaTable;
				_tmp11_ = entry;
				_tmp12_ = _tmp11_.katakana;
				_tmp13_ = entry;
				_tmp14_ = _tmp13_.hankaku_katakana;
				gee_map_set (_tmp10_, GINT_TO_POINTER (_tmp12_), _tmp14_);
				{
					SkkEntry* substitute_collection = NULL;
					gint substitute_collection_length1 = 0;
					gint _substitute_collection_size_ = 0;
					gint substitute_it = 0;
					substitute_collection = SKK_UTIL_HankakuKatakanaSubstitute;
					substitute_collection_length1 = G_N_ELEMENTS (SKK_UTIL_HankakuKatakanaSubstitute);
					for (substitute_it = 0; substitute_it < G_N_ELEMENTS (SKK_UTIL_HankakuKatakanaSubstitute); substitute_it = substitute_it + 1) {
						SkkEntry substitute = {0};
						substitute = substitute_collection[substitute_it];
						{
							GeeMap* _tmp15_;
							SkkEntry _tmp16_;
							gconstpointer _tmp17_;
							SkkEntry _tmp18_;
							gconstpointer _tmp19_;
							_tmp15_ = skk_util__HankakuKatakanaTable;
							_tmp16_ = substitute;
							_tmp17_ = _tmp16_.key;
							_tmp18_ = substitute;
							_tmp19_ = _tmp18_.value;
							gee_map_set (_tmp15_, GINT_TO_POINTER (GPOINTER_TO_INT (_tmp17_)), (const gchar*) _tmp19_);
						}
					}
				}
				_tmp20_ = entry;
				_tmp21_ = _tmp20_.hiragana;
				if (_tmp21_ != NULL) {
					SkkUtilKanaTableEntry _tmp22_;
					const gchar* _tmp23_;
					gint _tmp24_ = 0;
					_tmp22_ = entry;
					_tmp23_ = _tmp22_.hiragana;
					_tmp24_ = g_utf8_strlen (_tmp23_, (gssize) (-1));
					if (_tmp24_ > 1) {
						gint index;
						gunichar uc0 = 0U;
						gunichar uc1 = 0U;
						SkkUtilKanaTableEntry _tmp25_;
						const gchar* _tmp26_;
						gunichar _tmp27_ = 0U;
						SkkUtilKanaTableEntry _tmp28_;
						const gchar* _tmp29_;
						gunichar _tmp30_ = 0U;
						GeeMap* _tmp31_;
						gunichar _tmp32_;
						gboolean _tmp33_ = FALSE;
						GeeMap* _tmp38_;
						gunichar _tmp39_;
						gpointer _tmp40_ = NULL;
						GeeMap* composition;
						GeeMap* _tmp41_;
						gunichar _tmp42_;
						SkkUtilKanaTableEntry _tmp43_;
						gunichar _tmp44_;
						index = 0;
						_tmp25_ = entry;
						_tmp26_ = _tmp25_.hiragana;
						string_get_next_char (_tmp26_, &index, &_tmp27_);
						uc0 = _tmp27_;
						_tmp28_ = entry;
						_tmp29_ = _tmp28_.hiragana;
						string_get_next_char (_tmp29_, &index, &_tmp30_);
						uc1 = _tmp30_;
						_tmp31_ = skk_util__CompositionTable;
						_tmp32_ = uc0;
						_tmp33_ = gee_map_has_key (_tmp31_, GINT_TO_POINTER (_tmp32_));
						if (!_tmp33_) {
							GeeMap* _tmp34_;
							gunichar _tmp35_;
							GeeHashMap* _tmp36_;
							GeeHashMap* _tmp37_;
							_tmp34_ = skk_util__CompositionTable;
							_tmp35_ = uc0;
							_tmp36_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
							_tmp37_ = _tmp36_;
							gee_map_set (_tmp34_, GINT_TO_POINTER (_tmp35_), (GeeMap*) _tmp37_);
							_g_object_unref0 (_tmp37_);
						}
						_tmp38_ = skk_util__CompositionTable;
						_tmp39_ = uc0;
						_tmp40_ = gee_map_get (_tmp38_, GINT_TO_POINTER (_tmp39_));
						composition = (GeeMap*) _tmp40_;
						_tmp41_ = composition;
						_tmp42_ = uc1;
						_tmp43_ = entry;
						_tmp44_ = _tmp43_.katakana;
						gee_map_set (_tmp41_, GINT_TO_POINTER (_tmp42_), GINT_TO_POINTER (_tmp44_));
						_g_object_unref0 (composition);
					} else {
						GeeMap* _tmp45_;
						SkkUtilKanaTableEntry _tmp46_;
						const gchar* _tmp47_;
						gunichar _tmp48_ = 0U;
						SkkUtilKanaTableEntry _tmp49_;
						gunichar _tmp50_;
						_tmp45_ = skk_util__KatakanaTable;
						_tmp46_ = entry;
						_tmp47_ = _tmp46_.hiragana;
						_tmp48_ = string_get_char (_tmp47_, (glong) 0);
						_tmp49_ = entry;
						_tmp50_ = _tmp49_.katakana;
						gee_map_set (_tmp45_, GINT_TO_POINTER (_tmp48_), GINT_TO_POINTER (_tmp50_));
					}
				}
				_tmp51_ = entry;
				_tmp52_ = _tmp51_.hankaku_katakana;
				if (_tmp52_ != NULL) {
					SkkUtilKanaTableEntry _tmp53_;
					const gchar* _tmp54_;
					gint _tmp55_ = 0;
					_tmp53_ = entry;
					_tmp54_ = _tmp53_.hankaku_katakana;
					_tmp55_ = g_utf8_strlen (_tmp54_, (gssize) (-1));
					if (_tmp55_ > 1) {
						gint index;
						gunichar uc0 = 0U;
						gunichar uc1 = 0U;
						SkkUtilKanaTableEntry _tmp56_;
						const gchar* _tmp57_;
						gunichar _tmp58_ = 0U;
						SkkUtilKanaTableEntry _tmp59_;
						const gchar* _tmp60_;
						gunichar _tmp61_ = 0U;
						GeeMap* _tmp62_;
						gunichar _tmp63_;
						gboolean _tmp64_ = FALSE;
						GeeMap* _tmp69_;
						gunichar _tmp70_;
						gpointer _tmp71_ = NULL;
						GeeMap* composition;
						GeeMap* _tmp72_;
						gunichar _tmp73_;
						SkkUtilKanaTableEntry _tmp74_;
						gunichar _tmp75_;
						index = 0;
						_tmp56_ = entry;
						_tmp57_ = _tmp56_.hankaku_katakana;
						string_get_next_char (_tmp57_, &index, &_tmp58_);
						uc0 = _tmp58_;
						_tmp59_ = entry;
						_tmp60_ = _tmp59_.hankaku_katakana;
						string_get_next_char (_tmp60_, &index, &_tmp61_);
						uc1 = _tmp61_;
						_tmp62_ = skk_util__CompositionTable;
						_tmp63_ = uc0;
						_tmp64_ = gee_map_has_key (_tmp62_, GINT_TO_POINTER (_tmp63_));
						if (!_tmp64_) {
							GeeMap* _tmp65_;
							gunichar _tmp66_;
							GeeHashMap* _tmp67_;
							GeeHashMap* _tmp68_;
							_tmp65_ = skk_util__CompositionTable;
							_tmp66_ = uc0;
							_tmp67_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
							_tmp68_ = _tmp67_;
							gee_map_set (_tmp65_, GINT_TO_POINTER (_tmp66_), (GeeMap*) _tmp68_);
							_g_object_unref0 (_tmp68_);
						}
						_tmp69_ = skk_util__CompositionTable;
						_tmp70_ = uc0;
						_tmp71_ = gee_map_get (_tmp69_, GINT_TO_POINTER (_tmp70_));
						composition = (GeeMap*) _tmp71_;
						_tmp72_ = composition;
						_tmp73_ = uc1;
						_tmp74_ = entry;
						_tmp75_ = _tmp74_.katakana;
						gee_map_set (_tmp72_, GINT_TO_POINTER (_tmp73_), GINT_TO_POINTER (_tmp75_));
						_g_object_unref0 (composition);
					} else {
						GeeMap* _tmp76_;
						SkkUtilKanaTableEntry _tmp77_;
						const gchar* _tmp78_;
						gunichar _tmp79_ = 0U;
						SkkUtilKanaTableEntry _tmp80_;
						gunichar _tmp81_;
						_tmp76_ = skk_util__KatakanaTable;
						_tmp77_ = entry;
						_tmp78_ = _tmp77_.hankaku_katakana;
						_tmp79_ = string_get_char (_tmp78_, (glong) 0);
						_tmp80_ = entry;
						_tmp81_ = _tmp80_.katakana;
						gee_map_set (_tmp76_, GINT_TO_POINTER (_tmp79_), GINT_TO_POINTER (_tmp81_));
					}
				}
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp82_;
			_tmp82_ = TRUE;
			while (TRUE) {
				gboolean _tmp83_;
				gint _tmp85_;
				GeeMap* _tmp86_;
				gint _tmp87_;
				const gchar* _tmp88_;
				gint _tmp89_;
				_tmp83_ = _tmp82_;
				if (!_tmp83_) {
					gint _tmp84_;
					_tmp84_ = i;
					i = _tmp84_ + 1;
				}
				_tmp82_ = FALSE;
				_tmp85_ = i;
				if (!(_tmp85_ < G_N_ELEMENTS (SKK_UTIL_WideLatinTable))) {
					break;
				}
				_tmp86_ = skk_util__WideLatinToLatinTable;
				_tmp87_ = i;
				_tmp88_ = SKK_UTIL_WideLatinTable[_tmp87_];
				_tmp89_ = i;
				gee_map_set (_tmp86_, _tmp88_, GINT_TO_POINTER ((gchar) (_tmp89_ + 32)));
			}
		}
	}
}


static void skk_util_instance_init (SkkUtil * self) {
}


static void skk_util_finalize (GObject* obj) {
	SkkUtil * self;
	self = SKK_UTIL (obj);
	G_OBJECT_CLASS (skk_util_parent_class)->finalize (obj);
}


GType skk_util_get_type (void) {
	static volatile gsize skk_util_type_id__volatile = 0;
	if (g_once_init_enter (&skk_util_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkUtilClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_util_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkUtil), 0, (GInstanceInitFunc) skk_util_instance_init, NULL };
		GType skk_util_type_id;
		skk_util_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkUtil", &g_define_type_info, 0);
		g_once_init_leave (&skk_util_type_id__volatile, skk_util_type_id);
	}
	return skk_util_type_id__volatile;
}


SkkUnicodeString* skk_unicode_string_construct (GType object_type, const gchar* str) {
	SkkUnicodeString * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	g_return_val_if_fail (str != NULL, NULL);
	self = (SkkUnicodeString*) g_object_new (object_type, NULL);
	_tmp0_ = str;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->str);
	self->priv->str = _tmp1_;
	_tmp2_ = str;
	_tmp3_ = g_utf8_strlen (_tmp2_, (gssize) (-1));
	self->length = _tmp3_;
	return self;
}


SkkUnicodeString* skk_unicode_string_new (const gchar* str) {
	return skk_unicode_string_construct (SKK_TYPE_UNICODE_STRING, str);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


gchar* skk_unicode_string_substring (SkkUnicodeString* self, glong offset, glong len) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	glong _tmp1_;
	gint _tmp2_ = 0;
	glong byte_offset;
	glong byte_len = 0L;
	glong _tmp3_;
	const gchar* _tmp10_;
	glong _tmp11_;
	glong _tmp12_;
	gchar* _tmp13_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->str;
	_tmp1_ = offset;
	_tmp2_ = string_index_of_nth_char (_tmp0_, _tmp1_);
	byte_offset = (glong) _tmp2_;
	_tmp3_ = len;
	if (_tmp3_ < ((glong) 0)) {
		glong _tmp4_;
		_tmp4_ = len;
		byte_len = _tmp4_;
	} else {
		const gchar* _tmp5_;
		glong _tmp6_;
		glong _tmp7_;
		gint _tmp8_ = 0;
		glong _tmp9_;
		_tmp5_ = self->priv->str;
		_tmp6_ = offset;
		_tmp7_ = len;
		_tmp8_ = string_index_of_nth_char (_tmp5_, _tmp6_ + _tmp7_);
		_tmp9_ = byte_offset;
		byte_len = _tmp8_ - _tmp9_;
	}
	_tmp10_ = self->priv->str;
	_tmp11_ = byte_offset;
	_tmp12_ = byte_len;
	_tmp13_ = string_substring (_tmp10_, _tmp11_, _tmp12_);
	result = _tmp13_;
	return result;
}


static void skk_unicode_string_class_init (SkkUnicodeStringClass * klass) {
	skk_unicode_string_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkUnicodeStringPrivate));
	G_OBJECT_CLASS (klass)->finalize = skk_unicode_string_finalize;
}


static void skk_unicode_string_instance_init (SkkUnicodeString * self) {
	self->priv = SKK_UNICODE_STRING_GET_PRIVATE (self);
}


static void skk_unicode_string_finalize (GObject* obj) {
	SkkUnicodeString * self;
	self = SKK_UNICODE_STRING (obj);
	_g_free0 (self->priv->str);
	G_OBJECT_CLASS (skk_unicode_string_parent_class)->finalize (obj);
}


GType skk_unicode_string_get_type (void) {
	static volatile gsize skk_unicode_string_type_id__volatile = 0;
	if (g_once_init_enter (&skk_unicode_string_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkUnicodeStringClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_unicode_string_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkUnicodeString), 0, (GInstanceInitFunc) skk_unicode_string_instance_init, NULL };
		GType skk_unicode_string_type_id;
		skk_unicode_string_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkUnicodeString", &g_define_type_info, 0);
		g_once_init_leave (&skk_unicode_string_type_id__volatile, skk_unicode_string_type_id);
	}
	return skk_unicode_string_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


SkkMemoryMappedFile* skk_memory_mapped_file_construct (GType object_type, GFile* file) {
	SkkMemoryMappedFile * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (SkkMemoryMappedFile*) g_object_new (object_type, NULL);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	return self;
}


SkkMemoryMappedFile* skk_memory_mapped_file_new (GFile* file) {
	return skk_memory_mapped_file_construct (SKK_TYPE_MEMORY_MAPPED_FILE, file);
}


void skk_memory_mapped_file_remap (SkkMemoryMappedFile* self, GError** error) {
	void* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_memory;
	if (_tmp0_ != NULL) {
		void* _tmp1_;
		gsize _tmp2_;
		_tmp1_ = self->priv->_memory;
		_tmp2_ = self->priv->_length;
		munmap (_tmp1_, _tmp2_);
		self->priv->_memory = NULL;
	}
	skk_memory_mapped_file_map (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void skk_memory_mapped_file_map (SkkMemoryMappedFile* self, GError** error) {
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gint fd;
	gint _tmp5_;
	struct stat stat = {0};
	gint _tmp11_;
	struct stat _tmp12_ = {0};
	gint _tmp13_ = 0;
	gint retval;
	gint _tmp14_;
	struct stat _tmp16_;
	gsize _tmp17_;
	gint _tmp18_;
	void* _tmp19_ = NULL;
	void* _tmp20_;
	void* _tmp21_;
	struct stat _tmp23_;
	gsize _tmp24_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = g_file_get_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = open (_tmp2_, O_RDONLY, (mode_t) 0);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	fd = _tmp4_;
	_tmp5_ = fd;
	if (_tmp5_ < 0) {
		GFile* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		GError* _tmp9_;
		GError* _tmp10_;
		_tmp6_ = self->priv->file;
		_tmp7_ = g_file_get_path (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_error_new (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_NOT_READABLE, "can't open %s", _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp11_ = fd;
	_tmp13_ = fstat (_tmp11_, &_tmp12_);
	stat = _tmp12_;
	retval = _tmp13_;
	_tmp14_ = retval;
	if (_tmp14_ < 0) {
		GError* _tmp15_;
		_tmp15_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_NOT_READABLE, "can't stat fd");
		_inner_error_ = _tmp15_;
		if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp16_ = stat;
	_tmp17_ = _tmp16_.st_size;
	_tmp18_ = fd;
	_tmp19_ = mmap (NULL, _tmp17_, PROT_READ, MAP_SHARED, _tmp18_, (off_t) 0);
	self->priv->_memory = _tmp19_;
	_tmp20_ = self->priv->_memory;
	_tmp21_ = MAP_FAILED;
	if (_tmp20_ == _tmp21_) {
		GError* _tmp22_;
		_tmp22_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_NOT_READABLE, "mmap failed");
		_inner_error_ = _tmp22_;
		if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp23_ = stat;
	_tmp24_ = _tmp23_.st_size;
	self->priv->_length = _tmp24_;
}


void* skk_memory_mapped_file_get_memory (SkkMemoryMappedFile* self) {
	void* result;
	void* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_memory;
	result = _tmp0_;
	return result;
}


gsize skk_memory_mapped_file_get_length (SkkMemoryMappedFile* self) {
	gsize result;
	gsize _tmp0_;
	g_return_val_if_fail (self != NULL, 0UL);
	_tmp0_ = self->priv->_length;
	result = _tmp0_;
	return result;
}


static void skk_memory_mapped_file_class_init (SkkMemoryMappedFileClass * klass) {
	skk_memory_mapped_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkMemoryMappedFilePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_memory_mapped_file_get_property;
	G_OBJECT_CLASS (klass)->finalize = skk_memory_mapped_file_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_MEMORY_MAPPED_FILE_MEMORY, g_param_spec_pointer ("memory", "memory", "memory", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_MEMORY_MAPPED_FILE_LENGTH, g_param_spec_ulong ("length", "length", "length", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void skk_memory_mapped_file_instance_init (SkkMemoryMappedFile * self) {
	self->priv = SKK_MEMORY_MAPPED_FILE_GET_PRIVATE (self);
	self->priv->_memory = NULL;
	self->priv->_length = (gsize) 0;
}


static void skk_memory_mapped_file_finalize (GObject* obj) {
	SkkMemoryMappedFile * self;
	self = SKK_MEMORY_MAPPED_FILE (obj);
	_g_object_unref0 (self->priv->file);
	G_OBJECT_CLASS (skk_memory_mapped_file_parent_class)->finalize (obj);
}


GType skk_memory_mapped_file_get_type (void) {
	static volatile gsize skk_memory_mapped_file_type_id__volatile = 0;
	if (g_once_init_enter (&skk_memory_mapped_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkMemoryMappedFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_memory_mapped_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkMemoryMappedFile), 0, (GInstanceInitFunc) skk_memory_mapped_file_instance_init, NULL };
		GType skk_memory_mapped_file_type_id;
		skk_memory_mapped_file_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkMemoryMappedFile", &g_define_type_info, 0);
		g_once_init_leave (&skk_memory_mapped_file_type_id__volatile, skk_memory_mapped_file_type_id);
	}
	return skk_memory_mapped_file_type_id__volatile;
}


static void _vala_skk_memory_mapped_file_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SkkMemoryMappedFile * self;
	self = SKK_MEMORY_MAPPED_FILE (object);
	switch (property_id) {
		case SKK_MEMORY_MAPPED_FILE_MEMORY:
		g_value_set_pointer (value, skk_memory_mapped_file_get_memory (self));
		break;
		case SKK_MEMORY_MAPPED_FILE_LENGTH:
		g_value_set_ulong (value, skk_memory_mapped_file_get_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



