/* key-event.c generated by valac 0.14.0, the Vala compiler
 * generated from key-event.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Daiki Ueno <ueno@unixuser.org>
 * Copyright (C) 2011-2012 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define SKK_TYPE_MODIFIER_TYPE (skk_modifier_type_get_type ())

#define SKK_TYPE_KEY_EVENT (skk_key_event_get_type ())
#define SKK_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_KEY_EVENT, SkkKeyEvent))
#define SKK_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_KEY_EVENT, SkkKeyEventClass))
#define SKK_IS_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_KEY_EVENT))
#define SKK_IS_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_KEY_EVENT))
#define SKK_KEY_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_KEY_EVENT, SkkKeyEventClass))

typedef struct _SkkKeyEvent SkkKeyEvent;
typedef struct _SkkKeyEventClass SkkKeyEventClass;
typedef struct _SkkKeyEventPrivate SkkKeyEventPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	SKK_MODIFIER_TYPE_NONE = 0,
	SKK_MODIFIER_TYPE_SHIFT_MASK = 1 << 0,
	SKK_MODIFIER_TYPE_LOCK_MASK = 1 << 1,
	SKK_MODIFIER_TYPE_CONTROL_MASK = 1 << 2,
	SKK_MODIFIER_TYPE_MOD1_MASK = 1 << 3,
	SKK_MODIFIER_TYPE_MOD2_MASK = 1 << 4,
	SKK_MODIFIER_TYPE_MOD3_MASK = 1 << 5,
	SKK_MODIFIER_TYPE_MOD4_MASK = 1 << 6,
	SKK_MODIFIER_TYPE_MOD5_MASK = 1 << 7,
	SKK_MODIFIER_TYPE_LSHIFT_MASK = 1 << 22,
	SKK_MODIFIER_TYPE_RSHIFT_MASK = 1 << 23,
	SKK_MODIFIER_TYPE_USLEEP_MASK = 1 << 24,
	SKK_MODIFIER_TYPE_SUPER_MASK = 1 << 26,
	SKK_MODIFIER_TYPE_HYPER_MASK = 1 << 27,
	SKK_MODIFIER_TYPE_META_MASK = 1 << 28,
	SKK_MODIFIER_TYPE_RELEASE_MASK = 1 << 30
} SkkModifierType;

struct _SkkKeyEvent {
	GObject parent_instance;
	SkkKeyEventPrivate * priv;
};

struct _SkkKeyEventClass {
	GObjectClass parent_class;
};

struct _SkkKeyEventPrivate {
	gchar* _name;
	gunichar _code;
	SkkModifierType _modifiers;
};


static gpointer skk_key_event_parent_class = NULL;

GType skk_modifier_type_get_type (void) G_GNUC_CONST;
GType skk_key_event_get_type (void) G_GNUC_CONST;
#define SKK_KEY_EVENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_KEY_EVENT, SkkKeyEventPrivate))
enum  {
	SKK_KEY_EVENT_DUMMY_PROPERTY,
	SKK_KEY_EVENT_NAME,
	SKK_KEY_EVENT_CODE,
	SKK_KEY_EVENT_MODIFIERS
};
SkkKeyEvent* skk_key_event_new (const gchar* name, gunichar code, SkkModifierType modifiers);
SkkKeyEvent* skk_key_event_construct (GType object_type, const gchar* name, gunichar code, SkkModifierType modifiers);
static void skk_key_event_set_name (SkkKeyEvent* self, const gchar* value);
static void skk_key_event_set_code (SkkKeyEvent* self, gunichar value);
void skk_key_event_set_modifiers (SkkKeyEvent* self, SkkModifierType value);
SkkKeyEvent* skk_key_event_copy (SkkKeyEvent* self);
const gchar* skk_key_event_get_name (SkkKeyEvent* self);
gunichar skk_key_event_get_code (SkkKeyEvent* self);
SkkModifierType skk_key_event_get_modifiers (SkkKeyEvent* self);
SkkKeyEvent* skk_key_event_new_from_string (const gchar* key);
SkkKeyEvent* skk_key_event_construct_from_string (GType object_type, const gchar* key);
gchar* skk_key_event_to_string (SkkKeyEvent* self);
gboolean skk_key_event_base_equal (SkkKeyEvent* self, SkkKeyEvent* key);
static void skk_key_event_finalize (GObject* obj);
static void _vala_skk_key_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_skk_key_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
     * A set of bit-flags to indicate the state of modifier keys.
     */
GType skk_modifier_type_get_type (void) {
	static volatile gsize skk_modifier_type_type_id__volatile = 0;
	if (g_once_init_enter (&skk_modifier_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SKK_MODIFIER_TYPE_NONE, "SKK_MODIFIER_TYPE_NONE", "none"}, {SKK_MODIFIER_TYPE_SHIFT_MASK, "SKK_MODIFIER_TYPE_SHIFT_MASK", "shift-mask"}, {SKK_MODIFIER_TYPE_LOCK_MASK, "SKK_MODIFIER_TYPE_LOCK_MASK", "lock-mask"}, {SKK_MODIFIER_TYPE_CONTROL_MASK, "SKK_MODIFIER_TYPE_CONTROL_MASK", "control-mask"}, {SKK_MODIFIER_TYPE_MOD1_MASK, "SKK_MODIFIER_TYPE_MOD1_MASK", "mod1-mask"}, {SKK_MODIFIER_TYPE_MOD2_MASK, "SKK_MODIFIER_TYPE_MOD2_MASK", "mod2-mask"}, {SKK_MODIFIER_TYPE_MOD3_MASK, "SKK_MODIFIER_TYPE_MOD3_MASK", "mod3-mask"}, {SKK_MODIFIER_TYPE_MOD4_MASK, "SKK_MODIFIER_TYPE_MOD4_MASK", "mod4-mask"}, {SKK_MODIFIER_TYPE_MOD5_MASK, "SKK_MODIFIER_TYPE_MOD5_MASK", "mod5-mask"}, {SKK_MODIFIER_TYPE_LSHIFT_MASK, "SKK_MODIFIER_TYPE_LSHIFT_MASK", "lshift-mask"}, {SKK_MODIFIER_TYPE_RSHIFT_MASK, "SKK_MODIFIER_TYPE_RSHIFT_MASK", "rshift-mask"}, {SKK_MODIFIER_TYPE_USLEEP_MASK, "SKK_MODIFIER_TYPE_USLEEP_MASK", "usleep-mask"}, {SKK_MODIFIER_TYPE_SUPER_MASK, "SKK_MODIFIER_TYPE_SUPER_MASK", "super-mask"}, {SKK_MODIFIER_TYPE_HYPER_MASK, "SKK_MODIFIER_TYPE_HYPER_MASK", "hyper-mask"}, {SKK_MODIFIER_TYPE_META_MASK, "SKK_MODIFIER_TYPE_META_MASK", "meta-mask"}, {SKK_MODIFIER_TYPE_RELEASE_MASK, "SKK_MODIFIER_TYPE_RELEASE_MASK", "release-mask"}, {0, NULL, NULL}};
		GType skk_modifier_type_type_id;
		skk_modifier_type_type_id = g_enum_register_static ("SkkModifierType", values);
		g_once_init_leave (&skk_modifier_type_type_id__volatile, skk_modifier_type_type_id);
	}
	return skk_modifier_type_type_id__volatile;
}


/**
         * Create a key event.
         *
         * @param name a key name
         * @param code a character code
         * @param modifiers state of modifier keys
         *
         * @return a new KeyEvent
         */
SkkKeyEvent* skk_key_event_construct (GType object_type, const gchar* name, gunichar code, SkkModifierType modifiers) {
	SkkKeyEvent * self = NULL;
	const gchar* _tmp0_;
	gunichar _tmp1_;
	SkkModifierType _tmp2_;
	self = (SkkKeyEvent*) g_object_new (object_type, NULL);
	_tmp0_ = name;
	skk_key_event_set_name (self, _tmp0_);
	_tmp1_ = code;
	skk_key_event_set_code (self, _tmp1_);
	_tmp2_ = modifiers;
	skk_key_event_set_modifiers (self, _tmp2_);
	return self;
}


SkkKeyEvent* skk_key_event_new (const gchar* name, gunichar code, SkkModifierType modifiers) {
	return skk_key_event_construct (SKK_TYPE_KEY_EVENT, name, code, modifiers);
}


/**
         * Create a copy of the key event.
         *
         * @return a new KeyEvent
         */
SkkKeyEvent* skk_key_event_copy (SkkKeyEvent* self) {
	SkkKeyEvent* result = NULL;
	const gchar* _tmp0_;
	gunichar _tmp1_;
	SkkModifierType _tmp2_;
	SkkKeyEvent* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = self->priv->_code;
	_tmp2_ = self->priv->_modifiers;
	_tmp3_ = skk_key_event_new (_tmp0_, _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


/**
         * Create a key event from string.
         *
         * @param key a string representation of a key event
         *
         * @return a new KeyEvent
         */
static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


SkkKeyEvent* skk_key_event_construct_from_string (GType object_type, const gchar* key) {
	SkkKeyEvent * self = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_;
	g_return_val_if_fail (key != NULL, NULL);
	self = (SkkKeyEvent*) g_object_new (object_type, NULL);
	_tmp1_ = key;
	_tmp2_ = g_str_has_prefix (_tmp1_, "(");
	if (_tmp2_) {
		const gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = key;
		_tmp4_ = g_str_has_suffix (_tmp3_, ")");
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_ = NULL;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar** strv;
		gint strv_length1;
		gint _strv_size_;
		gint index;
		gchar** _tmp53_;
		gint _tmp53__length1;
		gint _tmp54_;
		const gchar* _tmp55_;
		gunichar _tmp56_ = 0U;
		const gchar* _tmp57_;
		gint _tmp58_ = 0;
		gunichar _tmp61_;
		_tmp6_ = key;
		_tmp7_ = string_slice (_tmp6_, (glong) 1, (glong) (-1));
		_tmp8_ = _tmp7_;
		_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, " ", 0);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = _vala_array_length (_tmp9_);
		_g_free0 (_tmp8_);
		strv = _tmp11_;
		strv_length1 = _tmp11__length1;
		_strv_size_ = strv_length1;
		index = 0;
		{
			gboolean _tmp12_;
			_tmp12_ = TRUE;
			while (TRUE) {
				gboolean _tmp13_;
				gint _tmp15_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				gchar** _tmp17_;
				gint _tmp17__length1;
				gint _tmp18_;
				const gchar* _tmp19_;
				_tmp13_ = _tmp12_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = index;
					index = _tmp14_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp15_ = index;
				_tmp16_ = strv;
				_tmp16__length1 = strv_length1;
				if (!(_tmp15_ < (_tmp16__length1 - 1))) {
					break;
				}
				_tmp17_ = strv;
				_tmp17__length1 = strv_length1;
				_tmp18_ = index;
				_tmp19_ = _tmp17_[_tmp18_];
				if (g_strcmp0 (_tmp19_, "control") == 0) {
					SkkModifierType _tmp20_;
					_tmp20_ = self->priv->_modifiers;
					skk_key_event_set_modifiers (self, _tmp20_ | SKK_MODIFIER_TYPE_CONTROL_MASK);
				} else {
					gchar** _tmp21_;
					gint _tmp21__length1;
					gint _tmp22_;
					const gchar* _tmp23_;
					_tmp21_ = strv;
					_tmp21__length1 = strv_length1;
					_tmp22_ = index;
					_tmp23_ = _tmp21_[_tmp22_];
					if (g_strcmp0 (_tmp23_, "meta") == 0) {
						SkkModifierType _tmp24_;
						_tmp24_ = self->priv->_modifiers;
						skk_key_event_set_modifiers (self, _tmp24_ | SKK_MODIFIER_TYPE_META_MASK);
					} else {
						gchar** _tmp25_;
						gint _tmp25__length1;
						gint _tmp26_;
						const gchar* _tmp27_;
						_tmp25_ = strv;
						_tmp25__length1 = strv_length1;
						_tmp26_ = index;
						_tmp27_ = _tmp25_[_tmp26_];
						if (g_strcmp0 (_tmp27_, "hyper") == 0) {
							SkkModifierType _tmp28_;
							_tmp28_ = self->priv->_modifiers;
							skk_key_event_set_modifiers (self, _tmp28_ | SKK_MODIFIER_TYPE_HYPER_MASK);
						} else {
							gchar** _tmp29_;
							gint _tmp29__length1;
							gint _tmp30_;
							const gchar* _tmp31_;
							_tmp29_ = strv;
							_tmp29__length1 = strv_length1;
							_tmp30_ = index;
							_tmp31_ = _tmp29_[_tmp30_];
							if (g_strcmp0 (_tmp31_, "super") == 0) {
								SkkModifierType _tmp32_;
								_tmp32_ = self->priv->_modifiers;
								skk_key_event_set_modifiers (self, _tmp32_ | SKK_MODIFIER_TYPE_SUPER_MASK);
							} else {
								gchar** _tmp33_;
								gint _tmp33__length1;
								gint _tmp34_;
								const gchar* _tmp35_;
								_tmp33_ = strv;
								_tmp33__length1 = strv_length1;
								_tmp34_ = index;
								_tmp35_ = _tmp33_[_tmp34_];
								if (g_strcmp0 (_tmp35_, "alt") == 0) {
									SkkModifierType _tmp36_;
									_tmp36_ = self->priv->_modifiers;
									skk_key_event_set_modifiers (self, _tmp36_ | SKK_MODIFIER_TYPE_MOD1_MASK);
								} else {
									gchar** _tmp37_;
									gint _tmp37__length1;
									gint _tmp38_;
									const gchar* _tmp39_;
									_tmp37_ = strv;
									_tmp37__length1 = strv_length1;
									_tmp38_ = index;
									_tmp39_ = _tmp37_[_tmp38_];
									if (g_strcmp0 (_tmp39_, "lshift") == 0) {
										SkkModifierType _tmp40_;
										_tmp40_ = self->priv->_modifiers;
										skk_key_event_set_modifiers (self, _tmp40_ | SKK_MODIFIER_TYPE_LSHIFT_MASK);
									} else {
										gchar** _tmp41_;
										gint _tmp41__length1;
										gint _tmp42_;
										const gchar* _tmp43_;
										_tmp41_ = strv;
										_tmp41__length1 = strv_length1;
										_tmp42_ = index;
										_tmp43_ = _tmp41_[_tmp42_];
										if (g_strcmp0 (_tmp43_, "rshift") == 0) {
											SkkModifierType _tmp44_;
											_tmp44_ = self->priv->_modifiers;
											skk_key_event_set_modifiers (self, _tmp44_ | SKK_MODIFIER_TYPE_RSHIFT_MASK);
										} else {
											gchar** _tmp45_;
											gint _tmp45__length1;
											gint _tmp46_;
											const gchar* _tmp47_;
											_tmp45_ = strv;
											_tmp45__length1 = strv_length1;
											_tmp46_ = index;
											_tmp47_ = _tmp45_[_tmp46_];
											if (g_strcmp0 (_tmp47_, "usleep") == 0) {
												SkkModifierType _tmp48_;
												_tmp48_ = self->priv->_modifiers;
												skk_key_event_set_modifiers (self, _tmp48_ | SKK_MODIFIER_TYPE_USLEEP_MASK);
											} else {
												gchar** _tmp49_;
												gint _tmp49__length1;
												gint _tmp50_;
												const gchar* _tmp51_;
												_tmp49_ = strv;
												_tmp49__length1 = strv_length1;
												_tmp50_ = index;
												_tmp51_ = _tmp49_[_tmp50_];
												if (g_strcmp0 (_tmp51_, "release") == 0) {
													SkkModifierType _tmp52_;
													_tmp52_ = self->priv->_modifiers;
													skk_key_event_set_modifiers (self, _tmp52_ | SKK_MODIFIER_TYPE_RELEASE_MASK);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		_tmp53_ = strv;
		_tmp53__length1 = strv_length1;
		_tmp54_ = index;
		_tmp55_ = _tmp53_[_tmp54_];
		skk_key_event_set_name (self, _tmp55_);
		_tmp57_ = self->priv->_name;
		_tmp58_ = g_utf8_strlen (_tmp57_, (gssize) (-1));
		if (_tmp58_ == 1) {
			const gchar* _tmp59_;
			gunichar _tmp60_ = 0U;
			_tmp59_ = self->priv->_name;
			_tmp60_ = string_get_char (_tmp59_, (glong) 0);
			_tmp56_ = _tmp60_;
		} else {
			_tmp56_ = (gunichar) '\0';
		}
		_tmp61_ = _tmp56_;
		skk_key_event_set_code (self, _tmp61_);
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	} else {
		const gchar* _tmp62_;
		gint _tmp63_ = 0;
		gint index;
		gint _tmp64_;
		_tmp62_ = key;
		_tmp63_ = string_last_index_of (_tmp62_, "-", 0);
		index = _tmp63_;
		_tmp64_ = index;
		if (_tmp64_ > 0) {
			const gchar* _tmp65_;
			gint _tmp66_;
			gchar* _tmp67_ = NULL;
			gchar* _tmp68_;
			gchar** _tmp69_;
			gchar** _tmp70_ = NULL;
			gchar** _tmp71_;
			gint _tmp71__length1;
			gchar** mods;
			gint mods_length1;
			gint _mods_size_;
			gchar** _tmp72_;
			gint _tmp72__length1;
			const gchar* _tmp82_;
			gint _tmp83_;
			gchar* _tmp84_ = NULL;
			gchar* _tmp85_;
			gunichar _tmp86_ = 0U;
			const gchar* _tmp87_;
			gint _tmp88_ = 0;
			gunichar _tmp91_;
			_tmp65_ = key;
			_tmp66_ = index;
			_tmp67_ = string_substring (_tmp65_, (glong) 0, (glong) _tmp66_);
			_tmp68_ = _tmp67_;
			_tmp70_ = _tmp69_ = g_strsplit (_tmp68_, "-", 0);
			_tmp71_ = _tmp70_;
			_tmp71__length1 = _vala_array_length (_tmp69_);
			_g_free0 (_tmp68_);
			mods = _tmp71_;
			mods_length1 = _tmp71__length1;
			_mods_size_ = mods_length1;
			_tmp72_ = mods;
			_tmp72__length1 = mods_length1;
			{
				gchar** mod_collection = NULL;
				gint mod_collection_length1 = 0;
				gint _mod_collection_size_ = 0;
				gint mod_it = 0;
				mod_collection = _tmp72_;
				mod_collection_length1 = _tmp72__length1;
				for (mod_it = 0; mod_it < _tmp72__length1; mod_it = mod_it + 1) {
					gchar* _tmp73_;
					gchar* mod = NULL;
					_tmp73_ = g_strdup (mod_collection[mod_it]);
					mod = _tmp73_;
					{
						const gchar* _tmp74_;
						_tmp74_ = mod;
						if (g_strcmp0 (_tmp74_, "C") == 0) {
							SkkModifierType _tmp75_;
							_tmp75_ = self->priv->_modifiers;
							skk_key_event_set_modifiers (self, _tmp75_ | SKK_MODIFIER_TYPE_CONTROL_MASK);
						} else {
							const gchar* _tmp76_;
							_tmp76_ = mod;
							if (g_strcmp0 (_tmp76_, "A") == 0) {
								SkkModifierType _tmp77_;
								_tmp77_ = self->priv->_modifiers;
								skk_key_event_set_modifiers (self, _tmp77_ | SKK_MODIFIER_TYPE_MOD1_MASK);
							} else {
								const gchar* _tmp78_;
								_tmp78_ = mod;
								if (g_strcmp0 (_tmp78_, "M") == 0) {
									SkkModifierType _tmp79_;
									_tmp79_ = self->priv->_modifiers;
									skk_key_event_set_modifiers (self, _tmp79_ | SKK_MODIFIER_TYPE_META_MASK);
								} else {
									const gchar* _tmp80_;
									_tmp80_ = mod;
									if (g_strcmp0 (_tmp80_, "G") == 0) {
										SkkModifierType _tmp81_;
										_tmp81_ = self->priv->_modifiers;
										skk_key_event_set_modifiers (self, _tmp81_ | SKK_MODIFIER_TYPE_MOD5_MASK);
									}
								}
							}
						}
						_g_free0 (mod);
					}
				}
			}
			_tmp82_ = key;
			_tmp83_ = index;
			_tmp84_ = string_substring (_tmp82_, (glong) (_tmp83_ + 1), (glong) (-1));
			_tmp85_ = _tmp84_;
			skk_key_event_set_name (self, _tmp85_);
			_g_free0 (_tmp85_);
			_tmp87_ = self->priv->_name;
			_tmp88_ = g_utf8_strlen (_tmp87_, (gssize) (-1));
			if (_tmp88_ == 1) {
				const gchar* _tmp89_;
				gunichar _tmp90_ = 0U;
				_tmp89_ = self->priv->_name;
				_tmp90_ = string_get_char (_tmp89_, (glong) 0);
				_tmp86_ = _tmp90_;
			} else {
				_tmp86_ = (gunichar) '\0';
			}
			_tmp91_ = _tmp86_;
			skk_key_event_set_code (self, _tmp91_);
			mods = (_vala_array_free (mods, mods_length1, (GDestroyNotify) g_free), NULL);
		} else {
			const gchar* _tmp92_;
			gunichar _tmp93_ = 0U;
			const gchar* _tmp94_;
			gint _tmp95_ = 0;
			gunichar _tmp98_;
			skk_key_event_set_modifiers (self, SKK_MODIFIER_TYPE_NONE);
			_tmp92_ = key;
			skk_key_event_set_name (self, _tmp92_);
			_tmp94_ = self->priv->_name;
			_tmp95_ = g_utf8_strlen (_tmp94_, (gssize) (-1));
			if (_tmp95_ == 1) {
				const gchar* _tmp96_;
				gunichar _tmp97_ = 0U;
				_tmp96_ = self->priv->_name;
				_tmp97_ = string_get_char (_tmp96_, (glong) 0);
				_tmp93_ = _tmp97_;
			} else {
				_tmp93_ = (gunichar) '\0';
			}
			_tmp98_ = _tmp93_;
			skk_key_event_set_code (self, _tmp98_);
		}
	}
	return self;
}


SkkKeyEvent* skk_key_event_new_from_string (const gchar* key) {
	return skk_key_event_construct_from_string (SKK_TYPE_KEY_EVENT, key);
}


/**
         * Convert the KeyEvent to string.
         *
         * @return a string representing the KeyEvent
         */
static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


gchar* skk_key_event_to_string (SkkKeyEvent* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _base;
	SkkModifierType _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_name;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->_name;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gunichar _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp4_ = self->priv->_code;
		_tmp5_ = g_unichar_to_string (_tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	_tmp7_ = g_strdup (_tmp6_);
	_base = _tmp7_;
	_tmp8_ = self->priv->_modifiers;
	if (_tmp8_ != 0) {
		GeeArrayList* _tmp9_;
		GeeArrayList* elements;
		SkkModifierType _tmp10_;
		SkkModifierType _tmp12_;
		SkkModifierType _tmp14_;
		SkkModifierType _tmp16_;
		SkkModifierType _tmp18_;
		SkkModifierType _tmp20_;
		SkkModifierType _tmp22_;
		SkkModifierType _tmp24_;
		SkkModifierType _tmp26_;
		GeeArrayList* _tmp28_;
		const gchar* _tmp29_;
		GeeArrayList* _tmp30_;
		GeeArrayList* _tmp31_;
		gint _tmp32_ = 0;
		gpointer* _tmp33_ = NULL;
		gchar** _tmp34_;
		gint _tmp34__length1;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp9_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
		elements = _tmp9_;
		_tmp10_ = self->priv->_modifiers;
		if ((_tmp10_ & SKK_MODIFIER_TYPE_CONTROL_MASK) != 0) {
			GeeArrayList* _tmp11_;
			_tmp11_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, "control");
		}
		_tmp12_ = self->priv->_modifiers;
		if ((_tmp12_ & SKK_MODIFIER_TYPE_META_MASK) != 0) {
			GeeArrayList* _tmp13_;
			_tmp13_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, "meta");
		}
		_tmp14_ = self->priv->_modifiers;
		if ((_tmp14_ & SKK_MODIFIER_TYPE_HYPER_MASK) != 0) {
			GeeArrayList* _tmp15_;
			_tmp15_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, "hyper");
		}
		_tmp16_ = self->priv->_modifiers;
		if ((_tmp16_ & SKK_MODIFIER_TYPE_SUPER_MASK) != 0) {
			GeeArrayList* _tmp17_;
			_tmp17_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, "super");
		}
		_tmp18_ = self->priv->_modifiers;
		if ((_tmp18_ & SKK_MODIFIER_TYPE_MOD1_MASK) != 0) {
			GeeArrayList* _tmp19_;
			_tmp19_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, "alt");
		}
		_tmp20_ = self->priv->_modifiers;
		if ((_tmp20_ & SKK_MODIFIER_TYPE_LSHIFT_MASK) != 0) {
			GeeArrayList* _tmp21_;
			_tmp21_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, "lshift");
		}
		_tmp22_ = self->priv->_modifiers;
		if ((_tmp22_ & SKK_MODIFIER_TYPE_RSHIFT_MASK) != 0) {
			GeeArrayList* _tmp23_;
			_tmp23_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, "rshift");
		}
		_tmp24_ = self->priv->_modifiers;
		if ((_tmp24_ & SKK_MODIFIER_TYPE_USLEEP_MASK) != 0) {
			GeeArrayList* _tmp25_;
			_tmp25_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, "usleep");
		}
		_tmp26_ = self->priv->_modifiers;
		if ((_tmp26_ & SKK_MODIFIER_TYPE_RELEASE_MASK) != 0) {
			GeeArrayList* _tmp27_;
			_tmp27_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, "release");
		}
		_tmp28_ = elements;
		_tmp29_ = _base;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp29_);
		_tmp30_ = elements;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, NULL);
		_tmp31_ = elements;
		_tmp33_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp31_, &_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp34__length1 = _tmp32_;
		_tmp35_ = g_strjoinv (" ", _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strconcat ("(", _tmp36_, NULL);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strconcat (_tmp38_, ")", NULL);
		_tmp40_ = _tmp39_;
		_g_free0 (_tmp38_);
		_g_free0 (_tmp36_);
		_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
		result = _tmp40_;
		_g_object_unref0 (elements);
		_g_free0 (_base);
		_g_free0 (_tmp0_);
		return result;
	} else {
		result = _base;
		_g_free0 (_tmp0_);
		return result;
	}
	_g_free0 (_base);
	_g_free0 (_tmp0_);
}


/**
         * Compare two key events ignoring modifiers.
         *
         * @param key a KeyEvent
         *
         * @return `true` if those base components are equal, `false` otherwise
         */
gboolean skk_key_event_base_equal (SkkKeyEvent* self, SkkKeyEvent* key) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gunichar _tmp1_;
	SkkKeyEvent* _tmp2_;
	gunichar _tmp3_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp1_ = self->priv->_code;
	_tmp2_ = key;
	_tmp3_ = _tmp2_->priv->_code;
	if (_tmp1_ == _tmp3_) {
		const gchar* _tmp4_;
		SkkKeyEvent* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->_name;
		_tmp5_ = key;
		_tmp6_ = _tmp5_->priv->_name;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp6_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	result = _tmp7_;
	return result;
}


const gchar* skk_key_event_get_name (SkkKeyEvent* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void skk_key_event_set_name (SkkKeyEvent* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


gunichar skk_key_event_get_code (SkkKeyEvent* self) {
	gunichar result;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_code;
	result = _tmp0_;
	return result;
}


static void skk_key_event_set_code (SkkKeyEvent* self, gunichar value) {
	gunichar _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_code = _tmp0_;
	g_object_notify ((GObject *) self, "code");
}


SkkModifierType skk_key_event_get_modifiers (SkkKeyEvent* self) {
	SkkModifierType result;
	SkkModifierType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_modifiers;
	result = _tmp0_;
	return result;
}


void skk_key_event_set_modifiers (SkkKeyEvent* self, SkkModifierType value) {
	SkkModifierType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_modifiers = _tmp0_;
	g_object_notify ((GObject *) self, "modifiers");
}


static void skk_key_event_class_init (SkkKeyEventClass * klass) {
	skk_key_event_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkKeyEventPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_key_event_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_skk_key_event_set_property;
	G_OBJECT_CLASS (klass)->finalize = skk_key_event_finalize;
	/**
	         * The base name of the KeyEvent.
	         *
	         * This is exclusive to {@link code}.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_KEY_EVENT_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * The base code of the KeyEvent.
	         *
	         * This is exclusive to {@link name}.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_KEY_EVENT_CODE, g_param_spec_uint ("code", "code", "code", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Modifier mask.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_KEY_EVENT_MODIFIERS, g_param_spec_enum ("modifiers", "modifiers", "modifiers", SKK_TYPE_MODIFIER_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void skk_key_event_instance_init (SkkKeyEvent * self) {
	self->priv = SKK_KEY_EVENT_GET_PRIVATE (self);
}


static void skk_key_event_finalize (GObject* obj) {
	SkkKeyEvent * self;
	self = SKK_KEY_EVENT (obj);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (skk_key_event_parent_class)->finalize (obj);
}


/**
     * Object representing a key event.
     */
GType skk_key_event_get_type (void) {
	static volatile gsize skk_key_event_type_id__volatile = 0;
	if (g_once_init_enter (&skk_key_event_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkKeyEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_key_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkKeyEvent), 0, (GInstanceInitFunc) skk_key_event_instance_init, NULL };
		GType skk_key_event_type_id;
		skk_key_event_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkKeyEvent", &g_define_type_info, 0);
		g_once_init_leave (&skk_key_event_type_id__volatile, skk_key_event_type_id);
	}
	return skk_key_event_type_id__volatile;
}


static void _vala_skk_key_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SkkKeyEvent * self;
	self = SKK_KEY_EVENT (object);
	switch (property_id) {
		case SKK_KEY_EVENT_NAME:
		g_value_set_string (value, skk_key_event_get_name (self));
		break;
		case SKK_KEY_EVENT_CODE:
		g_value_set_uint (value, skk_key_event_get_code (self));
		break;
		case SKK_KEY_EVENT_MODIFIERS:
		g_value_set_enum (value, skk_key_event_get_modifiers (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_skk_key_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SkkKeyEvent * self;
	self = SKK_KEY_EVENT (object);
	switch (property_id) {
		case SKK_KEY_EVENT_NAME:
		skk_key_event_set_name (self, g_value_get_string (value));
		break;
		case SKK_KEY_EVENT_CODE:
		skk_key_event_set_code (self, g_value_get_uint (value));
		break;
		case SKK_KEY_EVENT_MODIFIERS:
		skk_key_event_set_modifiers (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



