/**
 * @file    ExpectedAttributes.cpp
 * @brief   Implementation of ExpectedAttributes, the class allowing the specification
 *          of attributes to expect.
 * @author  Ben Bornstein
 * 
 * <!--------------------------------------------------------------------------
 * This file is part of libSBML.  Please visit http://sbml.org for more
 * information about SBML, and the latest version of libSBML.
 *
 * Copyright (C) 2009-2011 jointly by the following organizations: 
 *     1. California Institute of Technology, Pasadena, CA, USA
 *     2. EMBL European Bioinformatics Institute (EBML-EBI), Hinxton, UK
 *  
 * Copyright (C) 2006-2008 by the California Institute of Technology,
 *     Pasadena, CA, USA 
 *  
 * Copyright (C) 2002-2005 jointly by the following organizations: 
 *     1. California Institute of Technology, Pasadena, CA, USA
 *     2. Japan Science and Technology Agency, Japan
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.  A copy of the license agreement is provided
 * in the file named "LICENSE.txt" included with this software distribution
 * and also available online as http://sbml.org/software/libsbml/license.html
 * ------------------------------------------------------------------------ -->
 */


#include <sbml/common/sbmlfwd.h>
#include <sbml/common/common.h>
#include <sbml/common/operationReturnValues.h>
#include <sbml/ExpectedAttributes.h>

LIBSBML_CPP_NAMESPACE_BEGIN

/** @cond doxygen-c-only */


LIBSBML_EXTERN 
ExpectedAttributes_t *
ExpectedAttributes_create()
{
  return new ExpectedAttributes();
}

LIBSBML_EXTERN 
ExpectedAttributes_t *
ExpectedAttributes_clone(ExpectedAttributes_t *attr)
{
  if (attr == NULL) return NULL;
  return new ExpectedAttributes(*attr);
}

LIBSBML_EXTERN 
int
ExpectedAttributes_add(ExpectedAttributes_t *attr, const char* attribute)
{
  if (attr == NULL || attribute == NULL) return LIBSBML_INVALID_OBJECT;
  attr->add(std::string(attribute));
  return LIBSBML_OPERATION_SUCCESS;
}

LIBSBML_EXTERN 
char*
ExpectedAttributes_get(ExpectedAttributes_t *attr, unsigned int index)
{
  if (attr == NULL) return NULL;
  return safe_strdup(attr->get(index).c_str());
}

LIBSBML_EXTERN 
int
ExpectedAttributes_hasAttribute(ExpectedAttributes_t *attr, const char* attribute)
{
  if (attr == NULL) return (int)false;
  return attr->hasAttribute(std::string(attribute));
}


/** @endcond */

LIBSBML_CPP_NAMESPACE_END

