/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;


/**
  * Wrapper class for global methods and constants defined by libSBML.
  * <p>
  * <em style='color: #555'>
  * This class of objects is defined by libSBML only and has no direct
  * equivalent in terms of SBML components.  This class is not prescribed by
  * the SBML specifications, although it is used to implement features
  * defined in SBML.
  * </em>
  * <p>
  * In the C++ and C versions of libSBML, there exists a small number of
  * methods that are global in scope; in addition, libSBML uses a number
  * of enum's to define such things as error codes in a way that can be
  * used by both C++ and C.  This poses a problem in languages such as
  * Java, where there is no concept of global method or global constant.
  * SWIG wraps these global identifiers in the class whose documentation
  * you see before you.
  */
public class libsbml implements libsbmlConstants {

	
  /**
   * Downcast a package extension object to its specific package class.
   *
   * This method is used in the implementation of libSBML extensions to
   * support SBML Level&nbsp;3 packages.  It allows an object to be
   * downcast to the actual {@link SBMLExtension} object it is.
   *
   * @param cPtr the the pointer to the object
   * @param owner if <code>true</code>, it indicates the caller will "own"
   * the memory associated with the object and will be responsible for
   * freeing it.
   *
   * @return the {@link SBMLExtension} for the package
   *
   * @internal
   */
  public static SBMLExtension DowncastExtension(long cPtr, boolean owner)
  {		
    if (cPtr == 0) return null;
		
    SBMLExtension ext = new SBMLExtension(cPtr, false);
    String pkgName = ext.getName();


    return new SBMLExtension(cPtr,owner);
  }     
        
  /**
   * SBMLExtension derived classes must override this method
   * @internal
   */
  public static SBasePlugin DowncastSBasePlugin(long cPtr, boolean owner)
  {
    if (cPtr == 0) return null;

    SBasePlugin sbp = new SBasePlugin(cPtr,false);
    String pkgName = sbp.getPackageName();

    SBMLExtension sbmlext = SBMLExtensionRegistry.getInstance().getExtension(pkgName);
    if (sbmlext != null)
    {
      return sbmlext.DowncastSBasePlugin(cPtr,owner);
    }
    return new SBasePlugin(cPtr,owner);
  }

  /**
   * @internal
   */
  public static SBMLNamespaces DowncastSBMLNamespaces(long cPtr, boolean owner)
  {
    if (cPtr == 0) return null;
                
    SBMLNamespaces sbn = new SBMLNamespaces(cPtr, false);
    if (sbn != null)
    {
      XMLNamespaces ns = sbn.getNamespaces();

                              
    }
    return new SBMLNamespaces(cPtr, owner);
  }     
        
  /**
   * Internal method.
   *
   * @internal
   */
  public static SBase DowncastSBase(long cPtr, boolean owner)
  {
    if (cPtr == 0) return null;

    SBase sb = new SBase(cPtr,false);
    String pkgName = sb.getPackageName();
    if (pkgName.equals("core"))
    {
      switch( sb.getTypeCode() )
      {
        case libsbmlConstants.SBML_COMPARTMENT:
          return new Compartment(cPtr, owner);
  
        case libsbmlConstants.SBML_COMPARTMENT_TYPE:
          return new CompartmentType(cPtr, owner);
  
        case libsbmlConstants.SBML_CONSTRAINT:
          return new Constraint(cPtr, owner);
  
        case libsbmlConstants.SBML_DOCUMENT:
          return new SBMLDocument(cPtr, owner);
  
        case libsbmlConstants.SBML_DELAY:
          return new Delay(cPtr, owner);
  
        case libsbmlConstants.SBML_EVENT:
          return new Event(cPtr, owner);

        case libsbmlConstants.SBML_EVENT_ASSIGNMENT:
          return new EventAssignment(cPtr, owner);

        case libsbmlConstants.SBML_FUNCTION_DEFINITION:
          return new FunctionDefinition(cPtr, owner);
  
        case libsbmlConstants.SBML_INITIAL_ASSIGNMENT:
          return new InitialAssignment(cPtr, owner);

        case libsbmlConstants.SBML_KINETIC_LAW:
          return new KineticLaw(cPtr, owner);

        case libsbmlConstants.SBML_LIST_OF:
          String name = sb.getElementName();
          if(name.equals("listOf")){
            return new ListOf(cPtr, owner);
          }
          else if(name.equals("listOfCompartments")){
            return new ListOfCompartments(cPtr, owner);
          }
          else if(name.equals("listOfCompartmentTypes")){
            return new ListOfCompartmentTypes(cPtr, owner);
          }
          else if(name.equals("listOfConstraints")){
            return new ListOfConstraints(cPtr, owner);
          }
          else if(name.equals("listOfEvents")){
            return new ListOfEvents(cPtr, owner);
          }
          else if(name.equals("listOfEventAssignments")){
            return new ListOfEventAssignments(cPtr, owner);
          }
          else if(name.equals("listOfFunctionDefinitions")){
            return new ListOfFunctionDefinitions(cPtr, owner);
          }
          else if(name.equals("listOfInitialAssignments")){
            return new ListOfInitialAssignments(cPtr, owner);
          }
          else if(name.equals("listOfParameters")){
            return new ListOfParameters(cPtr, owner);
          }
          else if(name.equals("listOfLocalParameters")){
            return new ListOfLocalParameters(cPtr, owner);
          }
          else if(name.equals("listOfReactions")){
            return new ListOfReactions(cPtr, owner);
          }
          else if(name.equals("listOfRules")){
            return new ListOfRules(cPtr, owner);
          }
          else if(name.equals("listOfSpecies")){
            return new ListOfSpecies(cPtr, owner);
          }
          else if(name.equals("listOfUnknowns")){
            return new ListOfSpeciesReferences(cPtr, owner);
          }
          else if(name.equals("listOfReactants")){
            return new ListOfSpeciesReferences(cPtr, owner);
          }
          else if(name.equals("listOfProducts")){
            return new ListOfSpeciesReferences(cPtr, owner);
          }
          else if(name.equals("listOfModifiers")){
            return new ListOfSpeciesReferences(cPtr, owner);
          }
          else if(name.equals("listOfSpeciesTypes")){
            return new ListOfSpeciesTypes(cPtr, owner);
          }
          else if(name.equals("listOfUnits")){
            return new ListOfUnits(cPtr, owner);
          }
          else if(name.equals("listOfUnitDefinitions")){
            return new ListOfUnitDefinitions(cPtr, owner);
          }
          return new ListOf(cPtr, owner);

        case libsbmlConstants.SBML_MODEL:
          return new Model(cPtr, owner);

        case libsbmlConstants.SBML_PARAMETER:
          return new Parameter(cPtr, owner);

      case libsbmlConstants.SBML_PRIORITY:
        return new Priority(cPtr, owner);

      case libsbmlConstants.SBML_LOCAL_PARAMETER:
        return new LocalParameter(cPtr, owner);

        case libsbmlConstants.SBML_REACTION:
          return new Reaction(cPtr, owner);

        case libsbmlConstants.SBML_SPECIES:
          return new Species(cPtr, owner);

        case libsbmlConstants.SBML_SPECIES_REFERENCE:
          return new SpeciesReference(cPtr, owner);

        case libsbmlConstants.SBML_MODIFIER_SPECIES_REFERENCE:
          return new ModifierSpeciesReference(cPtr, owner);

        case libsbmlConstants.SBML_SPECIES_TYPE:
          return new SpeciesType(cPtr, owner);

        case libsbmlConstants.SBML_TRIGGER:
          return new Trigger(cPtr, owner);

        case libsbmlConstants.SBML_UNIT_DEFINITION:
          return new UnitDefinition(cPtr, owner);

        case libsbmlConstants.SBML_UNIT:
          return new Unit(cPtr, owner);

        case libsbmlConstants.SBML_ALGEBRAIC_RULE:
          return new AlgebraicRule(cPtr, owner);

        case libsbmlConstants.SBML_ASSIGNMENT_RULE:
          return new AssignmentRule(cPtr, owner);

        case libsbmlConstants.SBML_RATE_RULE:
          return new RateRule(cPtr, owner);

        case libsbmlConstants.SBML_STOICHIOMETRY_MATH:
          return new StoichiometryMath(cPtr, owner);

        default:
          return new SBase(cPtr, owner);
      }
    }
    else
    {
      SBMLExtension sbmlext = SBMLExtensionRegistry.getInstance().getExtension(pkgName);
      if (sbmlext != null)
      {
        return sbmlext.DowncastSBase(cPtr,owner);
      }
    }
    return new SBase(cPtr, owner);
  }


   static String getAbsolutePath(String filename)
   {
     java.io.File file = new java.io.File(filename);
     return file.getAbsolutePath();
   }


  /**
    * Stream handle for low-level C++ standard output stream.
    * <p>
    * A few libSBML methods accept an argument for indicating where to send
    * text string output.  An example is the {@link
    * SBMLDocument#printErrors} method.  However, the methods use C++ style
    * streams and not Java stream objects.  The OStream object class in the
    * libSBML Java interface provides a wrapper for the underlying C++
    * streams.  The present object (cout) is a static final variable that
    * can be used directly from your code.  An example use might be
    * something like this:
    * <p>
    * <div class="fragment"><pre class="fragment">
    * SBMLDocument document = libsbml.readSBML("somefile.xml");
    * if (document.getNumErrors() > 0)
    * {
    *     document.printErrors(libsbml.cout);
    *     println("Please correct the above problems first.");
    *     System.exit(1);
    * }</div>
    *
    * @see #cerr
    * @see #clog
    */
  public final static OStream cout;


  /**
    * Stream handle for low-level C++ standard error stream.
    * <p>
    * A few libSBML methods accept an argument for indicating where to send
    * text string output.  An example is the {@link
    * SBMLDocument#printErrors} method.  However, the methods use C++ style
    * streams and not Java stream objects.  The OStream object class in the
    * libSBML Java interface provides a wrapper for the underlying C++
    * streams.  The present object (cerr) is a static final variable that
    * can be used directly from your code.  An example use might be
    * something like this:
    * <p>
    * <div class="fragment"><pre class="fragment">
    * SBMLDocument document = libsbml.readSBML("somefile.xml");
    * if (document.getNumErrors() > 0)
    * {
    *     document.printErrors(libsbml.cerr);
    *     println("Please correct the above problems first.");
    *     System.exit(1);
    * }</div>
    * <p>
    * By default, most operating systems have have their standard error and
    * logging output streams directed to the console/terminal, and this is
    * where text messages will be shown.  This can usually be redirected
    * elsewhere, although how to do this depends on the specific environment
    * where the program is running.
    *
    * @see #cout
    * @see #clog
    */
  public final static OStream cerr;


  /**
    * Stream handle for low-level C++ standard logging stream.
    * <p>
    * A few libSBML methods accept an argument for indicating where to send
    * text string output.  An example is the {@link
    * SBMLDocument#printErrors} method.  However, the methods use C++ style
    * streams and not Java stream objects.  The OStream object class in the
    * libSBML Java interface provides a wrapper for the underlying C++
    * streams.  The present object (clog) is a static final variable that
    * can be used directly from your code.  An example use might be
    * something like this:
    * <p>
    * <div class="fragment"><pre class="fragment">
    * SBMLDocument document = libsbml.readSBML("somefile.xml");
    * if (document.getNumErrors() > 0)
    * {
    *     document.printErrors(libsbml.clog);
    *     println("Please correct the above problems first.");
    *     System.exit(1);
    * }</div>
    * <p>
    * By default, most operating systems have have their standard error and
    * logging output streams directed to the console/terminal, and this is
    * where text messages will be shown.  This can usually be redirected
    * elsewhere, although how to do this depends on the specific environment
    * where the program is running.
    *
    * @see #cout
    * @see #cerr
    */
  public final static OStream clog;

  static {
    cout = new OStream(OStream.COUT); 
    cerr = new OStream(OStream.CERR); 
    clog = new OStream(OStream.CLOG); 
  }

  /**
   * This private constructor does nothing and never invoked.
   * The purpose of this constuctor is to hide a default constructor of this 
   * class in javadoc documentation.
   */
  private libsbml() {}


  
/**
 * Returns the version number of this copy of libSBML as an integer.
 * <p>
 * @return the libSBML version as an integer; version 1.2.3 becomes 10203.
 */
 public static int getLibSBMLVersion() {
    return libsbmlJNI.getLibSBMLVersion();
  }

  
/**
 * Returns the version number of this copy of libSBML as a string.
 * <p>
 * @return the libSBML version as a string; version 1.2.3 becomes
 * '1.2.3'.
 * <p>
 * @see #getLibSBMLVersionString()
 */
 public static String getLibSBMLDottedVersion() {
    return libsbmlJNI.getLibSBMLDottedVersion();
  }

  
/**
 * Returns the version number of this copy of libSBML as a string without
 * periods.
 * <p>
 * @return the libSBML version as a string: version 1.2.3 becomes '10203'.
 * <p>
 * @see #getLibSBMLDottedVersion()
 */
 public static String getLibSBMLVersionString() {
    return libsbmlJNI.getLibSBMLVersionString();
  }

  
/**
 * Reads an SBML document from the given file <code>filename</code>.
 * <p>
 * If <code>filename</code> does not exist, or it is not an SBML file, an error will
 * be logged in the error log of the {@link SBMLDocument} object returned by this
 * method.  Calling programs can inspect this error log to determine
 * the nature of the problem.  Please refer to the definition of
 * {@link SBMLDocument} for more information about the error reporting mechanism.
 * <p>
 * @return a pointer to the {@link SBMLDocument} read.
 */
 public static SBMLDocument readSBML(String filename) {
    long cPtr = libsbmlJNI.readSBML(libsbml.getAbsolutePath(filename));
    return (cPtr == 0) ? null : new SBMLDocument(cPtr, true);
  }

  
/**
 * Reads an SBML document from the given file <code>filename</code>.
 * <p>
 * If <code>filename</code> does not exist, or it is not an SBML file, an error will
 * be logged in the error log of the {@link SBMLDocument} object returned by this
 * method.  Calling programs can inspect this error log to determine
 * the nature of the problem.  Please refer to the definition of
 * {@link SBMLDocument} for more information about the error reporting mechanism.
 * <p>
 * @return a pointer to the {@link SBMLDocument} read.
 */
 public static SBMLDocument readSBMLFromFile(String filename) {
    long cPtr = libsbmlJNI.readSBMLFromFile(libsbml.getAbsolutePath(filename));
    return (cPtr == 0) ? null : new SBMLDocument(cPtr, true);
  }

  
/**
 * Reads an SBML document from a string assumed to be in XML format.
 * <p>
 * If the string does not begin with XML declaration,
 *<div class='fragment'><pre>
&lt;?xml version='1.0' encoding='UTF-8'?&gt;
</pre></div>
 * <p>
 * an XML declaration string will be prepended.
 * <p>
 * This method will report an error if the given string <code>xml</code> is not SBML.
 * The error will be logged in the error log of the {@link SBMLDocument} object
 * returned by this method.  Calling programs can inspect this error log to
 * determine the nature of the problem.  Please refer to the definition of
 * {@link SBMLDocument} for more information about the error reporting mechanism.
 * <p>
 * @return a pointer to the {@link SBMLDocument} read.
 */
 public static SBMLDocument readSBMLFromString(String xml) {
    long cPtr = libsbmlJNI.readSBMLFromString(xml);
    return (cPtr == 0) ? null : new SBMLDocument(cPtr, true);
  }

  
/**
 * Writes the given SBML document <code>d</code> to the file named by <code>filename</code>.
 * <p>
 * This function is identical to <a href='#writeSBMLToFile(org.sbml.{@link libsbml}.SBMLDocument, java.lang.String)'><code>writeSBMLToFile(SBMLDocument d, String filename)</code></a>.
 * <p>
 * If the given filename ends with the suffix <code>&quot;.gz&quot;</code>
(for example, <code>&quot;myfile.xml.gz&quot;</code>), libSBML assumes the
caller wants the file to be written compressed in <em>gzip</em> format.
Similarly, if the given filename ends with <code>&quot;.zip&quot;</code> or
<code>&quot;.bz2&quot;</code>, libSBML assumes the caller wants the file to
be compressed in <em>zip</em> or <em>bzip2</em> format (respectively).
Files whose names lack these suffixes will be written uncompressed.
<em>Special considerations for the zip format</em>: If the given filename
ends with <code>&quot;.zip&quot;</code>, the file placed in the zip archive
will have the suffix <code>&quot;.xml&quot;</code> or
<code>&quot;.sbml&quot;</code>.  For example, the file in the zip archive
will be named <code>&quot;test.xml&quot;</code> if the given filename is
<code>&quot;test.xml.zip&quot;</code> or <code>&quot;test.zip&quot;</code>.
Similarly, the filename in the archive will be
<code>&quot;test.sbml&quot;</code> if the given filename is
<code>&quot;test.sbml.zip&quot;</code>.

 * <p>
 * @param d the {@link SBMLDocument} object to be written out in XML format
 * <p>
 * @param filename a string giving the path to a file where the XML
 * content is to be written.
 * <p>
 * @return <code>1</code> on success and <code>0</code> (zero) if <code>filename</code> could not be
 * written.  Some possible reasons for failure include (a) being unable to
 * open the file, and (b) using a filename that indicates a compressed SBML
 * file (i.e., a filename ending in <code>&quot;.zip&quot;</code> or
 * similar) when the compression functionality has not been enabled in
 * the underlying copy of libSBML.
 * <p>
 * <p>
 * <p>
 * @see SBMLWriter#hasZlib()
 * @see SBMLWriter#hasBzip2()
 */
 public static int writeSBML(SBMLDocument d, String filename) {
    return libsbmlJNI.writeSBML(SBMLDocument.getCPtr(d), d, libsbml.getAbsolutePath(filename));
  }

  
/**
 * Writes the given SBML document <code>d</code> to an in-memory string and
 * returns the string.
 * <p>
 * This is a convenience function that uses the
 * {@link SBMLWriter#writeSBMLToString(SBMLDocument d)} method internally,
 * yet does not require the caller to create an {@link SBMLWriter} object first.
 * <p>
 * @param d an {@link SBMLDocument} object to be written out in XML format
 * <p>
 * @return the string on success and <code>null</code> if one of the underlying parser
 * components fail.
 * <p>
 * <p>
 */
 public static String writeSBMLToString(SBMLDocument d) {
    return libsbmlJNI.writeSBMLToString(SBMLDocument.getCPtr(d), d);
  }

  
/**
 * Writes the given SBML document <code>d</code> to the file <code>filename</code>.
 * <p>
 * This is a convenience function that uses the
 * {@link SBMLWriter#writeSBMLToFile(SBMLDocument d, String
 * filename)} method internally, yet does not require the caller to create
 * an {@link SBMLWriter} object first.
 * <p>
 * If the given filename ends with the suffix <code>&quot;.gz&quot;</code>
(for example, <code>&quot;myfile.xml.gz&quot;</code>), libSBML assumes the
caller wants the file to be written compressed in <em>gzip</em> format.
Similarly, if the given filename ends with <code>&quot;.zip&quot;</code> or
<code>&quot;.bz2&quot;</code>, libSBML assumes the caller wants the file to
be compressed in <em>zip</em> or <em>bzip2</em> format (respectively).
Files whose names lack these suffixes will be written uncompressed.
<em>Special considerations for the zip format</em>: If the given filename
ends with <code>&quot;.zip&quot;</code>, the file placed in the zip archive
will have the suffix <code>&quot;.xml&quot;</code> or
<code>&quot;.sbml&quot;</code>.  For example, the file in the zip archive
will be named <code>&quot;test.xml&quot;</code> if the given filename is
<code>&quot;test.xml.zip&quot;</code> or <code>&quot;test.zip&quot;</code>.
Similarly, the filename in the archive will be
<code>&quot;test.sbml&quot;</code> if the given filename is
<code>&quot;test.sbml.zip&quot;</code>.

 * <p>
 * @param d an {@link SBMLDocument} object to be written out in XML format
 * <p>
 * @param filename a string giving the path to a file where the XML
 * content is to be written.
 * <p>
 * @return <code>1</code> on success and <code>0</code> (zero) if <code>filename</code> could not be
 * written.  Some possible reasons for failure include (a) being unable to
 * open the file, and (b) using a filename that indicates a compressed SBML
 * file (i.e., a filename ending in <code>&quot;.zip&quot;</code> or
 * similar) when the compression functionality has not been enabled in
 * the underlying copy of libSBML.
 * <p>
 * <p>
 * <p>
 * @see SBMLWriter#hasZlib()
 * @see SBMLWriter#hasBzip2()
 */
 public static int writeSBMLToFile(SBMLDocument d, String filename) {
    return libsbmlJNI.writeSBMLToFile(SBMLDocument.getCPtr(d), d, libsbml.getAbsolutePath(filename));
  }

  
/**
 * This method takes an SBML type code and returns a string representing
 * the code.
 * <p>
 * LibSBML attaches an identifying code to every
 * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
 * other languages, the set of type codes is stored in an enumeration; in
 * the Java language interface for libSBML, the type codes are defined as
 * static integer constants in the interface class {@link
 * libsbmlConstants}.  The names of the type codes all begin with the
 * characters <code>SBML_.</code> 
 * <p>
 * @return a human readable name for the given
 * SBML type code.
 * <p>
 * @note The caller does not own the returned string and is therefore not
 * allowed to modify it.
 */
 public static String SBMLTypeCode_toString(int tc, String pkgName) {
    return libsbmlJNI.SBMLTypeCode_toString(tc, pkgName);
  }

  
/**
 * Tests for logical equality between two given <code>UNIT_KIND_</code>
 * code values.
 * <p>
 * This function behaves exactly like C's <code>==</code> operator, except
 * for the following two cases:
 * <ul>
 * <li>{@link  libsbmlConstants#UNIT_KIND_LITER UNIT_KIND_LITER} <code>==</code> {@link  libsbmlConstants#UNIT_KIND_LITRE UNIT_KIND_LITRE}
 * <li>{@link  libsbmlConstants#UNIT_KIND_METER UNIT_KIND_METER} <code>==</code> {@link  libsbmlConstants#UNIT_KIND_METRE UNIT_KIND_METRE}
 * </ul>
 * <p>
 * In the two cases above, C equality comparison would yield <code>false</code>
 * (because each of the above is a distinct enumeration value), but
 * this function returns <code>true.</code>
 * <p>
 * @param uk1 a <code>UNIT_KIND_</code> value 
 * @param uk2 a second <code>UNIT_KIND_</code> value to compare to <code>uk1</code>
 * <p>
 * @return nonzero (for <code>true</code>) if <code>uk1</code> is logically equivalent to 
 * <code>uk2</code>, zero (for <code>false</code>) otherwise.
 * <p>
 * @note For more information about the libSBML unit codes, please refer to
 * the class documentation for {@link Unit}.
 */
 public static int UnitKind_equals(int uk1, int uk2) {
    return libsbmlJNI.UnitKind_equals(uk1, uk2);
  }

  
/**
 * Converts a text string naming a kind of unit to its corresponding
 * libSBML <code>UNIT_KIND_</code> constant/enumeration value.
 * <p>
 * @param name a string, the name of a predefined base unit in SBML
 * <p>
 * @return a value the set of <code>UNIT_KIND_</code> codes
 * defined in class {@link libsbmlConstants}, corresponding to the string
 * <code>name</code> (determined in a case-insensitive manner).
 * <p>
 * @note For more information about the libSBML unit codes, please refer to
 * the class documentation for {@link Unit}.
 */
 public static int UnitKind_forName(String name) {
    return libsbmlJNI.UnitKind_forName(name);
  }

  
/**
 * Converts a unit code to a text string equivalent.
 * <p>
 * @param uk a value from the set of <code>UNIT_KIND_</code> codes
 * defined in the class {@link libsbmlConstants}
 * <p>
 * <p>
 * @return the name corresponding to the given unit code.
 * <p>
 * @note For more information about the libSBML unit codes, please refer to
 * the class documentation for {@link Unit}.
 * <p>
 * @warning The string returned is a static data value.  The caller does not
 * own the returned string and is therefore not allowed to modify it.
 */
 public static String UnitKind_toString(int uk) {
    return libsbmlJNI.UnitKind_toString(uk);
  }

  
/**
 * Predicate for testing whether a given string corresponds to a
 * predefined libSBML unit code.
 * <p>
 * @param str a text string naming a base unit defined by SBML
 * @param level the Level of SBML
 * @param version the Version within the Level of SBML
 * <p>
 * @return nonzero (for <code>true</code>) if string is the name of a valid
 * <code>UNIT_KIND_</code> value, zero (for <code>false</code>) otherwise.
 * <p>
 * @note For more information about the libSBML unit codes, please refer to
 * the class documentation for {@link Unit}.
 */
 public static int UnitKind_isValidUnitKindString(String str, long level, long version) {
    return libsbmlJNI.UnitKind_isValidUnitKindString(str, level, version);
  }

  
/**
 * Reads the MathML from the given XML string, constructs a corresponding
 * abstract syntax tree, and returns a pointer to the root of the tree.
 * <p>
 * @param xml a string containing a full MathML expression
 * <p>
 * @return the root of an AST corresponding to the given mathematical
 * expression, otherwise <code>null</code> is returned if the given string is <code>null</code>
 * or invalid.
 */
 public static ASTNode readMathMLFromString(String xml) {
    long cPtr = libsbmlJNI.readMathMLFromString(xml);
    return (cPtr == 0) ? null : new ASTNode(cPtr, true);
  }

  
/**
 * Writes the given {@link ASTNode} (and its children) to a string as MathML, and
 * returns the string.
 * <p>
 * @param node the root of an AST to write out to the stream.
 * <p>
 * @return a string containing the written-out MathML representation
 * of the given AST.
 * <p>
 * @note The string is owned by the caller and should be freed (with
 * free()) when no longer needed.  <code>null</code> is returned if the given
 * argument is <code>null.</code>
 */
 public static String writeMathMLToString(ASTNode node) {
    return libsbmlJNI.writeMathMLToString(ASTNode.getCPtr(node), node);
  }

  
/**
 * Parses the given SBML formula and returns a representation of it as an
 * Abstract Syntax Tree (AST).
 * <p>
 * The text-string form of mathematical formulas produced by <code><a
 * href='{@link libsbml}.html'>{@link libsbml}.formulaToString()</a></code> and read by
 * <code><a href='{@link libsbml}.html'>{@link libsbml}.parseFormula()</a></code> are
 * simple C-inspired infix notation taken from SBML Level&nbsp;1.  A
 * formula in this text-string form therefore can be handed to a program
 * that understands SBML Level&nbsp;1 mathematical expressions, or used as
 * part of a formula translation system.  The syntax is described in detail
 * in the documentation for {@link ASTNode}.  
 * <p>
 * This returns the root node of the AST corresponding to the formula.  If
 * the formula contains a syntax error, <code>null</code> is returned instead.
 * <p>
 * Note that this facility is provided as a convenience by libSBML&mdash;the
 * MathML standard does not actually define a 'string-form' equivalent to
 * MathML expression trees, so the choice of formula syntax is somewhat
 * arbitrary.  The approach taken by libSBML is to use the syntax defined by
 * SBML Level&nbsp;1 (which in fact used a text-string representation of
 * formulas and not MathML).  This formula syntax is based mostly on C
 * programming syntax, and may contain operators, function calls, symbols,
 * and white space characters.  The following table provides the precedence
 * rules for the different entities that may appear in formula strings.
 * <p>
 * <center style='padding-bottom: 0.5em'>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
 <tr style='background: lightgray; font-size: 14px;'>
     <th align='left'>Token</th>
     <th align='left'>Operation</th>
     <th align='left'>Class</th>
     <th>Precedence</th>
     <th align='left'>Associates</th>
 </tr>
<tr><td><em>name</em></td><td>symbol reference</td><td>operand</td><td align='center'>6</td><td>n/a</td></tr>
<tr><td><code>(</code><em>expression</em><code>)</code></td><td>expression grouping</td><td>operand</td><td align='center'>6</td><td>n/a</td></tr>
<tr><td><code>f(</code><em>...</em><code>)</code></td><td>function call</td><td>prefix</td><td align='center'>6</td><td>left</td></tr>
<tr><td><code>-</code></td><td>negation</td><td>unary</td><td align='center'>5</td><td>right</td></tr>
<tr><td><code>^</code></td><td>power</td><td>binary</td><td align='center'>4</td><td>left</td></tr>
<tr><td><code>*</code></td><td>multiplication</td><td>binary</td><td align='center'>3</td><td>left</td></tr>
<tr><td><code>/</code></td><td>divison</td><td>binary</td><td align='center'>3</td><td>left</td></tr>
<tr><td><code>+</code></td><td>addition</td><td>binary</td><td align='center'>2</td><td>left</td></tr>
<tr><td><code>-</code></td><td>subtraction</td><td>binary</td><td align='center'>2</td><td>left</td></tr>
<tr><td><code>,</code></td><td>argument delimiter</td><td>binary</td><td align='center'>1</td><td>left</td></tr>
<caption class='top-caption'>A table of the expression operators and their precedence in the
text-string format for mathematical expressions used by SBML_parseFormula().
</caption>
</table>
</center>

 * <p>
 * In the table above, <em>operand</em> implies the construct is an operand, 
 * <em>prefix</em> implies the operation is applied to the following arguments, 
 * <em>unary</em> implies there is one argument, and <em>binary</em> implies there are
 * two arguments.  The values in the <b>Precedence</b> column show how the
 * order of different types of operation are determined.  For example, the
 * expression <code>a * b + c</code> is evaluated as <code>(a * b) +
 * c</code> because the @c * operator has higher precedence.  The
 * <b>Associates</b> column shows how the order of similar precedence
 * operations is determined; for example, <code>a - b + c</code> is
 * evaluated as <code>(a - b) + c</code> because the <code>+</code> and <code>-</code>
 * operators are left-associative.
 * <p>
 * The function call syntax consists of a function name, followed by optional
 * white space, followed by an opening parenthesis token, followed by a
 * sequence of zero or more arguments separated by commas (with each comma
 * optionally preceded and/or followed by zero or more white space
 * characters, followed by a closing parenthesis token.  The function name
 * must be chosen from one of the pre-defined functions in SBML or a
 * user-defined function in the model.  The following table lists the names
 * of certain common mathematical functions; this table corresponds to
 * Table&nbsp;6 in the <a target='_blank' href='http://sbml.org/Documents/Specifications#SBML_Level_1_Version_2'>SBML Level&nbsp;1 Version&nbsp;2 specification</a>:
 * <p>
 * <center>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
 <tr>
     <th align='left' width='60'>Name</th>
     <th align='left' width='35'>Args</th>
     <th align='left'>Formula or meaning</th>
     <th align='left' width='110'>Argument Constraints</th>
     <th align='left' width='100'>Result constraints</th>
 </tr>
<tr><td><code>abs</code></td><td><em>x</em></td><td>absolute value of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>acos</code></td><td><em>x</em></td><td>arc cosine of <em>x</em> in radians</td><td>-1.0 &le; <em>x</em> &le; 1.0</td><td>0 &le; <em>acos(x)</em> &le; &pi;</td></tr>
<tr><td><code>asin</code></td><td><em>x</em></td><td>arc sine of <em>x</em> in radians</td><td>-1.0 &le; <em>x</em> &le; 1.0</td><td>0 &le; <em>asin(x)</em> &le; &pi;</td></tr>
<tr><td><code>atan</code></td><td><em>x</em></td><td>arc tangent of <em>x</em> in radians</td><td></td><td>0 &le; <em>atan(x)</em> &le; &pi;</td></tr>
<tr><td><code>ceil</code></td><td><em>x</em></td><td>smallest number not less than <em>x</em> whose value is an exact integer</td><td></td><td></td></tr>
<tr><td><code>cos</code></td><td><em>x</em></td><td>cosine of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>exp</code></td><td><em>x</em></td><td><em>e</em><sup><em> x</em></sup>, where <em>e</em> is the base of the natural logarithm</td><td></td><td></td></tr>
<tr><td><code>floor</code></td><td><em>x</em></td><td>the largest number not greater than <em>x</em> whose value is an exact integer</td><td></td><td></td></tr>
<tr><td><code>log</code></td><td><em>x</em></td><td>natural logarithm of <em>x</em></td><td><em>x</em> &gt; 0</td><td></td></tr>
<tr><td><code>log10</code></td><td><em>x</em></td><td>base 10 logarithm of <em>x</em></td><td><em>x</em> &gt; 0</td><td></td></tr>
<tr><td><code>pow</code></td><td><em>x, y</em></td><td><em>x</em><sup><em> y</em></sup></td><td></td><td></td></tr>
<tr><td><code>sqr</code></td><td><em>x</em></td><td><em>x</em><sup><em>2</em></sup></td><td></td><td></td></tr>
<tr><td><code>sqrt</code></td><td><em>x</em></td><td>&radic;<em>x</em></td><td><em>x</em> &gt; 0</td><td><em>sqrt(x)</em> &ge; 0</td></tr>
<tr><td><code>sin</code></td><td><em>x</em></td><td>sine of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>tan</code></td><td><em>x</em></td><td>tangent of <em>x</em></td><td>x &ne; n*&pi;/2, for odd integer <em>n</em></td><td></td></tr>
<caption class='bottom-caption'>The names of mathematical functions defined in the SBML
Level&nbsp;1 Version&nbsp;2 text-string formula syntax.</caption>
</table>
</center>

 * <p>
 * @warning There are differences between the symbols used to represent the
 * common mathematical functions and the corresponding MathML token names.
 * This is a potential source of incompatibilities.  Note in particular that
 * in this text-string syntax, <code>log(x)</code> represents the natural
 * logarithm, whereas in MathML, the natural logarithm is
 * <code>&lt;ln/&gt;</code>.  Application writers are urged to be careful
 * when translating between text forms and MathML forms, especially if they
 * provide a direct text-string input facility to users of their software
 * systems.<br><br>
 * We urge developers to keep in mind that the text-string formula syntax is
specific to SBML Level&nbsp;1's C-like mathematical formula syntax.  In
particular, it is <em>not a general-purpose mathematical expression
syntax</em>.  LibSBML provides methods for parsing and transforming
text-string math formulas back and forth from AST structures, but it is
important to keep the system's limitations in mind.

 * <p>
 * @param formula the text-string formula expression to be parsed
 * <p>
 * @return the root node of the AST, or null if an error occurred in
 * parsing the formula
 * <p>
 * <p>
 * <p>
 * @see #formulaToString(ASTNode tree)
 */
 public static ASTNode parseFormula(String formula) {
    long cPtr = libsbmlJNI.parseFormula(formula);
    return (cPtr == 0) ? null : new ASTNode(cPtr, true);
  }

  
/**
 * Converts an AST to a string representation of a formula using a syntax
 * basically derived from SBML Level&nbsp;1.
 * <p>
 * The text-string form of mathematical formulas produced by <code><a
 * href='{@link libsbml}.html#formulaToString(org.sbml.{@link libsbml}.ASTNode)'>
 * {@link libsbml}.formulaToString()</a></code> and read by <code><a
 * href='{@link libsbml}.html#parseFormula(java.lang.String)'>
 * {@link libsbml}.parseFormula()</a></code> are simple C-inspired infix notation
 * taken from SBML Level&nbsp;1.  A formula in this text-string form
 * therefore can be handed to a program that understands SBML Level&nbsp;1
 * mathematical expressions, or used as part of a formula translation
 * system.  The syntax is described in detail in the documentation for
 * {@link ASTNode}.  
 * <p>
 * Note that this facility is provided as a convenience by libSBML&mdash;the
 * MathML standard does not actually define a 'string-form' equivalent to
 * MathML expression trees, so the choice of formula syntax is somewhat
 * arbitrary.  The approach taken by libSBML is to use the syntax defined by
 * SBML Level&nbsp;1 (which in fact used a text-string representation of
 * formulas and not MathML).  This formula syntax is based mostly on C
 * programming syntax, and may contain operators, function calls, symbols,
 * and white space characters.  The following table provides the precedence
 * rules for the different entities that may appear in formula strings.
 * <p>
 * <center style='padding-bottom: 0.5em'>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
 <tr style='background: lightgray; font-size: 14px;'>
     <th align='left'>Token</th>
     <th align='left'>Operation</th>
     <th align='left'>Class</th>
     <th>Precedence</th>
     <th align='left'>Associates</th>
 </tr>
<tr><td><em>name</em></td><td>symbol reference</td><td>operand</td><td align='center'>6</td><td>n/a</td></tr>
<tr><td><code>(</code><em>expression</em><code>)</code></td><td>expression grouping</td><td>operand</td><td align='center'>6</td><td>n/a</td></tr>
<tr><td><code>f(</code><em>...</em><code>)</code></td><td>function call</td><td>prefix</td><td align='center'>6</td><td>left</td></tr>
<tr><td><code>-</code></td><td>negation</td><td>unary</td><td align='center'>5</td><td>right</td></tr>
<tr><td><code>^</code></td><td>power</td><td>binary</td><td align='center'>4</td><td>left</td></tr>
<tr><td><code>*</code></td><td>multiplication</td><td>binary</td><td align='center'>3</td><td>left</td></tr>
<tr><td><code>/</code></td><td>divison</td><td>binary</td><td align='center'>3</td><td>left</td></tr>
<tr><td><code>+</code></td><td>addition</td><td>binary</td><td align='center'>2</td><td>left</td></tr>
<tr><td><code>-</code></td><td>subtraction</td><td>binary</td><td align='center'>2</td><td>left</td></tr>
<tr><td><code>,</code></td><td>argument delimiter</td><td>binary</td><td align='center'>1</td><td>left</td></tr>
<caption class='top-caption'>A table of the expression operators and their precedence in the
text-string format for mathematical expressions used by SBML_parseFormula().
</caption>
</table>
</center>

 * <p>
 * In the table above, <em>operand</em> implies the construct is an operand, 
 * <em>prefix</em> implies the operation is applied to the following arguments, 
 * <em>unary</em> implies there is one argument, and <em>binary</em> implies there are
 * two arguments.  The values in the <b>Precedence</b> column show how the
 * order of different types of operation are determined.  For example, the
 * expression <code>a * b + c</code> is evaluated as <code>(a * b) +
 * c</code> because the @c * operator has higher precedence.  The
 * <b>Associates</b> column shows how the order of similar precedence
 * operations is determined; for example, <code>a - b + c</code> is
 * evaluated as <code>(a - b) + c</code> because the <code>+</code> and <code>-</code>
 * operators are left-associative.
 * <p>
 * The function call syntax consists of a function name, followed by optional
 * white space, followed by an opening parenthesis token, followed by a
 * sequence of zero or more arguments separated by commas (with each comma
 * optionally preceded and/or followed by zero or more white space
 * characters, followed by a closing parenthesis token.  The function name
 * must be chosen from one of the pre-defined functions in SBML or a
 * user-defined function in the model.  The following table lists the names
 * of certain common mathematical functions; this table corresponds to
 * Table&nbsp;6 in the <a target='_blank' href='http://sbml.org/Documents/Specifications#SBML_Level_1_Version_2'>SBML Level&nbsp;1 Version&nbsp;2 specification</a>:
 * <p>
 * <center>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
 <tr>
     <th align='left' width='60'>Name</th>
     <th align='left' width='35'>Args</th>
     <th align='left'>Formula or meaning</th>
     <th align='left' width='110'>Argument Constraints</th>
     <th align='left' width='100'>Result constraints</th>
 </tr>
<tr><td><code>abs</code></td><td><em>x</em></td><td>absolute value of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>acos</code></td><td><em>x</em></td><td>arc cosine of <em>x</em> in radians</td><td>-1.0 &le; <em>x</em> &le; 1.0</td><td>0 &le; <em>acos(x)</em> &le; &pi;</td></tr>
<tr><td><code>asin</code></td><td><em>x</em></td><td>arc sine of <em>x</em> in radians</td><td>-1.0 &le; <em>x</em> &le; 1.0</td><td>0 &le; <em>asin(x)</em> &le; &pi;</td></tr>
<tr><td><code>atan</code></td><td><em>x</em></td><td>arc tangent of <em>x</em> in radians</td><td></td><td>0 &le; <em>atan(x)</em> &le; &pi;</td></tr>
<tr><td><code>ceil</code></td><td><em>x</em></td><td>smallest number not less than <em>x</em> whose value is an exact integer</td><td></td><td></td></tr>
<tr><td><code>cos</code></td><td><em>x</em></td><td>cosine of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>exp</code></td><td><em>x</em></td><td><em>e</em><sup><em> x</em></sup>, where <em>e</em> is the base of the natural logarithm</td><td></td><td></td></tr>
<tr><td><code>floor</code></td><td><em>x</em></td><td>the largest number not greater than <em>x</em> whose value is an exact integer</td><td></td><td></td></tr>
<tr><td><code>log</code></td><td><em>x</em></td><td>natural logarithm of <em>x</em></td><td><em>x</em> &gt; 0</td><td></td></tr>
<tr><td><code>log10</code></td><td><em>x</em></td><td>base 10 logarithm of <em>x</em></td><td><em>x</em> &gt; 0</td><td></td></tr>
<tr><td><code>pow</code></td><td><em>x, y</em></td><td><em>x</em><sup><em> y</em></sup></td><td></td><td></td></tr>
<tr><td><code>sqr</code></td><td><em>x</em></td><td><em>x</em><sup><em>2</em></sup></td><td></td><td></td></tr>
<tr><td><code>sqrt</code></td><td><em>x</em></td><td>&radic;<em>x</em></td><td><em>x</em> &gt; 0</td><td><em>sqrt(x)</em> &ge; 0</td></tr>
<tr><td><code>sin</code></td><td><em>x</em></td><td>sine of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>tan</code></td><td><em>x</em></td><td>tangent of <em>x</em></td><td>x &ne; n*&pi;/2, for odd integer <em>n</em></td><td></td></tr>
<caption class='bottom-caption'>The names of mathematical functions defined in the SBML
Level&nbsp;1 Version&nbsp;2 text-string formula syntax.</caption>
</table>
</center>

 * <p>
 * @warning There are differences between the symbols used to represent the
 * common mathematical functions and the corresponding MathML token names.
 * This is a potential source of incompatibilities.  Note in particular that
 * in this text-string syntax, <code>log(x)</code> represents the natural
 * logarithm, whereas in MathML, the natural logarithm is
 * <code>&lt;ln/&gt;</code>.  Application writers are urged to be careful
 * when translating between text forms and MathML forms, especially if they
 * provide a direct text-string input facility to users of their software
 * systems.<br><br>
 * We urge developers to keep in mind that the text-string formula syntax is
specific to SBML Level&nbsp;1's C-like mathematical formula syntax.  In
particular, it is <em>not a general-purpose mathematical expression
syntax</em>.  LibSBML provides methods for parsing and transforming
text-string math formulas back and forth from AST structures, but it is
important to keep the system's limitations in mind.

 * <p>
 * @param tree the AST to be converted.
 * <p>
 * @return the formula from the given AST as an SBML Level 1 text-string
 * mathematical formula.  The caller owns the returned string and is
 * responsible for freeing it when it is no longer needed.
 * <p>
 * <p>
 * <p>
 * @see #parseFormula(java.lang.String)
 */
 public static String formulaToString(ASTNode tree) {
    return libsbmlJNI.formulaToString(ASTNode.getCPtr(tree), tree);
  }

}
