/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * @internal 
 */
public class XMLInputStream {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected XMLInputStream(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(XMLInputStream obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (XMLInputStream obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_XMLInputStream(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  
  /**
   * Creates a new XMLInputStream.
   * <p>
   * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
 
   * @internal
   */
 public XMLInputStream(String content, boolean isFile, String library, XMLErrorLog errorLog) {
    this(libsbmlJNI.new_XMLInputStream__SWIG_0(content, isFile, library, XMLErrorLog.getCPtr(errorLog), errorLog), true);
  }

  
  /**
   * Creates a new XMLInputStream.
   * <p>
   * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
 
   * @internal
   */
 public XMLInputStream(String content, boolean isFile, String library) {
    this(libsbmlJNI.new_XMLInputStream__SWIG_1(content, isFile, library), true);
  }

  
  /**
   * Creates a new XMLInputStream.
   * <p>
   * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
 
   * @internal
   */
 public XMLInputStream(String content, boolean isFile) {
    this(libsbmlJNI.new_XMLInputStream__SWIG_2(content, isFile), true);
  }

  
  /**
   * Creates a new XMLInputStream.
   * <p>
   * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
 
   * @internal
   */
 public XMLInputStream(String content) {
    this(libsbmlJNI.new_XMLInputStream__SWIG_3(content), true);
  }

  
  /**
   * @return the encoding of the XML stream.
   * @internal
   */
 public String getEncoding() {
    return libsbmlJNI.XMLInputStream_getEncoding(swigCPtr, this);
  }

  
  /**
   * @return the version of the XML stream.
   * @internal
   */
 public String getVersion() {
    return libsbmlJNI.XMLInputStream_getVersion(swigCPtr, this);
  }

  
  /**
   * @return an {@link XMLErrorLog} which can be used to log XML parse errors and
   * other validation errors (and messages).
   * @internal
   */
 public XMLErrorLog getErrorLog() {
    long cPtr = libsbmlJNI.XMLInputStream_getErrorLog(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLErrorLog(cPtr, false);
  }

  
  /**
   * @return true if end of file (stream) has been reached, false
   * otherwise.
   * @internal
   */
 public boolean isEOF() {
    return libsbmlJNI.XMLInputStream_isEOF(swigCPtr, this);
  }

  
  /**
   * @return true if a fatal error occurred while reading from this stream.
   * @internal
   */
 public boolean isError() {
    return libsbmlJNI.XMLInputStream_isError(swigCPtr, this);
  }

  
  /**
   * @return true if the stream is in a good state (i.e. isEOF() and
   * isError() are both false), false otherwise.
   * @internal
   */
 public boolean isGood() {
    return libsbmlJNI.XMLInputStream_isGood(swigCPtr, this);
  }

  
  /**
   * Consumes the next {@link XMLToken} and return it.
   * <p>
   * @return the next {@link XMLToken} or EOF (XMLToken.isEOF() == true).
   * @internal
   */
 public XMLToken next() {
    return new XMLToken(libsbmlJNI.XMLInputStream_next(swigCPtr, this), true);
  }

  
  /**
   * Returns the next {@link XMLToken} without consuming it.  A subsequent call to
   * either peek() or next() will return the same token.
   * <p>
   * @return the next {@link XMLToken} or EOF (XMLToken.isEOF() == true).
   * @internal
   */
 public XMLToken peek() {
    return new XMLToken(libsbmlJNI.XMLInputStream_peek(swigCPtr, this), false);
  }

  
  /**
   * Consume zero or more XMLTokens up to and including the corresponding
   * end XML element or EOF.
   * @internal
   */
 public void skipPastEnd(XMLToken element) {
    libsbmlJNI.XMLInputStream_skipPastEnd(swigCPtr, this, XMLToken.getCPtr(element), element);
  }

  
  /**
   * Consume zero or more XMLTokens up to but not including the next XML
   * element or EOF.
   * @internal
   */
 public void skipText() {
    libsbmlJNI.XMLInputStream_skipText(swigCPtr, this);
  }

  
  /**
   * Sets the {@link XMLErrorLog} this stream will use to log errors.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> @link libsbmlConstants#{@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED } {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED } @endlink
   * </ul>
   * @internal
   */
 public int setErrorLog(XMLErrorLog log) {
    return libsbmlJNI.XMLInputStream_setErrorLog(swigCPtr, this, XMLErrorLog.getCPtr(log), log);
  }

  
  /**
   * Prints a string representation of the underlying token stream, for
   * debugging purposes.
   * @internal
   */
 public String toString() {
    return libsbmlJNI.XMLInputStream_toString(swigCPtr, this);
  }

  
  /**
   * Prints a string representation of the underlying token stream, for
   * debugging purposes.
   * @internal
   */
 public SBMLNamespaces getSBMLNamespaces() {
  return libsbml.DowncastSBMLNamespaces(libsbmlJNI.XMLInputStream_getSBMLNamespaces(swigCPtr, this), false);
}

  
  /**
   * Prints a string representation of the underlying token stream, for
   * debugging purposes.
   * @internal
   */
 public void setSBMLNamespaces(SBMLNamespaces sbmlns) {
    libsbmlJNI.XMLInputStream_setSBMLNamespaces(swigCPtr, this, SBMLNamespaces.getCPtr(sbmlns), sbmlns);
  }

}
