/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * The core component of SBML's package extension.
 * <p>
 * {@link SBMLExtension} class (abstract class) is a core component of package extension
 * which needs to be extended by package developers. 
 * The class provides functions for getting common attributes of package extension 
 * (e.g., package name, package version, and etc.), functions for adding (registering) 
 * each instantiated {@link SBasePluginCreator} object, and a static function (defined in each 
 * {@link SBMLExtension} extended class) for initializing/registering the package extension 
 * when the library of the package is loaded.
 * <p>
 * <h2>How to implement an {@link SBMLExtension} extended class for each package extension</h2>
 * <p>
 * Package developers must implement an {@link SBMLExtension} extended class for
 * their packages (e.g. GroupsExtension class is implemented for groups extension).
 * The extended class is implemented based on the following steps:
 * <p>
 * (NOTE: 
 *   'src/pacakges/groups/extension/GroupsExtension.{h,cpp}' and
 *   'src/pacakges/layout/extension/LayoutExtension.{h,cpp}' are
 *   example files in which {@link SBMLExtension} derived classes are implemented)
 * <p>
 * <ol>
 * <p>
 * <li> Define the following static functions in the extended class:
 *      (examples of groups extension are shown respectively)
 *   <ol>
 *     <li> <p>A string of package name (label) (The function name must be 'getPackageName'.)</p>
 * <p>
<div class='fragment'><pre>
  String {@link GroupsExtension#getPackageName ()}
  {
	static String pkgName = 'groups';
	return pkgName;
  }
</pre></div>
 *     </li>
 * <p>
 *     <li> <p>
 *        Methods returning an integer of Default SBML level, version, and package version
 *        (The method names must be 'getDefaultLevel()', 'getDefaultVersion()', and 
 *        'getDefaultPackageVersion()' respectively.)
 *        </p>
<div class='fragment'><pre>
  long {@link GroupsExtension#getDefaultLevel()}
  {
	return 3;
  }  
  long {@link GroupsExtension#getDefaultVersion()}
  {
	return 1; 
  }
  long {@link GroupsExtension#getDefaultPackageVersion()}
  {
	return 1;
  }  
</pre></div>
 *     </li>
 *     <li> <p> Methods returning Strings that represent the URI of packages </p>
<div class='fragment'><pre>
  String {@link GroupsExtension#getXmlnsL3V1V1 ()}
  {
	static String xmlns = 'http://www.sbml.org/sbml/level3/version1/groups/version1';
	return xmlns;
  }
</pre></div> 
 *     </li>
 *     <li> <p>Strings that represent the other URI needed in this package (if any) </p>
 *     </li>
 *   </ol> 
 * </li>
 * <p>
 * <li> Override the following pure virtual functions
      <ul>
       <li> <code>virtual String getName () const =0</code>. This function returns the name of the package (e.g., 'layout', 'groups'). </li>
       <li> <code>virtual long getLevel (String uri) const =0</code>. This function returns the SBML level with the given URI of this package. </li>
       <li> <code>virtual long getVersion (String uri) const =0</code>. This function returns the SBML version with the given URI of this package. </li>
       <li> <code>virtual long getPackageVersion (String uri) const =0</code>. This function returns the package version with the given URI of this package.</li>
       <li> <code>virtual long getURI (long sbmlLevel, long sbmlVersion, long pkgVersion) const =0</code>. 
             This function returns the URI (namespace) of the package corresponding to the combination of the given sbml level, sbml version, and pacakege version</li>
       <li> <code>virtual {@link SBMLExtension} clone () const = 0</code>. This function creates and returns a deep copy of this derived object.</li>
      </ul>
      <p>For example, the above functions are overridden in the groups
	package ('src/packages/groups/extension/GroupsExtension.cpp') as follows:</p>
<div class='fragment'><pre>
String
{@link GroupsExtension#getName()} const
{
  return getPackageName();
}

long 
{@link GroupsExtension#getLevel(String uri)} const
{
  if (uri == getXmlnsL3V1V1())
  {
    return 3;
  }
  
  return 0;
}

long 
{@link GroupsExtension#getVersion(String uri)} const
{
  if (uri == getXmlnsL3V1V1())
  {
    return 1;
  }

  return 0;
}

long
{@link GroupsExtension#getPackageVersion(String uri)} const
{
  if (uri == getXmlnsL3V1V1())
  {
    return 1;
  }

  return 0;
}

String 
{@link GroupsExtension#getURI(long sbmlLevel, long sbmlVersion, long pkgVersion)} const
{
  if (sbmlLevel == 3)
  {
    if (sbmlVersion == 1)
    {
      if (pkgVersion == 1)
      {
        return getXmlnsL3V1V1();
      }
    }
  }

  static String empty = '';

  return empty;
}

GroupsExtension* 
{@link GroupsExtension#clone ()} const
{
  return new GroupsExtension(*this);  
}
</pre></div>
 * <p>
 * Constructor, copy Constructor, and destructor also must be overridden
 * if additional data members are defined in the derived class.
 * <p>
 * </li>
 * <p>
 * <li> <p>
 *  Define typedef and template instantiation code for the package specific {@link SBMLExtensionNamespaces} template class
 *  </p>
 * <p>
 *   <ol>
 *     <li> typedef for the package specific {@link SBMLExtensionNamespaces} template class
 *       <p> For example, the typedef for GroupsExtension (defined in the groups package) is implemented in GroupsExtension.h as follows:</p>
<div class='fragment'><pre>
  // GroupsPkgNamespaces is derived from the {@link SBMLNamespaces} class and used when creating an object of 
  // {@link SBase} derived classes defined in groups package.
  typedef {@link SBMLExtensionNamespaces}&lt;GroupsExtension&gt; GroupsPkgNamespaces;
</pre></div>
 *     </li>
 * <p>
 *     <li> template instantiation code for the above typedef definition in the implementation file (i.e., *.cpp file).
 *       <p> For example, the template instantiation code for GroupsExtension is implemented in GroupsExtension.cpp 
 *           as follows:
 *       </p>
 * <p>
<div class='fragment'><pre>
  // Instantiate {@link SBMLExtensionNamespaces}&lt;GroupsExtension&gt; (GroupsPkgNamespaces) for DLL.
  template class LIBSBML_EXTERN {@link SBMLExtensionNamespaces}&lt;GroupsExtension&gt;;
</pre></div>
 * <p>
 *     </li>
 *  </ol>
 * <p>
 *  <p> The {@link SBMLExtensionNamespaces} template class is a derived class of
 *      {@link SBMLNamespaces} and can be used as an argument of constructors 
 *      of {@link SBase} derived classes defined in the package extensions.
 *      For example, a GroupsPkgNamespaces object can be used when creating a group 
 *      object as follows:
 *  </P>
<div class='fragment'><pre>
   GroupPkgNamespaces gpns(3,1,1);  // The arguments are SBML Level, SBML Version, and Groups Package Version.

   Group g = new Group(&gpns);      // Creates a group object of L3V1 Groups V1.
</pre></div>
 * <p>
 *   <p>
 *     Also, the GroupsPkgNamespaces object can be used when creating an
 *     {@link SBMLDocument} object with the groups package as follows:
 *   </p>
 * <p>
<div class='fragment'><pre>
   GroupsPkgNamespaces gpns(3,1,1);
   {@link SBMLDocument} doc;

   doc  = new {@link SBMLDocument}(&gnps); // Creates an {@link SBMLDocument} of L3V1 with Groups V1.
</pre></div>
 * <p>
 * </li>
 * <p>
 * <li> Override the following pure virtual function which returns the {@link SBMLNamespaces} derived object 
<div class='fragment'><pre>
       virtual {@link SBMLNamespaces} getSBMLExtensionNamespaces (String uri) const =0
</pre></div>
 *    <p> For example, the function is overridden in GroupsExtension
 class as follows:</p>
<div class='fragment'><pre>
{@link SBMLNamespaces}
{@link GroupsExtension#getSBMLExtensionNamespaces(String uri)} const
{
  GroupsPkgNamespaces* pkgns = null;
  if ( uri == getXmlnsL3V1V1())
  {
    pkgns = new GroupsPkgNamespaces(3,1,1);    
  }  
  return pkgns;
}
</pre></div>
   </li>
 * <p>
 * <p>
 *  <li> Define an enum type for representing the typecode of elements (SBase extended classes) defined in the package extension
 * <p>
 *   <p>  For example, SBMLGroupsTypeCode_t for groups package is
 *  defined in GroupsExtension.h as follows: </p>
<div class='fragment'><pre>
      typedef enum
      {
         SBML_GROUPS_GROUP  = 200
       , SBML_GROUPS_MEMBER = 201
      } SBMLGroupsTypeCode_t;
</pre></div>    
 * <p>
 *  <p> <em>SBML_GROUPS_GROUP</em> corresponds to the Group class (&lt;group&gt;)
 * and <em>SBML_GROUPS_MEMBER</em> corresponds to the Member (&lt;member&gt;) class, respectively.
 * <p>
 * <p>
 *  <p> Similarly, SBMLLayoutTypeCode_t 
 *   for layout package is defined in LayoutExtension.h as follows: </p>
 * <p>
<div class='fragment'><pre>
      typedef enum
      {
         SBML_LAYOUT_BOUNDINGBOX           = 100
       , SBML_LAYOUT_COMPARTMENTGLYPH      = 101
       , SBML_LAYOUT_CUBICBEZIER           = 102
       , SBML_LAYOUT_CURVE                 = 103
       , SBML_LAYOUT_DIMENSIONS            = 104
       , SBML_LAYOUT_GRAPHICALOBJECT       = 105
       , SBML_LAYOUT_LAYOUT                = 106   
       , SBML_LAYOUT_LINESEGMENT           = 107   
       , SBML_LAYOUT_POINT                 = 108    
       , SBML_LAYOUT_REACTIONGLYPH         = 109    
       , SBML_LAYOUT_SPECIESGLYPH          = 110    
       , SBML_LAYOUT_SPECIESREFERENCEGLYPH = 111
       , SBML_LAYOUT_TEXTGLYPH             = 112
      } SBMLLayoutTypeCode_t;
</pre></div>
 * <p>
 *  <p>
 *   These enum values are returned by corresponding getTypeCode() functions.
 *   (e.g. SBML_GROUPS_GROUP is returned in {@link Group#getTypeCode()})
 *  </p>
 * <p>
 *  <p>
 *   The value of each typecode can be duplicated between those of different 
 *   packages (In the above SBMLayoutTypeCode_t and SBMLGroupsTypeCode_t types, 
 *   unique values are assigned to enum values, but this is not mandatory.)
 *  </p>
 * <p>
 *  <p>
 *   Thus, to distinguish the typecodes of different packages, not only the return
 *   value of getTypeCode() function but also that of getPackageName()
 *   function should be checked as follows:
 *  </p>
<div class='fragment'><pre>
          void example (SBase sb)
          {
            String pkgName = sb-&gt;getPackageName();
            if (pkgName == 'core') {
              switch (sb-&gt;getTypeCode()) {
                case SBML_MODEL:
                   ....
                   break;
                case SBML_REACTION:
                   ....
              }
            } 
            else if (pkgName == 'layout') {
              switch (sb-&gt;getTypeCode()) {
                case SBML_LAYOUT_LAYOUT:
                   ....
                   break;
                case SBML_LAYOUT_REACTIONGLYPH:
                   ....
              }
            } 
            else if (pkgName == 'groups') {
              switch (sb-&gt;getTypeCode()) {
                case SBML_GROUPS_GROUP:
                   ....
                   break;
                case SBML_GROUPS_MEMBER:
                   ....
              }
            }
            ...
          } 
</pre></div>
 * <p>
 *  </li>
 *  <li> Override the following pure virtual function which returns a string corresponding to the given typecode:
 * <p>
<div class='fragment'><pre>
       virtual String {@link SBMLExtension#getStringFromTypeCode(int typeCode)} const;
</pre></div> 
 * <p>
 *   <p> For example, the function for groups extension is implemented as follows: </p>
<div class='fragment'><pre>
static
String SBML_GROUPS_TYPECODE_STRINGS[] =
{
    'Group'
  , 'Member'
};

String 
{@link GroupsExtension#getStringFromTypeCode(int typeCode)} const
{
  int min = SBML_GROUPS_GROUP;
  int max = SBML_GROUPS_MEMBER;

  if ( typeCode &lt; min || typeCode &gt; max)
  {
    return '(Unknown SBML Groups Type)';  
  }

  return SBML_GROUPS_TYPECODE_STRINGS[typeCode - min];
}
</pre></div> 
 * <p>
 *  </li>
 * <p>
 * <li> Implements a 'static void init()' function in the derived class
 * <p>
 * <p> In the init() function, initialization code which creates an instance of 
 *     the derived class and registering code which registers the instance to 
 *     {@link SBMLExtensionRegistry} class are implemented.
 * </p>
 * <p>
 * For example, the init() function for groups package is implemented as follows: 
<div class='fragment'><pre>
void 
{@link GroupsExtension#init()}
{
  //-------------------------------------------------------------------------
  //
  // 1. Checks if the groups pacakge has already been registered.
  //
  //-------------------------------------------------------------------------

  if {@link (SBMLExtensionRegistry#getInstance()}.isRegistered(getPackageName()))
  {
    // do nothing;
    return;
  }

  //-------------------------------------------------------------------------
  //
  // 2. Creates an {@link SBMLExtension} derived object.
  //
  //-------------------------------------------------------------------------

  GroupsExtension groupsExtension;

  //-------------------------------------------------------------------------------------
  //
  // 3. Creates {@link SBasePluginCreatorBase} derived objects required for this 
  //    extension. The derived classes can be instantiated by using the following 
  //     template class.
  //
  //    temaplate&lt;class SBasePluginType&gt; class {@link SBasePluginCreator}
  //
  //    The constructor of the creator class has two arguments:
  //
  //        (1) {@link SBaseExtensionPoint} : extension point to which the plugin object connected
  //        (2) std.vector&lt;String&gt; : a std.vector object that contains a list of URI
  //                                       (package versions) supported by the plugin object.
  //
  //    For example, two plugin objects (plugged in {@link SBMLDocument} and {@link Model} elements) are 
  //    required for the groups extension.
  //
  //    Since only 'required' attribute is used in {@link SBMLDocument} by the groups package, existing
  //    {@link SBMLDocumentPlugin} class can be used as-is for the plugin.
  //
  //    Since the lists of supported package versions (currently only L3V1-groups-V1 supported )
  //    are equal in the both plugin objects, the same vector object is given to each 
  //    constructor.
  //
  //---------------------------------------------------------------------------------------

  std.vector&lt;String&gt; packageURIs;
  packageURIs.push_back(getXmlnsL3V1V1());

  {@link SBaseExtensionPoint} sbmldocExtPoint('core',SBML_DOCUMENT);
  {@link SBaseExtensionPoint} modelExtPoint('core',SBML_MODEL);

  {@link SBasePluginCreator}&lt;{@link SBMLDocumentPlugin}, GroupsExtension&gt; sbmldocPluginCreator(sbmldocExtPoint,packageURIs);
  {@link SBasePluginCreator}&lt;GroupsModelPlugin,   GroupsExtension&gt; modelPluginCreator(modelExtPoint,packageURIs);

  //--------------------------------------------------------------------------------------
  //
  // 3. Adds the above {@link SBasePluginCreatorBase} derived objects to the {@link SBMLExtension} derived object.
  //
  //--------------------------------------------------------------------------------------

  groupsExtension.addSBasePluginCreator(&sbmldocPluginCreator);
  groupsExtension.addSBasePluginCreator(&modelPluginCreator);

  //-------------------------------------------------------------------------
  //
  // 4. Registers the {@link SBMLExtension} derived object to {@link SBMLExtensionRegistry}
  //
  //-------------------------------------------------------------------------

  int result = {@link SBMLExtensionRegistry#getInstance()}.addExtension(&groupsExtension);

  if (result != LIBSBML_OPERATION_SUCCESS)
  {
    std.cerr &lt;&lt; '[Error] {@link GroupsExtension#init()} failed.' &lt;&lt; std.endl;
  }
}
</pre></div>
 *    </p> 
 * </li>
 * <p>
 * <li> Instantiate a global {@link SBMLExtensionRegister} variable in appropriate 
 *      implementation file
 * <p>
 * <p> For example, the global variable for the groups extension is instantiated in GroupsExtension.cpp as follows: </p>
<div class='fragment'><pre>
  static {@link SBMLExtensionRegister}&lt;GroupsExtension&gt; groupsExtensionRegister;
</pre></div>
 *    The init() function is invoked when the global variable is instantiated,
 *    by which initialization and registering the package extension are performed.
 * </li>
 * <p>
 * <p>
 * </ol>
 * <p>
 */
public class SBMLExtension {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected SBMLExtension(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(SBMLExtension obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SBMLExtension obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SBMLExtension(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   * SBMLExtension derived classes must override this method
   */
  public SBasePlugin DowncastSBasePlugin(long cPtr, boolean owner)
  {
    if (cPtr == 0) return null;

    return new SBasePlugin(cPtr,false);
  }


  /**
   * SBMLExtension derived classes must override this method
   */
  public SBase DowncastSBase(long cPtr, boolean owner)
  {
    if (cPtr == 0) return null;

    return new SBase(cPtr, owner);
  }

  
  /**
   * Returns the number of {@link SBasePlugin} objects stored in this object.
   * <p>
   * @return the number of {@link SBasePlugin} objects stored in this object.
   */
 public int getNumOfSBasePlugins() {
    return libsbmlJNI.SBMLExtension_getNumOfSBasePlugins(swigCPtr, this);
  }

  
  /**
   * Returns the number of supported package Namespace (package versions) of this 
   * package extension.
   * <p>
   * @return the number of supported package Namespace (package versions) of this 
   * package extension.
   */
 public long getNumOfSupportedPackageURI() {
    return libsbmlJNI.SBMLExtension_getNumOfSupportedPackageURI(swigCPtr, this);
  }

  
  /**
   * Returns a flag indicating, whether the given URI (package version) is 
   * supported by this package extension.
   * <p>
   * @return true if the given URI (package version) is supported by this 
   * package extension, otherwise false is returned.
   */
 public boolean isSupported(String uri) {
    return libsbmlJNI.SBMLExtension_isSupported(swigCPtr, this, uri);
  }

  
  /**
   * <p>
   * Returns the ith URI (the supported package version)
   * <p>
   * @param i the index of the list of URI (the list of supporeted pacakge versions)
   * @return the URI of supported package version with the given index.
   */
 public String getSupportedPackageURI(long i) {
    return libsbmlJNI.SBMLExtension_getSupportedPackageURI(swigCPtr, this, i);
  }

  
  /**
   *  (NOTICE) Package developers MUST OVERRIDE this pure virtual function 
   *           in their derived class.
   * <p>
   * Creates and returns a deep copy of this {@link SBMLExtension} object.
   * <p>
   * @return a (deep) copy of this {@link SBase} object
   */
 public SBMLExtension cloneObject() {
	return libsbml.DowncastExtension(libsbmlJNI.SBMLExtension_cloneObject(swigCPtr, this), true);
}

  
  /**
   *  (NOTICE) Package developers MUST OVERRIDE this pure virtual function 
   *           in their derived class.
   * <p>
   * Returns the name of this package (e.g. 'layout', 'multi').
   * <p>
   * @return the name of package extension
   */
 public String getName() {
    return libsbmlJNI.SBMLExtension_getName(swigCPtr, this);
  }

  
  /**
   *  (NOTICE) Package developers MUST OVERRIDE this pure virtual function 
   *           in their derived class.
   * <p>
   * Returns the uri corresponding to the given SBML level, SBML version, and package version.
   * <p>
   * @param sbmlLevel the level of SBML
   * @param sbmlVersion the version of SBML
   * @param pkgVersion the version of package
   * <p>
   * @return a string of the package URI
   */
 public String getURI(long sbmlLevel, long sbmlVersion, long pkgVersion) {
    return libsbmlJNI.SBMLExtension_getURI(swigCPtr, this, sbmlLevel, sbmlVersion, pkgVersion);
  }

  
  /**
   *  (NOTICE) Package developers MUST OVERRIDE this pure virtual function 
   *           in their derived class.
   * <p>
   * Returns the SBML level associated with the given URI of this package.
   * <p>
   * @param uri the string of URI that represents a versions of the package
   * @return the SBML level associated with the given URI of this package.
   */
 public long getLevel(String uri) {
    return libsbmlJNI.SBMLExtension_getLevel(swigCPtr, this, uri);
  }

  
  /**
   *  (NOTICE) Package developers MUST OVERRIDE this pure virtual function 
   *           in their derived class.
   * <p>
   * Returns the SBML version associated with the given URI of this package.
   * <p>
   * @param uri the string of URI that represents a versions of the package
   * @return the SBML version associated with the given URI of this package.
   */
 public long getVersion(String uri) {
    return libsbmlJNI.SBMLExtension_getVersion(swigCPtr, this, uri);
  }

  
  /**
   *  (NOTICE) Package developers MUST OVERRIDE this pure virtual function 
   *           in their derived class.
   * <p>
   * Returns the package version associated with the given URI of this package.
   * <p>
   * @param uri the string of URI that represents a versions of this package
   * @return the package version associated with the given URI of this package.
   */
 public long getPackageVersion(String uri) {
    return libsbmlJNI.SBMLExtension_getPackageVersion(swigCPtr, this, uri);
  }

  
  /**
   *  (NOTICE) Package developers MUST OVERRIDE this pure virtual function 
   *           in their derived class.
   * <p>
   * This method takes a type code of this package and returns a string 
   * representing the code.
   */
 public String getStringFromTypeCode(int typeCode) {
    return libsbmlJNI.SBMLExtension_getStringFromTypeCode(swigCPtr, this, typeCode);
  }

  
  /**
   *  (NOTICE) Package developers MUST OVERRIDE this pure virtual function in 
   *           their derived class.
   * <p>
   * Returns an {@link SBMLExtensionNamespaces}<class SBMLExtensionType> object 
   * (e.g. {@link SBMLExtensionNamespaces}<LayoutExtension> whose alias type is 
   * LayoutPkgNamespaces) corresponding to the given uri.
   * Null will be returned if the given uri is not defined in the corresponding 
   * package.
   * <p>
   * @param uri the string of URI that represents one of versions of the package
   * @return an {@link SBMLExtensionNamespaces}<class SBMLExtensionType> object. null
   *         will be returned if the given uri is not defined in the corresponding 
   *         package. 
   */
 public SBMLNamespaces getSBMLExtensionNamespaces(String uri) {
  return libsbml.DowncastSBMLNamespaces(libsbmlJNI.SBMLExtension_getSBMLExtensionNamespaces(swigCPtr, this, uri), false);
}

  
  /**
   * enable/disable this package.
   * Returned value is the result of this function.
   * <p>
   * @param isEnabled the bool value: true (enabled) or false (disabled)
   * <p>
   * @return true if this function call succeeded, otherwise false is returned.
   */
 public boolean setEnabled(boolean isEnabled) {
    return libsbmlJNI.SBMLExtension_setEnabled(swigCPtr, this, isEnabled);
  }

  
  /**
   * Check if this package is enabled (true) or disabled (false).
   * <p>
   * @return true if this package is enabled, otherwise false is returned.
   */
 public boolean isEnabled() {
    return libsbmlJNI.SBMLExtension_isEnabled(swigCPtr, this);
  }

}
