/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * Wrapper class for the C++ standard file stream <code>ofstream</code>.
 * <p>
 * The C++ <code>ofstream</code> ('output file stream') provides an
 * interface for writing data to files as output streams.  This class,
 * {@link OFStream}, wraps the C++ <code>ofstream</code> and provides an {@link OStream}
 * interface to it.  The file to be associated with the stream can be
 * specified as a parameter to the constructors in this class.
 * <p>
 * This class may be useful because some libSBML methods accept an argument
 * for indicating where to send text string output.  An example is the
 * {@link SBMLDocument#printErrors(OStream stream)} method.  The methods use C++ style streams
 * and not Java stream objects.  The {@link OStream} object exists to bridge the
 * Java and underlying native implementation.  It is a simple wrapper
 * around the underlying stream object and provides a few basic methods for
 * manipulating it.
 * <p>
 */
public class OFStream extends OStream {
   private long swigCPtr;

   protected OFStream(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.OFStream_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(OFStream obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (OFStream obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_OFStream(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
    /**
     * Creates a new {@link OFStream} object for a file.
     * <p>
     * This opens the given file <code>filename</code> with the <code>is_append</code> flag
     * (default is <code>false</code>), and creates an {@link OFStream} object
     * instance that associates the file's content with an {@link OStream} object.
     * <p>
     * @param filename the name of the file to open
     * @param is_append whether to open the file for appending (default:
     * <code>false</code>, meaning overwrite the content instead)
     * <p>
     * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
 
     */
 public OFStream(String filename, boolean is_append) {
    this(libsbmlJNI.new_OFStream__SWIG_0(libsbml.getAbsolutePath(filename), is_append), true);
  }

  
    /**
     * Creates a new {@link OFStream} object for a file.
     * <p>
     * This opens the given file <code>filename</code> with the <code>is_append</code> flag
     * (default is <code>false</code>), and creates an {@link OFStream} object
     * instance that associates the file's content with an {@link OStream} object.
     * <p>
     * @param filename the name of the file to open
     * @param is_append whether to open the file for appending (default:
     * <code>false</code>, meaning overwrite the content instead)
     * <p>
     * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
 
     */
 public OFStream(String filename) {
    this(libsbmlJNI.new_OFStream__SWIG_1(libsbml.getAbsolutePath(filename)), true);
  }

  
    /**
     * Opens a file and associates this stream object with it.
     * <p>
     * This method opens a given file <code>filename</code> with the given
     * <code>is_append</code> flag (whose default value is <code>false</code>),
     * and associates <i>this</i> stream object with the file's content.
     * <p>
     * @param filename the name of the file to open
     * @param is_append whether to open the file for appending (default:
     * <code>false</code>, meaning overwrite the content instead)
     * <p>
     * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
 
     */
 public void open(String filename, boolean is_append) {
    libsbmlJNI.OFStream_open__SWIG_0(swigCPtr, this, libsbml.getAbsolutePath(filename), is_append);
  }

  
    /**
     * Opens a file and associates this stream object with it.
     * <p>
     * This method opens a given file <code>filename</code> with the given
     * <code>is_append</code> flag (whose default value is <code>false</code>),
     * and associates <i>this</i> stream object with the file's content.
     * <p>
     * @param filename the name of the file to open
     * @param is_append whether to open the file for appending (default:
     * <code>false</code>, meaning overwrite the content instead)
     * <p>
     * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
 
     */
 public void open(String filename) {
    libsbmlJNI.OFStream_open__SWIG_1(swigCPtr, this, libsbml.getAbsolutePath(filename));
  }

  
    /**
     * Closes the file currently associated with this stream object.
     */
 public void close() {
    libsbmlJNI.OFStream_close(swigCPtr, this);
  }

  
    /**
     * Returns <code>true</code> if this stream object is currently
     * associated with a file.
     * <p>
     * @return <code>true</code> if the stream object is currently
     * associated with a file, <code>false</code> otherwise
     */
 public boolean is_open() {
    return libsbmlJNI.OFStream_is_open(swigCPtr, this);
  }

}
