/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's Compartment construct.
 * <p>
 * A compartment in SBML represents a bounded space in which species are
 * located.  Compartments do not necessarily have to correspond to actual
 * structures inside or outside of a biological cell.
 * <p>
 * It is important to note that although compartments are optional in the
 * overall definition of {@link Model}, every species in an SBML model must be
 * located in a compartment.  This in turn means that if a model defines
 * any species, the model must also define at least one compartment.  The
 * reason is simply that species represent physical things, and therefore
 * must exist <em>somewhere</em>.  Compartments represent the <em>somewhere</em>.
 * <p>
 * {@link Compartment} has one required attribute, 'id', to give the compartment a
 * unique identifier by which other parts of an SBML model definition can
 * refer to it.  A compartment can also have an optional 'name' attribute
 * of type <code>string.</code>  Identifiers and names must be used according to the
 * guidelines described in the SBML specifications.
 * <p>
 * {@link Compartment} also has an optional attribute 'spatialDimensions' that is
 * used to indicate the number of spatial dimensions possessed by the
 * compartment.  Most modeling scenarios involve compartments with integer
 * values of 'spatialDimensions' of <code>3</code> (i.e., a three-dimensional
 * compartment, which is to say, a volume), or 2 (a two-dimensional
 * compartment, a surface), or <code>1</code> (a one-dimensional compartment, a
 * line).  In SBML Level&nbsp;3, the type of this attribute is <code>double</code>,
 * there are no restrictions on the permitted values of the
 * 'spatialDimensions' attribute, and there are no default values.  In SBML
 * Level&nbsp;2, the value must be a positive <code>integer</code>, and the default
 * value is <code>3</code>; the permissible values in SBML Level&nbsp;2 are <code>3</code>, 
 * <code>2</code>, <code>1</code>, and <code>0</code> (for a point).
 * <p>
 * Another optional attribute on {@link Compartment} is 'size', representing the
 * <em>initial</em> total size of that compartment in the model.  The 'size'
 * attribute must be a floating-point value and may represent a volume (if
 * the compartment is a three-dimensional one), or an area (if the
 * compartment is two-dimensional), or a length (if the compartment is
 * one-dimensional).  There is no default value of compartment size in SBML
 * Level&nbsp;2 or Level&nbsp;3.  In particular, a missing 'size' value
 * <em>does not imply that the compartment size is 1</em>.  (This is unlike
 * the definition of compartment 'volume' in SBML Level&nbsp;1.)  When the
 * compartment's 'spatialDimensions' attribute does not have a value of 
 * <code>0</code>, a missing value of 'size' for a given compartment signifies that the
 * value either is unknown, or to be obtained from an external source, or
 * determined by an {@link InitialAssignment}, {@link AssignmentRule}, {@link AlgebraicRule} or
 * {@link RateRule} elsewhere in the model.  In SBML Level&nbsp;2, there are
 * additional special requirements on the values of 'size'; we discuss them
 * in a <a href='#comp-l2'>separate section below</a>.
 * <p>
 * The units associated with a compartment's 'size' attribute value may be
 * set using the optional attribute 'units'.  The rules for setting and
 * using compartment size units differ between SBML Level&nbsp;2 and
 * Level&nbsp;3, and are discussed separately below.
 * <p>
 * Finally, the optional {@link Compartment} attribute named 'constant' is used to
 * indicate whether the compartment's size stays constant after simulation
 * begins.  A value of <code>true</code> indicates the compartment's 'size' cannot be
 * changed by any other construct except {@link InitialAssignment}; a value of 
 * <code>false</code> indicates the compartment's 'size' can be changed by other
 * constructs in SBML.  In SBML Level&nbsp;2, there is an additional
 * explicit restriction that if 'spatialDimensions'=<code>'0'</code>, the value
 * cannot be changed by {@link InitialAssignment} either.  Further, in
 * Level&nbsp;2, 'constant' has a default value of <code>true.</code>  In SBML
 * Level&nbsp;3, there is no default value for the 'constant' attribute.
 * <p>
 * <p>
 * <h2>Additional considerations in SBML Level&nbsp;2</h2>
 * <p>
 * In SBML Level&nbsp;2, the default units of compartment size, and the
 * kinds of units allowed as values of the attribute 'units', interact with
 * the number of spatial dimensions of the compartment.  The value of the
 * 'units' attribute of a {@link Compartment} object must be one of the base units
 * (see {@link Unit}), or the predefined unit identifiers <code>volume</code>, <code>area</code>, 
 * <code>length</code> or <code>dimensionless</code>, or a new unit defined by a {@link UnitDefinition}
 * object in the enclosing {@link Model}, subject to the restrictions detailed in
 * the following table:
 * <p>
 * <center style='padding-bottom: 0.5em'>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
<caption class='top-caption'>Restrictions on values permitted for
compartment <code>size</code> and <code>units</code> attributes.</caption>
 <tr>
     <th align='left' valign='bottom'>
       Value of<br><code>spatialDimensions</code>
     </th>
     <th align='left' valign='bottom'>
       <code>size</code><br>allowed?
     </th>
     <th align='left' valign='bottom'>
       <code>units</code><br>allowed?
     </th>
     <th align='left' valign='bottom'>
	  Allowable kinds of units
     </th>
     <th align='left' valign='bottom'>
	  Default value of attribute <code>units</code>
     </th>
 </tr>
 <tr>
     <td>'<code>3</code>'</td>
     <td>yes</td>
     <td>yes</td>
     <td>units of volume, or <code>dimensionless</code></td>
     <td>'<code>volume</code>'</td>
 </tr>
 <tr>
     <td>'<code>2</code>'</td>
     <td>yes</td>
     <td>yes</td>
     <td>units of area, or <code>dimensionless</code></td>
     <td>'<code>area</code>'</td>
 </tr>
 <tr>
     <td>'<code>1</code>'</td>
     <td>yes</td>
     <td>yes</td>
     <td>units of length, or <code>dimensionless</code></td>
     <td>'<code>length</code>'</td>
 </tr>
 <tr>
     <td>'<code>0</code>'</td>
     <td>no</td>
     <td>no</td>
     <td>(no units allowed)</td>
     <td></td>
 </tr>
 </tr>
</table>
</center>
 
 * <p>
 * In SBML Level&nbsp;2, the units of the compartment size, as defined by the
 * 'units' attribute or (if 'units' is not set) the default value listed in
 * the table above, are used in the following ways when the compartment has
 * a 'spatialDimensions' value greater than <code>0:</code>
 * <ul>
 * <li> The value of the 'units' attribute is used as the units of the
 * compartment identifier when the identifier appears as a numerical
 * quantity in a mathematical formula expressed in MathML.
 * <p>
 * <li> The <code>math</code> element of an {@link AssignmentRule} or {@link InitialAssignment}
 * referring to this compartment must have identical units.
 * <p>
 * <li> In {@link RateRule} objects that set the rate of change of the compartment's
 * size, the units of the rule's <code>math</code> element must be identical to the
 * compartment's 'units' attribute divided by the default <em>time</em> units.
 * (In other words, the units for the rate of change of compartment size
 * are <em>compartment size</em>/<em>time</em> units.
 * <p>
 * <li> When a {@link Species} is to be treated in terms of concentrations or
 * density, the units of the spatial size portion of the concentration
 * value (i.e., the denominator in the units formula <em>substance</em>/
 * <em>size</em>) are those indicated by the value of the 'units' attribute on the
 * compartment in which the species is located.
 * </ul>
 * <p>
 * Compartments with 'spatialDimensions'=<code>0</code> require special treatment in
 * this framework.  As implied above, the 'size' attribute must not have a
 * value on an SBML Level&nbsp;2 {@link Compartment} object if the
 * 'spatialDimensions' attribute has a value of <code>0.</code>  An additional
 * related restriction is that the 'constant' attribute must default to or
 * be set to <code>true</code> if the value of the 'spatialDimensions' attribute is
 * <code>0</code>, because a zero-dimensional compartment cannot ever have a size.
 * <p>
 * If a compartment has no size or dimensional units, how should such a
 * compartment's identifier be interpreted when it appears in mathematical
 * formulas?  The answer is that such a compartment's identifier should not
 * appear in mathematical formulas in the first place&mdash;it has no
 * value, and its value cannot change.  Note also that a zero-dimensional
 * compartment is a point, and species located at points can only be
 * described in terms of amounts, not spatially-dependent measures such as
 * concentration.  Since SBML {@link KineticLaw} formulas are already in terms of
 * <em>substance</em>/<em>time</em> and not (say) <em>concentration</em>/<em>time</em>, volume
 * or other factors in principle are not needed for species located in
 * zero-dimensional compartments.
 * <p>
 * Finally, in SBML Level&nbsp;2 Versions 2&ndash;4, each compartment in a
 * model may optionally be designated as belonging to a particular
 * compartment <em>type</em>.  The optional attribute 'compartmentType' is used
 * identify the compartment type represented by the {@link Compartment} structure.
 * The 'compartmentType' attribute's value must be the identifier of a
 * {@link CompartmentType} instance defined in the model.  If the 'compartmentType'
 * attribute is not present on a particular compartment definition, a
 * unique virtual compartment type is assumed for that compartment, and no
 * other compartment can belong to that compartment type.  The values of
 * 'compartmentType' attributes on compartments have no effect on the
 * numerical interpretation of a model.  Simulators and other numerical
 * analysis software may ignore 'compartmentType' attributes.  The
 * 'compartmentType' attribute and the {@link CompartmentType} class of objects are
 * not present in SBML Level&nbsp;3 Core nor in SBML Level&nbsp;1.
 * <p>
 * <p>
 * <h2>Additional considerations in SBML Level&nbsp;3</h2>
 * <p>
 * One difference between SBML Level&nbsp;3 and lower Levels of SBML is
 * that there are no restrictions on the permissible values of the
 * 'spatialDimensions' attribute, and there is no default value defined for
 * the attribute.  The value of 'spatialDimensions' does not have to be an
 * integer, either; this is to allow for the possibility of representing
 * structures with fractal dimensions.
 * <p>
 * The number of spatial dimensions possessed by a compartment cannot enter
 * into mathematical formulas, and therefore cannot directly alter the
 * numerical interpretation of a model.  However, the value of
 * 'spatialDimensions' <em>does</em> affect the interpretation of the units
 * associated with a compartment's size.  Specifically, the value of
 * 'spatialDimensions' is used to select among the {@link Model} attributes
 * 'volumeUnits', 'areaUnits' and 'lengthUnits' when a {@link Compartment} object
 * does not define a value for its 'units' attribute.
 * <p>
 * The 'units' attribute may be left unspecified for a given compartment in
 * a model; in that case, the compartment inherits the unit of measurement
 * specified by one of the attributes on the enclosing {@link Model} object
 * instance.  The applicable attribute on {@link Model} depends on the value of the
 * compartment's 'spatialDimensions' attribute; the relationship is shown
 * in the table below.  If the {@link Model} object does not define the relevant
 * attribute ('volumeUnits', 'areaUnits' or 'lengthUnits') for a given
 * 'spatialDimensions' value, the unit associated with that {@link Compartment}
 * object's size is undefined.  If <em>both</em> 'spatialDimensions' and 'units'
 * are left unset on a given {@link Compartment} object instance, then no unit can
 * be chosen from among the {@link Model}'s 'volumeUnits', 'areaUnits' or
 * 'lengthUnits' attributes (even if the {@link Model} instance provides values for
 * those attributes), because there is no basis to select between them and
 * there is no default value of 'spatialDimensions'.  Leaving the units of
 * compartments' sizes undefined in an SBML model does not render the model
 * invalid; however, as a matter of best practice, we strongly recommend
 * that all models specify the units of measurement for all compartment
 * sizes.
 * <p>
 * <center style='padding-bottom: 0.5em'>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
<caption class='top-caption'>Interpretation of the {@link Compartment} 'units' attribute.</caption>
 <tr>
     <th align='left' valign='bottom'>
       Value of attribute<br>'spatialDimensions'
     </th>
     <th align='left' valign='bottom'>
       Attribute of {@link Model} used<br>for inheriting the unit
     </th>
     <th align='left' valign='bottom'>
       Recommended candidate units
     </th>
 </tr>
 <tr>
     <td>'<code>3</code>'</td>
     <td>'volumeUnits'</td>
     <td>units of volume, or <code>dimensionless</code></td>
 </tr>
 <tr>
     <td>'<code>2</code>'</td>
     <td>'areaUnits'</td>
     <td>units of area, or <code>dimensionless</code></td>
 </tr>
 <tr>
     <td>'<code>1</code>'</td>
     <td>'lengthUnits'</td>
     <td>units of length, or <code>dimensionless</code></td>
 </tr>
 <tr>
     <td><em>other</em></td>
     <td><em>no units inherited</em></td>
     <td><em>no specific recommendations</em></td>
 </tr>
 </tr>
</table>
</center>

 * <p>
 * The unit of measurement associated with a compartment's size, as defined
 * by the 'units' attribute or (if 'units' is not set) the inherited value
 * from {@link Model} according to the table above, is used in the following ways:
 * <p>
 * <ul>
 * <p>
 * <li> When the identifier of the compartment appears as a numerical
 * quantity in a mathematical formula expressed in MathML, it represents
 * the size of the compartment, and the unit associated with the size is
 * the value of the 'units' attribute.
 * <p>
 * <li> When a {@link Species} is to be treated in terms of concentrations or
 * density, the unit associated with the spatial size portion of the
 * concentration value (i.e., the denominator in the formula
 * <em>amount</em>/<em>size</em>) is specified by the value of the 'units'
 * attribute on the compartment in which the species is located.
 * <p>
 * <li> The 'math' elements of {@link AssignmentRule}, {@link InitialAssignment} and
 * {@link EventAssignment} objects setting the value of the compartment size
 * should all have the same units as the unit associated with the
 * compartment's size.
 * <p>
 * <li> In a {@link RateRule} object that defines a rate of change for a
 * compartment's size, the unit of the rule's 'math' element should be
 * identical to the compartment's 'units' attribute divided by the
 * model-wide unit of <em>time</em>.  (In other words, {<em>unit of
 * compartment size</em>}/{<em>unit of time</em>}.)
 * <p>
 * </ul>
 * <p>
 * <p>
 * <h2>Other aspects of {@link Compartment}</h2>
 * <p>
 * In SBML Level&nbsp;1 and Level&nbsp;2, {@link Compartment} has an optional
 * attribute named 'outside', whose value can be the identifier of another
 * {@link Compartment} object defined in the enclosing {@link Model} object.  Doing so
 * means that the other compartment contains it or is outside of it.  This
 * enables the representation of simple topological relationships between
 * compartments, for those simulation systems that can make use of the
 * information (e.g., for drawing simple diagrams of compartments).  It is
 * worth noting that in SBML, there is no relationship between compartment
 * sizes when compartment positioning is expressed using the 'outside'
 * attribute.  The size of a given compartment does not in any sense
 * include the sizes of other compartments having it as the value of their
 * 'outside' attributes.  In other words, if a compartment <em>B</em> has the
 * identifier of compartment <em>A</em> as its 'outside' attribute value, the
 * size of <em>A</em> does not include the size of <em>B</em>.  The compartment sizes
 * are separate.
 * <p>
 * In Level&nbsp;2, there are two restrictions on the 'outside' attribute.
 * First, because a compartment with 'spatialDimensions' of <code>0</code> has no
 * size, such a compartment cannot act as the container of any other
 * compartment <em>except</em> compartments that <em>also</em> have
 * 'spatialDimensions' values of <code>0.</code>  Second, the directed graph formed
 * by representing {@link Compartment} structures as vertexes and the 'outside'
 * attribute values as edges must be acyclic.  The latter condition is
 * imposed to prevent a compartment from being contained inside itself.  In
 * the absence of a value for 'outside', compartment definitions in SBML
 * Level&nbsp;2 do not have any implied spatial relationships between each
 * other.
 * <p>
 * <p>
 * <!-- leave this next break as-is to work around some doxygen bug -->
 */
public class Compartment extends SBase {
   private long swigCPtr;

   protected Compartment(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.Compartment_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Compartment obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Compartment obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_Compartment(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
  /**
   * Creates a new {@link Compartment} using the given SBML <code>level</code> and <code>version</code>
   * values.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link Compartment}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Compartment}
   * <p>
   * @note Upon the addition of a {@link Compartment} object to an {@link SBMLDocument}
   * (e.g., using {@link Model#addCompartment(Compartment c)}), the SBML Level, SBML Version
   * and XML namespace of the document <em>override</em> the values used
   * when creating the {@link Compartment} object via this constructor.  This is
   * necessary to ensure that an SBML document is a consistent structure.
   * Nevertheless, the ability to supply the values at the time of creation
   * of a {@link Compartment} is an important aid to producing valid SBML.
   * Knowledge of the intented SBML Level and Version determine whether it
   * is valid to assign a particular value to an attribute, or whether it
   * is valid to add an object to an existing {@link SBMLDocument}.
   */
 public Compartment(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Compartment__SWIG_0(level, version), true);
  }

  
  /**
   * Creates a new {@link Compartment} using the given {@link SBMLNamespaces} object 
   * <code>sbmlns</code>.
   * <p>
   * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
   * A common approach to using this class constructor is to create an
   * {@link SBMLNamespaces} object somewhere in a program, once, then pass it to
   * object constructors such as this one when needed.
   * <p>
   * It is worth emphasizing that although this constructor does not take
   * an identifier argument, in SBML Level&nbsp;2 and beyond, the 'id'
   * (identifier) attribute of a {@link Compartment} is required to have a value.
   * Thus, callers are cautioned to assign a value after calling this
   * constructor.  Setting the identifier can be accomplished using the
   * method {@link Compartment#setId(String id)}.
   * <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   * <p>
   * @note Upon the addition of a {@link Compartment} object to an {@link SBMLDocument}
   * (e.g., using {@link Model#addCompartment(Compartment c)}), the SBML XML namespace of the
   * document <em>overrides</em> the value used when creating the {@link Compartment}
   * object via this constructor.  This is necessary to ensure that an SBML
   * document is a consistent structure.  Nevertheless, the ability to
   * supply the values at the time of creation of a {@link Compartment} is an
   * important aid to producing valid SBML.  Knowledge of the intented SBML
   * Level and Version determine whether it is valid to assign a particular
   * value to an attribute, or whether it is valid to add an object to an
   * existing {@link SBMLDocument}.
   */
 public Compartment(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Compartment__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
  /**
   * Copy constructor; creates a copy of a {@link Compartment}.
   * <p>
   * @param orig the {@link Compartment} instance to copy.
   */
 public Compartment(Compartment orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Compartment__SWIG_2(Compartment.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link Compartment} object.
   * <p>
   * @return a (deep) copy of this {@link Compartment}.
   */
 public Compartment cloneObject() {
    long cPtr = libsbmlJNI.Compartment_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new Compartment(cPtr, true);
  }

  
  /**
   * Initializes the fields of this {@link Compartment} object to 'typical' default
   * values.
   * <p>
   * The SBML {@link Compartment} component has slightly different aspects and
   * default attribute values in different SBML Levels and Versions.
   * This method sets the values to certain common defaults, based
   * mostly on what they are in SBML Level&nbsp;2.  Specifically:
   * <ul>
   * <li> Sets attribute 'spatialDimensions' to <code>3</code>
   * <li> Sets attribute 'constant' to <code>true</code>
   * <li> (Applies to Level&nbsp;1 models only) Sets attribute 'volume' to <code>1.0</code>
   * <li> (Applies to Level&nbsp;3 models only) Sets attribute 'units' to <code>litre</code>
   * </ul>
   */
 public void initDefaults() {
    libsbmlJNI.Compartment_initDefaults(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'id' attribute of this {@link Compartment} object.
   * <p>
   * @return the id of this {@link Compartment}.
   */
 public String getId() {
    return libsbmlJNI.Compartment_getId(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'name' attribute of this {@link Compartment} object.
   * <p>
   * @return the name of this {@link Compartment}.
   */
 public String getName() {
    return libsbmlJNI.Compartment_getName(swigCPtr, this);
  }

  
  /**
   * Get the value of the 'compartmentType' attribute of this {@link Compartment}
   * object.
   * <p>
   * @return the value of the 'compartmentType' attribute of this
   * {@link Compartment} as a string.
   * <p>
   * @note The 'compartmentType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   */
 public String getCompartmentType() {
    return libsbmlJNI.Compartment_getCompartmentType(swigCPtr, this);
  }

  
  /**
   * Get the number of spatial dimensions of this {@link Compartment} object.
   * <p>
   * @note In SBML Level&nbsp;3, the data type of the 'spatialDimensions'
   * attribute is <code>double</code>, whereas in Level&nbsp;2, it is <code>integer.</code>
   * LibSBML provides a separate method for obtaining the value as a double,
   * for models where it is relevant.
   * <p>
   * @return the value of the 'spatialDimensions' attribute of this
   * {@link Compartment} as a long integereger
   * <p>
   * @see #getSpatialDimensionsAsDouble()
   */
 public long getSpatialDimensions() {
    return libsbmlJNI.Compartment_getSpatialDimensions(swigCPtr, this);
  }

  
  /**
   * Get the number of spatial dimensions of this {@link Compartment} object
   * as a double.
   * <p>
   * @note In SBML Level&nbsp;3, the data type of the 'spatialDimensions'
   * attribute is <code>double</code>, whereas in Level&nbsp;2, it is <code>integer.</code>  To
   * avoid backward compatibility issues, libSBML provides a separate
   * method for obtaining the value as a double, for models where it is
   * relevant.
   * <p>
   * @return the value of the 'spatialDimensions' attribute of this
   * {@link Compartment} as a double, or <code>NaN</code> if this model is not in SBML
   * Level&nbsp;3 format.
   * <p>
   * @see #getSpatialDimensions()
   */
 public double getSpatialDimensionsAsDouble() {
    return libsbmlJNI.Compartment_getSpatialDimensionsAsDouble(swigCPtr, this);
  }

  
  /**
   * Get the size of this {@link Compartment}.
   * <p>
   * This method is identical to
   * {@link Compartment#getVolume()}.
   * In SBML Level&nbsp;1, compartments are always three-dimensional
   * constructs and only have volumes, whereas in SBML Level&nbsp;2,
   * compartments may be other than three-dimensional and therefore the
   * 'volume' attribute is named 'size' in Level&nbsp;2.  LibSBML provides
   * both
   * {@link Compartment#getSize()} and
   * {@link Compartment#getVolume()} for
   * easier compatibility between SBML Levels.
   * <p>
   * @return the value of the 'size' attribute ('volume' in Level&nbsp;1) of
   * this {@link Compartment} as a float-point number.
   * <p>
   * @see #isSetSize()
   * @see #getVolume()
   */
 public double getSize() {
    return libsbmlJNI.Compartment_getSize(swigCPtr, this);
  }

  
  /**
   * Get the volume of this {@link Compartment}.
   * <p>
   * This method is identical to
   * {@link Compartment#getSize()}.  In
   * SBML Level&nbsp;1, compartments are always three-dimensional
   * constructs and only have volumes, whereas in SBML Level&nbsp;2,
   * compartments may be other than three-dimensional and therefore the
   * 'volume' attribute is named 'size' in Level&nbsp;2.  LibSBML provides
   * both
   * {@link Compartment#getSize()} and
   * {@link Compartment#getVolume()}
   * for easier compatibility between SBML Levels.
   * <p>
   * @return the value of the 'volume' attribute ('size' in Level&nbsp;2) of
   * this {@link Compartment}, as a floating-point number.
   * <p>
   * @note The attribute 'volume' only exists by that name in SBML
   * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
   * named 'size'.
   * <p>
   * @see #isSetVolume()
   * @see #getSize()
   */
 public double getVolume() {
    return libsbmlJNI.Compartment_getVolume(swigCPtr, this);
  }

  
  /**
   * Get the units of this compartment's size.
   * <p>
   * The value of an SBML compartment's 'units' attribute establishes the
   * unit of measurement associated with the compartment's size.
   * <p>
   * @return the value of the 'units' attribute of this {@link Compartment}, as a
   * string.  An empty string indicates that no units have been assigned to
   * the value of the size.
   * <p>
   * @note There is an important distinction to be made between <em>no units
assigned</em>, and assuming a value without units has any specific unit
such as <code>dimensionless</code>.  In SBML, default units are never
attributed to numbers, and numbers without units are not automatically
assumed to have the unit <code>dimensionless</code>.  Please consult the
relevant SBML specification document for a more in-depth explanation of
this topic and the SBML unit system.

   * <p>
   * @see #isSetUnits()
   * @see Compartment#setUnits(String sid)
   * @see #getSize()
   */
 public String getUnits() {
    return libsbmlJNI.Compartment_getUnits(swigCPtr, this);
  }

  
  /**
   * Get the identifier, if any, of the compartment that is designated
   * as being outside of this one.
   * <p>
   * @return the value of the 'outside' attribute of this {@link Compartment}.
   * <p>
   * @note The 'outside' attribute is defined in SBML Level&nbsp;1 and
   * Level&nbsp;2, but does not exist in SBML Level&nbsp;3 Version&nbsp;1
   * Core.
   */
 public String getOutside() {
    return libsbmlJNI.Compartment_getOutside(swigCPtr, this);
  }

  
  /**
   * Get the value of the 'constant' attribute of this {@link Compartment}.
   * <p>
   * @return <code>true</code> if this {@link Compartment}'s size is flagged as being
   * constant, <code>false</code> otherwise.
   */
 public boolean getConstant() {
    return libsbmlJNI.Compartment_getConstant(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link Compartment}'s 'id' attribute is set.
   * <p>
   * @return <code>true</code> if the 'id' attribute of this {@link Compartment} is 
   * set, <code>false</code> otherwise.
   */
 public boolean isSetId() {
    return libsbmlJNI.Compartment_isSetId(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link Compartment}'s 'name' attribute is set.
   * <p>
   * @return <code>true</code> if the 'name' attribute of this {@link Compartment} is
   * set, <code>false</code> otherwise.
   */
 public boolean isSetName() {
    return libsbmlJNI.Compartment_isSetName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link Compartment}'s 'compartmentType' attribute is set.
   * <p>
   * @return <code>true</code> if the 'compartmentType' attribute of this {@link Compartment}
   * is set, <code>false</code> otherwise.
   * <p>
   * @note The 'compartmentType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   */
 public boolean isSetCompartmentType() {
    return libsbmlJNI.Compartment_isSetCompartmentType(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link Compartment}'s 'size' attribute is set.
   * <p>
   * This method is similar but not identical to
   * {@link Compartment#isSetVolume()}.  The latter
   * should be used in the context of SBML Level&nbsp;1 models instead of
   * {@link Compartment#isSetSize()}
   * because {@link Compartment#isSetVolume()}
   * performs extra processing to take into account the difference in
   * default values between SBML Levels 1 and 2.
   * <p>
   * @return <code>true</code> if the 'size' attribute ('volume' in Level&nbsp;2) of
   * this {@link Compartment} is set, <code>false</code> otherwise.
   * <p>
   * @see #isSetVolume()
   * @see #setSize(double value)
   */
 public boolean isSetSize() {
    return libsbmlJNI.Compartment_isSetSize(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this {@link Compartment}'s
   * 'volume' attribute is set.
   * <p>
   * This method is similar but not identical to
   * {@link Compartment#isSetSize()}.  The latter
   * should not be used in the context of SBML Level&nbsp;1 models because this
   * method performs extra processing to take into account
   * the difference in default values between SBML Levels 1 and 2.
   * <p>
   * @return <code>true</code> if the 'volume' attribute ('size' in Level&nbsp;2 and
   * above) of this {@link Compartment} is set, <code>false</code> otherwise.
   * <p>
   * @note The attribute 'volume' only exists by that name in SBML
   * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
   * named 'size'.  In SBML Level&nbsp;1, a compartment's volume has a
   * default value (<code>1.0</code>) and therefore this method will always return 
   * <code>true.</code>  In Level 2, a compartment's size (the equivalent of SBML
   * Level&nbsp;1's 'volume') is optional and has no default value, and
   * therefore may or may not be set.
   * <p>
   * @see #isSetSize()
   * @see Compartment#setVolume(double value)
   */
 public boolean isSetVolume() {
    return libsbmlJNI.Compartment_isSetVolume(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link Compartment}'s 'units' attribute is set.
   * <p>
   * @return <code>true</code> if the 'units' attribute of this {@link Compartment} is
   * set, <code>false</code> otherwise.
   * <p>
   * @note There is an important distinction to be made between <em>no units
assigned</em>, and assuming a value without units has any specific unit
such as <code>dimensionless</code>.  In SBML, default units are never
attributed to numbers, and numbers without units are not automatically
assumed to have the unit <code>dimensionless</code>.  Please consult the
relevant SBML specification document for a more in-depth explanation of
this topic and the SBML unit system.

   */
 public boolean isSetUnits() {
    return libsbmlJNI.Compartment_isSetUnits(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link Compartment}'s 'outside' attribute is set.
   * <p>
   * @return <code>true</code> if the 'outside' attribute of this {@link Compartment} is
   * set, <code>false</code> otherwise.
   * <p>
   * @note The 'outside' attribute is defined in SBML Level&nbsp;1 and
   * Level&nbsp;2, but does not exist in SBML Level&nbsp;3 Version&nbsp;1
   * Core.
   */
 public boolean isSetOutside() {
    return libsbmlJNI.Compartment_isSetOutside(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link Compartment}'s 'spatialDimensions' attribute is set.
   * <p>
   * @return <code>true</code> if the 'spatialDimensions' attribute of this
   * {@link Compartment} is set, <code>false</code> otherwise.
   */
 public boolean isSetSpatialDimensions() {
    return libsbmlJNI.Compartment_isSetSpatialDimensions(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link Compartment}'s 'constant' attribute is set.
   * <p>
   * @return <code>true</code> if the 'constant' attribute of this {@link Compartment} is
   * set, <code>false</code> otherwise.
   */
 public boolean isSetConstant() {
    return libsbmlJNI.Compartment_isSetConstant(swigCPtr, this);
  }

  
  /**
   * Sets the value of the 'id' attribute of this {@link Compartment}.
   * <p>
   * The string <code>sid</code> is copied.  Note that SBML has strict requirements
   * for the syntax of identifiers.  The following is a summary of the definition of the SBML identifier type 
<code>SId</code>, which defines the permitted syntax of identifiers.  We
express the syntax using an extended form of BNF notation: 
<p>
<code style='margin-left: 2em'>letter .= 'a'..'z','A'..'Z'</code><br>
<code style='margin-left: 2em'>digit  .= '0'..'9'</code><br>
<code style='margin-left: 2em'>idChar .= letter | digit | '_'</code><br>
<code style='margin-left: 2em'>SId    .= ( letter | '_' ) idChar*</code><br>
<p>
The characters <code>(</code> and <code>)</code> are used for grouping, the
character <code>*</code> 'zero or more times', and the character
<code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
determined by an exact character sequence match; i.e., comparisons must be
performed in a case-sensitive manner.  In addition, there are a few
conditions for the uniqueness of identifiers in an SBML model.  Please
consult the SBML specifications for the exact formulations.
<p>

   * <p>
   * @param sid the string to use as the identifier of this {@link Compartment}
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * </ul>
   */
 public int setId(String sid) {
    return libsbmlJNI.Compartment_setId(swigCPtr, this, sid);
  }

  
  /**
   * Sets the value of the 'name' attribute of this {@link Compartment}.
   * <p>
   * The string in <code>name</code> is copied.
   * <p>
   * @param name the new name for the {@link Compartment}
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * </ul>
   */
 public int setName(String name) {
    return libsbmlJNI.Compartment_setName(swigCPtr, this, name);
  }

  
  /**
   * Sets the 'compartmentType' attribute of this {@link Compartment}.
   * <p>
   * @param sid the identifier of a {@link CompartmentType} object defined
   * elsewhere in this {@link Model}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   * <p>
   * @note The 'compartmentType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   */
 public int setCompartmentType(String sid) {
    return libsbmlJNI.Compartment_setCompartmentType(swigCPtr, this, sid);
  }

  
  /**
   * Sets the 'spatialDimensions' attribute of this {@link Compartment}.
   * <p>
   * If <code>value</code> is not one of <code>0</code>, <code>1</code>, <code>2</code>, or <code>3</code>, this method will
   * have no effect (i.e., the 'spatialDimensions' attribute will not be
   * set).
   * <p>
   * @param value a long integereger indicating the number of dimensions
   * of this compartment.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   */
 public int setSpatialDimensions(long value) {
    return libsbmlJNI.Compartment_setSpatialDimensions__SWIG_0(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'spatialDimensions' attribute of this {@link Compartment} as a double.
   * <p>
   * @param value a double indicating the number of dimensions
   * of this compartment.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   */
 public int setSpatialDimensions(double value) {
    return libsbmlJNI.Compartment_setSpatialDimensions__SWIG_1(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'size' attribute (or 'volume' in SBML Level&nbsp;1) of this
   * {@link Compartment}.
   * <p>
   * This method is identical to
   * {@link Compartment#setVolume(double value)}
   * and is provided for compatibility between
   * SBML Level&nbsp;1 and Level&nbsp;2.
   * <p>
   * @param value a <code>double</code> representing the size of this compartment
   * instance in whatever units are in effect for the compartment.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   * <p>
   * @note The attribute 'volume' only exists by that name in SBML
   * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
   * named 'size'.
   */
 public int setSize(double value) {
    return libsbmlJNI.Compartment_setSize(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'volume' attribute (or 'size' in SBML Level&nbsp;2) of this
   * {@link Compartment}.
   * <p>
   * This method is identical to
   * {@link Compartment#setVolume(double value)}
   * and is provided for compatibility between SBML Level&nbsp;1 and
   * Level&nbsp;2.
   * <p>
   * @param value a <code>double</code> representing the volume of this compartment
   * instance in whatever units are in effect for the compartment.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   * <p>
   * @note The attribute 'volume' only exists by that name in SBML
   * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
   * named 'size'.
   */
 public int setVolume(double value) {
    return libsbmlJNI.Compartment_setVolume(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'units' attribute of this {@link Compartment}.
   * <p>
   * @param sid the identifier of the defined units to use.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * </ul>
   */
 public int setUnits(String sid) {
    return libsbmlJNI.Compartment_setUnits(swigCPtr, this, sid);
  }

  
  /**
   * Sets the 'outside' attribute of this {@link Compartment}.
   * <p>
   * @param sid the identifier of a compartment that encloses this one.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * </ul>
   * <p>
   * @note The 'outside' attribute is defined in SBML Level&nbsp;1 and
   * Level&nbsp;2, but does not exist in SBML Level&nbsp;3 Version&nbsp;1
   * Core.
   */
 public int setOutside(String sid) {
    return libsbmlJNI.Compartment_setOutside(swigCPtr, this, sid);
  }

  
  /**
   * Sets the value of the 'constant' attribute of this {@link Compartment}.
   * <p>
   * @param value a boolean indicating whether the size/volume of this
   * compartment should be considered constant (<code>true</code>) or variable
   * (<code>false</code>)
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   */
 public int setConstant(boolean value) {
    return libsbmlJNI.Compartment_setConstant(swigCPtr, this, value);
  }

  
  /**
   * Renames all the SIdRef attributes on this element, including any found in MathML
   */
 public void renameSIdRefs(String oldid, String newid) {
    libsbmlJNI.Compartment_renameSIdRefs(swigCPtr, this, oldid, newid);
  }

  
  /**
   * Renames all the UnitSIdRef attributes on this element
   */
 public void renameUnitSIdRefs(String oldid, String newid) {
    libsbmlJNI.Compartment_renameUnitSIdRefs(swigCPtr, this, oldid, newid);
  }

  
  /**
   * Unsets the value of the 'name' attribute of this {@link Compartment}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */
 public int unsetName() {
    return libsbmlJNI.Compartment_unsetName(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'compartmentType'
   * attribute of this {@link Compartment}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   * <p>
   * @note The 'compartmentType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   * <p>
   * @see #setCompartmentType(String sid)
   * @see #isSetCompartmentType()
   */
 public int unsetCompartmentType() {
    return libsbmlJNI.Compartment_unsetCompartmentType(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'size' attribute of this {@link Compartment}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @note The attribute 'volume' only exists by that name in SBML
   * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
   * named 'size'.
   */
 public int unsetSize() {
    return libsbmlJNI.Compartment_unsetSize(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'volume' attribute of this
   * {@link Compartment}.
   * <p>
   * In SBML Level&nbsp;1, a {@link Compartment} volume has a default value (<code>1.0</code>) and
   * therefore <em>should always be set</em>.  In Level&nbsp;2, 'size' is
   * optional with no default value and as such may or may not be set.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @note The attribute 'volume' only exists by that name in SBML
   * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
   * named 'size'.
   */
 public int unsetVolume() {
    return libsbmlJNI.Compartment_unsetVolume(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'units' attribute of this {@link Compartment}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */
 public int unsetUnits() {
    return libsbmlJNI.Compartment_unsetUnits(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'outside' attribute of this {@link Compartment}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @note The 'outside' attribute is defined in SBML Level&nbsp;1 and
   * Level&nbsp;2, but does not exist in SBML Level&nbsp;3 Version&nbsp;1
   * Core.
   */
 public int unsetOutside() {
    return libsbmlJNI.Compartment_unsetOutside(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'spatialDimensions' attribute of this {@link Compartment}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   * <p>
   * @note This function is only valid for SBML Level&nbsp;3.
   */
 public int unsetSpatialDimensions() {
    return libsbmlJNI.Compartment_unsetSpatialDimensions(swigCPtr, this);
  }

  
  /**
   * Constructs and returns a {@link UnitDefinition} that corresponds to the units
   * of this {@link Compartment}'s designated size.
   * <p>
   * Compartments in SBML have an attribute ('units') for declaring the
   * units of measurement intended for the value of the compartment's size.
   * In the absence of a value given for this attribute, the units are
   * inherited from values either defined on the enclosing {@link Model} (in SBML
   * Level&nbsp;3) or in defaults (in SBML Level&nbsp;2).  This method
   * returns a {@link UnitDefinition} object based on how this compartment's units
   * are interpreted according to the relevant SBML guidelines, or it
   * returns <code>null</code> if no units have been declared and no defaults are
   * defined by the relevant SBML specification.
   * <p>
   * Note that unit declarations for {@link Compartment} objects are specified in
   * terms of the <em>identifier</em> of a unit (e.g., using
   * {@link Compartment#setUnits(String sid)}), but
   * <em>this</em> method returns a {@link UnitDefinition} object, not a unit
   * identifier.  It does this by constructing an appropriate
   * {@link UnitDefinition}.  For SBML Level&nbsp;2 models, it will do this even
   * when the value of the 'units' attribute is one of the special SBML
   * Level&nbsp;2 unit identifiers <code>'substance'</code>, <code>'volume'</code>, <code>'area'</code>,
   * <code>'length'</code> or <code>'time'.</code>  Callers may find this useful in conjunction
   * with the helper methods provided by the {@link UnitDefinition} class for
   * comparing different {@link UnitDefinition} objects.
   * <p>
   * @return a {@link UnitDefinition} that expresses the units of this 
   * {@link Compartment}, or <code>null</code> if one cannot be constructed.
   * <p>
   * @note The libSBML system for unit analysis depends on the model as a
   * whole.  In cases where the {@link Compartment} object has not yet been added
   * to a model, or the model itself is incomplete, unit analysis is not
   * possible, and consequently this method will return <code>null.</code>
   * <p>
   * @see #isSetUnits()
   * @see #getUnits()
   */
 public UnitDefinition getDerivedUnitDefinition() {
    long cPtr = libsbmlJNI.Compartment_getDerivedUnitDefinition__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, false);
  }

  
  /**
   * Returns the libSBML type code for this SBML object.
   * <p>
   * LibSBML attaches an identifying code to every
   * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
   * other languages, the set of type codes is stored in an enumeration; in
   * the Java language interface for libSBML, the type codes are defined as
   * static integer constants in the interface class {@link
   * libsbmlConstants}.  The names of the type codes all begin with the
   * characters <code>SBML_.</code> 
   * <p>
   * @return the SBML type code for this object, or
   * {@link  libsbmlConstants#SBML_UNKNOWN SBML_UNKNOWN} (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.Compartment_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for {@link Compartment}, is
   * always <code>'compartment'.</code>
   * <p>
   * @return the name of this element, i.e., <code>'compartment'.</code>
   */
 public String getElementName() {
    return libsbmlJNI.Compartment_getElementName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if
   * all the required attributes for this {@link Compartment} object
   * have been set.
   * <p>
   * @note The required attributes for a {@link Compartment} object are:
   * <ul>
   * <li> 'id' (or 'name' in SBML Level&nbsp;1)
   * <li> 'constant' (in SBML Level&nbsp;3 only)
   * </ul>
   * <p>
   * @return a boolean value indicating whether all the required
   * attributes for this object have been defined.
   */
 public boolean hasRequiredAttributes() {
    return libsbmlJNI.Compartment_hasRequiredAttributes(swigCPtr, this);
  }

}
