/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * Parent class for the various SBML 'ListOfXYZ' classes.
 *
 * @htmlinclude not-sbml-warning.html
 *
 * SBML defines various ListOf___ classes that are containers used for
 * organizing the main components of an SBML model.  All are derived from
 * the abstract class SBase, and inherit the attributes and subelements of
 * SBase, such as 'metaid' as and 'annotation'.  The ListOf___ classes do
 * not add any attributes of their own.
 *
 * The ListOf class in libSBML is a utility class that serves as the parent
 * class for implementing the ListOf__ classes.  It provides methods for
 * working generically with the various SBML lists of objects in a program.
 * LibSBML uses this separate list class rather than ordinary
 * @if clike C&#43;&#43; @endif@if java Java@endif@if python Python@endif lists,
 * so that it can provide the methods and features associated with SBase.
 *
 * @see ListOfFunctionDefinitions
 * @see ListOfUnitDefinitions
 * @see ListOfCompartmentTypes
 * @see ListOfSpeciesTypes
 * @see ListOfCompartments
 * @see ListOfSpecies
 * @see ListOfParameters
 * @see ListOfInitialAssignments
 * @see ListOfRules
 * @see ListOfConstraints
 * @see ListOfReactions
 * @see ListOfEvents
 */
public class ListOf : SBase {
	private HandleRef swigCPtr;
	
	internal ListOf(IntPtr cPtr, bool cMemoryOwn) : base(libsbmlPINVOKE.ListOf_SWIGUpcast(cPtr), cMemoryOwn)
	{
		//super(libsbmlPINVOKE.ListOfUpcast(cPtr), cMemoryOwn);
		swigCPtr = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(ListOf obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (ListOf obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~ListOf() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_ListOf(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  
  /**
   * Creates a new ListOf object.
   *
   * @param level the SBML Level; if not assigned, defaults to the
   * value of SBML_DEFAULT_LEVEL.
   * 
   * @param version the Version within the SBML Level; if not assigned,
   * defaults to the value of SBML_DEFAULT_VERSION.
   * 
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public ListOf(long level, long version) : this(libsbmlPINVOKE.new_ListOf__SWIG_0(level, version), true) {
  }

  
  /**
   * Creates a new ListOf object.
   *
   * @param level the SBML Level; if not assigned, defaults to the
   * value of SBML_DEFAULT_LEVEL.
   * 
   * @param version the Version within the SBML Level; if not assigned,
   * defaults to the value of SBML_DEFAULT_VERSION.
   * 
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public ListOf(long level) : this(libsbmlPINVOKE.new_ListOf__SWIG_1(level), true) {
  }

  
  /**
   * Creates a new ListOf object.
   *
   * @param level the SBML Level; if not assigned, defaults to the
   * value of SBML_DEFAULT_LEVEL.
   * 
   * @param version the Version within the SBML Level; if not assigned,
   * defaults to the value of SBML_DEFAULT_VERSION.
   * 
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public ListOf() : this(libsbmlPINVOKE.new_ListOf__SWIG_2(), true) {
  }

  
  /**
   * Creates a new ListOf with SBMLNamespaces object.
   *
   * @param sbmlns the set of namespaces that this ListOf should contain.
   */
 public ListOf(SBMLNamespaces sbmlns) : this(libsbmlPINVOKE.new_ListOf__SWIG_3(SBMLNamespaces.getCPtr(sbmlns)), true) {
  }

  
  /**
   * Copy constructor;  creates a copy of this ListOf.
   *
   * @param orig the ListOf instance to copy.
   */
 public ListOf(ListOf orig) : this(libsbmlPINVOKE.new_ListOf__SWIG_4(ListOf.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Creates and returns a deep copy of this ListOf.
   * 
   * @return a (deep) copy of this ListOf.
   */
 public new SBase clone() {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.ListOf_clone(swigCPtr), true);
	return ret;
}

  
  /**
   * Adds item to the end of this ListOf.
   *
   * This variant of the method makes a clone of the @p item handed to it.
   * This means that when the ListOf is destroyed, the original items will
   * not be destroyed.
   *
   * @param item the item to be added to the list.
   *
   * @see appendAndOwn(SBase item)
   */
 public int append(SBase item) {
    int ret = libsbmlPINVOKE.ListOf_append(swigCPtr, SBase.getCPtr(item));
    return ret;
  }

  
  /**
   * Adds item to the end of this ListOf.
   *
   * This variant of the method does not clone the @p item handed to it;
   * instead, it assumes ownership of it.  This means that when the ListOf
   * is destroyed, the item will be destroyed along with it.
   *
   * @param item the item to be added to the list.
   *
   * @see append(SBase item)
   */
 public int appendAndOwn(SBase item) {
    int ret = libsbmlPINVOKE.ListOf_appendAndOwn(swigCPtr, SBase.getCPtrAndDisown(item));
    return ret;
  }

  
  /**
   * Adds a clone of all items in the provided ListOf to this object.  This means that when this ListOf is destroyed, the original items will not be destroyed.
   *
   * @param list A list of items to be added.
   *
   * @see append(SBase item)
   */
 public int appendFrom(ListOf list) {
    int ret = libsbmlPINVOKE.ListOf_appendFrom(swigCPtr, ListOf.getCPtr(list));
    return ret;
  }

  
  /** 
   * Inserts the item at the given position of this ListOf
   * 
   * This variant of the method makes a clone of the @p item handet to it. 
   * This means that when the ListOf is destroyed, the original items will
   * not be destroyed. 
   * 
   * @param location the location where to insert the item
   * @param item the item to be inserted to the list
   * 
   * @see insertAndOwn(int location, SBase item)
   */
 public int insert(int location, SBase item) {
    int ret = libsbmlPINVOKE.ListOf_insert(swigCPtr, location, SBase.getCPtr(item));
    return ret;
  }

  
  /** 
   * Inserts the item at the given position of this ListOf
   * 
   * This variant of the method makes a clone of the @p item handet to it. 
   * This means that when the ListOf is destroyed, the original items will
   * not be destroyed. 
   * 
   * @param location the location where to insert the item
   * @param item the item to be inserted to the list
   * 
   * @see insert(int location, SBase item)
   */
 public int insertAndOwn(int location, SBase item) {
    int ret = libsbmlPINVOKE.ListOf_insertAndOwn(swigCPtr, location, SBase.getCPtrAndDisown(item));
    return ret;
  }

  
  /**
   * Get an item from the list.
   *
   * @param n the index number of the item to get.
   * 
   * @return the nth item in this ListOf items.
   *
   * @see size()
   */
 public SBase get(long n) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.ListOf_get__SWIG_0(swigCPtr, n), false);
	return ret;
}

  
  /**
   * Returns the first child element found that has the given id in the model-wide SId namespace, or null if no such object is found.
   *
   * @param id string representing the id of objects to find
   *
   * @return pointer to the first element found with the given id.
   */
 public SBase getElementBySId(string id) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.ListOf_getElementBySId(swigCPtr, id), false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
	return ret;
}

  
  /**
   * Returns the first child element it can find with the given metaid, or null if no such object is found.
   *
   * @param metaid string representing the metaid of objects to find
   *
   * @return pointer to the first element found with the given metaid.
   */
 public SBase getElementByMetaId(string metaid) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.ListOf_getElementByMetaId(swigCPtr, metaid), false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
	return ret;
}

  
  /**
   * Removes all items in this ListOf object.
   *
   * If @p doDelete is @c true (default), all items in this ListOf object
   * are deleted and cleared, and thus the caller doesn't have to delete
   * those items.  Otherwise, all items are just cleared from this ListOf
   * object and the caller is responsible for deleting all items.  (In that
   * case, pointers to all items should be stored elsewhere before calling
   * this function.)
   *
   * @param doDelete if @c true (default), all items are deleted and cleared.
   * Otherwise, all items are just cleared and not deleted.
   * 
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */ 
 public void clear(bool doDelete) {
    libsbmlPINVOKE.ListOf_clear__SWIG_0(swigCPtr, doDelete);
  }

  
  /**
   * Removes all items in this ListOf object.
   *
   * If @p doDelete is @c true (default), all items in this ListOf object
   * are deleted and cleared, and thus the caller doesn't have to delete
   * those items.  Otherwise, all items are just cleared from this ListOf
   * object and the caller is responsible for deleting all items.  (In that
   * case, pointers to all items should be stored elsewhere before calling
   * this function.)
   *
   * @param doDelete if @c true (default), all items are deleted and cleared.
   * Otherwise, all items are just cleared and not deleted.
   * 
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */ 
 public void clear() {
    libsbmlPINVOKE.ListOf_clear__SWIG_1(swigCPtr);
  }

  
  /**
   * Because ListOf objects typically live as object children of their parent object and not as pointer children, this function clears itself, but does not attempt to do anything else.  If a particular ListOf subclass does indeed exist as a pointer only, this function will need to be overridden.
   *
   * @return integer value indicating success/failure of the
   * function.  @if clike The value is drawn from the
   * enumeration #OperationReturnValues_t. @endif The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   */
 public int removeFromParentAndDelete() {
    int ret = libsbmlPINVOKE.ListOf_removeFromParentAndDelete(swigCPtr);
    return ret;
  }

  
  /**
   * Removes the <em>n</em>th item from this ListOf items and returns a
   * pointer to it.
   *
   * The caller owns the returned item and is responsible for deleting it.
   *
   * @param n the index of the item to remove
   *
   * @see size()
   */
 public SBase remove(long n) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.ListOf_remove(swigCPtr, n), true);
	return ret;
}

  
  /**
   * Get the size of this ListOf.
   * 
   * @return the number of items in this ListOf items.
   */
 public long size() { return (long)libsbmlPINVOKE.ListOf_size(swigCPtr); }

  
  /**
   * Sets this SBML object to child SBML objects (if any).
   * (Creates a child-parent relationship by the parent)
   *
   * Subclasses must override this function if they define
   * one ore more child elements.
   * Basically, this function needs to be called in
   * constructor, copy constructor and assignment operator.
   *
   * @see setSBMLDocument
   * @see enablePackageInternal
   */
 /* libsbml-internal */ public new void connectToChild() {
    libsbmlPINVOKE.ListOf_connectToChild(swigCPtr);
  }

  
  /**
   * Returns the libSBML type code for this object, namely, @c
   * SBML_LIST_OF.
   * 
   * @if clike LibSBML attaches an identifying code to every kind of SBML
   * object.  These are known as <em>SBML type codes</em>.  The set of
   * possible type codes is defined in the enumeration #SBMLTypeCode_t.
   * The names of the type codes all begin with the characters @c
   * SBML_. @endif@if java LibSBML attaches an identifying code to every
   * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
   * other languages, the set of type codes is stored in an enumeration; in
   * the Java language interface for libSBML, the type codes are defined as
   * static integer constants in the interface class {@link
   * libsbmlcs.libsbml}.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if python LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the Python language interface for libSBML, the type
   * codes are defined as static integer constants in the interface class
   * @link libsbml@endlink.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if csharp LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the C# language interface for libSBML, the type codes
   * are defined as static integer constants in the interface class @link
   * libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
   * the characters @c SBML_. @endif
   *
   * @return the SBML type code for this object, or @link libsbmlcs.libsbml.SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
   *
   * @see getElementName()
   */
 public new int getTypeCode() {
    int ret = libsbmlPINVOKE.ListOf_getTypeCode(swigCPtr);
    return ret;
  }

  
  /**
   * Get the type code of the objects contained in this ListOf.
   * 
   * @if clike LibSBML attaches an identifying code to every kind of SBML
   * object.  These are known as <em>SBML type codes</em>.  The set of
   * possible type codes is defined in the enumeration #SBMLTypeCode_t.
   * The names of the type codes all begin with the characters @c
   * SBML_. @endif@if java LibSBML attaches an identifying code to every
   * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
   * other languages, the set of type codes is stored in an enumeration; in
   * the Java language interface for libSBML, the type codes are defined as
   * static integer constants in the interface class {@link
   * libsbmlcs.libsbml}.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if python LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the Python language interface for libSBML, the type
   * codes are defined as static integer constants in the interface class
   * @link libsbml@endlink.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if csharp LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the C# language interface for libSBML, the type codes
   * are defined as static integer constants in the interface class @link
   * libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
   * the characters @c SBML_. @endif
   * 
   * @return the SBML type code for the objects contained in this ListOf
   * instance, or @link libsbmlcs.libsbml.SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
   */
 public int getItemTypeCode() {
    int ret = libsbmlPINVOKE.ListOf_getItemTypeCode(swigCPtr);
    return ret;
  }

  
  /**
   * Returns the XML element name of this object, which for ListOf, is
   * always @c 'listOf'.
   * 
   * @return the XML name of this element.
   */
 public new string getElementName() {
    string ret = libsbmlPINVOKE.ListOf_getElementName(swigCPtr);
    return ret;
  }

  
  /**
   * Enables/Disables the given package with this element and child
   * elements (if any).
   * (This is an internal implementation for enablePackage function)
   *
   * @note Subclasses of the SBML Core package in which one or more child
   * elements are defined must override this function.
   */
 /* libsbml-internal */ public new void enablePackageInternal(string pkgURI, string pkgPrefix, bool flag) {
    libsbmlPINVOKE.ListOf_enablePackageInternal(swigCPtr, pkgURI, pkgPrefix, flag);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

}

}
