/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * LibSBML implementation of %SBML's %KineticLaw construct.
 *
 * An object of class KineticLaw is used to describe the rate at which the
 * process defined by a given Reaction takes place.  KineticLaw has
 * subelements called 'math' (for MathML content) and 'listOfParameters'
 * (of class ListOfParameters), in addition to the attributes and
 * subelements it inherits from SBase.
 *
 * KineticLaw's 'math' subelement for holding a MathML formula defines the
 * rate of the reaction.  The formula may refer to other entities in a
 * model as well as local parameter definitions within the scope of the
 * Reaction (see below).  It is important to keep in mind, however, that
 * the only Species identifiers that can be used in this formula are those
 * declared in the lists of reactants, products and modifiers in the
 * Reaction structure.  (In other words, before a species can be referenced
 * in the KineticLaw, it must be declared in one of those lists.)
 *
 * KineticLaw provides a way to define @em local parameters whose
 * identifiers can be used in the 'math' formula of that KineticLaw
 * instance.  Prior to SBML Level&nbsp;3, these parameter definitions are
 * stored inside a 'listOfParameters' subelement containing Parameter
 * objects; in SBML Level&nbsp;3, this is achieved using a specialized
 * object class called LocalParameter and the containing subelement is
 * called 'listOfLocalParameters'.  In both cases, the parameters so
 * defined are only visible within the KineticLaw; they cannot be accessed
 * outside.  A local parameter within one reaction is not visible from
 * within another reaction, nor is it visible to any other construct
 * outside of the KineticLaw in which it is defined.  In addition, another
 * important feature is that if such a Parameter (or in Level&nbsp;3,
 * LocalParameter) object has the same identifier as another object in the
 * scope of the enclosing Model, the definition inside the KineticLaw takes
 * precedence.  In other words, within the KineticLaw's 'math' formula,
 * references to local parameter identifiers <strong>shadow any identical
 * global identifiers</strong>.
 *
 * The values of local parameters defined within KineticLaw objects cannot
 * change.  In SBML Level&nbsp;3, this quality is built into the
 * LocalParameter construct.  In Level&nbsp;2, where the same kind of
 * Parameter object class is used as for global parameters, the Parameter
 * objects' 'constant' attribute must always have a value of @c true
 * (either explicitly or left to its default value).
 *
 * 
 * @section shadowing-warning A warning about identifier shadowing
 *
 * A common misconception is that different classes of objects (e.g.,
 * species, compartments, parameters) in SBML have different identifier
 * scopes.  They do not.  The implication is that if a KineticLaw's local
 * parameter definition uses an identifier identical to @em any other
 * identifier defined in the model outside the KineticLaw, even if the
 * other identifier does @em not belong to a parameter type of object, the
 * local parameter's identifier takes precedence within that KineticLaw's
 * 'math' formula.  It is not an error in SBML for identifiers to shadow
 * each other this way, but can lead to confusing and subtle errors.
 *
 * 
 * @section version-diffs SBML Level/Version differences
 *
 * In SBML Level&nbsp;2 Version&nbsp;1, the SBML specification
 * included two additional attributes on KineticLaw called 'substanceUnits'
 * and 'timeUnits'.  They were removed beginning with SBML Level&nbsp;2
 * Version&nbsp;2 because further research determined they introduced many
 * problems.  The most significant problem was that their use could easily
 * lead to the creation of valid models whose reactions nevertheless could
 * not be integrated into a system of equations without outside knowledge
 * for converting the quantities used.  Examination of real-life models
 * revealed that a common reason for using 'substanceUnits' on KineticLaw
 * was to set the units of all reactions to the same set of substance
 * units, something that is better achieved by using UnitDefinition to
 * redefine @c 'substance' for the whole Model.
 *
 * As mentioned above, in SBML Level&nbsp;2 Versions 2&ndash;4, local
 * parameters are of class Parameter.  In SBML Level&nbsp;3, the class of
 * object is LocalParameter.
 */
public class KineticLaw : SBase {
	private HandleRef swigCPtr;
	
	internal KineticLaw(IntPtr cPtr, bool cMemoryOwn) : base(libsbmlPINVOKE.KineticLaw_SWIGUpcast(cPtr), cMemoryOwn)
	{
		//super(libsbmlPINVOKE.KineticLawUpcast(cPtr), cMemoryOwn);
		swigCPtr = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(KineticLaw obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (KineticLaw obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~KineticLaw() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_KineticLaw(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  
  /**
   * Creates a new KineticLaw using the given SBML @p level and @p version
   * values.
   *
   * @param level a long integer, the SBML Level to assign to this KineticLaw
   *
   * @param version a long integer, the SBML Version to assign to this
   * KineticLaw
   * 
   * @note Upon the addition of a KineticLaw object to an SBMLDocument
   * (e.g., using Reaction::setKineticLaw(@if java KineticLaw kl@endif)), the SBML Level, SBML Version
   * and XML namespace of the document @em override the values used
   * when creating the KineticLaw object via this constructor.  This is
   * necessary to ensure that an SBML document is a consistent structure.
   * Nevertheless, the ability to supply the values at the time of creation
   * of a KineticLaw is an important aid to producing valid SBML.  Knowledge
   * of the intented SBML Level and Version determine whether it is valid
   * to assign a particular value to an attribute, or whether it is valid
   * to add an object to an existing SBMLDocument.
   */
 public KineticLaw(long level, long version) : this(libsbmlPINVOKE.new_KineticLaw__SWIG_0(level, version), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Creates a new KineticLaw using the given SBMLNamespaces object
   * @p sbmlns.
   *
   * The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
   * A common approach to using this class constructor is to create an
   * SBMLNamespaces object somewhere in a program, once, then pass it to
   * object constructors such as this one when needed.
   *
   * @param sbmlns an SBMLNamespaces object.
   *
   * @note Upon the addition of a KineticLaw object to an SBMLDocument
   * (e.g., using Reaction::setKineticLaw(@if java KineticLaw kl@endif)), the SBML XML namespace of the
   * document @em overrides the value used when creating the KineticLaw
   * object via this constructor.  This is necessary to ensure that an SBML
   * document is a consistent structure.  Nevertheless, the ability to
   * supply the values at the time of creation of a KineticLaw is an
   * important aid to producing valid SBML.  Knowledge of the intented SBML
   * Level and Version determine whether it is valid to assign a particular
   * value to an attribute, or whether it is valid to add an object to an
   * existing SBMLDocument.
   */
 public KineticLaw(SBMLNamespaces sbmlns) : this(libsbmlPINVOKE.new_KineticLaw__SWIG_1(SBMLNamespaces.getCPtr(sbmlns)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Copy constructor; creates a copy of this KineticLaw.
   */
 public KineticLaw(KineticLaw orig) : this(libsbmlPINVOKE.new_KineticLaw__SWIG_2(KineticLaw.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Creates and returns a deep copy of this KineticLaw object.
   *
   * @return a (deep) copy of this KineticLaw.
   */
 public new KineticLaw clone() {
    IntPtr cPtr = libsbmlPINVOKE.KineticLaw_clone(swigCPtr);
    KineticLaw ret = (cPtr == IntPtr.Zero) ? null : new KineticLaw(cPtr, true);
    return ret;
  }

  
   /**
   * Returns the first child element found that has the given id in the model-wide SId namespace, or null if no such object is found.
   *
   * @param id string representing the id of objects to find.
   *
   * @return pointer to the first element found with the given id.
   */
 public SBase getElementBySId(string id) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.KineticLaw_getElementBySId(swigCPtr, id), false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
	return ret;
}

  
  /**
   * Returns the first child element it can find with the given metaid, or null if no such object is found.
   *
   * @param metaid string representing the metaid of objects to find
   *
   * @return pointer to the first element found with the given metaid.
   */
 public SBase getElementByMetaId(string metaid) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.KineticLaw_getElementByMetaId(swigCPtr, metaid), false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
	return ret;
}

  
/**
   * Returns the mathematical formula for this KineticLaw object and return
   * it as as a text string.
   *
   * This is fundamentally equivalent to
   * @if java KineticLaw::getMath()@else getMath()@endif.
   * This variant is provided principally for compatibility compatibility
   * with SBML Level&nbsp;1.
   * 
   * @return a string representing the formula of this KineticLaw.
   *
   * @note @htmlinclude level-1-uses-text-string-math.html
   *
   * @see getMath()
   */
 public string getFormula() {
    string ret = libsbmlPINVOKE.KineticLaw_getFormula(swigCPtr);
    return ret;
  }

  
  /**
   * Returns the mathematical formula for this KineticLaw object and return
   * it as as an AST.
   *
   * This is fundamentally equivalent to
   * @if java KineticLaw::getFormula()@else getFormula()@endif.
   * The latter is provided principally for compatibility compatibility
   * with SBML Level&nbsp;1, which represented mathematical formulas in
   * text-string form.
   * 
   * @return the ASTNode representation of the mathematical formula.
   *
   * @see getFormula()
   */
 public ASTNode getMath() {
    IntPtr cPtr = libsbmlPINVOKE.KineticLaw_getMath(swigCPtr);
    ASTNode ret = (cPtr == IntPtr.Zero) ? null : new ASTNode(cPtr, false);
    return ret;
  }

  
  /**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Returns the value of the
   * 'timeUnits' attribute of this KineticLaw object.
   *
   * @return the 'timeUnits' attribute value.
   *
   * @note The attributes 'timeUnits' and 'substanceUnits' are present only
   * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
   * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
   * removed.  For compatibility with new versions of SBML, users are
   * cautioned to avoid these attributes.
   */
 public string getTimeUnits() {
    string ret = libsbmlPINVOKE.KineticLaw_getTimeUnits(swigCPtr);
    return ret;
  }

  
  /**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Returns the value of the
   * 'substanceUnits' attribute of this KineticLaw object.
   *
   * @return the 'substanceUnits' attribute value.
   *
   * @note The attributes 'timeUnits' and 'substanceUnits' are present only
   * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
   * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
   * removed.  For compatibility with new versions of SBML, users are
   * cautioned to avoid these attributes.
   */
 public string getSubstanceUnits() {
    string ret = libsbmlPINVOKE.KineticLaw_getSubstanceUnits(swigCPtr);
    return ret;
  }

  
  /**
   * Predicate returning @c true if this
   * KineticLaw's 'formula' attribute is set.
   *
   * This is functionally identical to the method
   * @if java KineticLaw::isSetMath()@else isSetMath()@endif.  It is
   * provided in order to mirror the parallel between
   * @if java KineticLaw::getFormula()@else getFormula()@endif and
   * @if java KineticLaw::getMath()@else getMath()@endif.
   *
   * @return @c true if the formula (meaning the @c math subelement) of
   * this KineticLaw is set, @c false otherwise.
   *
   * @note @htmlinclude level-1-uses-text-string-math.html
   *
   * @see isSetMath()
   */  
 public bool isSetFormula() {
    bool ret = libsbmlPINVOKE.KineticLaw_isSetFormula(swigCPtr);
    return ret;
  }

  
  /**
   * Predicate returning @c true if this
   * Kinetic's 'math' subelement is set.
   *
   * This is identical to the method
   * @if java KineticLaw::isSetFormula()@else isSetFormula()@endif.
   * It is provided in order to mirror the parallel between
   * @if java KineticLaw::getFormula()@else getFormula()@endif and
   * @if java KineticLaw::getMath()@else getMath()@endif.
   * 
   * @return @c true if the formula (meaning the @c math subelement) of
   * this KineticLaw is set, @c false otherwise.
   * 
   * @see isSetFormula()
   */
 public bool isSetMath() {
    bool ret = libsbmlPINVOKE.KineticLaw_isSetMath(swigCPtr);
    return ret;
  }

  
  /**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Predicate returning @c true if
   * this SpeciesReference's 'timeUnits' attribute is set.
   *
   * @return @c true if the 'timeUnits' attribute of this KineticLaw object
   * is set, @c false otherwise.
   *
   * @note The attributes 'timeUnits' and 'substanceUnits' are present only
   * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
   * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
   * removed.  For compatibility with new versions of SBML, users are
   * cautioned to avoid these attributes.
   */
 public bool isSetTimeUnits() {
    bool ret = libsbmlPINVOKE.KineticLaw_isSetTimeUnits(swigCPtr);
    return ret;
  }

  
  /**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Predicate returning @c true if
   * this SpeciesReference's 'substanceUnits' attribute is set.
   *
   * @return @c true if the 'substanceUnits' attribute of this KineticLaw
   * object is set, @c false otherwise.
   *
   * @note The attributes 'timeUnits' and 'substanceUnits' are present only
   * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
   * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
   * removed.  For compatibility with new versions of SBML, users are
   * cautioned to avoid these attributes.
   */
 public bool isSetSubstanceUnits() {
    bool ret = libsbmlPINVOKE.KineticLaw_isSetSubstanceUnits(swigCPtr);
    return ret;
  }

  
  /**
   * Sets the mathematical expression of this KineticLaw instance to the
   * given @p formula.
   *
   * The given @p formula string is copied.  Internally, libSBML stores the
   * mathematical expression as an ASTNode.
   *
   * @param formula the mathematical expression to use, represented in
   * text-string form.
   *
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
   *
   * @note @htmlinclude level-1-uses-text-string-math.html
   *
   * @see setMath(ASTNode math)
   */
 public int setFormula(string formula) {
    int ret = libsbmlPINVOKE.KineticLaw_setFormula(swigCPtr, formula);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Sets the mathematical expression of this KineticLaw instance to a copy
   * of the given ASTNode.
   *
   * This is fundamentally identical to
   * @if java KineticLaw::setFormula(String formula)@else getFormula()@endif.
   * The latter is provided principally for compatibility compatibility with
   * SBML Level&nbsp;1, which represented mathematical formulas in text-string
   * form.
   *
   * @param math an ASTNode representing a formula tree.
   *
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
   *
   * @see setFormula(string formula)
   */
 public int setMath(ASTNode math) {
    int ret = libsbmlPINVOKE.KineticLaw_setMath(swigCPtr, ASTNode.getCPtr(math));
    return ret;
  }

  
  /**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Sets the 'timeUnits' attribute
   * of this KineticLaw object to a copy of the identifier in @p sid.
   *
   * @param sid the identifier of the units to use.
   *
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
   *
   * @note The attributes 'timeUnits' and 'substanceUnits' are present only
   * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
   * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
   * removed.  For compatibility with new versions of SBML, users are
   * cautioned to avoid these attributes.
   */
 public int setTimeUnits(string sid) {
    int ret = libsbmlPINVOKE.KineticLaw_setTimeUnits(swigCPtr, sid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Sets the 'substanceUnits'
   * attribute of this KineticLaw object to a copy of the identifier given
   * in @p sid.
   *
   * @param sid the identifier of the units to use.
   *
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
   *
   * @note The attributes 'timeUnits' and 'substanceUnits' are present only
   * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
   * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
   * removed.  For compatibility with new versions of SBML, users are
   * cautioned to avoid these attributes.
   */
 public int setSubstanceUnits(string sid) {
    int ret = libsbmlPINVOKE.KineticLaw_setSubstanceUnits(swigCPtr, sid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Unsets the 'timeUnits'
   * attribugte of this KineticLaw object.
   *
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
   *
   * @note The attributes 'timeUnits' and 'substanceUnits' are present only
   * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
   * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
   * removed.  For compatibility with new versions of SBML, users are
   * cautioned to avoid these attributes.
   */
 public int unsetTimeUnits() {
    int ret = libsbmlPINVOKE.KineticLaw_unsetTimeUnits(swigCPtr);
    return ret;
  }

  
  /**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Unsets the 'substanceUnits'
   * attribute of this KineticLaw object.
   *
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
   *
   * @note The attributes 'timeUnits' and 'substanceUnits' are present only
   * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
   * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
   * removed.  For compatibility with new versions of SBML, users are
   * cautioned to avoid these attributes.
   */
 public int unsetSubstanceUnits() {
    int ret = libsbmlPINVOKE.KineticLaw_unsetSubstanceUnits(swigCPtr);
    return ret;
  }

  
  /**
   * Adds a copy of the given Parameter object to the list of local
   * parameters in this KineticLaw.
   *
   * @param p the Parameter to add
   *
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   *
   * @note This method should be used with some caution.  The fact that
   * this method @em copies the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this KineticLaw.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the KineticLaw</em>.  In addition, the caller should make
   * sure to free the original object if it is no longer being used, or
   * else a memory leak will result.  Please see
   * @if java KineticLaw::createParameter()@else createParameter()@endif
   * for a method that does not lead to these issues.
   *
   * @see createParameter()
   */
 public int addParameter(Parameter p) {
    int ret = libsbmlPINVOKE.KineticLaw_addParameter(swigCPtr, Parameter.getCPtr(p));
    return ret;
  }

  
  /**
   * Adds a copy of the given LocalParameter object to the list of local
   * parameters in this KineticLaw.
   *
   * @param p the LocalParameter to add
   *
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   *
   * @note This method should be used with some caution.  The fact that
   * this method @em copies the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this KineticLaw.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the KineticLaw</em>.  In addition, the caller should make
   * sure to free the original object if it is no longer being used, or
   * else a memory leak will result.  Please see
   * @if java KineticLaw::createParameter()@else createParameter()@endif
   * for a method that does not lead to these issues.
   *
   * @see createLocalParameter()
   */
 public int addLocalParameter(LocalParameter p) {
    int ret = libsbmlPINVOKE.KineticLaw_addLocalParameter(swigCPtr, LocalParameter.getCPtr(p));
    return ret;
  }

  
  /**
   * Creates a new Parameter object, adds it to this KineticLaw's list of
   * local parameters, and returns the Parameter object created.
   *
   * @return a new Parameter object instance
   *
   * @see addParameter(Parameter p)
   */
 public Parameter createParameter() {
    IntPtr cPtr = libsbmlPINVOKE.KineticLaw_createParameter(swigCPtr);
    Parameter ret = (cPtr == IntPtr.Zero) ? null : new Parameter(cPtr, false);
    return ret;
  }

  
  /**
   * Creates a new LocalParameter object, adds it to this KineticLaw's list
   * of local parameters, and returns the LocalParameter object created.
   *
   * @return a new LocalParameter object instance
   *
   * @see addLocalParameter(LocalParameter p)
   */
 public LocalParameter createLocalParameter() {
    IntPtr cPtr = libsbmlPINVOKE.KineticLaw_createLocalParameter(swigCPtr);
    LocalParameter ret = (cPtr == IntPtr.Zero) ? null : new LocalParameter(cPtr, false);
    return ret;
  }

  
  /**
   * Returns the list of local parameters in this KineticLaw object.
   * 
   * @return the list of Parameters for this KineticLaw.
   */
 public ListOfParameters getListOfParameters() {
    IntPtr cPtr = libsbmlPINVOKE.KineticLaw_getListOfParameters__SWIG_0(swigCPtr);
    ListOfParameters ret = (cPtr == IntPtr.Zero) ? null : new ListOfParameters(cPtr, false);
    return ret;
  }

  
  /**
   * Returns the list of local parameters in this KineticLaw object.
   * 
   * @return the list of LocalParameters for this KineticLaw.
   */
 public ListOfLocalParameters getListOfLocalParameters() {
    IntPtr cPtr = libsbmlPINVOKE.KineticLaw_getListOfLocalParameters__SWIG_0(swigCPtr);
    ListOfLocalParameters ret = (cPtr == IntPtr.Zero) ? null : new ListOfLocalParameters(cPtr, false);
    return ret;
  }

  
  /**
   * Returns the nth Parameter object in the list of local parameters in
   * this KineticLaw instance.
   *
   * @param n the index of the Parameter object sought
   * 
   * @return the nth Parameter of this KineticLaw.
   */
 public Parameter getParameter(long n) {
    IntPtr cPtr = libsbmlPINVOKE.KineticLaw_getParameter__SWIG_0(swigCPtr, n);
    Parameter ret = (cPtr == IntPtr.Zero) ? null : new Parameter(cPtr, false);
    return ret;
  }

  
  /**
   * Returns the nth LocalParameter object in the list of local parameters in
   * this KineticLaw instance.
   *
   * @param n the index of the LocalParameter object sought
   * 
   * @return the nth LocalParameter of this KineticLaw.
   */
 public LocalParameter getLocalParameter(long n) {
    IntPtr cPtr = libsbmlPINVOKE.KineticLaw_getLocalParameter__SWIG_0(swigCPtr, n);
    LocalParameter ret = (cPtr == IntPtr.Zero) ? null : new LocalParameter(cPtr, false);
    return ret;
  }

  
  /**
   * Returns a local parameter based on its identifier.
   *
   * @param sid the identifier of the Parameter being sought.
   * 
   * @return the Parameter object in this KineticLaw instace having the
   * given 'id', or @c null if no such Parameter exists.
   */
 public Parameter getParameter(string sid) {
    IntPtr cPtr = libsbmlPINVOKE.KineticLaw_getParameter__SWIG_2(swigCPtr, sid);
    Parameter ret = (cPtr == IntPtr.Zero) ? null : new Parameter(cPtr, false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Returns a local parameter based on its identifier.
   *
   * @param sid the identifier of the LocalParameter being sought.
   * 
   * @return the LocalParameter object in this KineticLaw instace having the
   * given 'id', or @c null if no such LocalParameter exists.
   */
 public LocalParameter getLocalParameter(string sid) {
    IntPtr cPtr = libsbmlPINVOKE.KineticLaw_getLocalParameter__SWIG_2(swigCPtr, sid);
    LocalParameter ret = (cPtr == IntPtr.Zero) ? null : new LocalParameter(cPtr, false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Returns the number of local parameters in this KineticLaw instance.
   * 
   * @return the number of Parameters in this KineticLaw.
   */
 public long getNumParameters() { return (long)libsbmlPINVOKE.KineticLaw_getNumParameters(swigCPtr); }

  
  /**
   * Returns the number of local parameters in this KineticLaw instance.
   * 
   * @return the number of LocalParameters in this KineticLaw.
   */
 public long getNumLocalParameters() { return (long)libsbmlPINVOKE.KineticLaw_getNumLocalParameters(swigCPtr); }

  
  /**
   * Calculates and returns a UnitDefinition that expresses the units
   * of measurement assumed for the 'math' expression of this
   * KineticLaw.
   *
   * The units are calculated based on the mathematical expression in the
   * KineticLaw and the model quantities referenced by
   * <c>&lt;ci&gt;</c> elements used within that expression.  The
   * @if java KineticLaw::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif
   * method returns the calculated units.
   *
   * Note that the functionality that facilitates unit analysis depends 
   * on the model as a whole.  Thus, in cases where the object has not 
   * been added to a model or the model itself is incomplete,
   * unit analysis is not possible and this method will return @c null.
   *
   * @warning Note that it is possible the 'math' expression in the
   * KineticLaw contains pure numbers or parameters with undeclared
   * units.  In those cases, it is not possible to calculate the units of
   * the overall expression without making assumptions.  LibSBML does not
   * make assumptions about the units, and
   * @if java KineticLaw::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif
   * only returns the units as far as it is able to determine them.  For
   * example, in an expression <em>X + Y</em>, if <em>X</em> has
   * unambiguously-defined units and <em>Y</em> does not, it will return
   * the units of <em>X</em>.  <strong>It is important that callers also
   * invoke the method</strong>
   * @if java KineticLaw::containsUndeclaredUnits()@else containsUndeclaredUnits()@endif
   * <strong>to determine whether this situation holds</strong>.  Callers may
   * wish to take suitable actions in those scenarios.
   *
   * @return a UnitDefinition that expresses the units of the math 
   * expression of this KineticLaw, or @c null if one cannot be constructed.
   *
   * @see containsUndeclaredUnits()
   */
 public UnitDefinition getDerivedUnitDefinition() {
    IntPtr cPtr = libsbmlPINVOKE.KineticLaw_getDerivedUnitDefinition__SWIG_0(swigCPtr);
    UnitDefinition ret = (cPtr == IntPtr.Zero) ? null : new UnitDefinition(cPtr, false);
    return ret;
  }

  
  /**
   * Predicate returning @c true if 
   * the math expression of this KineticLaw contains
   * parameters/numbers with undeclared units.
   * 
   * @return @c true if the math expression of this KineticLaw
   * includes parameters/numbers 
   * with undeclared units, @c false otherwise.
   *
   * @note A return value of @c true indicates that the UnitDefinition
   * returned by
   * @if java KineticLaw::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif
   * may not accurately represent the units of the expression.
   *
   * @see getDerivedUnitDefinition()
   */
 public bool containsUndeclaredUnits() {
    bool ret = libsbmlPINVOKE.KineticLaw_containsUndeclaredUnits__SWIG_0(swigCPtr);
    return ret;
  }

  
  /**
   * Removes the nth Parameter object in the list of local parameters 
   * in this KineticLaw instance and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param n the index of the Parameter object to remove
   * 
   * @return the Parameter object removed.  As mentioned above, 
   * the caller owns the returned item. @c null is returned if the given index 
   * is out of range.
   */
 public Parameter removeParameter(long n) {
    IntPtr cPtr = libsbmlPINVOKE.KineticLaw_removeParameter__SWIG_0(swigCPtr, n);
    Parameter ret = (cPtr == IntPtr.Zero) ? null : new Parameter(cPtr, true);
    return ret;
  }

  
  /**
   * Removes the nth LocalParameter object in the list of local parameters 
   * in this KineticLaw instance and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param n the index of the LocalParameter object to remove
   * 
   * @return the LocalParameter object removed.  As mentioned above, 
   * the caller owns the returned item. @c null is returned if the given index 
   * is out of range.
   */
 public LocalParameter removeLocalParameter(long n) {
    IntPtr cPtr = libsbmlPINVOKE.KineticLaw_removeLocalParameter__SWIG_0(swigCPtr, n);
    LocalParameter ret = (cPtr == IntPtr.Zero) ? null : new LocalParameter(cPtr, true);
    return ret;
  }

  
  /**
   * Removes a Parameter object with the given identifier in the list of
   * local parameters in this KineticLaw instance and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param sid the identifier of the Parameter to remove
   * 
   * @return the Parameter object removed.  As mentioned above, the 
   * caller owns the returned object. @c null is returned if no Parameter
   * object with the identifier exists in this KineticLaw instance.
   */
 public Parameter removeParameter(string sid) {
    IntPtr cPtr = libsbmlPINVOKE.KineticLaw_removeParameter__SWIG_1(swigCPtr, sid);
    Parameter ret = (cPtr == IntPtr.Zero) ? null : new Parameter(cPtr, true);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Removes a LocalParameter object with the given identifier in the list of
   * local parameters in this KineticLaw instance and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param sid the identifier of the LocalParameter to remove
   * 
   * @return the LocalParameter object removed.  As mentioned above, the 
   * caller owns the returned object. @c null is returned if no LocalParameter
   * object with the identifier exists in this KineticLaw instance.
   */
 public LocalParameter removeLocalParameter(string sid) {
    IntPtr cPtr = libsbmlPINVOKE.KineticLaw_removeLocalParameter__SWIG_1(swigCPtr, sid);
    LocalParameter ret = (cPtr == IntPtr.Zero) ? null : new LocalParameter(cPtr, true);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Sets this SBML object to child SBML objects (if any).
   * (Creates a child-parent relationship by the parent)
   *
   * Subclasses must override this function if they define
   * one ore more child elements.
   * Basically, this function needs to be called in
   * constructor, copy constructor and assignment operator.
   *
   * @see setSBMLDocument
   * @see enablePackageInternal
   */
 /* libsbml-internal */ public new void connectToChild() {
    libsbmlPINVOKE.KineticLaw_connectToChild(swigCPtr);
  }

  
  /**
   * Enables/Disables the given package with this element and child
   * elements (if any).
   * (This is an internal implementation for enablePackage function)
   *
   * @note Subclasses of the SBML Core package in which one or more child
   * elements are defined must override this function.
   */
 /* libsbml-internal */ public new void enablePackageInternal(string pkgURI, string pkgPrefix, bool flag) {
    libsbmlPINVOKE.KineticLaw_enablePackageInternal(swigCPtr, pkgURI, pkgPrefix, flag);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Returns the libSBML type code for this %SBML object.
   * 
   * @if clike LibSBML attaches an identifying code to every kind of SBML
   * object.  These are known as <em>SBML type codes</em>.  The set of
   * possible type codes is defined in the enumeration #SBMLTypeCode_t.
   * The names of the type codes all begin with the characters @c
   * SBML_. @endif@if java LibSBML attaches an identifying code to every
   * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
   * other languages, the set of type codes is stored in an enumeration; in
   * the Java language interface for libSBML, the type codes are defined as
   * static integer constants in the interface class {@link
   * libsbmlcs.libsbml}.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if python LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the Python language interface for libSBML, the type
   * codes are defined as static integer constants in the interface class
   * @link libsbml@endlink.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if csharp LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the C# language interface for libSBML, the type codes
   * are defined as static integer constants in the interface class @link
   * libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
   * the characters @c SBML_. @endif
   *
   * @return the SBML type code for this object, or @link
   * libsbmlcs.libsbml.SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
   *
   * @see getElementName()
   */
 public new int getTypeCode() {
    int ret = libsbmlPINVOKE.KineticLaw_getTypeCode(swigCPtr);
    return ret;
  }

  
  /**
   * Returns the XML element name of this object, which for Species, is
   * always @c 'kineticLaw'.
   * 
   * @return the name of this element, i.e., @c 'kineticLaw'.
   */
 public new string getElementName() {
    string ret = libsbmlPINVOKE.KineticLaw_getElementName(swigCPtr);
    return ret;
  }

  
  /**
   * Predicate returning @c true if
   * all the required attributes for this KineticLaw object
   * have been set.
   *
   * @note The required attributes for a KineticLaw object are:
   * @li 'formula' (SBML Level&nbsp;1 only)
   *
   * @return a bool value indicating whether all the required
   * attributes for this object have been defined.
   */
 public new bool hasRequiredAttributes() {
    bool ret = libsbmlPINVOKE.KineticLaw_hasRequiredAttributes(swigCPtr);
    return ret;
  }

  
  /**
   * Predicate returning @c true if
   * all the required elements for this KineticLaw object
   * have been set.
   *
   * @note The required elements for a KineticLaw object are:
   * @li 'math'
   *
   * @return a bool value indicating whether all the required
   * elements for this object have been defined.
   */
 public new bool hasRequiredElements() {
    bool ret = libsbmlPINVOKE.KineticLaw_hasRequiredElements(swigCPtr);
    return ret;
  }

  
  /**
   * Finds this KineticLaw's Reaction parent and calls unsetKineticLaw() on it, indirectly deleting itself.  Overridden from the SBase function since the parent is not a ListOf.
   *
   * @return integer value indicating success/failure of the
   * function.  @if clike The value is drawn from the
   * enumeration #OperationReturnValues_t. @endif The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   */
 public int removeFromParentAndDelete() {
    int ret = libsbmlPINVOKE.KineticLaw_removeFromParentAndDelete(swigCPtr);
    return ret;
  }

  
  /**
   * Renames all the SIdRef attributes on this element, including any found in MathML
   */
 public void renameSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.KineticLaw_renameSIdRefs(swigCPtr, oldid, newid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Renames all the UnitSIdRef attributes on this element
   */
 public void renameUnitSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.KineticLaw_renameUnitSIdRefs(swigCPtr, oldid, newid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Replace all nodes with the name 'id' from the child 'math' object with the provided function. 
   *
   */
 /* libsbml-internal */ public void replaceSIDWithFunction(string id, ASTNode function) {
    libsbmlPINVOKE.KineticLaw_replaceSIDWithFunction(swigCPtr, id, ASTNode.getCPtr(function));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * If this reaction id matches the provided 'id' string, replace the 'math' object with the function (existing/function). 
   */
 /* libsbml-internal */ public void divideAssignmentsToSIdByFunction(string id, ASTNode function) {
    libsbmlPINVOKE.KineticLaw_divideAssignmentsToSIdByFunction(swigCPtr, id, ASTNode.getCPtr(function));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

}

}
