/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbml {

using System;
using System.Runtime.InteropServices;

public class SBMLValidator : IDisposable {
	private HandleRef swigCPtr;
	protected bool swigCMemOwn;
	
	internal SBMLValidator(IntPtr cPtr, bool cMemoryOwn)
	{
		swigCMemOwn = cMemoryOwn;
		swigCPtr    = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(SBMLValidator obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (SBMLValidator obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~SBMLValidator() {
    Dispose();
  }

  public virtual void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_SBMLValidator(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
    }
  }

  
  /**
  * Constructor.
  */
 public SBMLValidator() : this(libsbmlPINVOKE.new_SBMLValidator__SWIG_0(), true) {
    SwigDirectorConnect();
  }

  
  /**
  * Copy constructor.
  */
 public SBMLValidator(SBMLValidator arg0) : this(libsbmlPINVOKE.new_SBMLValidator__SWIG_1(SBMLValidator.getCPtr(arg0)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    SwigDirectorConnect();
  }

  
  /**
  * Creates and returns a deep copy of this SBMLConverter.
  * 
  * @return a (deep) copy of this SBMLConverter.
  */
 public SBMLValidator clone() {
    IntPtr cPtr = (SwigDerivedClassHasMethod("clone", swigMethodTypes0) ? libsbmlPINVOKE.SBMLValidator_cloneSwigExplicitSBMLValidator(swigCPtr) : libsbmlPINVOKE.SBMLValidator_clone(swigCPtr));
    SBMLValidator ret = (cPtr == IntPtr.Zero) ? null : new SBMLValidator(cPtr, true);
    return ret;
  }

  
  /**
   * @return the current SBML document
   */
 public SBMLDocument getDocument() {
    IntPtr cPtr = (SwigDerivedClassHasMethod("getDocument", swigMethodTypes1) ? libsbmlPINVOKE.SBMLValidator_getDocumentSwigExplicitSBMLValidator__SWIG_0(swigCPtr) : libsbmlPINVOKE.SBMLValidator_getDocument__SWIG_0(swigCPtr));
    SBMLDocument ret = (cPtr == IntPtr.Zero) ? null : new SBMLDocument(cPtr, false);
    return ret;
  }

  
  /** 
   * Sets the current SBML document
   * 
   * @param doc the document to use for this validation
   * 
   * @return status code
   */
 public int setDocument(SBMLDocument doc) {
    int ret = (SwigDerivedClassHasMethod("setDocument", swigMethodTypes3) ? libsbmlPINVOKE.SBMLValidator_setDocumentSwigExplicitSBMLValidator(swigCPtr, SBMLDocument.getCPtr(doc)) : libsbmlPINVOKE.SBMLValidator_setDocument(swigCPtr, SBMLDocument.getCPtr(doc)));
    return ret;
  }

  
  /** 
   * the actual validation code 
   * 
   * @return number of validation errors encountered
   */
 public long validate() { return (long)(SwigDerivedClassHasMethod("validate", swigMethodTypes4) ? libsbmlPINVOKE.SBMLValidator_validateSwigExplicitSBMLValidator__SWIG_0(swigCPtr) : libsbmlPINVOKE.SBMLValidator_validate__SWIG_0(swigCPtr)); }

  
  /**
   * Clears the Validator's list of failures.
   *
   * If you are validating multiple SBML documents with the same Validator,
   * call this method after you have processed the list of failures from
   * the last Validation run and before validating the next document.
   */
 public void clearFailures() {
    if (SwigDerivedClassHasMethod("clearFailures", swigMethodTypes5)) libsbmlPINVOKE.SBMLValidator_clearFailuresSwigExplicitSBMLValidator(swigCPtr); else libsbmlPINVOKE.SBMLValidator_clearFailures(swigCPtr);
  }

  
  /**
   * Adds the given failure to this list of Validators failures.
   */
 public void logFailure(SBMLError msg) {
    libsbmlPINVOKE.SBMLValidator_logFailure(swigCPtr, SBMLError.getCPtr(msg));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
    /**
   * Validates the given SBMLDocument.  Failures logged during
   * validation may be retrieved via getFailures().
   *
   * @return the number of validation errors that occurred.
   */
 public long validate(SBMLDocument d) { return (long)libsbmlPINVOKE.SBMLValidator_validate__SWIG_1(swigCPtr, SBMLDocument.getCPtr(d)); }

  
  /**
   * Validates the given SBMLDocument.  Failures logged during
   * validation may be retrieved via getFailures().
   *
   * @return the number of validation errors that occurred.
   */
 public long validate(string filename) { return (long)libsbmlPINVOKE.SBMLValidator_validate__SWIG_2(swigCPtr, filename); }

  
  /**
   * Returns the list of errors or warnings logged during parsing, 
   * consistency checking, or attempted translation of this model.
   * 
   * @return the SBMLErrorLog used for the SBMLDocument
   * 
   * @see SBMLDocument::getNumErrors()
   */
 public SBMLErrorLog getErrorLog() {
    IntPtr cPtr = libsbmlPINVOKE.SBMLValidator_getErrorLog(swigCPtr);
    SBMLErrorLog ret = (cPtr == IntPtr.Zero) ? null : new SBMLErrorLog(cPtr, false);
    return ret;
  }

  
  /**
   * Returns the Model object stored in the SBMLDocument.
   *
   * It is important to note that this method <em>does not create</em> a
   * Model instance.  The model in the SBMLDocument must have been created
   * at some prior time, for example using SBMLDocument::createModel() 
   * or SBMLDocument::setModel(@if java Model m@endif).
   * This method returns @c null if a model does not yet exist.
   * 
   * @return the Model contained in the SBMLDocument.
   *
   */
 public Model getModel() {
    IntPtr cPtr = libsbmlPINVOKE.SBMLValidator_getModel__SWIG_0(swigCPtr);
    Model ret = (cPtr == IntPtr.Zero) ? null : new Model(cPtr, false);
    return ret;
  }

  
  /** 
   * Returns the local number of failures
   * 
   * This method returns the number of failures logged by this validator 
   * (that is it does not include the number of the documents error log).
   *
   * @return the number of errors logged by this validator. 
   */
 public long getNumFailures() { return (long)libsbmlPINVOKE.SBMLValidator_getNumFailures(swigCPtr); }

  
  /** 
   * Returns the failure at the given index. 
   *
   * @param n the zero based index of failures
   * 
   * @return the failure at the given index
   */
 public SBMLError getFailure(long n) {
    IntPtr cPtr = libsbmlPINVOKE.SBMLValidator_getFailure(swigCPtr, n);
    SBMLError ret = (cPtr == IntPtr.Zero) ? null : new SBMLError(cPtr, false);
    return ret;
  }

  private void SwigDirectorConnect() {
    if (SwigDerivedClassHasMethod("clone", swigMethodTypes0))
      swigDelegate0 = new SwigDelegateSBMLValidator_0(SwigDirectorclone);
    if (SwigDerivedClassHasMethod("getDocument", swigMethodTypes1))
      swigDelegate1 = new SwigDelegateSBMLValidator_1(SwigDirectorgetDocument__SWIG_0);
    if (SwigDerivedClassHasMethod("getDocument", swigMethodTypes2))
      swigDelegate2 = new SwigDelegateSBMLValidator_2(SwigDirectorgetDocument__SWIG_1);
    if (SwigDerivedClassHasMethod("setDocument", swigMethodTypes3))
      swigDelegate3 = new SwigDelegateSBMLValidator_3(SwigDirectorsetDocument);
    if (SwigDerivedClassHasMethod("validate", swigMethodTypes4))
      swigDelegate4 = new SwigDelegateSBMLValidator_4(SwigDirectorvalidate__SWIG_0);
    if (SwigDerivedClassHasMethod("clearFailures", swigMethodTypes5))
      swigDelegate5 = new SwigDelegateSBMLValidator_5(SwigDirectorclearFailures);
    libsbmlPINVOKE.SBMLValidator_director_connect(swigCPtr, swigDelegate0, swigDelegate1, swigDelegate2, swigDelegate3, swigDelegate4, swigDelegate5);
  }

  private bool SwigDerivedClassHasMethod(string methodName, Type[] methodTypes) {
    System.Reflection.MethodInfo methodInfo = this.GetType().GetMethod(methodName, System.Reflection.BindingFlags.Public | System.Reflection.BindingFlags.NonPublic | System.Reflection.BindingFlags.Instance, null, methodTypes, null);
    bool hasDerivedMethod = methodInfo.DeclaringType.IsSubclassOf(typeof(SBMLValidator));
    return hasDerivedMethod;
  }

  private IntPtr SwigDirectorclone() {
    return SBMLValidator.getCPtr(clone()).Handle;
  }

  private IntPtr SwigDirectorgetDocument__SWIG_0() {
    return SBMLDocument.getCPtr(getDocument()).Handle;
  }

  private IntPtr SwigDirectorgetDocument__SWIG_1() {
    return SBMLDocument.getCPtr(getDocument()).Handle;
  }

  private int SwigDirectorsetDocument(IntPtr doc) {
    return setDocument((doc == IntPtr.Zero) ? null : new SBMLDocument(doc, false));
  }

  private uint SwigDirectorvalidate__SWIG_0() {
    return (uint)validate();
  }

  private void SwigDirectorclearFailures() {
    clearFailures();
  }

  public delegate IntPtr SwigDelegateSBMLValidator_0();
  public delegate IntPtr SwigDelegateSBMLValidator_1();
  public delegate IntPtr SwigDelegateSBMLValidator_2();
  public delegate int SwigDelegateSBMLValidator_3(IntPtr doc);
  public delegate uint SwigDelegateSBMLValidator_4();
  public delegate void SwigDelegateSBMLValidator_5();

  private SwigDelegateSBMLValidator_0 swigDelegate0;
  private SwigDelegateSBMLValidator_1 swigDelegate1;
  private SwigDelegateSBMLValidator_2 swigDelegate2;
  private SwigDelegateSBMLValidator_3 swigDelegate3;
  private SwigDelegateSBMLValidator_4 swigDelegate4;
  private SwigDelegateSBMLValidator_5 swigDelegate5;

  private static Type[] swigMethodTypes0 = new Type[] {  };
  private static Type[] swigMethodTypes1 = new Type[] {  };
  private static Type[] swigMethodTypes2 = new Type[] {  };
  private static Type[] swigMethodTypes3 = new Type[] { typeof(SBMLDocument) };
  private static Type[] swigMethodTypes4 = new Type[] {  };
  private static Type[] swigMethodTypes5 = new Type[] {  };
}

}
