/* this is a roxen module */
/* c burgess 20/1/99           */

/*
 * written to provide a means of producing nice catalogues from
 * sqlqueries without resorting to lunatic multiple queries :)
 *
 * you may experience unexpected results with some tables - for
 * instance, a vert cols=4 table where there are nine results will
 * give one empty column and three of three. this only seems to happen
 * where (rows < cols) && (rows = cols-1) ...
 * this is because it deduces the number of rows, then (effectively)
 * fills each row first. (that's not true, but it explains what
 * happens.)
 *
 * chris burgess, chris@ibex.co.nz, 20/1/99
 */

int thread_safe=1;

#include <module.h>
#include <simulate.h>
inherit "module";

// inherit "roxenlib";

// #define DEBUG

static private string doc()
{
  return "<tt>table, tr, td, (*)_end, emptycell</tt> args replace the specified tag with the argument value.<br>" + 
    "<tt>sep</tt> defines the separator (default |)<br>" + 
    "<tt>cols</tt> defines the number of columns to create<br>" +
    "<tt>vert</tt> specifies that values should be arranged down then across";
}

void create() {  
	defvar("debug", 
		   1,
		   "Show errors in pages",
		   TYPE_FLAG,
		   "Whether to show errors when things go awry."
		   );
	defvar("emptycell", 
		   "&nbsp;",
		   "Empty cell value",
		   TYPE_STRING,
		   "HTML of any empty cell in the returned table, eg '<tt>&amp;nbsp;</tt>'.");
	defvar("td_end", 
		   "</td>",
		   "Table cell close",
		   TYPE_STRING,
		   "HTML used to close a table cell, eg '<tt>&lt;/td&gt;");
	defvar("td", 
		   "<td align=\"left\" valign=\"top\">",
		   "Table cell open",
		   TYPE_STRING,
		   "HTML used to open a table cell, eg '<tt>&lt;td&gt;");
	defvar("tr_end", 
		   "</tr>",
		   "Table row end",
		   TYPE_STRING,
		   "HTML used to end a table row, eg '<tt>&lt;/tr&gt;");
	defvar("tr",
		   "<tr>",
		   "Table row start",
		   TYPE_STRING,
		   "HTML used to start a table row, eg '<tt>&lt;tr&gt;");
	defvar("table_end", 
		   "</table>",
		   "Table end",
		   TYPE_STRING,
		   "HTML used to end a table, eg '<tt>&lt;/table&gt;");
	defvar("table", 
		   "<table>",
		   "Table start",
		   TYPE_STRING,
		   "HTML used to begin a table, eg '<tt>&lt;table&gt;");
}


array register_module()
{
	return ({ MODULE_PARSER, 
              "Columnify Module",
              "This module makes columns using the container <tt>&lt;columnify&gt; &lt;/columnify&gt;</tt> "
              "and the separator <tt>&lt;cell&gt;</tt>. It actually makes tables, but the function is more column "
              "oriented, hence the silly name. Also, there is already a <tt>&lt;tablify&gt;</tt> tag which does "
              "a completely different thing.<p>" + doc(),
              ({ }),
              1
    });
}

string container_columnify(string tag_name, mapping args, string contents, object request_id, mapping defines) {

	/*
	 * result is end result returned
	 * sep is the separator, taken from an arg or default "|"
	 * table, tr, td and (*)_end and emptycell defvars or args for table format
	 * cols is an arg or defvar, rows is calculated from contents/cols rounded up
	 * (*)_cells are the contents arrays
	 */
	string result,sep,table,table_end,td,td_end,tr,tr_end,emptycell,tmp = "";
	int cols,rows;
	string *blank_cells, *content_cells, *all_cells;

	string debug = "";

	// some defaults, called from defvars now
	emptycell = (args->emptycell||query("emptycell"));
	td = (args->td||query("td"));
	td_end = (args->td_end||query("td_end"))+ "\n";
	tr = (args->tr||query("tr")) + "\n";
	tr_end = (args->tr_end||query("tr_end")) + "\n";
	table = (args->table||query("table")) + "\n";
	table_end = (args->table_end||query("table_end")) + "\n";

	result = "";

	// decide on separator and make array of cell contents
	if (!(args->sep))
		sep = "|";
	else
		sep = args->sep;
	content_cells = contents/sep;

	if(query("debug"))
	  debug += "content_cells = " + sizeof(content_cells) + "\n";

	// optionally delete 'blank' content_cells - good for sqloutput where sep
	// can go before </sqloutput> and produce empty final cell
	if (args->trim) {
		content_cells -= ({"","\n"," "});
	}

	// cols is either arg or 2
	if (!(int)(args->cols))
		cols = 2;
	else
		cols = (int)args->cols;

	if(query("debug"))
	  debug += "cols = " + cols + "\n";

	// get float of rows, make into int rounded up
	float f_cols;
	f_cols = 0.0 + cols;
	float f_rows = (sizeof(content_cells)/f_cols);
	int rows = (int)f_rows;
	if (rows < f_rows)
		rows++;

	if(query("debug"))
	  debug += "rows = " + rows + "\n";

	// create array of blank cells to pad empty table cells
	// more useful for vert than horz but still a good idea
	int num_blank_cells = (( cols * rows ) - sizeof(content_cells));
	blank_cells = allocate(num_blank_cells);
	for ( int i = 0 ; i < num_blank_cells ; i++ ) {
		blank_cells[i] = emptycell;
	}

	if(query("debug"))
	  debug += "blank_cells = " + sizeof(blank_cells) + "\n";

	// now create array of content + blank cells
	all_cells = (content_cells + blank_cells);

	if(query("debug"))
	  debug += "all_cells = " + sizeof(all_cells) + "\norder:";

	// open the table
	result += table;

	// for each row ...
	for ( int r = 0 ; r < rows ; r++ ) {
	  tmp += tr;
	  // for each column ...
	  for ( int c = 0 ; c < cols ; c++ ) {
		tmp += td;
		if (args->vert)
		  tmp += all_cells[rows*c+r];
		else
		  tmp += all_cells[cols*r+c];
		tmp += td_end;

		if(query("debug"))
		  if (args->vert)
			debug += rows*c+r + " ";
		  else
			debug += cols*r+c + " ";

	  }
	  tmp += tr_end;
	}

	if(query("debug"))
	  debug += "\n";

	result += tmp;
	
	if(query("debug"))
	  debug += sprintf("%O",all_cells);
	
	result += table_end;

	if (debug)
	  report_error(debug);

	if (debug)
	  request_id->variables->debug = debug;

	return result;

}

// This is nessesary functions for all MODULE_PARSER modules.
mapping query_container_callers() { 
	return( ([ "columnify": container_columnify ]) );
}

// 	if (!args->vert) {
// 		// for each col

// 		for ( int i = 0; i < (sizeof(all_cells)-1); i++ ) {
// 			// append tr tags at row start & end
// 			if ( i % cols == 0 )
// 				tmp = tr + td;
// 			else
// 				tmp = td;
// 				tmp += all_cells[i];
// 			if ( (i+1) % cols == 0 )
// 				tmp += td_end + tr_end;
// 			else
// 				tmp += td_end;
// 			result += tmp;
// 			}
// 		result += tmp;

// 		if(query("debug"))
// 		  debug += "vertical\n";

// 	} else {
// 		// for each row ...
// 		for ( int r = 0 ; r < rows ; r++ ) {
// 			tmp += tr;
// 			// for each column ...
// 			for ( int c = 0 ; c < cols ; c++ ) {
// 				tmp += td;
// 				int e = ((rows)*c+r);
// 				tmp += all_cells[e];
// 				tmp += td_end;
// 			}
// 			tmp += tr_end;
// 		}
// 		result += tmp;

// 		if(query("debug"))
// 		  debug += "horiz\n";

// 	}
